/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.kmelia.notification;

import com.silverpeas.kmelia.notification.AbstractKmeliaPublicationUserNotification;
import com.silverpeas.notification.model.NotificationResourceData;
import com.silverpeas.util.StringUtil;
import com.silverpeas.util.template.SilverpeasTemplate;
import com.stratelia.silverpeas.notificationManager.constant.NotifAction;
import com.stratelia.webactiv.beans.admin.UserDetail;
import com.stratelia.webactiv.kmelia.control.ejb.KmeliaHelper;
import com.stratelia.webactiv.util.DateUtil;
import com.stratelia.webactiv.util.FileRepositoryManager;
import com.stratelia.webactiv.util.node.model.NodePK;
import com.stratelia.webactiv.util.publication.model.PublicationDetail;
import java.util.Collection;
import java.util.Date;
import org.silverpeas.attachment.model.SimpleDocument;

public class KmeliaDocumentSubscriptionPublicationUserNotification
extends AbstractKmeliaPublicationUserNotification {
    private final SimpleDocument document;

    public KmeliaDocumentSubscriptionPublicationUserNotification(NodePK nodePK, PublicationDetail resource, SimpleDocument document, String senderName) {
        super(nodePK, resource, NotifAction.REPORT, senderName);
        this.document = document;
    }

    protected String getBundleSubjectKey() {
        return "AlertDocument";
    }

    protected String getFileName() {
        return "notificationAttachment";
    }

    protected Collection<String> getUserIdsToNotify() {
        return null;
    }

    protected void perform(PublicationDetail resource) {
        super.perform((Object)resource);
        this.getNotificationMetaData().displayReceiversInFooter();
    }

    @Override
    protected void performTemplateData(String language, PublicationDetail resource, SilverpeasTemplate template) {
        super.performTemplateData(language, resource, template);
        template.setAttribute("attachmentFileName", (Object)this.document.getFilename());
        if (StringUtil.isDefined((String)this.document.getTitle())) {
            template.setAttribute("attachmentTitle", (Object)this.document.getTitle());
        }
        if (StringUtil.isDefined((String)this.document.getDescription())) {
            template.setAttribute("attachmentDesc", (Object)this.document.getDescription());
        }
        template.setAttribute("attachmentCreationDate", (Object)DateUtil.getOutputDate((Date)this.document.getCreated(), (String)language));
        template.setAttribute("attachmentSize", (Object)FileRepositoryManager.formatFileSize((long)this.document.getSize()));
        UserDetail author = this.getOrganisationController().getUserDetail(this.document.getUpdatedBy());
        if (author == null) {
            author = this.getOrganisationController().getUserDetail(this.document.getCreatedBy());
        }
        template.setAttribute("attachmentAuthor", (Object)(author.getFirstName() + " " + author.getLastName()));
        if (this.document.isVersioned()) {
            template.setAttribute("attachmentMajorNumber", (Object)this.document.getMajorVersion());
            template.setAttribute("attachmentMinorNumber", (Object)this.document.getMinorVersion());
        }
    }

    @Override
    protected void performNotificationResource(String language, PublicationDetail resource, NotificationResourceData notificationResourceData) {
        super.performNotificationResource(language, resource, notificationResourceData);
        StringBuilder sb = new StringBuilder(1024);
        if (StringUtil.isDefined((String)this.document.getTitle())) {
            sb.append(this.document.getTitle());
        }
        if (sb.length() > 0) {
            sb.append(" - ");
        }
        sb.append(this.document.getFilename());
        sb.insert(0, " - ");
        sb.insert(0, notificationResourceData.getResourceName());
        notificationResourceData.setResourceName(sb.toString());
    }

    @Override
    protected String getResourceURL(PublicationDetail resource) {
        return KmeliaHelper.getDocumentUrl(resource, this.document);
    }

    @Override
    protected String getContributionAccessLinkLabelBundleKey() {
        return "kmelia.notifDocumentLinkLabel";
    }
}

