/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.webactiv.kmelia;

import com.silverpeas.util.StringUtil;
import com.silverpeas.util.security.ComponentSecurity;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.SilverpeasRole;
import com.stratelia.webactiv.beans.admin.ObjectType;
import com.stratelia.webactiv.kmelia.control.ejb.KmeliaBm;
import com.stratelia.webactiv.kmelia.control.ejb.KmeliaHelper;
import com.stratelia.webactiv.kmelia.model.KmeliaRuntimeException;
import com.stratelia.webactiv.util.EJBUtilitaire;
import com.stratelia.webactiv.util.JNDINames;
import com.stratelia.webactiv.util.ResourceLocator;
import com.stratelia.webactiv.util.exception.UtilException;
import com.stratelia.webactiv.util.node.control.NodeBm;
import com.stratelia.webactiv.util.node.model.NodeDetail;
import com.stratelia.webactiv.util.node.model.NodePK;
import com.stratelia.webactiv.util.publication.control.PublicationBm;
import com.stratelia.webactiv.util.publication.model.PublicationDetail;
import com.stratelia.webactiv.util.publication.model.PublicationPK;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.silverpeas.core.admin.OrganisationController;
import org.silverpeas.core.admin.OrganisationControllerFactory;

public class KmeliaSecurity
implements ComponentSecurity {
    private static final String CO_WRITING_PARAM = "coWriting";
    private static final String DRAFT_VISIBLE_WITH_CO_WRITING_PARAM = "draftVisibleWithCoWriting";
    public static final String PUBLICATION_TYPE = "Publication";
    public static final String NODE_TYPE = "Node";
    public static final String RIGHTS_ON_TOPIC_PARAM = "rightsOnTopics";
    private PublicationBm publicationBm;
    private NodeBm nodeBm;
    private KmeliaBm kmeliaBm;
    private OrganisationController controller = null;
    private Map<String, Boolean> cache = Collections.synchronizedMap(new HashMap());
    private volatile boolean cacheEnabled = false;
    private ResourceLocator kmeliaSettings = new ResourceLocator("org.silverpeas.kmelia.settings.kmeliaSettings", "fr");

    public KmeliaSecurity() {
        this.controller = OrganisationControllerFactory.getOrganisationController();
    }

    public KmeliaSecurity(OrganisationController controller) {
        this.controller = controller;
    }

    public synchronized void enableCache() {
        this.cache.clear();
        this.cacheEnabled = true;
    }

    public synchronized void disableCache() {
        this.cache.clear();
        this.cacheEnabled = false;
    }

    private void writeInCache(String objectId, String objectType, String componentId, boolean available) {
        if (this.cacheEnabled) {
            this.cache.put(objectId + objectType + componentId, available);
        }
    }

    private Boolean readFromCache(String objectId, String objectType, String componentId) {
        if (this.cacheEnabled) {
            return this.cache.get(objectId + objectType + componentId);
        }
        return null;
    }

    private void writeInCache(String componentId, boolean available) {
        if (this.cacheEnabled) {
            this.cache.put(componentId, available);
        }
    }

    private Boolean readFromCache(String componentId) {
        if (this.cacheEnabled) {
            return this.cache.get(componentId);
        }
        return null;
    }

    public boolean isAccessAuthorized(String componentId, String userId, String objectId) {
        return this.isAccessAuthorized(componentId, userId, objectId, PUBLICATION_TYPE);
    }

    public boolean isAccessAuthorized(String componentId, String userId, String objectId, String objectType) {
        if (!this.isComponentAvailable(componentId, userId)) {
            return false;
        }
        if (this.isKmeliaObjectType(objectType)) {
            PublicationPK pk = new PublicationPK(objectId, componentId);
            if (!this.isPublicationAvailable(pk, userId)) {
                return false;
            }
            PublicationDetail publication = this.getPublicationDetail(pk);
            if (publication != null) {
                String profile = this.getProfile(userId, pk);
                if (!this.getKmeliaBm().isPublicationVisible(publication, SilverpeasRole.from((String)profile), userId)) {
                    return false;
                }
                if (publication.isValid()) {
                    return true;
                }
                if (publication.isValidationRequired()) {
                    if (SilverpeasRole.user.isInRole(new String[]{profile})) {
                        return false;
                    }
                    if (SilverpeasRole.writer.isInRole(new String[]{profile})) {
                        return publication.isPublicationEditor(userId) || this.isCoWritingEnable(componentId);
                    }
                    return true;
                }
                if (publication.isRefused()) {
                    if (!SilverpeasRole.user.isInRole(new String[]{profile})) {
                        return publication.isPublicationEditor(userId) || this.isCoWritingEnable(componentId) || SilverpeasRole.admin.isInRole(new String[]{profile}) || SilverpeasRole.publisher.isInRole(new String[]{profile});
                    }
                    return false;
                }
                if (publication.isDraft()) {
                    if (!SilverpeasRole.user.isInRole(new String[]{profile})) {
                        if (this.isCoWritingEnable(componentId) && this.isDraftVisibleWithCoWriting() && !SilverpeasRole.reader.isInRole(new String[]{profile})) {
                            return true;
                        }
                        return publication.isPublicationEditor(userId);
                    }
                    return false;
                }
            }
        } else if (NODE_TYPE.equalsIgnoreCase(objectType)) {
            NodePK pk = new NodePK(objectId, componentId);
            return this.isNodeAvailable(pk, userId);
        }
        return true;
    }

    public boolean isObjectAvailable(String componentId, String userId, String objectId, String objectType) {
        if (this.isKmeliaObjectType(objectType)) {
            return this.isPublicationAvailable(new PublicationPK(objectId, componentId), userId);
        }
        if (NODE_TYPE.equalsIgnoreCase(objectType)) {
            return this.isNodeAvailable(new NodePK(objectId, componentId), userId);
        }
        return true;
    }

    protected boolean isKmeliaObjectType(String objectType) {
        return objectType != null && (PUBLICATION_TYPE.equalsIgnoreCase(objectType) || objectType.startsWith("Attachment") || objectType.startsWith("Version"));
    }

    protected boolean isRightsOnTopicsEnabled(String componentId) {
        String param = this.controller.getComponentParameterValue(componentId, RIGHTS_ON_TOPIC_PARAM);
        return StringUtil.getBooleanValue((String)param);
    }

    protected boolean isDraftVisibleWithCoWriting() {
        return this.kmeliaSettings.getBoolean(DRAFT_VISIBLE_WITH_CO_WRITING_PARAM, false);
    }

    protected boolean isCoWritingEnable(String componentId) {
        String param = this.controller.getComponentParameterValue(componentId, CO_WRITING_PARAM);
        return StringUtil.getBooleanValue((String)param);
    }

    private boolean isComponentAvailable(String componentId, String userId) {
        Boolean fromCache = this.readFromCache(componentId);
        if (fromCache != null) {
            return fromCache;
        }
        boolean available = this.controller.isComponentAvailable(componentId, userId);
        this.writeInCache(componentId, available);
        return available;
    }

    protected boolean isPublicationAvailable(PublicationPK pk, String userId) {
        Boolean fromCache = this.readFromCache(pk.getId(), PUBLICATION_TYPE, pk.getInstanceId());
        if (fromCache != null) {
            return fromCache;
        }
        boolean objectAvailable = false;
        Collection<NodePK> fatherPKs = this.getPublicationFolderPKs(pk);
        if (fatherPKs == null) {
            return false;
        }
        if (this.isInBasket(fatherPKs)) {
            SilverpeasRole profile = SilverpeasRole.from((String)KmeliaHelper.getProfile(this.getAppProfiles(userId, pk.getInstanceId())));
            if (SilverpeasRole.READER_ROLES.contains(profile)) {
                return false;
            }
            if (SilverpeasRole.admin == profile) {
                return true;
            }
            PublicationDetail publication = this.getPublicationDetail(pk);
            if (publication != null) {
                return publication.isPublicationEditor(userId);
            }
        } else if (this.isRightsOnTopicsEnabled(pk.getInstanceId())) {
            for (NodePK fatherPK : fatherPKs) {
                if (!fatherPK.isTrash()) {
                    try {
                        objectAvailable = this.isNodeAvailable(fatherPK, userId);
                    }
                    catch (Exception e) {
                        SilverTrace.error((String)"kmelia", (String)"KmeliaSecurity.isNodeAvailable", (String)"root.MSG_GEN_PARAM_VALUE", (String)("Node (" + fatherPK.getId() + ", " + fatherPK.getInstanceId() + ") no more exist but still referenced by a publication (" + pk.getId() + ", " + pk.getInstanceId() + ")"));
                        objectAvailable = false;
                    }
                } else {
                    objectAvailable = true;
                }
                if (!objectAvailable) continue;
                break;
            }
        } else {
            objectAvailable = true;
        }
        this.writeInCache(pk.getId(), PUBLICATION_TYPE, pk.getInstanceId(), objectAvailable);
        return objectAvailable;
    }

    private Collection<NodePK> getPublicationFolderPKs(PublicationPK pk) {
        Collection fatherPKs = null;
        try {
            fatherPKs = this.getPublicationBm().getAllFatherPK(pk);
        }
        catch (Exception e) {
            SilverTrace.warn((String)"kmelia", (String)"KmeliaSecurity.getPublicationFolderPKs", (String)"kmelia.EX_IMPOSSIBLE_DOBTENIR_LA_PUBLICATION", (String)("PubId = " + pk.toString()));
        }
        return fatherPKs;
    }

    private boolean isInBasket(Collection<NodePK> pks) {
        Iterator<NodePK> i$ = pks.iterator();
        if (i$.hasNext()) {
            NodePK pk = i$.next();
            return pk.isTrash();
        }
        return false;
    }

    private PublicationDetail getPublicationDetail(PublicationPK pk) {
        try {
            return this.getPublicationBm().getDetail(pk);
        }
        catch (Exception e) {
            throw new KmeliaRuntimeException("KmeliaSecurity.getPublicationDetail()", 4, "kmelia.EX_IMPOSSIBLE_DOBTENIR_LA_PUBLICATION", e);
        }
    }

    private boolean isNodeAvailable(NodePK nodePK, String userId) {
        NodeDetail node;
        Boolean fromCache = this.readFromCache(nodePK.getId(), NODE_TYPE, nodePK.getInstanceId());
        if (fromCache != null) {
            return fromCache;
        }
        boolean objectAvailable = false;
        objectAvailable = this.isRightsOnTopicsEnabled(nodePK.getInstanceId()) ? ((node = this.getNodeBm().getHeader(nodePK, false)) != null ? (!node.haveRights() ? true : this.controller.isObjectAvailable(node.getRightsDependsOn(), ObjectType.NODE, nodePK.getInstanceId(), userId)) : false) : true;
        this.writeInCache(nodePK.getId(), NODE_TYPE, nodePK.getInstanceId(), objectAvailable);
        return objectAvailable;
    }

    private String getProfile(String userId, PublicationPK pubPK) {
        String[] profiles;
        if (!this.isRightsOnTopicsEnabled(pubPK.getInstanceId())) {
            profiles = this.getAppProfiles(userId, pubPK.getInstanceId());
        } else {
            Collection nodePKs = this.getPublicationBm().getAllFatherPK(pubPK);
            ArrayList<String> lProfiles = new ArrayList<String>();
            for (NodePK nodePK : nodePKs) {
                NodeDetail node = this.getNodeBm().getHeader(nodePK);
                if (node == null) continue;
                SilverTrace.debug((String)"kmelia", (String)"KmeliaSecurity.getProfile", (String)"root.MSG_GEN_PARAM_VALUE", (String)("nodePK = " + nodePK.toString()));
                if (!node.haveRights()) {
                    lProfiles.addAll(Arrays.asList(this.getAppProfiles(userId, pubPK.getInstanceId())));
                    continue;
                }
                lProfiles.addAll(Arrays.asList(this.controller.getUserProfiles(userId, pubPK.getInstanceId(), node.getRightsDependsOn(), ObjectType.NODE)));
            }
            profiles = lProfiles.toArray(new String[lProfiles.size()]);
        }
        return KmeliaHelper.getProfile(profiles);
    }

    private String[] getAppProfiles(String userId, String appId) {
        return this.controller.getUserProfiles(userId, appId);
    }

    private PublicationBm getPublicationBm() {
        if (this.publicationBm == null) {
            try {
                this.setPublicationBm((PublicationBm)EJBUtilitaire.getEJBObjectRef((String)JNDINames.PUBLICATIONBM_EJBHOME, PublicationBm.class));
            }
            catch (UtilException e) {
                throw new KmeliaRuntimeException("KmeliaSecurity.getPublicationBm()", 4, "kmelia.EX_IMPOSSIBLE_DE_FABRIQUER_PUBLICATIONBM_HOME", (Exception)((Object)e));
            }
        }
        return this.publicationBm;
    }

    public NodeBm getNodeBm() {
        if (this.nodeBm == null) {
            try {
                this.setNodeBm((NodeBm)EJBUtilitaire.getEJBObjectRef((String)JNDINames.NODEBM_EJBHOME, NodeBm.class));
            }
            catch (UtilException e) {
                throw new KmeliaRuntimeException("KmeliaSecurity.getNodeBm()", 4, "kmelia.EX_IMPOSSIBLE_DE_FABRIQUER_NODEBM_HOME", (Exception)((Object)e));
            }
        }
        return this.nodeBm;
    }

    public KmeliaBm getKmeliaBm() {
        if (this.kmeliaBm == null) {
            try {
                this.setKmeliaBm((KmeliaBm)EJBUtilitaire.getEJBObjectRef((String)JNDINames.KMELIABM_EJBHOME, KmeliaBm.class));
            }
            catch (UtilException e) {
                throw new KmeliaRuntimeException("KmeliaSecurity.getKmeliaBm()", 4, "kmelia.EX_IMPOSSIBLE_DE_FABRIQUER_KMELIABM_HOME", (Exception)((Object)e));
            }
        }
        return this.kmeliaBm;
    }

    public synchronized boolean isCacheEnabled() {
        return this.cacheEnabled;
    }

    void setPublicationBm(PublicationBm publicationBm) {
        this.publicationBm = publicationBm;
    }

    void setNodeBm(NodeBm nodeBm) {
        this.nodeBm = nodeBm;
    }

    void setKmeliaBm(KmeliaBm kmeliaBm) {
        this.kmeliaBm = kmeliaBm;
    }
}

