/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.webactiv.kmelia.control;

import com.silverpeas.notification.DefaultNotificationSubscriber;
import com.silverpeas.notification.NotificationTopic;
import com.silverpeas.notification.RegisteredTopics;
import com.silverpeas.notification.SilverpeasNotification;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.kmelia.control.ejb.KmeliaBm;
import com.stratelia.webactiv.kmelia.model.KmeliaRuntimeException;
import com.stratelia.webactiv.util.EJBUtilitaire;
import com.stratelia.webactiv.util.JNDINames;
import com.stratelia.webactiv.util.publication.model.PublicationPK;
import javax.inject.Named;
import org.silverpeas.attachment.notification.AttachmentDeletionNotification;
import org.silverpeas.attachment.notification.AttachmentRef;

@Named
public class AttachmentKmeliaListener
extends DefaultNotificationSubscriber {
    public void subscribeOnTopics() {
        this.subscribeForNotifications(NotificationTopic.onTopic((String)RegisteredTopics.ATTACHMENT_TOPIC.getTopicName()));
    }

    public void unsubscribeOnTopics() {
        this.unsubscribeForNotifications(NotificationTopic.onTopic((String)RegisteredTopics.ATTACHMENT_TOPIC.getTopicName()));
    }

    public void onNotification(SilverpeasNotification notification, NotificationTopic onTopic) {
        AttachmentDeletionNotification deletion;
        AttachmentRef attachment;
        if (RegisteredTopics.ATTACHMENT_TOPIC.getTopicName().equals(onTopic.getName()) && notification instanceof AttachmentDeletionNotification && (attachment = (deletion = (AttachmentDeletionNotification)notification).getAttachment()) != null) {
            PublicationPK pubPK = new PublicationPK(attachment.getForeignId(), attachment.getInstanceId());
            this.anExternalPublicationElementHaveChanged(pubPK);
        }
    }

    private void anExternalPublicationElementHaveChanged(PublicationPK pubPK) {
        try {
            this.getKmeliaBm().externalElementsOfPublicationHaveChanged(pubPK, null, -1);
        }
        catch (Exception e) {
            SilverTrace.error((String)"kmelia", (String)"AttachmentKmeliaListener.onNotification", (String)"kmelia.EX_IMPOSSIBLE_DE_MODIFIER_LA_PUBLICATION", (String)("pubPK = " + pubPK.toString()), (Throwable)e);
        }
    }

    private KmeliaBm getKmeliaBm() {
        try {
            return (KmeliaBm)EJBUtilitaire.getEJBObjectRef((String)JNDINames.KMELIABM_EJBHOME, KmeliaBm.class);
        }
        catch (Exception e) {
            throw new KmeliaRuntimeException("AttachmentKmeliaListener.getKmeliaBm()", 4, "root.EX_CANT_GET_REMOTE_OBJECT", e);
        }
    }
}

