/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.kmelia.dao;

import com.silverpeas.kmelia.dao.TopicSearchDao;
import com.silverpeas.kmelia.model.MostInterestedQueryVO;
import com.stratelia.webactiv.util.ResourceLocator;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import javax.inject.Named;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.simple.ParameterizedRowMapper;
import org.springframework.jdbc.core.support.JdbcDaoSupport;

@Named(value="topicSearchDao")
public class TopicSearchDaoImpl
extends JdbcDaoSupport
implements TopicSearchDao {
    private static final String QUERY_GET_LIST_MOST_INTERESTED_QUERY = "SELECT count(*) as nb, query FROM sc_kmelia_search WHERE instanceid = ? GROUP BY query, language ORDER BY nb DESC, query";
    private static ResourceLocator settings = new ResourceLocator("com.stratelia.webactiv.kmelia.settings.kmeliaSettings", "fr");

    @Override
    public List<MostInterestedQueryVO> getMostInterestedSearch(String instanceId) {
        this.getJdbcTemplate().setMaxRows(settings.getInteger("kmelia.stats.most.interested.query.limit", 10));
        return this.getJdbcTemplate().query((PreparedStatementCreator)new MyPreparedStatementCreator(instanceId), (RowMapper)new MostInterestedQueryRowMapper());
    }

    class MyPreparedStatementCreator
    implements PreparedStatementCreator {
        private String instanceId;

        public MyPreparedStatementCreator(String instanceId) {
            this.instanceId = instanceId;
        }

        public PreparedStatement createPreparedStatement(Connection connection) throws SQLException {
            PreparedStatement ps = connection.prepareStatement(TopicSearchDaoImpl.QUERY_GET_LIST_MOST_INTERESTED_QUERY);
            ps.setString(1, this.getInstanceId());
            return ps;
        }

        public String getInstanceId() {
            return this.instanceId;
        }
    }

    private static class MostInterestedQueryRowMapper
    implements ParameterizedRowMapper<MostInterestedQueryVO> {
        private MostInterestedQueryRowMapper() {
        }

        public MostInterestedQueryVO mapRow(ResultSet rs, int rowNum) throws SQLException {
            MostInterestedQueryVO interestedQuery = new MostInterestedQueryVO(rs.getString("query"), rs.getInt("nb"));
            return interestedQuery;
        }
    }
}

