/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.webactiv.kmelia.control.ejb;

import com.silverpeas.util.ArrayUtil;
import com.silverpeas.util.StringUtil;
import com.stratelia.webactiv.beans.admin.ObjectType;
import com.stratelia.webactiv.kmelia.control.ejb.KmeliaHelper;
import com.stratelia.webactiv.util.node.model.NodeDetail;
import com.stratelia.webactiv.util.node.model.NodePK;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.silverpeas.core.admin.OrganisationController;
import org.silverpeas.core.admin.OrganisationControllerFactory;

class KmeliaUserTreeViewFilter {
    private static final String NODE_TO_EXCLUDE = "@@@NODE_TO_EXCLUDE@@@";
    private final OrganisationController orga = OrganisationControllerFactory.getOrganisationController();
    private final String userId;
    private final String instanceId;
    private final NodePK initialNodeIdentifier;
    private final String bestUserComponentInstanceRole;
    private final boolean isRightsOnTopicsUsed;
    private Map<Integer, List<String>> nodeUserRoles = null;

    public static KmeliaUserTreeViewFilter from(String userId, String instanceId, NodePK initialNodeIdentifier, String bestUserComponentInstanceRole, boolean isRightsOnTopicsUsed) {
        return new KmeliaUserTreeViewFilter(userId, instanceId, initialNodeIdentifier, bestUserComponentInstanceRole, isRightsOnTopicsUsed);
    }

    private KmeliaUserTreeViewFilter(String userId, String instanceId, NodePK initialNodeIdentifier, String bestUserComponentInstanceRole, boolean isRightsOnTopicsUsed) {
        this.userId = userId;
        this.instanceId = instanceId;
        this.initialNodeIdentifier = initialNodeIdentifier;
        this.bestUserComponentInstanceRole = bestUserComponentInstanceRole;
        this.isRightsOnTopicsUsed = isRightsOnTopicsUsed;
    }

    void setBestUserRoleAndFilter(List<NodeDetail> tree) {
        String sNB;
        int nbPublisOnRoot;
        NodeDetail root;
        if (this.isRightsOnTopicsUsed) {
            Iterator<NodeDetail> treeIt = tree.iterator();
            while (treeIt.hasNext()) {
                NodeDetail node = treeIt.next();
                if (this.setBestUserNodeRole(node, this.bestUserComponentInstanceRole)) continue;
                treeIt.remove();
            }
        } else {
            for (NodeDetail node : tree) {
                node.setUserRole(this.bestUserComponentInstanceRole);
            }
        }
        if (!tree.isEmpty() && (root = tree.get(0)).getNodePK().isRoot() && (nbPublisOnRoot = Integer.parseInt(sNB = StringUtil.defaultStringIfNotDefined((String)this.orga.getComponentParameterValue(this.initialNodeIdentifier.getInstanceId(), "nbPubliOnRoot"), (String)"0"))) != 0) {
            root.setUserRole("user");
        }
    }

    private boolean setBestUserNodeRole(NodeDetail node, String bestParentNodeUserRole) {
        String nodeUserRole = node.getUserRole();
        if (nodeUserRole != null) {
            return !NODE_TO_EXCLUDE.equals(nodeUserRole);
        }
        String bestNodeUserRole = bestParentNodeUserRole;
        boolean hasUserNodeAccess = false;
        if (node.haveRights()) {
            int rightsDependsOn = node.getRightsDependsOn();
            Object[] profiles = this.getNodeUserRoles(rightsDependsOn);
            String string = bestNodeUserRole = ArrayUtil.isEmpty((Object[])profiles) ? null : KmeliaHelper.getProfile((String[])profiles);
        }
        if (bestNodeUserRole != null) {
            node.setUserRole(bestNodeUserRole);
            hasUserNodeAccess = true;
        }
        Iterator nodeChildIterator = node.getChildrenDetails().iterator();
        while (nodeChildIterator.hasNext()) {
            NodeDetail child = (NodeDetail)nodeChildIterator.next();
            boolean hasUserChildNodeAccess = this.setBestUserNodeRole(child, bestNodeUserRole);
            if (!hasUserChildNodeAccess) {
                nodeChildIterator.remove();
            }
            hasUserNodeAccess = hasUserNodeAccess || hasUserChildNodeAccess;
        }
        if (!hasUserNodeAccess) {
            node.setUserRole(NODE_TO_EXCLUDE);
        }
        return hasUserNodeAccess;
    }

    private String[] getNodeUserRoles(Integer nodeId) {
        List<String> roles;
        if (this.nodeUserRoles == null) {
            this.nodeUserRoles = this.orga.getUserObjectProfiles(this.userId, this.instanceId, ObjectType.NODE);
        }
        return (roles = this.nodeUserRoles.get(nodeId)) != null ? roles.toArray(new String[roles.size()]) : new String[]{};
    }
}

