/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.form.displayers;

import com.silverpeas.form.FieldTemplate;
import com.silverpeas.form.FormException;
import com.silverpeas.form.PagesContext;
import com.silverpeas.form.Util;
import com.silverpeas.form.displayers.AbstractFieldDisplayer;
import com.silverpeas.form.fieldType.FileField;
import com.silverpeas.util.EncodeHelper;
import com.silverpeas.util.FileUtil;
import com.silverpeas.util.StringUtil;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.io.IOUtils;
import org.silverpeas.attachment.AttachmentServiceFactory;
import org.silverpeas.attachment.model.DocumentType;
import org.silverpeas.attachment.model.HistorisedDocument;
import org.silverpeas.attachment.model.SimpleAttachment;
import org.silverpeas.attachment.model.SimpleDocument;
import org.silverpeas.attachment.model.SimpleDocumentPK;
import org.silverpeas.servlet.FileUploadUtil;

public abstract class AbstractFileFieldDisplayer
extends AbstractFieldDisplayer<FileField> {
    protected static final String OPERATION_KEY = "Operation";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SimpleDocument createSimpleDocument(String objectId, String componentId, FileItem item, String fileName, String userId, boolean versionned) throws IOException {
        SimpleDocumentPK documentPk = new SimpleDocumentPK(null, componentId);
        SimpleAttachment attachment = new SimpleAttachment(fileName, null, null, null, item.getSize(), FileUtil.getMimeType(fileName), userId, new Date(), null);
        SimpleDocument document = versionned ? new HistorisedDocument(documentPk, objectId, 0, attachment) : new SimpleDocument(documentPk, objectId, 0, false, null, attachment);
        document.setDocumentType(DocumentType.form);
        InputStream in = item.getInputStream();
        try {
            SimpleDocument simpleDocument = AttachmentServiceFactory.getAttachmentService().createAttachment(document, in, false);
            return simpleDocument;
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }

    protected void deleteAttachment(String attachmentId, PagesContext pageContext) {
        SilverTrace.info("form", "AbstractFileFieldDisplayer.deleteAttachment", "root.MSG_GEN_ENTER_METHOD", "attachmentId = " + attachmentId + ", componentId = " + pageContext.getComponentId());
        SimpleDocumentPK pk = new SimpleDocumentPK(attachmentId, pageContext.getComponentId());
        SimpleDocument doc = AttachmentServiceFactory.getAttachmentService().searchDocumentById(pk, pageContext.getContentLanguage());
        if (doc != null) {
            AttachmentServiceFactory.getAttachmentService().deleteAttachment(doc);
        }
    }

    public String[] getManagedTypes() {
        return new String[]{"file"};
    }

    @Override
    public void displayScripts(PrintWriter out, FieldTemplate template, PagesContext pageContext) throws IOException {
        this.checkFieldType(template.getTypeName(), "AbstractFileFieldDisplayer.displayScripts");
        String language = pageContext.getLanguage();
        String fieldName = template.getFieldName();
        if (template.isMandatory() && pageContext.useMandatory()) {
            out.append("  if (isWhitespace(stripInitialWhitespace(field.value))) {\n").append("   var ").append(fieldName).append("Value = document.getElementById('").append(fieldName).append("_id").append("').value;\n").append("   var ").append(fieldName).append("Operation = document.").append(pageContext.getFormName()).append(".").append(fieldName).append(OPERATION_KEY).append(".value;\n").append("   if (").append(fieldName).append("Value=='' || ").append(fieldName).append("Operation=='").append(Operation.DELETION.name()).append("') {\n").append("     errorMsg+=\"  - '").append(EncodeHelper.javaStringToJsString(template.getLabel(language))).append("' ").append(Util.getString("GML.MustBeFilled", language)).append("\\n\";\n").append("     errorNb++;\n").append("   }\n").append(" }\n");
        }
        if (!template.isReadOnly()) {
            Util.includeFileNameLengthChecker(template, pageContext, out);
            Util.getJavascriptChecker(template.getFieldName(), pageContext, out);
        }
    }

    @Override
    public List<String> update(List<FileItem> items, FileField field, FieldTemplate template, PagesContext pageContext) throws FormException {
        ArrayList<String> attachmentIds = new ArrayList<String>();
        String attachmentId = this.processInput(items, field, pageContext);
        attachmentIds.addAll(this.update(attachmentId, field, template, pageContext));
        return attachmentIds;
    }

    protected String processInput(List<FileItem> items, FileField field, PagesContext pageContext) {
        try {
            String fileLinkOnApplication;
            String currentAttachmentId = field.getAttachmentId();
            String inputName = Util.getFieldOccurrenceName(field.getName(), field.getOccurrence());
            String attachmentId = this.processUploadedFile(items, inputName, pageContext);
            Operation operation = Operation.valueOf(FileUploadUtil.getParameter(items, inputName + OPERATION_KEY));
            if (!StringUtil.isDefined(attachmentId) && StringUtil.startsWith((CharSequence)(fileLinkOnApplication = FileUploadUtil.getParameter(items, inputName + "$$id")), (CharSequence)"/")) {
                attachmentId = this.isDeletion(operation, fileLinkOnApplication) ? null : fileLinkOnApplication;
            }
            if (!pageContext.isCreation()) {
                boolean isDeletionOfCurrent = this.isDeletion(operation, currentAttachmentId);
                boolean isUpdate = StringUtil.isDefined(currentAttachmentId) && StringUtil.isDefined(attachmentId) && !currentAttachmentId.equals(attachmentId);
                boolean isAddOrUpdate = StringUtil.isDefined(attachmentId);
                if (isDeletionOfCurrent || isUpdate) {
                    if (!StringUtil.startsWith((CharSequence)currentAttachmentId, (CharSequence)"/")) {
                        this.deleteAttachment(currentAttachmentId, pageContext);
                    }
                } else if (!isAddOrUpdate) {
                    return currentAttachmentId;
                }
            }
            return attachmentId;
        }
        catch (IOException ex) {
            SilverTrace.error("form", "VideoFieldDisplayer.update", "form.EXP_UNKNOWN_FIELD", null, ex);
            return null;
        }
    }

    @Override
    public List<String> update(String attachmentId, FileField field, FieldTemplate template, PagesContext pagesContext) throws FormException {
        ArrayList<String> updated = new ArrayList<String>();
        if ("file".equals(field.getTypeName())) {
            if (!StringUtil.isDefined(attachmentId)) {
                field.setNull();
            } else {
                field.setAttachmentId(attachmentId);
                updated.add(attachmentId);
            }
        } else {
            throw new FormException("FileFieldDisplayer.update", "form.EX_NOT_CORRECT_VALUE", "file");
        }
        return updated;
    }

    protected boolean isDeletion(Operation operation, String attachmentId) {
        return StringUtil.isDefined(attachmentId) && operation == Operation.DELETION;
    }

    protected boolean isUpdate(Operation operation, String attachmentId) {
        return StringUtil.isDefined(attachmentId) && operation == Operation.UPDATE;
    }

    protected String processUploadedFile(List<FileItem> items, String parameterName, PagesContext pagesContext) throws IOException {
        String attachmentId = null;
        FileItem item = FileUploadUtil.getFile(items, parameterName);
        if (item != null && !item.isFormField()) {
            String componentId = pagesContext.getComponentId();
            String userId = pagesContext.getUserId();
            String objectId = pagesContext.getObjectId();
            if (StringUtil.isDefined(item.getName())) {
                String fileName = FileUtil.getFilename(item.getName());
                long size = item.getSize();
                if (size > 0L) {
                    SimpleDocument document = this.createSimpleDocument(objectId, componentId, item, fileName, userId, false);
                    attachmentId = document.getId();
                }
            }
        }
        return attachmentId;
    }

    @Override
    public boolean isDisplayedMandatory() {
        return true;
    }

    protected void checkFieldType(String typeName, String contextCall) {
        if (!"file".equals(typeName)) {
            SilverTrace.info("form", contextCall, "form.INFO_NOT_CORRECT_TYPE", "file");
        }
    }

    protected static enum Operation {
        ADD,
        UPDATE,
        DELETION;

    }
}

