/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.form.displayers;

import com.silverpeas.form.FieldTemplate;
import com.silverpeas.form.FormException;
import com.silverpeas.form.PagesContext;
import com.silverpeas.form.Util;
import com.silverpeas.form.displayers.AbstractTextFieldDisplayer;
import com.silverpeas.form.fieldType.TextField;
import com.silverpeas.util.StringUtil;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import java.io.PrintWriter;
import java.util.Map;
import org.apache.ecs.Element;
import org.apache.ecs.ElementContainer;
import org.apache.ecs.xhtml.a;
import org.apache.ecs.xhtml.iframe;
import org.apache.ecs.xhtml.img;
import org.apache.ecs.xhtml.input;

public class MapFieldDisplayer
extends AbstractTextFieldDisplayer<TextField> {
    public static final String PARAM_MAP = "map";
    public static final String PARAM_HEIGHT = "height";
    public static final String PARAM_WIDTH = "width";
    public static final String PARAM_KIND = "kind";
    public static final String PARAM_ZOOM = "zoom";
    public static final String PARAM_ENLARGE = "enlarge";
    public static final String KIND_NORMAL = "m";
    public static final String KIND_SATELLITE = "k";
    public static final String KIND_HYBRID = "h";
    public static final String KIND_RELIEF = "t";

    @Override
    public void display(PrintWriter out, TextField field, FieldTemplate template, PagesContext pageContext) throws FormException {
        if (field == null) {
            return;
        }
        if (!field.getTypeName().equals("text")) {
            SilverTrace.info("form", "TextFieldDisplayer.display", "form.INFO_NOT_CORRECT_TYPE", "text");
        }
        String fieldName = Util.getFieldOccurrenceName(template.getFieldName(), field.getOccurrence());
        Map<String, String> parameters = template.getParameters(pageContext.getLanguage());
        String value = field.getValue();
        if (pageContext.isBlankFieldsUse()) {
            value = "";
        }
        if (template.isReadOnly() && !template.isHidden()) {
            StringBuilder src = new StringBuilder(50);
            src.append("https://maps.google.fr/maps?");
            src.append("hl=").append(pageContext.getLanguage()).append("&amp;");
            src.append("source=embed&amp;");
            src.append("layer=c&amp;");
            src.append("t=").append(this.getParameterValue(parameters, PARAM_KIND, KIND_NORMAL)).append("&amp;");
            src.append("q=").append(value).append("&amp;");
            String zoom = this.getParameterValue(parameters, PARAM_ZOOM, null);
            if (StringUtil.isDefined(zoom)) {
                src.append("z=").append(zoom).append("&amp;");
            }
            src.append("iwloc=dummy");
            String link = src.toString();
            a href = new a();
            href.setHref(link);
            href.setTarget("_blank");
            href.addElement(value);
            boolean map = StringUtil.getBooleanValue(this.getParameterValue(parameters, PARAM_MAP, "false"));
            boolean enlarge = StringUtil.getBooleanValue(this.getParameterValue(parameters, PARAM_ENLARGE, "false"));
            ElementContainer container = new ElementContainer();
            if (map) {
                iframe anIFrame = new iframe();
                anIFrame.addAttribute(PARAM_WIDTH, this.getParameterValue(parameters, PARAM_WIDTH, "425"));
                anIFrame.addAttribute(PARAM_HEIGHT, this.getParameterValue(parameters, PARAM_HEIGHT, "350"));
                anIFrame.setFrameBorder(false);
                anIFrame.setScrolling("no");
                anIFrame.setMarginHeight(0);
                anIFrame.setMarginWidth(0);
                anIFrame.setSrc(link.replace("source", "output"));
                container.addElement((Element)anIFrame);
                if (enlarge) {
                    container.addElement("<br/>");
                    container.addElement("<small class=\"map-enlarge\">");
                    container.addElement((Element)href);
                    container.addElement("</small>");
                }
            } else {
                container.addElement((Element)href);
            }
            out.print(container.toString());
        } else if (!(template.isHidden() || template.isDisabled() || template.isReadOnly())) {
            input textInput = new input();
            textInput.setName(fieldName);
            textInput.setID(fieldName);
            textInput.setValue(value);
            textInput.setSize("50");
            textInput.setType(template.isHidden() ? "hidden" : "text");
            if (template.isDisabled()) {
                textInput.setDisabled(true);
            } else if (template.isReadOnly()) {
                textInput.setReadOnly(true);
            }
            img image = null;
            if (template.isMandatory() && pageContext.useMandatory()) {
                image = new img();
                image.setSrc(Util.getIcon("mandatoryField"));
                image.setWidth(5);
                image.setHeight(5);
                image.setBorder(0);
            }
            if (image != null) {
                ElementContainer container = new ElementContainer();
                container.addElement((Element)textInput);
                container.addElement("&nbsp;");
                container.addElement((Element)image);
                out.println(container.toString());
            } else {
                out.println(textInput.toString());
            }
        }
    }

    private String getParameterValue(Map<String, String> parameters, String name, String defaultValue) {
        return parameters.containsKey(name) ? parameters.get(name) : defaultValue;
    }
}

