/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.form.displayers;

import com.silverpeas.form.FieldTemplate;
import com.silverpeas.form.FormException;
import com.silverpeas.form.PagesContext;
import com.silverpeas.form.Util;
import com.silverpeas.form.displayers.AbstractFieldDisplayer;
import com.silverpeas.form.fieldType.TextField;
import com.silverpeas.util.EncodeHelper;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.util.DateUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.ecs.Element;
import org.apache.ecs.ElementContainer;
import org.apache.ecs.xhtml.img;
import org.apache.ecs.xhtml.input;

public class TimeFieldDisplayer
extends AbstractFieldDisplayer<TextField> {
    public String[] getManagedTypes() {
        return new String[]{"text"};
    }

    @Override
    public void displayScripts(PrintWriter out, FieldTemplate template, PagesContext PagesContext2) throws IOException {
        String language = PagesContext2.getLanguage();
        if (!"text".equals(template.getTypeName())) {
            SilverTrace.info("form", "TimeFieldDisplayer.displayScripts", "form.INFO_NOT_CORRECT_TYPE", "text");
        }
        out.println("var " + template.getFieldName() + "Empty = isWhitespace(stripInitialWhitespace(field.value));");
        if (template.isMandatory() && PagesContext2.useMandatory()) {
            out.println("\tif (" + template.getFieldName() + "Empty) {");
            out.println("\t\terrorMsg+=\"  - '" + template.getLabel(language) + "' " + Util.getString("GML.MustBeFilled", language) + "\\n\";");
            out.println("\t\terrorNb++;");
            out.println("\t}");
        }
        out.println(" if (!" + template.getFieldName() + "Empty) {");
        out.println("var reg=new RegExp(\"^([01][0-9]|2[0-3]):([0-5][0-9])$\",\"g\");");
        out.println("if (!reg.test(field.value)) {");
        out.println("\t\terrorMsg+=\"  - '" + template.getLabel(language) + "' " + Util.getString("GML.MustContainsCorrectHour", language) + "\\n \";");
        out.println("\t\terrorNb++;");
        out.println("}");
        out.println("}");
        Util.getJavascriptChecker(template.getFieldName(), PagesContext2, out);
    }

    @Override
    public void display(PrintWriter out, TextField field, FieldTemplate template, PagesContext pageContext) throws FormException {
        String value = "";
        String html = "";
        String fieldName = template.getFieldName();
        SilverTrace.info("form", "TimeFieldDisplayer.display", "root.MSG_GEN_PARAM_VALUE", "fieldName=" + fieldName);
        Map<String, String> parameters = template.getParameters(pageContext.getLanguage());
        if (field == null) {
            return;
        }
        if (!field.getTypeName().equals("text")) {
            SilverTrace.info("form", "TimeFieldDisplayer.display", "form.INFO_NOT_CORRECT_TYPE", "text");
        }
        String defaultParam = parameters.containsKey("default") ? parameters.get("default") : "";
        String defaultValue = "";
        if ("now".equalsIgnoreCase(defaultParam) && !pageContext.isIgnoreDefaultValues()) {
            defaultValue = DateUtil.formatTime(new Date());
        }
        String string = value = !field.isNull() ? field.getValue(pageContext.getLanguage()) : defaultValue;
        if (pageContext.isBlankFieldsUse()) {
            value = "";
        }
        if (template.isReadOnly() && !template.isHidden()) {
            html = value;
        } else {
            input inputField = new input();
            inputField.setName(template.getFieldName());
            inputField.setID(template.getFieldName());
            inputField.setValue(EncodeHelper.javaStringToHtmlString(value));
            inputField.setType(template.isHidden() ? "hidden" : "text");
            inputField.setMaxlength("5");
            inputField.setSize("10");
            if (template.isDisabled()) {
                inputField.setDisabled(true);
            } else if (template.isReadOnly()) {
                inputField.setReadOnly(true);
            }
            img image = null;
            if (template.isMandatory() && !template.isDisabled() && !template.isReadOnly() && !template.isHidden() && pageContext.useMandatory()) {
                image = new img();
                image.setSrc(Util.getIcon("mandatoryField"));
                image.setWidth(5);
                image.setHeight(5);
                image.setBorder(0);
            }
            if (image != null) {
                ElementContainer container = new ElementContainer();
                container.addElement((Element)inputField);
                container.addElement("&nbsp;");
                container.addElement((Element)image);
                out.println(container.toString());
            } else {
                out.println(inputField.toString());
            }
        }
        out.println(html);
    }

    @Override
    public List<String> update(String newValue, TextField field, FieldTemplate template, PagesContext PagesContext2) throws FormException {
        if (!"text".equals(field.getTypeName())) {
            throw new FormException("TimeFieldDisplayer.update", "form.EX_NOT_CORRECT_TYPE", "text");
        }
        if (!field.acceptValue(newValue, PagesContext2.getLanguage())) {
            throw new FormException("TimeFieldDisplayer.update", "form.EX_NOT_CORRECT_VALUE", "text");
        }
        field.setValue(newValue, PagesContext2.getLanguage());
        return Collections.emptyList();
    }

    @Override
    public boolean isDisplayedMandatory() {
        return true;
    }

    @Override
    public int getNbHtmlObjectsDisplayed(FieldTemplate template, PagesContext pagesContext) {
        return 1;
    }
}

