/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.form.record;

import com.silverpeas.form.FormException;
import com.silverpeas.form.FormRuntimeException;
import com.silverpeas.form.record.GenericRecordSetManager;
import com.silverpeas.form.record.RecordRow;
import com.silverpeas.publicationTemplate.PublicationTemplate;
import com.silverpeas.publicationTemplate.PublicationTemplateException;
import com.silverpeas.publicationTemplate.PublicationTemplateManager;
import com.silverpeas.util.StringUtil;
import com.silverpeas.util.security.EncryptionContentIterator;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.util.DBUtil;
import com.stratelia.webactiv.util.JNDINames;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.silverpeas.util.crypto.CryptoException;

public class FormEncryptionContentIterator
implements EncryptionContentIterator {
    String formName;
    Iterator<Map<String, String>> contents;
    Connection con;

    public FormEncryptionContentIterator() {
    }

    public FormEncryptionContentIterator(String formName) {
        this.formName = formName;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map<String, String> next() {
        return this.contents.next();
    }

    @Override
    public boolean hasNext() {
        boolean hasNext = this.contents.hasNext();
        if (!hasNext) {
            this.commitConnection();
        }
        return hasNext;
    }

    @Override
    public void update(Map<String, String> updatedContent) {
        SilverTrace.info("form", this.getClass().getName() + ".update()", "root.MSG_GEN_ENTER_METHOD", updatedContent.size() + " items to update");
        ArrayList<RecordRow> rowsToUpdate = new ArrayList<RecordRow>();
        for (Map.Entry<String, String> entry : updatedContent.entrySet()) {
            String key = entry.getKey();
            String[] recordIdAndFieldName = StringUtil.splitByWholeSeparator((String)key, (String)"$SP$");
            RecordRow rowToUpdate = new RecordRow(Integer.parseInt(recordIdAndFieldName[0]), recordIdAndFieldName[1], entry.getValue());
            rowsToUpdate.add(rowToUpdate);
        }
        SilverTrace.info("form", this.getClass().getName() + ".update()", "root.MSG_GEN_PARAM_VALUE", rowsToUpdate.size() + " fields to update");
        try {
            FormEncryptionContentIterator.getGenericRecordSetManager().updateFieldRows(this.getConnection(), rowsToUpdate);
        }
        catch (Exception e) {
            SilverTrace.info("form", this.getClass().getName() + ".update()", "form.EXP_UPDATE_FAILED", e);
            this.rollbackConnection();
            throw new FormRuntimeException("FormEncryptionContentIterator.update", 4, "form.EXP_UPDATE_FAILED", e);
        }
        SilverTrace.info("form", this.getClass().getName() + ".update()", "root.MSG_GEN_EXIT_METHOD", rowsToUpdate.size() + "Fields updated !");
    }

    @Override
    public void onError(Map<String, String> content, CryptoException ex) {
        SilverTrace.error("form", this.getClass().getName() + ".onError()", "form.ERROR_DURING_ENCRYPTION", ex);
        this.rollbackConnection();
        throw new FormRuntimeException("FormEncryptionContentIterator", 4, "form.ERROR_DURING_ENCRYPTION", ex);
    }

    @Override
    public void init() {
        ArrayList<Map<String, String>> contents = new ArrayList<Map<String, String>>();
        if (StringUtil.isDefined(this.formName)) {
            Map<String, String> toProcess = this.getFormData(this.formName);
            contents.add(toProcess);
        } else {
            List<PublicationTemplate> forms;
            try {
                forms = PublicationTemplateManager.getInstance().getCryptedPublicationTemplates();
            }
            catch (PublicationTemplateException e) {
                throw new FormRuntimeException("FormEncryptionContentIterator", 4, "form.EXP_SELECT_FAILED", e);
            }
            for (PublicationTemplate form : forms) {
                contents.add(this.getFormData(form.getFileName()));
            }
        }
        this.contents = contents.iterator();
        this.openConnection();
    }

    private Map<String, String> getFormData(String formName) {
        List<Object> rows = new ArrayList();
        try {
            rows = FormEncryptionContentIterator.getGenericRecordSetManager().getAllRecordsOfTemplate(formName);
        }
        catch (FormException e) {
            throw new FormRuntimeException("FormEncryptionContentIterator.getFormData", 4, "form.EXP_SELECT_FAILED", e);
        }
        HashMap<String, String> toProcess = new HashMap<String, String>();
        for (RecordRow recordRow : rows) {
            toProcess.put(recordRow.getRecordId() + "$SP$" + recordRow.getFieldName(), recordRow.getFieldValue());
        }
        SilverTrace.info("form", this.getClass().getName() + ".getFormData()", "root.MSG_GEN_PARAM_VALUE", toProcess.size() + " rows to process with form " + formName);
        return toProcess;
    }

    private static GenericRecordSetManager getGenericRecordSetManager() {
        return GenericRecordSetManager.getInstance();
    }

    private void openConnection() {
        try {
            this.con = DBUtil.makeConnection(JNDINames.FORMTEMPLATE_DATASOURCE);
            this.con.setAutoCommit(false);
        }
        catch (Exception e) {
            throw new FormRuntimeException("FormEncryptionContentIterator.openConnection", 4, "root.EX_CONNECTION_OPEN_FAILED", e);
        }
    }

    private Connection getConnection() {
        return this.con;
    }

    private void rollbackConnection() {
        DBUtil.rollback(this.con);
        DBUtil.close(this.con);
    }

    private void commitConnection() {
        try {
            this.con.commit();
        }
        catch (SQLException e) {
            throw new FormRuntimeException("FormEncryptionContentIterator.commitConnection", 4, "root.EX_ERR_COMMIT", e);
        }
        finally {
            DBUtil.close(this.con);
        }
    }
}

