/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.form.record;

import com.silverpeas.form.DataRecord;
import com.silverpeas.form.Field;
import com.silverpeas.form.FieldDisplayer;
import com.silverpeas.form.FieldTemplate;
import com.silverpeas.form.FormException;
import com.silverpeas.form.PagesContext;
import com.silverpeas.form.RecordTemplate;
import com.silverpeas.form.TypeManager;
import com.silverpeas.form.record.GenericFieldTemplate;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GenericDataRecord
implements DataRecord,
Serializable {
    private static final long serialVersionUID = 1L;
    private int id = -1;
    private String externalId = null;
    private Field[] fields = null;
    private RecordTemplate template = null;
    private String language = null;
    private Map<String, List<Field>> fieldsByName = null;

    public GenericDataRecord(RecordTemplate template) throws FormException {
        this.template = template;
        ArrayList allFields = new ArrayList();
        this.fieldsByName = new HashMap<String, List<Field>>();
        for (String fieldName : template.getFieldNames()) {
            FieldTemplate fieldTemplate = template.getFieldTemplate(fieldName);
            ArrayList<Field> occurrences = new ArrayList<Field>();
            int maximumNumberOfOccurrences = fieldTemplate.getMaximumNumberOfOccurrences();
            for (int o = 0; o < maximumNumberOfOccurrences; ++o) {
                Field field = fieldTemplate.getEmptyField(o);
                occurrences.add(field);
            }
            this.fieldsByName.put(fieldName, occurrences);
            allFields.addAll(occurrences);
        }
        this.fields = allFields.toArray(new Field[allFields.size()]);
    }

    @Override
    public String getId() {
        return this.externalId;
    }

    @Override
    public void setId(String id) {
        this.externalId = id;
    }

    public Field[] getFields() {
        return this.fields;
    }

    @Override
    public Field getField(String fieldName) throws FormException {
        return this.getField(fieldName, 0);
    }

    @Override
    public Field getField(String fieldName, int occurrence) {
        List<Field> occurrences = this.fieldsByName.get(fieldName);
        Field field = null;
        if (occurrences != null && occurrence < occurrences.size()) {
            field = occurrences.get(occurrence);
        }
        if (field == null) {
            SilverTrace.warn("form", "GenericDataRecord.getField", "form.EXP_UNKNOWN_FIELD", "fieldName '" + fieldName + "' in DB not found in XML descriptor");
        }
        return field;
    }

    @Override
    public Field getField(int fieldIndex) throws FormException {
        if (fieldIndex >= 0 && fieldIndex < this.fields.length) {
            return this.fields[fieldIndex];
        }
        throw new FormException("DataRecord", "form.EXP_INDEX_OUT_OF_BOUNDS");
    }

    @Override
    public boolean isNew() {
        return this.id == -1;
    }

    int getInternalId() {
        return this.id;
    }

    void setInternalId(int id) {
        this.id = id;
    }

    @Override
    public String[] getFieldNames() {
        return this.template.getFieldNames();
    }

    @Override
    public String getLanguage() {
        return this.language;
    }

    @Override
    public void setLanguage(String language) {
        this.language = language;
    }

    @Override
    public Map<String, String> getValues(String language) {
        HashMap<String, String> formValues = new HashMap<String, String>();
        String[] fieldNames = this.getFieldNames();
        PagesContext pageContext = new PagesContext();
        pageContext.setLanguage(language);
        for (String fieldName : fieldNames) {
            try {
                Field field = this.getField(fieldName);
                GenericFieldTemplate fieldTemplate = (GenericFieldTemplate)this.template.getFieldTemplate(fieldName);
                FieldDisplayer fieldDisplayer = TypeManager.getInstance().getDisplayer(fieldTemplate.getTypeName(), "simpletext");
                StringWriter sw = new StringWriter();
                PrintWriter out = new PrintWriter(sw);
                fieldDisplayer.display(out, field, fieldTemplate, pageContext);
                formValues.put(fieldName, sw.toString());
            }
            catch (Exception e) {
                SilverTrace.warn("form", "GenericDataRecord.getValues", "CANT_GET_FIELD_VALUE", "objectId = " + this.externalId + "fieldName = " + fieldName, e);
            }
        }
        return formValues;
    }
}

