/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.scheduler.quartz;

import com.silverpeas.scheduler.Job;
import com.silverpeas.scheduler.JobExecutionContext;
import com.silverpeas.scheduler.ScheduledJob;
import com.silverpeas.scheduler.Scheduler;
import com.silverpeas.scheduler.SchedulerEvent;
import com.silverpeas.scheduler.SchedulerEventListener;
import com.silverpeas.scheduler.SchedulerException;
import com.silverpeas.scheduler.quartz.QuartzSchedulerJob;
import com.silverpeas.scheduler.quartz.QuartzTriggerBuilder;
import com.silverpeas.scheduler.trigger.JobTrigger;
import com.silverpeas.util.AssertArgument;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Named;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionException;
import org.quartz.Trigger;
import org.quartz.impl.StdSchedulerFactory;

@Named(value="scheduler")
public class QuartzScheduler
implements Scheduler {
    private static final String SCHEDULED_JOB = "job";
    private org.quartz.Scheduler backend;

    protected QuartzScheduler() throws SchedulerException {
        StdSchedulerFactory quartzSchedulerFactory = new StdSchedulerFactory();
        try {
            this.backend = quartzSchedulerFactory.getScheduler();
            this.backend.start();
            SilverTrace.info("scheduler", this.getClass().getSimpleName() + ".<init>()", "root.EX_NO_MESSAGE", this.getClass().getSimpleName() + " is started");
        }
        catch (org.quartz.SchedulerException ex) {
            SilverTrace.fatal("scheduler", this.getClass().getSimpleName() + ".<init>()", "root.EX_NO_MESSAGE", this.getClass().getSimpleName() + " failed to start", ex);
            throw new SchedulerException(ex.getMessage(), ex);
        }
    }

    @Override
    public ScheduledJob scheduleJob(String jobName, JobTrigger trigger, SchedulerEventListener listener) throws SchedulerException {
        QuartzScheduler.checkArguments(jobName, trigger, listener);
        QuartzSchedulerJob job = new QuartzSchedulerJob(jobName, trigger).withSchedulerEventListener(listener);
        JobDetail jobDetail = new JobDetail(jobName, QuartzJob.class);
        jobDetail.getJobDataMap().put((Object)SCHEDULED_JOB, (Object)job);
        try {
            this.schedule(job, jobDetail);
            return job;
        }
        catch (Exception ex) {
            SilverTrace.error("scheduler", this.getClass().getSimpleName() + ".scheduleJob()", "root.EX_NO_MESSAGE", "The scheduling of the job '" + jobName + "' failed!", ex);
            throw new SchedulerException(ex.getMessage(), ex);
        }
    }

    @Override
    public ScheduledJob scheduleJob(Job theJob, JobTrigger trigger, SchedulerEventListener listener) throws SchedulerException {
        QuartzScheduler.checkArguments(theJob, trigger);
        QuartzSchedulerJob job = new QuartzSchedulerJob(theJob, trigger).withSchedulerEventListener(listener);
        JobDetail jobDetail = new JobDetail(theJob.getName(), QuartzJob.class);
        jobDetail.getJobDataMap().put((Object)SCHEDULED_JOB, (Object)job);
        try {
            this.schedule(job, jobDetail);
            return job;
        }
        catch (Exception ex) {
            SilverTrace.error("scheduler", this.getClass().getSimpleName() + ".scheduleJob()", "root.EX_NO_MESSAGE", "The scheduling of the job '" + theJob.getName() + "' failed!", ex);
            throw new SchedulerException(ex.getMessage(), ex);
        }
    }

    @Override
    public ScheduledJob scheduleJob(Job theJob, JobTrigger trigger) throws SchedulerException {
        return this.scheduleJob(theJob, trigger, null);
    }

    @Override
    public void unscheduleJob(String jobName) throws SchedulerException {
        QuartzScheduler.checkJobName(jobName);
        try {
            this.backend.deleteJob(jobName, "DEFAULT");
        }
        catch (org.quartz.SchedulerException ex) {
            SilverTrace.error("scheduler", this.getClass().getSimpleName() + ".unscheduleJob()", "root.EX_NO_MESSAGE", "The unscheduling of the job '" + jobName + "' failed!", ex);
            throw new SchedulerException(ex.getMessage(), ex);
        }
    }

    @Override
    public boolean isJobScheduled(String jobName) {
        QuartzScheduler.checkJobName(jobName);
        try {
            JobDetail jobDetail = this.backend.getJobDetail(jobName, "DEFAULT");
            return jobDetail != null;
        }
        catch (org.quartz.SchedulerException ex) {
            return false;
        }
    }

    @Override
    public void shutdown() throws SchedulerException {
        try {
            SilverTrace.info("scheduler", this.getClass().getSimpleName() + ".shutdown()", "root.EX_NO_MESSAGE", this.getClass().getSimpleName() + " is shutdown");
            this.backend.shutdown();
        }
        catch (org.quartz.SchedulerException ex) {
            SilverTrace.fatal("scheduler", this.getClass().getSimpleName() + ".shutdown()", "root.EX_NO_MESSAGE", "The scheduler shutdown failed!", ex);
            throw new SchedulerException(ex.getMessage(), ex);
        }
    }

    private void schedule(QuartzSchedulerJob job, JobDetail jobDetail) throws org.quartz.SchedulerException {
        Trigger quartzTrigger = QuartzTriggerBuilder.buildFrom(job);
        this.backend.scheduleJob(jobDetail, quartzTrigger);
        job.setNextExecutionTime(quartzTrigger.getNextFireTime());
    }

    private static void checkArguments(String jobName, JobTrigger trigger, SchedulerEventListener listener) {
        QuartzScheduler.checkJobName(jobName);
        QuartzScheduler.checkJobTrigger(trigger);
        AssertArgument.assertNotNull(listener, "The scheduler event listener shouldn't be null");
    }

    private static void checkArguments(Job job, JobTrigger trigger) {
        AssertArgument.assertNotNull(job, "The job should not be null");
        QuartzScheduler.checkJobTrigger(trigger);
    }

    private static void checkJobName(String jobName) {
        AssertArgument.assertDefined(jobName, "The job name should be defined");
    }

    private static void checkJobTrigger(JobTrigger trigger) {
        AssertArgument.assertNotNull(trigger, "The job trigger shouldn't be null");
    }

    public static class QuartzJob
    implements org.quartz.Job {
        public void execute(org.quartz.JobExecutionContext jec) throws JobExecutionException {
            JobDataMap data = jec.getJobDetail().getJobDataMap();
            QuartzSchedulerJob job = (QuartzSchedulerJob)data.get((Object)QuartzScheduler.SCHEDULED_JOB);
            SchedulerEventListener eventListener = job.getSchedulerEventListener();
            job.setNextExecutionTime(jec.getNextFireTime());
            JobExecutionContext context = JobExecutionContext.createWith(job.getName(), jec.getFireTime());
            if (eventListener == null) {
                try {
                    job.execute(context);
                }
                catch (Exception ex) {
                    SilverTrace.error("scheduler", QuartzScheduler.class.getName(), ex.getMessage(), ex);
                }
            } else {
                try {
                    eventListener.triggerFired(SchedulerEvent.triggerFired(context));
                    job.execute(context);
                    eventListener.jobSucceeded(SchedulerEvent.jobSucceeded(context));
                }
                catch (Exception ex) {
                    try {
                        eventListener.jobFailed(SchedulerEvent.jobFailed(context, ex));
                    }
                    catch (Exception e) {
                        Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "Error while executing job " + job.getName() + ": " + e.getMessage(), e);
                    }
                }
            }
        }
    }
}

