/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.scheduler.quartz;

import com.silverpeas.scheduler.Job;
import com.silverpeas.scheduler.JobExecutionContext;
import com.silverpeas.scheduler.ScheduledJob;
import com.silverpeas.scheduler.SchedulerEventListener;
import com.silverpeas.scheduler.trigger.JobTrigger;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import java.io.Serializable;
import java.util.Date;

public class QuartzSchedulerJob
implements ScheduledJob,
Serializable {
    private static final long serialVersionUID = 5310306615365508746L;
    private Job job;
    private JobTrigger trigger;
    private SchedulerEventListener listener;
    private long nextFireTime;

    protected QuartzSchedulerJob(String name, JobTrigger trigger) {
        this.job = new Job(name){

            @Override
            public void execute(JobExecutionContext context) {
                SilverTrace.debug("scheduler", this.getClass().getSimpleName() + "<init>()", "root.EX_NO_MESSAGE", "Empty job: the job is delegated to an event listener.");
            }
        };
        this.trigger = trigger;
    }

    protected QuartzSchedulerJob(Job jobToExecute, JobTrigger trigger) {
        this.job = jobToExecute;
        this.trigger = trigger;
    }

    protected QuartzSchedulerJob withSchedulerEventListener(SchedulerEventListener listener) {
        this.listener = listener;
        return this;
    }

    @Override
    public String getName() {
        return this.job.getName();
    }

    @Override
    public JobTrigger getTrigger() {
        return this.trigger;
    }

    @Override
    public SchedulerEventListener getSchedulerEventListener() {
        return this.listener;
    }

    @Override
    public void execute(JobExecutionContext context) throws Exception {
        this.job.execute(context);
    }

    @Override
    public Date getNextExecutionTime() {
        return new Date(this.nextFireTime);
    }

    @Override
    public long getNexExecutionTimeInMillis() {
        return this.nextFireTime;
    }

    protected void setNextExecutionTime(Date executionTime) {
        this.nextFireTime = executionTime.getTime();
    }
}

