/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.socialnetwork.status;

import com.silverpeas.socialnetwork.model.SocialInformation;
import com.silverpeas.socialnetwork.status.SocialInformationStatus;
import com.silverpeas.socialnetwork.status.Status;
import com.stratelia.webactiv.util.DBUtil;
import com.stratelia.webactiv.util.exception.UtilException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class StatusDao {
    private static final String INSERT_STATUS = "INSERT INTO sb_sn_status (id, userid, creationdate, description) VALUES (?, ?, ?, ?)";
    private static final String DELETE_STATUS = "DELETE FROM sb_sn_status WHERE id = ?";
    private static final String SELECT_STATUS_BY_ID = "SELECT id,userid, creationdate, description FROM sb_sn_status  WHERE id = ? ";
    private static final String SELECT_LAST_STATUS_BY_USERID = " SELECT * FROM sb_sn_status WHERE userid = ? ORDER BY creationdate DESC";
    private static final String UPDATE_STATUS_BY_ID = "UPDATE sb_sn_status  SET  description = ? WHERE id = ? ";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int changeStatus(Connection connection, Status status) throws UtilException, SQLException {
        int id = DBUtil.getNextId("sb_sn_status", "id");
        PreparedStatement pstmt = null;
        try {
            pstmt = connection.prepareStatement(INSERT_STATUS);
            pstmt.setInt(1, id);
            pstmt.setInt(2, status.getUserId());
            pstmt.setTimestamp(3, new Timestamp(status.getCreationDate().getTime()));
            pstmt.setString(4, status.getDescription());
            pstmt.executeUpdate();
        }
        finally {
            DBUtil.close(pstmt);
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteStatus(Connection connection, int id) throws SQLException {
        PreparedStatement pstmt = null;
        boolean endAction = false;
        try {
            pstmt = connection.prepareStatement(DELETE_STATUS);
            pstmt.setInt(1, id);
            pstmt.executeUpdate();
            endAction = true;
        }
        finally {
            DBUtil.close(pstmt);
        }
        return endAction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Status getStatus(Connection connection, int id) throws SQLException {
        Status status = null;
        ResultSet rs = null;
        PreparedStatement pstmt = null;
        try {
            pstmt = connection.prepareStatement(SELECT_STATUS_BY_ID);
            pstmt.setInt(1, id);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                status = new Status();
                status.setId(rs.getInt(1));
                status.setUserId(rs.getInt(2));
                status.setCreationDate(new Date(rs.getTimestamp(3).getTime()));
                status.setDescription(rs.getString(4));
            }
        }
        finally {
            DBUtil.close(pstmt);
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Status getLastStatus(Connection connection, int userid) throws SQLException {
        Status status = new Status();
        ResultSet rs = null;
        PreparedStatement pstmt = null;
        try {
            pstmt = connection.prepareStatement(SELECT_LAST_STATUS_BY_USERID);
            pstmt.setInt(1, userid);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                status.setId(rs.getInt(1));
                status.setUserId(rs.getInt(2));
                status.setCreationDate(new Date(rs.getTimestamp(3).getTime()));
                status.setDescription(rs.getString(4));
            }
        }
        finally {
            DBUtil.close(pstmt);
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateStatus(Connection connection, Status status) throws SQLException {
        PreparedStatement pstmt = null;
        boolean endAction = false;
        try {
            pstmt = connection.prepareStatement(UPDATE_STATUS_BY_ID);
            pstmt.setString(1, status.getDescription());
            pstmt.setInt(2, status.getId());
            pstmt.executeUpdate();
            endAction = true;
        }
        finally {
            DBUtil.close(pstmt);
        }
        return endAction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SocialInformation> getAllStatus(Connection connection, int userId, Date begin, Date end) throws SQLException {
        List<SocialInformation> list;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            String query = "SELECT id,userid, creationdate, description FROM sb_sn_status WHERE userid = ? and creationdate >= ? and creationdate <= ? ORDER BY creationdate DESC";
            pstmt = connection.prepareStatement(query);
            pstmt.setInt(1, userId);
            pstmt.setTimestamp(2, new Timestamp(begin.getTime()));
            pstmt.setTimestamp(3, new Timestamp(end.getTime()));
            rs = pstmt.executeQuery();
            list = this.getSocialInformationsList(rs);
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, pstmt);
            throw throwable;
        }
        DBUtil.close(rs, pstmt);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<SocialInformation> getSocialInformationsListOfMyContacts(Connection connection, List<String> myContactsIds, Date begin, Date end) throws SQLException {
        List<SocialInformation> list;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            String query = "SELECT id,userid, creationdate, description FROM sb_sn_status WHERE userid in (" + StatusDao.toSqlString(myContactsIds) + ") " + "AND creationdate >= ? AND creationdate <= ? " + "ORDER BY creationdate DESC";
            pstmt = connection.prepareStatement(query);
            pstmt.setTimestamp(1, new Timestamp(begin.getTime()));
            pstmt.setTimestamp(2, new Timestamp(end.getTime()));
            rs = pstmt.executeQuery();
            list = this.getSocialInformationsList(rs);
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, pstmt);
            throw throwable;
        }
        DBUtil.close(rs, pstmt);
        return list;
    }

    private List<SocialInformation> getSocialInformationsList(ResultSet rs) throws SQLException {
        ArrayList<SocialInformation> status_list = new ArrayList<SocialInformation>();
        while (rs.next()) {
            Status status = new Status();
            status.setId(rs.getInt(1));
            status.setUserId(rs.getInt(2));
            status.setCreationDate(new Date(rs.getTimestamp(3).getTime()));
            status.setDescription(rs.getString(4));
            status_list.add(new SocialInformationStatus(status));
        }
        return status_list;
    }

    private static String toSqlString(List<String> list) {
        StringBuilder result = new StringBuilder(100);
        if (list == null || list.isEmpty()) {
            return "''";
        }
        int i = 0;
        for (String var : list) {
            if (i != 0) {
                result.append(",");
            }
            result.append("'").append(var).append("'");
            ++i;
        }
        return result.toString();
    }
}

