/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.silverpeas.authentication.security;

import com.stratelia.silverpeas.authentication.security.SecurityCache;
import com.stratelia.silverpeas.authentication.security.SecurityData;
import java.util.HashMap;

public class SecurityHolder {
    private static SecurityCache securityCache = new SecurityCache();
    private static HashMap<String, SecurityData> persistentCache = new HashMap();

    public static void addData(String securityId, String userId, String domainId) {
        SecurityHolder.addData(securityId, userId, domainId, false);
    }

    public static void addData(String securityId, String userId, String domainId, boolean persistent) {
        if (persistent) {
            persistentCache.put(securityId, new SecurityData(userId, domainId));
        } else {
            securityCache.addData(securityId, userId, domainId);
        }
    }

    public static SecurityData getData(String securityId) {
        SecurityData securityData = securityCache.getData(securityId);
        if (securityData == null) {
            securityData = SecurityHolder.getPersistentData(securityId);
        }
        return securityData;
    }

    private static SecurityData getPersistentData(String securityId) {
        return persistentCache.get(securityId);
    }
}

