/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.silverpeas.domains.ldapdriver;

import com.novell.ldap.LDAPEntry;
import com.silverpeas.util.ArrayUtil;
import com.silverpeas.util.StringUtil;
import com.stratelia.silverpeas.domains.ldapdriver.AbstractLDAPGroup;
import com.stratelia.silverpeas.domains.ldapdriver.LDAPUtility;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.beans.admin.AdminException;
import com.stratelia.webactiv.beans.admin.Group;
import com.stratelia.webactiv.beans.admin.SynchroReport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class LDAPGroupAllRoot
extends AbstractLDAPGroup {
    protected List<String> getMemberGroupIds(String lds, String memberId, boolean isGroup) throws AdminException {
        ArrayList<String> groupsVector = new ArrayList<String>();
        if (StringUtil.isDefined(memberId)) {
            SilverTrace.info("admin", "LDAPGroupAllRoot.getMemberGroupIds()", "root.MSG_GEN_ENTER_METHOD", "MemberId=" + memberId + ", isGroup=" + isGroup);
            LDAPEntry memberEntry = isGroup ? LDAPUtility.getFirstEntryFromSearch(lds, this.driverSettings.getGroupsSpecificGroupsBaseDN(), this.driverSettings.getScope(), this.driverSettings.getGroupsIdFilter(memberId), this.driverSettings.getGroupAttributes()) : LDAPUtility.getFirstEntryFromSearch(lds, this.driverSettings.getLDAPUserBaseDN(), this.driverSettings.getScope(), this.driverSettings.getUsersIdFilter(memberId), this.driverSettings.getGroupAttributes());
            if (memberEntry == null) {
                throw new AdminException("LDAPGroupAllRoot.getMemberGroupIds", 4, "admin.EX_ERR_LDAP_USER_ENTRY_ISNULL", "Id=" + memberId + " IsGroup=" + isGroup);
            }
            String groupsMemberField = this.driverSettings.getGroupsMemberField();
            LDAPEntry[] theEntries = "memberUid".equalsIgnoreCase(groupsMemberField) ? LDAPUtility.search1000Plus(lds, this.driverSettings.getGroupsSpecificGroupsBaseDN(), this.driverSettings.getScope(), "(&" + this.driverSettings.getGroupsFullFilter() + "(" + this.driverSettings.getGroupsMemberField() + "=" + memberId + "))", this.driverSettings.getGroupsNameField(), this.driverSettings.getGroupAttributes()) : LDAPUtility.search1000Plus(lds, this.driverSettings.getGroupsSpecificGroupsBaseDN(), this.driverSettings.getScope(), "(&" + this.driverSettings.getGroupsFullFilter() + "(" + this.driverSettings.getGroupsMemberField() + "=" + memberEntry.getDN() + "))", this.driverSettings.getGroupsNameField(), this.driverSettings.getGroupAttributes());
            for (LDAPEntry currentEntry : theEntries) {
                SilverTrace.info("admin", "LDAPGroupAllRoot.getMemberGroupIds()", "root.MSG_GEN_PARAM_VALUE", "GroupFound=" + currentEntry.getDN());
                groupsVector.add(this.getGroupId(currentEntry));
            }
        }
        return groupsVector;
    }

    @Override
    public String[] getGroupMemberGroupIds(String lds, String groupId) throws AdminException {
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    @Override
    public String[] getUserMemberGroupIds(String lds, String userId) throws AdminException {
        HashSet<String> groupsManaged = new HashSet<String>();
        List<String> groupsIdsSet = this.getMemberGroupIds(lds, userId, false);
        while (groupsIdsSet.size() > 0) {
            ArrayList<String> groupsCur = new ArrayList<String>();
            for (String grId : groupsIdsSet) {
                if (!StringUtil.isDefined(grId) || groupsManaged.contains(grId)) continue;
                groupsManaged.add(grId);
                groupsCur.addAll(this.getMemberGroupIds(lds, grId, true));
            }
            groupsIdsSet = groupsCur;
        }
        return groupsManaged.toArray(new String[groupsManaged.size()]);
    }

    @Override
    protected String[] getUserIds(String lds, LDAPEntry groupEntry) throws AdminException {
        HashSet<String> usersManaged = new HashSet<String>();
        HashSet<String> groupsManaged = new HashSet<String>();
        ArrayList<LDAPEntry> groupsSet = new ArrayList<LDAPEntry>();
        groupsSet.add(groupEntry);
        while (groupsSet.size() > 0) {
            ArrayList<LDAPEntry> groupsCur = new ArrayList<LDAPEntry>();
            for (LDAPEntry curGroup : groupsSet) {
                if (curGroup == null) continue;
                String grId = "???";
                try {
                    grId = this.getGroupId(curGroup);
                    if (groupsManaged.contains(grId)) continue;
                    groupsManaged.add(grId);
                    usersManaged.addAll(this.getTRUEUserIds(lds, curGroup));
                    groupsCur.addAll(this.getTRUEChildGroupsEntry(lds, curGroup));
                }
                catch (AdminException e) {
                    SilverTrace.info("admin", "LDAPGroupAllRoot.getUserIds()", "admin.MSG_ERR_LDAP_GENERAL", "GROUP NOT FOUND : " + grId, e);
                }
            }
            groupsSet = groupsCur;
        }
        return usersManaged.toArray(new String[usersManaged.size()]);
    }

    protected List<String> getTRUEUserIds(String lds, LDAPEntry groupEntry) throws AdminException {
        String[] stringVals;
        SilverTrace.info("admin", "LDAPGroupAllRoot.getTRUEUserIds()", "root.MSG_GEN_ENTER_METHOD", "lds = " + lds + ", group = " + groupEntry.getDN());
        ArrayList<String> usersVector = new ArrayList<String>();
        String groupsMemberField = this.driverSettings.getGroupsMemberField();
        for (String memberFieldValue : stringVals = LDAPUtility.getAttributeValues(groupEntry, groupsMemberField)) {
            SilverTrace.info("admin", "LDAPGroupAllRoot.getTRUEUserIds()", "root.MSG_GEN_PARAM_VALUE", memberFieldValue);
            try {
                LDAPEntry userEntry;
                if ("memberUid".equals(groupsMemberField)) {
                    userEntry = this.getUserEntryByUID(lds, memberFieldValue);
                    if (userEntry == null) continue;
                    usersVector.add(memberFieldValue);
                    continue;
                }
                userEntry = this.getUserEntryByDN(lds, memberFieldValue);
                if (userEntry != null) {
                    String userSpecificId = this.getUserId(userEntry);
                    if ((userEntry = this.getUserEntryByUID(lds, userSpecificId)) == null) continue;
                    usersVector.add(userSpecificId);
                    continue;
                }
                LDAPEntry gEntry = this.getGroupEntryByDN(lds, memberFieldValue);
                if (gEntry == null) continue;
                usersVector.addAll(this.getTRUEUserIds(lds, gEntry));
            }
            catch (AdminException e) {
                SilverTrace.error("admin", "LDAPGroupAllRoot.getTRUEUserIds()", "admin.MSG_ERR_LDAP_GENERAL", "USER NOT FOUND : " + LDAPUtility.dblBackSlashesForDNInFilters(memberFieldValue), e);
            }
        }
        SilverTrace.info("admin", "LDAPGroupAllRoot.getTRUEUserIds()", "root.MSG_GEN_EXIT_METHOD");
        return usersVector;
    }

    @Override
    protected LDAPEntry[] getChildGroupsEntry(String lds, String parentId, String extraFilter) throws AdminException {
        if (StringUtil.isDefined(parentId)) {
            return ArrayUtil.EMPTY_LDAP_ENTRY_ARRAY;
        }
        LDAPEntry[] theEntries = null;
        String theFilter = this.driverSettings.getGroupsFullFilter();
        if (StringUtil.isDefined(extraFilter)) {
            theFilter = "(&" + extraFilter + this.driverSettings.getGroupsFullFilter() + ")";
        }
        try {
            SilverTrace.info("admin", "LDAPGroupAllRoot.getChildGroupsEntry()", "root.MSG_GEN_PARAM_VALUE", "Root Group Search");
            theEntries = LDAPUtility.search1000Plus(lds, this.driverSettings.getGroupsSpecificGroupsBaseDN(), this.driverSettings.getScope(), theFilter, this.driverSettings.getGroupsNameField(), this.driverSettings.getGroupAttributes());
            SynchroReport.debug("LDAPGroupAllRoot.getChildGroupsEntry()", "R\u00e9cup\u00e9ration de " + theEntries.length + " groupes racine", null);
        }
        catch (AdminException e) {
            if (this.synchroInProcess) {
                SilverTrace.warn("admin", "LDAPGroupAllRoot.getChildGroupsEntry()", "admin.EX_ERR_CHILD_GROUPS", "ParentGroupId=" + parentId, e);
                this.append("PB getting Group's subgroups : ").append(parentId).append("\n");
                SynchroReport.error("LDAPGroupAllRoot.getChildGroupsEntry()", "Erreur lors de la r\u00e9cup\u00e9ration des groupes racine (parentId = " + parentId + ")", e);
            }
            throw e;
        }
        return theEntries;
    }

    protected List<LDAPEntry> getTRUEChildGroupsEntry(String lds, LDAPEntry theEntry) {
        try {
            LDAPEntry[] entries = LDAPUtility.search1000Plus(lds, theEntry.getDN(), this.driverSettings.getScope(), this.driverSettings.getGroupsFullFilter(), this.driverSettings.getGroupsNameField(), this.driverSettings.getGroupAttributes());
            if (entries != null) {
                ArrayList<LDAPEntry> subGroups = new ArrayList<LDAPEntry>();
                for (LDAPEntry entry : entries) {
                    if (entry.getDN().equals(theEntry.getDN())) continue;
                    subGroups.add(entry);
                }
                return subGroups;
            }
        }
        catch (AdminException e) {
            SilverTrace.error("admin", "LDAPGroupAllRoot.getTRUEChildGroupsEntry()", "admin.MSG_ERR_LDAP_GENERAL", "GETTING SUBGROUPS FAILED FOR : " + theEntry.getDN(), e);
        }
        return new ArrayList<LDAPEntry>();
    }

    @Override
    public Group[] getAllChangedGroups(String lds, String extraFilter) throws AdminException {
        HashMap<String, Group> groupsManaged = new HashMap<String, Group>();
        LDAPEntry[] les = this.getChildGroupsEntry(lds, null, extraFilter);
        ArrayList<LDAPEntry> groupsIdsSet = new ArrayList<LDAPEntry>(les.length);
        for (LDAPEntry childGroupEntry : les) {
            groupsIdsSet.add(childGroupEntry);
            groupsManaged.put(childGroupEntry.getDN(), this.translateGroup(lds, childGroupEntry));
        }
        while (!groupsIdsSet.isEmpty()) {
            ArrayList<LDAPEntry> groupsCur = new ArrayList<LDAPEntry>();
            for (LDAPEntry theGroup : groupsIdsSet) {
                SilverTrace.info("admin", "LDAPGroupAllRoot.getAllChangedGroups()", "root.MSG_GEN_PARAM_VALUE", "GroupTraite2=" + theGroup.getDN());
                for (LDAPEntry childGroupEntry : les = LDAPUtility.search1000Plus(lds, this.driverSettings.getGroupsSpecificGroupsBaseDN(), this.driverSettings.getScope(), "(&" + this.driverSettings.getGroupsFullFilter() + "(" + this.driverSettings.getGroupsMemberField() + "=" + theGroup.getDN() + "))", this.driverSettings.getGroupsNameField(), this.driverSettings.getGroupAttributes())) {
                    SilverTrace.info("admin", "LDAPGroupAllRoot.getAllChangedGroups()", "root.MSG_GEN_PARAM_VALUE", "GroupFound2=" + childGroupEntry.getDN());
                    if (groupsManaged.containsKey(childGroupEntry.getDN())) continue;
                    SilverTrace.info("admin", "LDAPGroupAllRoot.getAllChangedGroups()", "root.MSG_GEN_PARAM_VALUE", "GroupAjoute2=" + childGroupEntry.getDN());
                    groupsCur.add(childGroupEntry);
                    groupsManaged.put(childGroupEntry.getDN(), this.translateGroup(lds, childGroupEntry));
                }
            }
            groupsIdsSet = groupsCur;
        }
        return groupsManaged.values().toArray(new Group[groupsManaged.size()]);
    }

    private String getGroupId(LDAPEntry entry) {
        return LDAPUtility.getFirstAttributeValue(entry, this.driverSettings.getGroupsIdField());
    }

    private String getUserId(LDAPEntry entry) {
        return LDAPUtility.getFirstAttributeValue(entry, this.driverSettings.getUsersIdField());
    }

    private LDAPEntry getUserEntryByUID(String lds, String uid) throws AdminException {
        return LDAPUtility.getFirstEntryFromSearch(lds, this.driverSettings.getLDAPUserBaseDN(), this.driverSettings.getScope(), this.driverSettings.getUsersIdFilter(uid), this.driverSettings.getUserAttributes());
    }

    private LDAPEntry getUserEntryByDN(String lds, String dn) throws AdminException {
        return LDAPUtility.getFirstEntryFromSearch(lds, dn, this.driverSettings.getScope(), this.driverSettings.getUsersFullFilter(), this.driverSettings.getUserAttributes());
    }

    private LDAPEntry getGroupEntryByDN(String lds, String dn) throws AdminException {
        return LDAPUtility.getFirstEntryFromSearch(lds, dn, this.driverSettings.getScope(), this.driverSettings.getGroupsFullFilter(), this.driverSettings.getGroupAttributes());
    }
}

