/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.silverpeas.notificationManager;

import com.stratelia.silverpeas.notificationManager.NotificationManagerException;
import com.stratelia.silverpeas.notificationManager.NotificationManagerSettings;
import com.stratelia.silverpeas.notificationManager.NotificationMetaData;
import com.stratelia.webactiv.beans.admin.UserDetail;
import org.silverpeas.cache.service.CacheServiceFactory;

public class CurrentUserNotificationContext {
    public static CurrentUserNotificationContext getCurrentUserNotificationContext() {
        CurrentUserNotificationContext current = CacheServiceFactory.getRequestCacheService().get(CurrentUserNotificationContext.class.getName(), CurrentUserNotificationContext.class);
        if (current == null) {
            current = new CurrentUserNotificationContext();
            CacheServiceFactory.getRequestCacheService().put(CurrentUserNotificationContext.class.getName(), current);
        }
        return current;
    }

    public void checkManualUserNotification(NotificationMetaData notificationMetaData) throws NotificationManagerException {
        if (NotificationManagerSettings.isUserManualNotificationRecipientLimitEnabled() && notificationMetaData.isManualUserOne()) {
            boolean limitExceeded;
            int nbUserReceivers = notificationMetaData.getAllUserRecipients().size();
            UserDetail currentUser = UserDetail.getCurrentRequester();
            if (currentUser != null) {
                limitExceeded = currentUser.isUserManualNotificationUserReceiverLimit() && currentUser.getUserManualNotificationUserReceiverLimitValue() < nbUserReceivers;
            } else {
                boolean bl = limitExceeded = NotificationManagerSettings.getUserManualNotificationRecipientLimit() < nbUserReceivers;
            }
            if (limitExceeded) {
                throw new NotificationManagerException("CurrentUserNotificationContext", 4, "notificationManager.EX_USER_MANUAL_NOTIFICATION_LIMIT_EXCEEDED");
            }
        }
    }
}

