/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.silverpeas.notificationserver.xml;

import com.stratelia.silverpeas.notificationserver.NotificationData;
import com.stratelia.silverpeas.notificationserver.NotificationTag;
import com.stratelia.silverpeas.notificationserver.xml.CommentContentHandler;
import com.stratelia.silverpeas.notificationserver.xml.LoginContentHandler;
import com.stratelia.silverpeas.notificationserver.xml.MessageContentHandler;
import com.stratelia.silverpeas.notificationserver.xml.PriorityContentHandler;
import com.stratelia.silverpeas.notificationserver.xml.SenderContentHandler;
import com.stratelia.silverpeas.notificationserver.xml.TargetContentHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class NotifyContentHandler
extends DefaultHandler {
    private NotificationData data;
    private XMLReader parser;

    public NotifyContentHandler(NotificationData data, XMLReader parser) {
        this.data = data;
        this.parser = parser;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        NotificationTag tag = NotificationTag.valueOf(qName);
        DefaultHandler child = null;
        switch (tag) {
            case LOGIN: {
                child = new LoginContentHandler(this.data, this, this.parser);
                break;
            }
            case MESSAGE: {
                child = new MessageContentHandler(this.data, this, this.parser);
                break;
            }
            case SENDER: {
                child = new SenderContentHandler(this.data, this, this.parser);
                break;
            }
            case COMMENT: {
                child = new CommentContentHandler(this.data, this, this.parser);
                break;
            }
            case TARGET: {
                child = new TargetContentHandler(this.data, this, this.parser);
                break;
            }
            case PRIORITY: {
                child = new PriorityContentHandler(this.data, this, this.parser);
            }
        }
        if (child != null) {
            this.parser.setContentHandler(child);
            child.startElement(uri, localName, qName, attributes);
        }
    }
}

