/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.webactiv.beans.admin;

import com.silverpeas.util.StringUtil;
import com.stratelia.webactiv.beans.admin.DomainDriver;
import com.stratelia.webactiv.beans.admin.DomainProperty;
import com.stratelia.webactiv.util.ResourceLocator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractDomainDriver
implements DomainDriver {
    protected int domainId = -1;
    protected List<DomainProperty> domainProperties = new ArrayList<DomainProperty>();
    protected String[] keys = null;
    protected String m_PropertiesMultilang = "";
    protected Map<String, HashMap<String, String>> m_PropertiesLabels = new HashMap<String, HashMap<String, String>>();
    protected Map<String, HashMap<String, String>> m_PropertiesDescriptions = new HashMap<String, HashMap<String, String>>();
    protected String[] m_mapParameters = null;
    protected boolean synchroInProcess = false;
    protected boolean x509Enabled = false;

    @Override
    public void init(int domainId, String initParam, String authenticationServer) throws Exception {
        ResourceLocator rs = new ResourceLocator(initParam, "");
        int nbProps = 0;
        this.domainId = domainId;
        this.domainProperties.clear();
        this.m_PropertiesMultilang = rs.getString("property.ResourceFile");
        String s = rs.getString("property.Number");
        if (StringUtil.isDefined(s)) {
            nbProps = Integer.parseInt(s);
        }
        this.keys = new String[nbProps];
        this.m_mapParameters = new String[nbProps];
        for (int i = 1; i <= nbProps; ++i) {
            s = rs.getString("property_" + Integer.toString(i) + ".Name");
            if (s == null || s.length() <= 0) continue;
            DomainProperty newElmt = new DomainProperty(rs, String.valueOf(i));
            this.domainProperties.add(newElmt);
            this.keys[i - 1] = newElmt.getName();
            this.m_mapParameters[i - 1] = newElmt.getMapParameter();
        }
        this.x509Enabled = rs.getBoolean("security.x509.enabled", false);
        this.initFromProperties(rs);
    }

    @Override
    public String[] getPropertiesNames() {
        return this.keys;
    }

    @Override
    public DomainProperty getProperty(String propName) {
        for (DomainProperty domainProp : this.domainProperties) {
            if (!domainProp.getName().equals(propName)) continue;
            return domainProp;
        }
        return null;
    }

    @Override
    public String[] getMapParameters() {
        return this.m_mapParameters;
    }

    @Override
    public List<DomainProperty> getPropertiesToImport(String language) {
        ArrayList<DomainProperty> props = new ArrayList<DomainProperty>();
        Map<String, String> theLabels = this.getPropertiesLabels(language);
        Map<String, String> theDescriptions = this.getPropertiesDescriptions(language);
        this.addPropertiesToImport(props, theDescriptions);
        for (DomainProperty domainProp : this.domainProperties) {
            if (!domainProp.isUsedToImport()) continue;
            String propLabel = theLabels.get(domainProp.getName());
            String propDescription = theDescriptions.get(domainProp.getName());
            domainProp.setLabel(propLabel);
            domainProp.setDescription(propDescription);
            props.add(domainProp);
        }
        return props;
    }

    @Override
    public void addPropertiesToImport(List<DomainProperty> props) {
    }

    @Override
    public void addPropertiesToImport(List<DomainProperty> props, Map<String, String> theDescriptions) {
    }

    @Override
    public Map<String, String> getPropertiesLabels(String language) {
        HashMap<String, String> valret = this.m_PropertiesLabels.get(language);
        if (valret == null) {
            HashMap<String, String> newLabels = new HashMap<String, String>();
            ResourceLocator rs = new ResourceLocator(this.m_PropertiesMultilang, language);
            for (String key : this.keys) {
                newLabels.put(key, rs.getString(key));
            }
            this.m_PropertiesLabels.put(language, newLabels);
            valret = newLabels;
        }
        return valret;
    }

    @Override
    public Map<String, String> getPropertiesDescriptions(String language) {
        HashMap<String, String> valret = this.m_PropertiesDescriptions.get(language);
        if (valret == null) {
            HashMap<String, String> newDescriptions = new HashMap<String, String>();
            ResourceLocator rs = new ResourceLocator(this.m_PropertiesMultilang, language);
            for (String key : this.keys) {
                newDescriptions.put(key, rs.getString(key + ".description"));
            }
            this.m_PropertiesDescriptions.put(language, newDescriptions);
            valret = newDescriptions;
        }
        return valret;
    }

    @Override
    public void initFromProperties(ResourceLocator rs) throws Exception {
    }

    @Override
    public long getDriverActions() {
        if (this.x509Enabled) {
            return 33279L;
        }
        return 511L;
    }

    @Override
    public boolean isSynchroOnLoginEnabled() {
        return false;
    }

    @Override
    public boolean isSynchroThreaded() {
        return false;
    }

    @Override
    public boolean isSynchroOnLoginRecursToGroups() {
        return true;
    }

    @Override
    public boolean isGroupsInheritProfiles() {
        return false;
    }

    @Override
    public boolean mustImportUsers() {
        return true;
    }

    @Override
    public String getTimeStamp(String minTimeStamp) throws Exception {
        return "";
    }

    @Override
    public String getTimeStampField() throws Exception {
        return null;
    }

    @Override
    public boolean isX509CertificateEnabled() {
        return false;
    }

    @Override
    public void beginSynchronization() throws Exception {
        this.synchroInProcess = true;
    }

    @Override
    public boolean isSynchroInProcess() throws Exception {
        return this.synchroInProcess;
    }

    @Override
    public String endSynchronization(boolean cancelSynchro) throws Exception {
        this.synchroInProcess = false;
        return "";
    }

    protected static int idAsInt(String id) {
        if (!StringUtil.isDefined(id)) {
            return -1;
        }
        try {
            return Integer.parseInt(id);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    protected static String idAsString(int id) {
        return String.valueOf(id);
    }
}

