/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.webactiv.beans.admin;

import com.silverpeas.admin.components.ComponentPasteInterface;
import com.silverpeas.admin.components.Instanciateur;
import com.silverpeas.admin.components.Parameter;
import com.silverpeas.admin.components.PasteDetail;
import com.silverpeas.admin.components.Profile;
import com.silverpeas.admin.components.WAComponent;
import com.silverpeas.admin.notification.AdminNotificationService;
import com.silverpeas.admin.spaces.SpaceInstanciator;
import com.silverpeas.admin.spaces.SpaceTemplate;
import com.silverpeas.util.ArrayUtil;
import com.silverpeas.util.StringUtil;
import com.silverpeas.util.i18n.I18NHelper;
import com.stratelia.silverpeas.containerManager.ContainerManager;
import com.stratelia.silverpeas.contentManager.ContentManager;
import com.stratelia.silverpeas.domains.ldapdriver.LDAPSynchroUserItf;
import com.stratelia.silverpeas.peasCore.URLManager;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.SilverpeasRole;
import com.stratelia.webactiv.beans.admin.AdminException;
import com.stratelia.webactiv.beans.admin.AdminGroupInst;
import com.stratelia.webactiv.beans.admin.CompoSpace;
import com.stratelia.webactiv.beans.admin.ComponentI18N;
import com.stratelia.webactiv.beans.admin.ComponentInst;
import com.stratelia.webactiv.beans.admin.ComponentInstLight;
import com.stratelia.webactiv.beans.admin.ComponentInstManager;
import com.stratelia.webactiv.beans.admin.Domain;
import com.stratelia.webactiv.beans.admin.DomainDriver;
import com.stratelia.webactiv.beans.admin.DomainDriverManager;
import com.stratelia.webactiv.beans.admin.DomainDriverManagerFactory;
import com.stratelia.webactiv.beans.admin.DomainProperty;
import com.stratelia.webactiv.beans.admin.Group;
import com.stratelia.webactiv.beans.admin.GroupManager;
import com.stratelia.webactiv.beans.admin.GroupProfileInst;
import com.stratelia.webactiv.beans.admin.GroupProfileInstManager;
import com.stratelia.webactiv.beans.admin.GroupSynchronizationRule;
import com.stratelia.webactiv.beans.admin.GroupsSearchCriteria;
import com.stratelia.webactiv.beans.admin.ProfileInst;
import com.stratelia.webactiv.beans.admin.ProfileInstManager;
import com.stratelia.webactiv.beans.admin.ProfiledObjectManager;
import com.stratelia.webactiv.beans.admin.RightAssignationContext;
import com.stratelia.webactiv.beans.admin.SearchCriteria;
import com.stratelia.webactiv.beans.admin.SearchCriteriaDAOFactory;
import com.stratelia.webactiv.beans.admin.SpaceAndChildren;
import com.stratelia.webactiv.beans.admin.SpaceInst;
import com.stratelia.webactiv.beans.admin.SpaceInstLight;
import com.stratelia.webactiv.beans.admin.SpaceInstManager;
import com.stratelia.webactiv.beans.admin.SpaceProfile;
import com.stratelia.webactiv.beans.admin.SpaceProfileInst;
import com.stratelia.webactiv.beans.admin.SpaceProfileInstManager;
import com.stratelia.webactiv.beans.admin.SpaceWithSubSpacesAndComponents;
import com.stratelia.webactiv.beans.admin.SynchroDomainScheduler;
import com.stratelia.webactiv.beans.admin.SynchroGroupReport;
import com.stratelia.webactiv.beans.admin.SynchroGroupScheduler;
import com.stratelia.webactiv.beans.admin.SynchroReport;
import com.stratelia.webactiv.beans.admin.UserDetail;
import com.stratelia.webactiv.beans.admin.UserDetailsSearchCriteria;
import com.stratelia.webactiv.beans.admin.UserFull;
import com.stratelia.webactiv.beans.admin.UserLog;
import com.stratelia.webactiv.beans.admin.UserManager;
import com.stratelia.webactiv.beans.admin.cache.AdminCache;
import com.stratelia.webactiv.beans.admin.cache.DomainCache;
import com.stratelia.webactiv.beans.admin.cache.GroupCache;
import com.stratelia.webactiv.beans.admin.cache.Space;
import com.stratelia.webactiv.beans.admin.cache.TreeCache;
import com.stratelia.webactiv.beans.admin.dao.GroupSearchCriteriaForDAO;
import com.stratelia.webactiv.beans.admin.dao.UserSearchCriteriaForDAO;
import com.stratelia.webactiv.organization.AdminPersistenceException;
import com.stratelia.webactiv.organization.OrganizationSchemaPool;
import com.stratelia.webactiv.organization.ScheduledDBReset;
import com.stratelia.webactiv.util.DBUtil;
import com.stratelia.webactiv.util.DateUtil;
import com.stratelia.webactiv.util.FileRepositoryManager;
import com.stratelia.webactiv.util.JNDINames;
import com.stratelia.webactiv.util.ResourceLocator;
import com.stratelia.webactiv.util.pool.ConnectionPool;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.time.FastDateFormat;
import org.silverpeas.admin.space.SpaceServiceFactory;
import org.silverpeas.admin.space.quota.ComponentSpaceQuotaKey;
import org.silverpeas.admin.space.quota.DataStorageSpaceQuotaKey;
import org.silverpeas.admin.user.constant.UserAccessLevel;
import org.silverpeas.admin.user.constant.UserState;
import org.silverpeas.quota.exception.QuotaException;
import org.silverpeas.quota.model.Quota;
import org.silverpeas.search.indexEngine.model.FullIndexEntry;
import org.silverpeas.search.indexEngine.model.IndexEngineProxy;
import org.silverpeas.util.ListSlice;

public class Admin {
    private static final String PARAM_MSG_KEY = "root.MSG_GEN_PARAM_VALUE";
    private static final String START_SERVER_MSG = "Admin.startServer";
    public static final String ADMIN_COMPONENT_ID = "ADMIN";
    public static final String SPACE_KEY_PREFIX = "WA";
    private static final Object semaphore = new Object();
    private static boolean delUsersOnDiffSynchro = true;
    private static boolean shouldFallbackGroupNames = true;
    private static boolean shouldFallbackUserLogins = false;
    private static String m_groupSynchroCron = "";
    private static String m_domainSynchroCron = "";
    private static final SpaceInstManager spaceManager = new SpaceInstManager();
    private static final ComponentInstManager componentManager = new ComponentInstManager();
    private static final ProfileInstManager profileManager = new ProfileInstManager();
    private static final SpaceProfileInstManager spaceProfileManager = new SpaceProfileInstManager();
    private final GroupManager groupManager;
    private final UserManager userManager = UserManager.get();
    private static final ProfiledObjectManager profiledObjectManager = new ProfiledObjectManager();
    private static final GroupProfileInstManager groupProfileManager = new GroupProfileInstManager();
    private static Instanciateur componentInstanciator = null;
    private static SpaceInstanciator spaceInstanciator = null;
    private static int m_nEntrepriseClientSpaceId = 0;
    private static String administratorMail = null;
    private static String m_sDAPIGeneralAdminId = null;
    private static Map<String, UserLog> loggedUsers = Collections.synchronizedMap(new HashMap(100));
    private static FastDateFormat formatter = FastDateFormat.getInstance((String)"dd/MM/yyyy HH:mm:ss:S");
    private static final AdminCache cache = new AdminCache();
    private static final ScheduledDBReset scheduledDBReset;
    public static final String basketSuffix = " (Restaur\u00e9)";
    private static SynchroGroupScheduler groupSynchroScheduler;
    private static SynchroDomainScheduler domainSynchroScheduler;
    private static ResourceLocator roleMapping;
    private static boolean useProfileInheritance;
    private static transient boolean cacheLoaded;
    @Inject
    @Named(value="adminNotificationService")
    AdminNotificationService adminNotificationService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Admin() {
        this.groupManager = GroupManager.get();
        if (spaceInstanciator == null) {
            spaceInstanciator = new SpaceInstanciator(this.getAllComponents());
        }
        Class<Admin> clazz = Admin.class;
        synchronized (Admin.class) {
            if (!cacheLoaded) {
                this.reloadCache();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public void reloadCache() {
        cache.resetCache();
        TreeCache.clearCache();
        GroupCache.clearCache();
        try {
            SilverTrace.info("admin", START_SERVER_MSG, PARAM_MSG_KEY, "Start filling tree cache...");
            List<SpaceInstLight> spaces = spaceManager.getAllSpaces(DomainDriverManagerFactory.getCurrentDomainDriverManager());
            for (SpaceInstLight space : spaces) {
                this.addSpaceInTreeCache(space, false);
            }
            SilverTrace.info("admin", START_SERVER_MSG, PARAM_MSG_KEY, "Tree cache filled !");
        }
        catch (Exception e) {
            SilverTrace.error("admin", "Constructor", "ERROR_WHEN_INITIALIZING_ADMIN", e);
        }
        cacheLoaded = true;
    }

    public void startServer() {
        ArrayList<String> synchroDomainIds = new ArrayList<String>();
        DomainDriverManager ddm = DomainDriverManagerFactory.getCurrentDomainDriverManager();
        Domain[] domains = null;
        try {
            domains = ddm.getAllDomains();
        }
        catch (AdminException e) {
            SilverTrace.error("admin", START_SERVER_MSG, "admin.CANT_LOAD_DOMAINS_DURING_INITIALIZATION", e);
        }
        if (domains != null) {
            for (Domain domain : domains) {
                try {
                    DomainDriver synchroDomain = ddm.getDomainDriver(Integer.parseInt(domain.getId()));
                    if (synchroDomain == null || !synchroDomain.isSynchroThreaded()) continue;
                    synchroDomainIds.add(domain.getId());
                }
                catch (Exception e) {
                    SilverTrace.error("admin", START_SERVER_MSG, "admin.CANT_LOAD_DOMAIN_DURING_INITIALIZATION", "domainId = " + domain.getId(), e);
                }
            }
        }
        domainSynchroScheduler = new SynchroDomainScheduler();
        domainSynchroScheduler.initialize(m_domainSynchroCron, synchroDomainIds);
        Group[] groups = null;
        try {
            groups = this.getSynchronizedGroups();
        }
        catch (AdminException e) {
            SilverTrace.error("admin", START_SERVER_MSG, "admin.CANT_LOAD_SYNCHRONIZED_GROUPS_DURING_INITIALIZATION", e);
        }
        ArrayList<String> synchronizedGroupIds = new ArrayList<String>();
        if (groups != null) {
            for (Group group : groups) {
                if (!group.isSynchronized()) continue;
                synchronizedGroupIds.add(group.getId());
            }
        }
        groupSynchroScheduler = new SynchroGroupScheduler();
        groupSynchroScheduler.initialize(m_groupSynchroCron, synchronizedGroupIds);
    }

    private void addSpaceInTreeCache(SpaceInstLight space, boolean addSpaceToSuperSpace) throws NumberFormatException, AdminException {
        Space spaceInCache = new Space();
        spaceInCache.setSpace(space);
        List<ComponentInstLight> components = componentManager.getComponentsInSpace(Integer.parseInt(space.getShortId()));
        spaceInCache.setComponents(components);
        List<SpaceInstLight> subSpaces = this.getSubSpaces(space.getShortId());
        spaceInCache.setSubspaces(subSpaces);
        TreeCache.addSpace(space.getShortId(), spaceInCache);
        for (SpaceInstLight subSpace : subSpaces) {
            this.addSpaceInTreeCache(subSpace, false);
        }
        if (addSpaceToSuperSpace && !space.isRoot()) {
            TreeCache.addSubSpace(space.getFatherId(), space);
        }
    }

    public String getGeneralSpaceId() {
        return SPACE_KEY_PREFIX + m_nEntrepriseClientSpaceId;
    }

    public void createSpaceIndex(int spaceId) {
        try {
            SpaceInstLight space = this.getSpaceInstLight(String.valueOf(spaceId));
            this.createSpaceIndex(space);
        }
        catch (AdminException e) {
            SilverTrace.error("admin", "admin.createSpaceIndex", PARAM_MSG_KEY, "spaceId = " + spaceId);
        }
    }

    public void createSpaceIndex(SpaceInstLight spaceInst) {
        SilverTrace.info("admin", "admin.createSpaceIndex", PARAM_MSG_KEY, "Space Name : " + spaceInst.getName() + " Space Id : " + spaceInst.getShortId());
        String spaceId = spaceInst.getFullId();
        FullIndexEntry indexEntry = new FullIndexEntry("Spaces", "Space", spaceId);
        indexEntry.setTitle(spaceInst.getName());
        indexEntry.setPreView(spaceInst.getDescription());
        indexEntry.setCreationUser(String.valueOf(spaceInst.getCreatedBy()));
        IndexEngineProxy.addIndexEntry(indexEntry);
    }

    public void deleteSpaceIndex(SpaceInst spaceInst) {
        SilverTrace.info("admin", "admin.deleteSpaceIndex", PARAM_MSG_KEY, "Space Name : " + spaceInst.getName() + " Space Id : " + spaceInst.getId());
        String spaceId = this.getSpaceId(spaceInst);
        FullIndexEntry indexEntry = new FullIndexEntry("Spaces", "Space", spaceId);
        IndexEngineProxy.removeIndexEntry(indexEntry.getPK());
    }

    public String addSpaceInst(String userId, SpaceInst spaceInst) throws AdminException {
        String string;
        Connection connectionProd = null;
        DomainDriverManager domainDriverManager = DomainDriverManagerFactory.getCurrentDomainDriverManager();
        domainDriverManager.startTransaction(false);
        try {
            SilverTrace.info("admin", "admin.addSpaceInst", PARAM_MSG_KEY, "Space Name : " + spaceInst.getName() + " NbCompo: " + spaceInst.getNumComponentInst());
            connectionProd = this.openConnection(false);
            if (!spaceInst.isRoot()) {
                spaceInst.setDomainFatherId(this.getDriverSpaceId(spaceInst.getDomainFatherId()));
                if (useProfileInheritance && !spaceInst.isInheritanceBlocked()) {
                    this.setSpaceProfilesToSubSpace(spaceInst, null);
                }
            }
            spaceInst.setCreatorUserId(userId);
            String sSpaceInstId = spaceManager.createSpaceInst(spaceInst, domainDriverManager);
            spaceInst.setId(this.getClientSpaceId(sSpaceInstId));
            cache.opAddSpace(this.getSpaceInstById(sSpaceInstId, true));
            ArrayList<ComponentInst> alCompoInst = spaceInst.getAllComponentsInst();
            for (ComponentInst componentInst : alCompoInst) {
                componentInst.setDomainFatherId(spaceInst.getId());
                this.addComponentInst(userId, componentInst, false);
            }
            domainDriverManager.commit();
            connectionProd.commit();
            SpaceInstLight space = this.getSpaceInstLight(sSpaceInstId);
            this.addSpaceInTreeCache(space, true);
            SilverTrace.info("admin", "admin.addSpaceInst", PARAM_MSG_KEY, "Indexation : spaceInst = " + spaceInst.getName());
            this.createSpaceIndex(space);
            string = spaceInst.getId();
        }
        catch (Exception e) {
            try {
                try {
                    domainDriverManager.rollback();
                    connectionProd.rollback();
                    cache.resetCache();
                }
                catch (Exception e1) {
                    SilverTrace.error("admin", "Admin.addSpaceInst", "root.EX_ERR_ROLLBACK", e1);
                }
                throw new AdminException("Admin.addSpaceInst", 4, "admin.EX_ERR_ADD_SPACE", "space name : '" + spaceInst.getName() + "'", e);
            }
            catch (Throwable throwable) {
                domainDriverManager.releaseOrganizationSchema();
                DBUtil.close(connectionProd);
                throw throwable;
            }
        }
        domainDriverManager.releaseOrganizationSchema();
        DBUtil.close(connectionProd);
        return string;
    }

    public String deleteSpaceInstById(String userId, String spaceId, boolean definitive) throws AdminException {
        return this.deleteSpaceInstById(userId, spaceId, true, definitive);
    }

    public String deleteSpaceInstById(String userId, String spaceId, boolean startNewTransaction, boolean definitive) throws AdminException {
        if (startNewTransaction && !this.isSpaceManageable(spaceId, userId)) {
            SilverTrace.error("admin", "Admin.deleteSpaceInstById", "admin.USER_NOT_ALLOWED", "User " + userId + " not allowed to delete space " + spaceId);
            throw new AdminException("Admin.deleteSpaceInstById", 4, "admin.USER_NOT_ALLOWED");
        }
        SilverTrace.spy("admin", "Admin.deleteSpaceInstById()", spaceId, "ASP", "", userId, "2");
        DomainDriverManager domainDriverManager = DomainDriverManagerFactory.getFactory().getDomainDriverManager();
        try {
            if (startNewTransaction) {
                domainDriverManager.startTransaction(false);
            }
            String sDriverSpaceId = this.getDriverSpaceId(spaceId);
            SpaceInst spaceInst = this.getSpaceInstById(sDriverSpaceId, true);
            if (!definitive) {
                spaceManager.sendSpaceToBasket(domainDriverManager, spaceInst, userId);
                this.deleteSpaceProfiles(spaceInst);
                this.notifyOnSpaceLogicalDeletion(spaceId, userId);
            } else {
                String[] subSpaceIds;
                for (String subSpaceid : subSpaceIds = this.getAllSubSpaceIds(spaceId)) {
                    this.deleteSpaceInstById(userId, subSpaceid, false, true);
                }
                List<SpaceInstLight> removedSpaces = this.getRemovedSpaces();
                for (SpaceInstLight removedSpace : removedSpaces) {
                    if (!sDriverSpaceId.equals(removedSpace.getFatherId())) continue;
                    this.deleteSpaceInstById(userId, removedSpace.getFullId(), false, true);
                }
                for (int nI = 0; nI < spaceInst.getNumSpaceProfileInst(); ++nI) {
                    this.deleteSpaceProfileInst(spaceInst.getSpaceProfileInst(nI).getId(), false);
                }
                ArrayList<ComponentInst> alCompoInst = spaceInst.getAllComponentsInst();
                for (ComponentInst anAlCompoInst : alCompoInst) {
                    this.deleteComponentInst(userId, this.getClientComponentId(anAlCompoInst), true, false);
                }
                List<ComponentInstLight> removedComponents = this.getRemovedComponents();
                for (ComponentInstLight removedComponent : removedComponents) {
                    if (!spaceId.equals(removedComponent.getDomainFatherId())) continue;
                    this.deleteComponentInst(userId, removedComponent.getId(), true, false);
                }
                spaceManager.deleteSpaceInst(spaceInst, domainDriverManager);
            }
            if (startNewTransaction) {
                domainDriverManager.commit();
            }
            cache.opRemoveSpace(spaceInst);
            TreeCache.removeSpace(sDriverSpaceId);
            this.deleteSpaceIndex(spaceInst);
            String string = spaceId;
            return string;
        }
        catch (Exception e) {
            if (startNewTransaction) {
                this.rollback();
            }
            throw new AdminException("Admin.deleteSpaceInstById", 4, "admin.EX_ERR_DELETE_SPACE", "user Id : '" + userId + "', space Id : '" + spaceId + "'", e);
        }
        finally {
            if (startNewTransaction) {
                domainDriverManager.releaseOrganizationSchema();
            }
        }
    }

    private void notifyOnSpaceLogicalDeletion(String spaceId, String userId) {
        this.adminNotificationService.notifyOnDeletionOf(this.getClientSpaceId(spaceId), userId);
        List<SpaceInstLight> spaces = TreeCache.getSubSpaces(this.getDriverSpaceId(spaceId));
        for (SpaceInstLight space : spaces) {
            this.notifyOnSpaceLogicalDeletion(space.getFullId(), userId);
        }
    }

    private void deleteSpaceProfiles(SpaceInst spaceInst) throws AdminException {
        for (int nI = 0; nI < spaceInst.getNumSpaceProfileInst(); ++nI) {
            this.deleteSpaceProfileInst(spaceInst.getSpaceProfileInst(nI).getId(), false);
        }
        ArrayList<ComponentInst> components = spaceInst.getAllComponentsInst();
        for (ComponentInst component : components) {
            for (int p = 0; p < component.getNumProfileInst(); ++p) {
                if (component.getProfileInst(p).isInherited()) continue;
                this.deleteProfileInst(component.getProfileInst(p).getId(), false);
            }
        }
        String[] subSpaceIds = spaceInst.getSubSpaceIds();
        for (int i = 0; subSpaceIds != null && i < subSpaceIds.length; ++i) {
            SpaceInst subSpace = this.getSpaceInstById(subSpaceIds[i]);
            this.deleteSpaceProfiles(subSpace);
        }
    }

    public void restoreSpaceFromBasket(String spaceId) throws AdminException {
        DomainDriverManager domainDriverManager = DomainDriverManagerFactory.getFactory().getDomainDriverManager();
        domainDriverManager.startTransaction(false);
        try {
            String driverSpaceId = this.getDriverSpaceId(spaceId);
            spaceManager.removeSpaceFromBasket(domainDriverManager, driverSpaceId);
            cache.removeSpaceInst(driverSpaceId);
            TreeCache.removeSpace(driverSpaceId);
            SpaceInst spaceInst = this.getSpaceInstById(driverSpaceId, true);
            if (useProfileInheritance && !spaceInst.isInheritanceBlocked() && !spaceInst.isRoot()) {
                this.updateSpaceInheritance(spaceInst, false);
            }
            domainDriverManager.commit();
            SilverTrace.info("admin", "admin.restoreSpaceFromBasket", PARAM_MSG_KEY, "Indexation : spaceInst = " + spaceInst.getName());
            this.createSpaceIndex(Integer.parseInt(driverSpaceId));
            cache.opAddSpace(spaceInst);
            this.addSpaceInTreeCache(this.getSpaceInstLight(driverSpaceId), true);
        }
        catch (Exception e) {
            this.rollback();
            throw new AdminException("Admin.restoreSpaceFromBasket", 4, "admin.EX_ERR_RESTORE_SPACE_FROM_BASKET", "spaceId = " + spaceId);
        }
        finally {
            domainDriverManager.releaseOrganizationSchema();
        }
    }

    public SpaceInst getSpaceInstById(String spaceId) throws AdminException {
        try {
            SpaceInst spaceInst = this.getSpaceInstById(spaceId, false);
            if (spaceInst == null) {
                return null;
            }
            spaceInst.setId(spaceId);
            ArrayList<ComponentInst> alCompoInst = spaceInst.getAllComponentsInst();
            for (ComponentInst component : alCompoInst) {
                String sClientComponentId = this.getClientComponentId(component);
                component.setId(sClientComponentId);
            }
            String[] asSubSpaceIds = spaceInst.getSubSpaceIds();
            for (int nI = 0; asSubSpaceIds != null && nI < asSubSpaceIds.length; ++nI) {
                asSubSpaceIds[nI] = this.getClientSpaceId(asSubSpaceIds[nI]);
            }
            spaceInst.setSubSpaceIds(asSubSpaceIds);
            return spaceInst;
        }
        catch (Exception e) {
            throw new AdminException("Admin.getSpaceInstById", 4, "admin.EX_ERR_GET_SPACE", " space Id : '" + spaceId + "'", e);
        }
    }

    private SpaceInst getSpaceInstById(String spaceId, boolean useDriverSpaceId) throws AdminException {
        DomainDriverManager domainDriverManager = DomainDriverManagerFactory.getFactory().getDomainDriverManager();
        try {
            String driverSpaceId = useDriverSpaceId ? spaceId : this.getDriverSpaceId(spaceId);
            SpaceInst spaceInst = cache.getSpaceInst(driverSpaceId);
            if (spaceInst == null && (spaceInst = spaceManager.getSpaceInstById(domainDriverManager, driverSpaceId)) != null) {
                cache.putSpaceInst(spaceInst);
            }
            return spaceManager.copy(spaceInst);
        }
        catch (Exception e) {
            throw new AdminException("Admin.getSpaceInstById", 4, "admin.EX_ERR_GET_SPACE", " space Id : '" + spaceId + "'", e);
        }
    }

    public SpaceInst getPersonalSpace(String userId) throws AdminException {
        DomainDriverManager domainDriverManager = DomainDriverManagerFactory.getFactory().getDomainDriverManager();
        return spaceManager.getPersonalSpace(domainDriverManager, userId);
    }

    public String[] getAllSubSpaceIds(String domainFatherId) throws AdminException {
        SilverTrace.debug("admin", "Admin.getAllSubSpaceIds", "root.MSG_GEN_ENTER_METHOD", "father space id: '" + domainFatherId + "'");
        DomainDriverManager domainDriverManager = DomainDriverManagerFactory.getFactory().getDomainDriverManager();
        try {
            String[] asDriverSpaceIds = spaceManager.getAllSubSpaceIds(domainDriverManager, this.getDriverSpaceId(domainFatherId));
            asDriverSpaceIds = this.getClientSpaceIds(asDriverSpaceIds);
            return asDriverSpaceIds;
        }
        catch (Exception e) {
            throw new AdminException("Admin.getAllSubSpaceIds", 4, "admin.EX_ERR_GET_ALL_SUBSPACE_IDS", " father space Id : '" + domainFatherId + "'", e);
        }
    }

    public String updateSpaceInst(SpaceInst spaceInstNew) throws AdminException {
        if (!this.isSpaceManageable(spaceInstNew.getId(), spaceInstNew.getUpdaterUserId())) {
            SilverTrace.error("admin", "Admin.updateSpaceInst", "admin.USER_NOT_ALLOWED", "User " + spaceInstNew.getUpdaterUserId() + " not allowed to update space " + spaceInstNew.getId());
            throw new AdminException("Admin.updateSpaceInst", 4, "admin.USER_NOT_ALLOWED");
        }
        DomainDriverManager domainDriverManager = DomainDriverManagerFactory.getFactory().getDomainDriverManager();
        domainDriverManager.startTransaction(false);
        try {
            SpaceInst oldSpace = this.getSpaceInstById(spaceInstNew.getId());
            SilverTrace.debug("admin", "Admin.updateSpaceInst", "root.MSG_GEN_ENTER_METHOD", "Before id: '" + spaceInstNew.getId() + "' after Id: " + this.getDriverSpaceId(spaceInstNew.getId()));
            spaceInstNew.setId(this.getDriverSpaceId(spaceInstNew.getId()));
            spaceManager.updateSpaceInst(domainDriverManager, spaceInstNew);
            if (useProfileInheritance && oldSpace.isInheritanceBlocked() != spaceInstNew.isInheritanceBlocked()) {
                this.updateSpaceInheritance(oldSpace, spaceInstNew.isInheritanceBlocked());
            }
            domainDriverManager.commit();
            cache.opUpdateSpace(spaceInstNew);
            SpaceInstLight spaceInCache = TreeCache.getSpaceInstLight(spaceInstNew.getId());
            if (spaceInCache != null) {
                spaceInCache.setInheritanceBlocked(spaceInstNew.isInheritanceBlocked());
            }
            SpaceInstLight spaceLight = spaceManager.getSpaceInstLightById(domainDriverManager, this.getDriverSpaceId(spaceInstNew.getId()));
            spaceLight.setInheritanceBlocked(spaceInstNew.isInheritanceBlocked());
            TreeCache.updateSpace(spaceLight);
            SilverTrace.info("admin", "admin.updateSpaceInst", PARAM_MSG_KEY, "Indexation : spaceInst = " + spaceInstNew.getName());
            this.createSpaceIndex(spaceLight);
            String string = spaceInstNew.getId();
            return string;
        }
        catch (Exception e) {
            this.rollback();
            throw new AdminException("Admin.updateSpaceInst", 4, "admin.EX_ERR_UPDATE_SPACE", "space Id : '" + spaceInstNew.getId() + "'", e);
        }
        finally {
            domainDriverManager.releaseOrganizationSchema();
        }
    }

    public void updateSpaceOrderNum(String spaceId, int orderNum) throws AdminException {
        DomainDriverManager domainDriverManager = DomainDriverManagerFactory.getFactory().getDomainDriverManager();
        try {
            SilverTrace.debug("admin", "Admin.updateSpaceOrderNum", "root.MSG_GEN_ENTER_METHOD", "Space id: '" + spaceId + "' New Order num: " + Integer.toString(orderNum));
            String driverSpaceId = this.getDriverSpaceId(spaceId);
            domainDriverManager.startTransaction(false);
            spaceManager.updateSpaceOrder(domainDriverManager, driverSpaceId, orderNum);
            domainDriverManager.commit();
            cache.opUpdateSpace(spaceManager.getSpaceInstById(domainDriverManager, driverSpaceId));
            SpaceInstLight space = TreeCache.getSpaceInstLight(driverSpaceId);
            space.setOrderNum(orderNum);
            if (!space.isRoot()) {
                TreeCache.setSubspaces(space.getFatherId(), this.getSubSpaces(space.getFatherId()));
            }
        }
        catch (Exception e) {
            this.rollback();
            throw new AdminException("Admin.updateSpaceOrderNum", 4, "admin.EX_ERR_UPDATE_SPACE", "space Id : '" + spaceId + "'", e);
        }
        finally {
            domainDriverManager.releaseOrganizationSchema();
        }
    }

    private void updateSpaceInheritance(SpaceInst space, boolean inheritanceBlocked) throws AdminException {
        try {
            if (inheritanceBlocked) {
                List<SpaceProfileInst> inheritedProfiles = space.getInheritedProfiles();
                for (SpaceProfileInst profile : inheritedProfiles) {
                    this.deleteSpaceProfileInst(profile.getId(), false);
                }
            } else {
                List<SpaceProfileInst> profiles = space.getProfiles();
                for (SpaceProfileInst profile : profiles) {
                    if (profile == null || profile.isManager()) continue;
                    this.deleteSpaceProfileInst(profile.getId(), false);
                }
                if (!space.isRoot()) {
                    this.setSpaceProfilesToSubSpace(space, null, true, false);
                }
            }
        }
        catch (AdminException e) {
            this.rollback();
            throw new AdminException("Admin.updateComponentInst", 4, "admin.EX_ERR_UPDATE_SPACE", "spaceId = " + space.getId(), e);
        }
    }

    public boolean isSpaceInstExist(String spaceId) throws AdminException {
        DomainDriverManager domainDriverManager = DomainDriverManagerFactory.getFactory().getDomainDriverManager();
        try {
            return spaceManager.isSpaceInstExist(domainDriverManager, this.getDriverSpaceId(spaceId));
        }
        catch (AdminException e) {
            throw new AdminException("Admin.isSpaceInstExist", 4, "admin.EX_ERR_IS_SPACE_EXIST", "space Id : '" + spaceId + "'", e);
        }
    }

    public String[] getAllRootSpaceIds() throws AdminException {
        SilverTrace.debug("admin", "Admin.getAllSpaceIds", "root.MSG_GEN_ENTER_METHOD");
        DomainDriverManager domainDriverManager = DomainDriverManagerFactory.getFactory().getDomainDriverManager();
        try {
            String[] driverSpaceIds = spaceManager.getAllRootSpaceIds(domainDriverManager);
            driverSpaceIds = this.getClientSpaceIds(driverSpaceIds);
            return driverSpaceIds;
        }
        catch (Exception e) {
            throw new AdminException("Admin.getAllSpaceIds", 4, "admin.EX_ERR_GET_ALL_SPACE_IDS", e);
        }
    }

    public List<SpaceInstLight> getPathToComponent(String componentId) throws AdminException {
        ArrayList<SpaceInstLight> path = new ArrayList<SpaceInstLight>(0);
        ComponentInstLight component = this.getComponentInstLight(componentId);
        if (component != null) {
            String spaceId = component.getDomainFatherId();
            return this.getPathToSpace(spaceId, true);
        }
        return path;
    }

    public List<SpaceInstLight> getPathToSpace(String spaceId, boolean includeTarget) throws AdminException {
        ArrayList<SpaceInstLight> path = new ArrayList<SpaceInstLight>(10);
        SpaceInstLight space = this.getSpaceInstLight(this.getDriverSpaceId(spaceId));
        if (space != null) {
            if (includeTarget) {
                path.add(0, space);
            }
            while (!space.isRoot()) {
                String fatherId = space.getFatherId();
                space = this.getSpaceInstLight(fatherId);
                path.add(0, space);
            }
        }
        return path;
    }

    public String[] getAllSpaceIds() throws AdminException {
        SilverTrace.debug("admin", "Admin.getAllSpaceIds", "root.MSG_GEN_ENTER_METHOD");
        DomainDriverManager domainDriverManager = DomainDriverManagerFactory.getFactory().getDomainDriverManager();
        try {
            String[] driverSpaceIds = spaceManager.getAllSpaceIds(domainDriverManager);
            driverSpaceIds = this.getClientSpaceIds(driverSpaceIds);
            return driverSpaceIds;
        }
        catch (Exception e) {
            throw new AdminException("Admin.getAllSpaceIds", 4, "admin.EX_ERR_GET_ALL_SPACE_IDS", e);
        }
    }

    public List<SpaceInstLight> getRemovedSpaces() throws AdminException {
        SilverTrace.debug("admin", "Admin.getRemovedSpaces", "root.MSG_GEN_ENTER_METHOD");
        DomainDriverManager domainDriverManager = DomainDriverManagerFactory.getFactory().getDomainDriverManager();
        try {
            return spaceManager.getRemovedSpaces(domainDriverManager);
        }
        catch (Exception e) {
            throw new AdminException("Admin.getRemovedSpaces", 4, "admin.EX_ERR_GET_REMOVED_SPACES", e);
        }
    }

    public List<ComponentInstLight> getRemovedComponents() throws AdminException {
        SilverTrace.debug("admin", "Admin.getRemovedComponents", "root.MSG_GEN_ENTER_METHOD");
        DomainDriverManager domainDriverManager = DomainDriverManagerFactory.getFactory().getDomainDriverManager();
        try {
            return componentManager.getRemovedComponents(domainDriverManager);
        }
        catch (Exception e) {
            throw new AdminException("Admin.getRemovedComponents", 4, "admin.EX_ERR_GET_REMOVED_COMPONENTS", e);
        }
    }

    public String[] getSpaceNames(String[] asClientSpaceIds) throws AdminException {
        if (asClientSpaceIds == null) {
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        try {
            String[] asSpaceNames = new String[asClientSpaceIds.length];
            for (int nI = 0; nI < asClientSpaceIds.length; ++nI) {
                SpaceInstLight spaceInst = this.getSpaceInstLightById(asClientSpaceIds[nI]);
                asSpaceNames[nI] = spaceInst.getName();
            }
            return asSpaceNames;
        }
        catch (Exception e) {
            throw new AdminException("Admin.getSpaceNames", 4, "admin.EX_ERR_GET_SPACE_NAMES", e);
        }
    }

    public Map<String, SpaceTemplate> getAllSpaceTemplates() {
        return spaceInstanciator.getAllSpaceTemplates();
    }

    public SpaceInst getSpaceInstFromTemplate(String templateName) {
        return spaceInstanciator.getSpaceToInstanciate(templateName);
    }

    public Map<String, String> getAllComponentsNames() {
        SilverTrace.debug("admin", "Admin.getAllComponentsNames", "root.MSG_GEN_ENTER_METHOD");
        Map<String, String> components = Instanciateur.getAllComponentsNames();
        for (Map.Entry<String, String> entry : components.entrySet()) {
            SilverTrace.debug("admin", "Admin.getAllComponentsNames", "admin.MSG_INFO_COMPONENT_FOUND", entry.getKey() + ": " + entry.getValue());
        }
        return components;
    }

    public Map<String, WAComponent> getAllComponents() {
        return Instanciateur.getWAComponents();
    }

    public ComponentInst getComponentInst(String sClientComponentId) throws AdminException {
        try {
            ComponentInst componentInst = this.getComponentInst(sClientComponentId, false, null);
            componentInst.setId(this.getClientComponentId(componentInst));
            componentInst.setDomainFatherId(this.getClientSpaceId(componentInst.getDomainFatherId()));
            return componentInst;
        }
        catch (Exception e) {
            throw new AdminException("Admin.getComponentInst", 4, "admin.EX_ERR_GET_COMPONENT", "component Id: '" + sClientComponentId + "'", e);
        }
    }

    public ComponentInstLight getComponentInstLight(String componentId) throws AdminException {
        DomainDriverManager domainDriverManager = DomainDriverManagerFactory.getFactory().getDomainDriverManager();
        try {
            String driverComponentId = this.getDriverComponentId(componentId);
            return componentManager.getComponentInstLight(domainDriverManager, driverComponentId);
        }
        catch (Exception e) {
            throw new AdminException("Admin.getComponentInstLight", 4, "admin.EX_ERR_GET_COMPONENT", "component Id: '" + componentId + "'", e);
        }
    }

    private ComponentInst getComponentInst(String componentId, boolean isDriverComponentId, String fatherDriverSpaceId) throws AdminException {
        DomainDriverManager domainDriverManager = DomainDriverManagerFactory.getFactory().getDomainDriverManager();
        try {
            String driverComponentId = isDriverComponentId ? componentId : this.getDriverComponentId(componentId);
            ComponentInst componentInst = cache.getComponentInst(driverComponentId);
            SilverTrace.info("admin", "Admin.getComponentInst", "root.MSG_GEN_ENTER_METHOD", "componentInst=" + componentInst + " id=" + driverComponentId);
            if (componentInst == null) {
                componentInst = componentManager.getComponentInst(domainDriverManager, driverComponentId, fatherDriverSpaceId);
                SilverTrace.info("admin", "Admin.getComponentInst", "root.MSG_GEN_ENTER_METHOD", "componentInst FatherId=" + componentInst.getDomainFatherId());
                cache.putComponentInst(componentInst);
            }
            return componentManager.copy(componentInst);
        }
        catch (Exception e) {
            throw new AdminException("Admin.getComponentInst", 4, "admin.EX_ERR_GET_COMPONENT", "component Id: '" + componentId + "'", e);
        }
    }

    public List<Parameter> getComponentParameters(String componentId) {
        DomainDriverManager domainDriverManager = DomainDriverManagerFactory.getFactory().getDomainDriverManager();
        try {
            return componentManager.getParameters(domainDriverManager, this.getDriverComponentId(componentId));
        }
        catch (Exception e) {
            SilverTrace.error("admin", "Admin.getComponentParameters", "admin.EX_ERR_GET_COMPONENT_PARAMS", "sComponentId: '" + componentId + "'", e);
            return Collections.emptyList();
        }
    }

    public String getComponentParameterValue(String componentId, String parameterName) {
        List<Parameter> parameters = this.getComponentParameters(componentId);
        for (Parameter parameter : parameters) {
            if (!parameter.getName().equalsIgnoreCase(parameterName)) continue;
            return parameter.getValue();
        }
        return "";
    }

    public List<ComponentInstLight> getComponentsWithParameter(String paramName, String paramValue) {
        DomainDriverManager domainDriverManager = DomainDriverManagerFactory.getFactory().getDomainDriverManager();
        try {
            Parameter param = new Parameter();
            param.setName(paramName);
            param.setValue(paramValue);
            List<String> driverComponentIds = componentManager.getComponentIds(domainDriverManager, param);
            ArrayList<ComponentInstLight> components = new ArrayList<ComponentInstLight>();
            for (String id : driverComponentIds) {
                ComponentInst component = this.getComponentInst(id, true, null);
                ComponentInstLight componentLight = TreeCache.getComponent(component.getName() + component.getId());
                if (componentLight == null) continue;
                components.add(componentLight);
            }
            return components;
        }
        catch (Exception e) {
            SilverTrace.error("admin", "Admin.getComponentIdsWithParameter", "admin.EX_ERR_GET_COMPONENTS", "param = " + paramName + ", value = " + paramValue, e);
            return Collections.emptyList();
        }
    }

    public void restoreComponentFromBasket(String componentId) throws AdminException {
        DomainDriverManager domainDriverManager = DomainDriverManagerFactory.getFactory().getDomainDriverManager();
        try {
            domainDriverManager.startTransaction(false);
            componentManager.restoreComponentFromBasket(domainDriverManager, this.getDriverComponentId(componentId));
            ComponentInst componentInst = this.getComponentInst(componentId);
            if (useProfileInheritance && !componentInst.isInheritanceBlocked()) {
                this.setSpaceProfilesToComponent(componentInst, null);
            }
            domainDriverManager.commit();
            cache.opUpdateComponent(componentInst);
            ComponentInstLight component = this.getComponentInstLight(componentId);
            TreeCache.addComponent(this.getDriverComponentId(componentId), component, this.getDriverSpaceId(component.getDomainFatherId()));
            this.createComponentIndex(component);
        }
        catch (Exception e) {
            this.rollback();
            throw new AdminException("Admin.restoreComponentFromBasket", 4, "admin.EX_ERR_RESTORE_COMPONENT_FROM_BASKET", "componentId = " + componentId);
        }
        finally {
            domainDriverManager.releaseOrganizationSchema();
        }
    }

    public void createComponentIndex(String componentId) {
        try {
            ComponentInstLight component = this.getComponentInstLight(componentId);
            this.createComponentIndex(component);
        }
        catch (AdminException e) {
            SilverTrace.error("admin", "Admin.createComponentIndex", "admin.EX_ERR_GET_COMPONENT_PARAMS", "componentId: '" + componentId + "'", e);
        }
    }

    public void createComponentIndex(ComponentInstLight componentInst) {
        if (componentInst != null) {
            SilverTrace.debug("admin", "Admin.createComponentIndex", "root.MSG_GEN_ENTER_METHOD", "componentInst.getName() = " + componentInst.getName() + "' componentInst.getId() = " + componentInst.getId() + " componentInst.getLabel() = " + componentInst.getLabel());
            String componentId = componentInst.getId().startsWith(componentInst.getName()) ? componentInst.getId() : componentInst.getName().concat(componentInst.getId());
            FullIndexEntry indexEntry = new FullIndexEntry("Components", "Component", componentId);
            indexEntry.setTitle(componentInst.getLabel());
            indexEntry.setPreView(componentInst.getDescription());
            indexEntry.setCreationUser(Integer.toString(componentInst.getCreatedBy()));
            IndexEngineProxy.addIndexEntry(indexEntry);
        }
    }

    private void deleteComponentIndex(String componentId) {
        FullIndexEntry indexEntry = new FullIndexEntry("Components", "Component", componentId);
        IndexEngineProxy.removeIndexEntry(indexEntry.getPK());
    }

    private void deleteComponentData(String componentId) {
        FileRepositoryManager.deleteAbsolutePath(null, componentId, "");
        IndexEngineProxy.deleteByScope(componentId);
    }

    public String addComponentInst(String sUserId, ComponentInst componentInst) throws AdminException, QuotaException {
        return this.addComponentInst(sUserId, componentInst, true);
    }

    public String addComponentInst(String userId, ComponentInst componentInst, boolean startNewTransaction) throws AdminException, QuotaException {
        Connection connectionProd = null;
        DomainDriverManager domainDriverManager = DomainDriverManagerFactory.getFactory().getDomainDriverManager();
        try {
            connectionProd = this.openConnection(false);
            if (startNewTransaction) {
                domainDriverManager.startTransaction(false);
            }
            SpaceInst spaceInstFather = this.getSpaceInstById(componentInst.getDomainFatherId());
            SpaceServiceFactory.getComponentSpaceQuotaService().verify(ComponentSpaceQuotaKey.from(spaceInstFather));
            String driverComponentId = componentManager.createComponentInst(componentInst, domainDriverManager, this.getDriverSpaceId(spaceInstFather.getId()));
            spaceInstFather.addComponentInst(componentInst);
            componentInst.setId(driverComponentId);
            String componentName = componentInst.getName();
            String componentId = componentName + componentInst.getId();
            String[] asCompoNames = new String[]{componentName};
            String[] asCompoIds = new String[]{componentId};
            this.instantiateComponents(userId, asCompoIds, asCompoNames, spaceInstFather.getId(), connectionProd);
            if (this.isContentManagedComponent(componentName)) {
                ContainerManager containerManager = new ContainerManager();
                ContentManager contentManager = new ContentManager();
                containerManager.registerNewContainerInstance(connectionProd, componentId, "containerPDC", componentName);
                contentManager.registerNewContentInstance(connectionProd, componentId, "containerPDC", componentName);
            }
            if (useProfileInheritance && !componentInst.isInheritanceBlocked()) {
                this.setSpaceProfilesToComponent(componentInst, spaceInstFather);
            }
            if (startNewTransaction) {
                domainDriverManager.commit();
            }
            connectionProd.commit();
            cache.opAddComponent(componentInst);
            ComponentInstLight component = this.getComponentInstLight(componentId);
            TreeCache.addComponent(driverComponentId, component, this.getDriverSpaceId(spaceInstFather.getId()));
            this.createComponentIndex(component);
            String string = componentId;
            return string;
        }
        catch (Exception e) {
            try {
                if (startNewTransaction) {
                    domainDriverManager.rollback();
                }
                connectionProd.rollback();
            }
            catch (Exception e1) {
                SilverTrace.error("admin", "Admin.addComponentInst", "root.EX_ERR_ROLLBACK", e1);
            }
            if (e instanceof QuotaException) {
                throw (QuotaException)e;
            }
            throw new AdminException("Admin.addComponentInst", 4, "admin.EX_ERR_ADD_COMPONENT", "component name: '" + componentInst.getName() + "'", e);
        }
        finally {
            if (startNewTransaction) {
                domainDriverManager.releaseOrganizationSchema();
            }
            DBUtil.close(connectionProd);
        }
    }

    boolean isContentManagedComponent(String componentName) {
        return "expertLocator".equals(componentName) || "questionReply".equals(componentName) || "whitePages".equals(componentName) || "kmelia".equals(componentName) || "survey".equals(componentName) || "toolbox".equals(componentName) || "quickinfo".equals(componentName) || "almanach".equals(componentName) || "quizz".equals(componentName) || "forums".equals(componentName) || "pollingStation".equals(componentName) || "bookmark".equals(componentName) || "chat".equals(componentName) || "infoLetter".equals(componentName) || "webSites".equals(componentName) || "gallery".equals(componentName) || "blog".equals(componentName);
    }

    public String deleteComponentInst(String userId, String componentId, boolean definitive) throws AdminException {
        return this.deleteComponentInst(userId, componentId, definitive, true);
    }

    private String deleteComponentInst(String userId, String componentId, boolean definitive, boolean startNewTransaction) throws AdminException {
        String string;
        Connection connectionProd;
        block19: {
            if (startNewTransaction && !this.isComponentManageable(componentId, userId)) {
                SilverTrace.error("admin", "Admin.deleteComponentInst", "admin.USER_NOT_ALLOWED", "User " + userId + " not allowed to delete component " + componentId);
                throw new AdminException("Admin.deleteComponentInst", 4, "admin.USER_NOT_ALLOWED");
            }
            connectionProd = null;
            SilverTrace.spy("admin", "Admin.deleteComponentInst()", "ACP", componentId, "", userId, "2");
            DomainDriverManager domainDriverManager = DomainDriverManagerFactory.getFactory().getDomainDriverManager();
            try {
                String sDriverComponentId;
                ComponentInst componentInst;
                String sFatherClientId;
                SpaceInst space;
                if (startNewTransaction) {
                    domainDriverManager.startTransaction(false);
                }
                if ((space = this.getSpaceInstById(sFatherClientId = (componentInst = this.getComponentInst(sDriverComponentId = this.getDriverComponentId(componentId), true, null)).getDomainFatherId())).getFirstPageType() == 1 && space.getFirstPageExtraParam().equals(componentId) && !definitive) {
                    space.setFirstPageType(0);
                    space.setFirstPageExtraParam(null);
                    space.setUpdaterUserId(userId);
                    this.updateSpaceInst(space);
                }
                if (!definitive) {
                    for (int nI = 0; nI < componentInst.getNumProfileInst(); ++nI) {
                        this.deleteProfileInst(componentInst.getProfileInst(nI).getId(), false);
                    }
                    componentManager.sendComponentToBasket(domainDriverManager, componentInst, userId);
                } else {
                    connectionProd = this.openConnection(false);
                    String componentName = componentInst.getName();
                    String[] asCompoName = new String[]{componentName};
                    String[] asCompoId = new String[]{componentId};
                    this.unInstantiateComponents(userId, asCompoId, asCompoName, this.getClientSpaceId(sFatherClientId), connectionProd);
                    for (int nI = 0; nI < componentInst.getNumProfileInst(); ++nI) {
                        this.deleteProfileInst(componentInst.getProfileInst(nI).getId(), false);
                    }
                    componentManager.deleteComponentInst(componentInst, domainDriverManager);
                    if (this.isContentManagedComponent(componentName)) {
                        ContainerManager containerManager = new ContainerManager();
                        ContentManager contentManager = new ContentManager();
                        containerManager.unregisterNewContainerInstance(connectionProd, componentId, "containerPDC", componentName);
                        contentManager.unregisterNewContentInstance(connectionProd, componentId, "containerPDC", componentName);
                    }
                    connectionProd.commit();
                }
                if (startNewTransaction) {
                    domainDriverManager.commit();
                }
                cache.opRemoveComponent(componentInst);
                TreeCache.removeComponent(this.getDriverSpaceId(sFatherClientId), componentId);
                this.deleteComponentIndex(componentId);
                if (definitive) {
                    this.deleteComponentData(componentId);
                }
                string = componentId;
                if (!startNewTransaction) break block19;
            }
            catch (Exception e) {
                try {
                    try {
                        if (startNewTransaction) {
                            domainDriverManager.rollback();
                        }
                        if (connectionProd != null) {
                            connectionProd.rollback();
                        }
                    }
                    catch (Exception e1) {
                        SilverTrace.error("admin", "Admin.deleteComponentInst", "root.EX_ERR_ROLLBACK", e1);
                    }
                    throw new AdminException("Admin.deleteComponentInst", 4, "admin.EX_ERR_DELETE_COMPONENT", "component Id: '" + componentId + "'", e);
                }
                catch (Throwable throwable) {
                    if (startNewTransaction) {
                        domainDriverManager.releaseOrganizationSchema();
                    }
                    DBUtil.close(connectionProd);
                    throw throwable;
                }
            }
            domainDriverManager.releaseOrganizationSchema();
        }
        DBUtil.close(connectionProd);
        return string;
    }

    public void updateComponentOrderNum(String componentId, int orderNum) throws AdminException {
        DomainDriverManager domainDriverManager = DomainDriverManagerFactory.getFactory().getDomainDriverManager();
        try {
            SilverTrace.debug("admin", "Admin.updateComponentOrderNum", "root.MSG_GEN_ENTER_METHOD", "Component id: '" + componentId + "' New Order num: " + orderNum);
            String driverComponentId = this.getDriverComponentId(componentId);
            domainDriverManager.startTransaction(false);
            componentManager.updateComponentOrder(domainDriverManager, driverComponentId, orderNum);
            domainDriverManager.commit();
            cache.opUpdateComponent(componentManager.getComponentInst(domainDriverManager, driverComponentId, null));
        }
        catch (Exception e) {
            this.rollback();
            throw new AdminException("Admin.updateComponentOrderNum", 4, "admin.EX_ERR_UPDATE_COMPONENT", "Component Id : '" + componentId + "'", e);
        }
        finally {
            domainDriverManager.releaseOrganizationSchema();
        }
    }

    public String updateComponentInst(ComponentInst component) throws AdminException {
        if (!this.isComponentManageable(component.getId(), component.getUpdaterUserId())) {
            SilverTrace.error("admin", "Admin.updateComponentInst", "admin.USER_NOT_ALLOWED", "User " + component.getUpdaterUserId() + " not allowed to update component " + component.getId());
            throw new AdminException("Admin.updateComponentInst", 4, "admin.USER_NOT_ALLOWED");
        }
        DomainDriverManager domainDriverManager = DomainDriverManagerFactory.getFactory().getDomainDriverManager();
        try {
            ComponentInst oldComponent = this.getComponentInst(component.getId());
            String componentClientId = this.getClientComponentId(oldComponent);
            domainDriverManager.startTransaction(false);
            String sDriverComponentId = this.getDriverComponentId(component.getId());
            component.setId(sDriverComponentId);
            componentManager.updateComponentInst(domainDriverManager, component);
            if (useProfileInheritance && oldComponent.isInheritanceBlocked() != component.isInheritanceBlocked()) {
                this.updateComponentInheritance(oldComponent, component.isInheritanceBlocked());
            }
            domainDriverManager.commit();
            this.adminNotificationService.notifyOfComponentConfigurationChange(componentClientId, component.getUpdaterUserId(), oldComponent.diff(component));
            cache.opUpdateComponent(component);
            TreeCache.getComponent(componentClientId).setInheritanceBlocked(component.isInheritanceBlocked());
            component.setId(componentClientId);
            this.createComponentIndex(componentClientId);
            String string = componentClientId;
            return string;
        }
        catch (Exception e) {
            this.rollback();
            throw new AdminException("Admin.updateComponentInst", 4, "admin.EX_ERR_UPDATE_COMPONENT", "component Id: '" + component.getId() + "'", e);
        }
        finally {
            domainDriverManager.releaseOrganizationSchema();
        }
    }

    private void updateComponentInheritance(ComponentInst component, boolean inheritanceBlocked) throws AdminException {
        try {
            if (inheritanceBlocked) {
                List<ProfileInst> inheritedProfiles = component.getInheritedProfiles();
                for (ProfileInst profile : inheritedProfiles) {
                    this.deleteProfileInst(profile.getId(), false);
                }
            } else {
                List<ProfileInst> profiles = component.getProfiles();
                for (ProfileInst profile : profiles) {
                    this.deleteProfileInst(profile.getId(), false);
                }
                this.setSpaceProfilesToComponent(component, null);
            }
        }
        catch (AdminException e) {
            this.rollback();
            throw new AdminException("Admin.updateComponentInst", 4, "admin.EX_ERR_UPDATE_COMPONENT", "component Id: '" + component.getId() + "'", e);
        }
    }

    private void setSpaceProfilesToSubSpace(SpaceInst subSpace, SpaceInst space) throws AdminException {
        this.setSpaceProfilesToSubSpace(subSpace, space, false, false);
    }

    protected void setSpaceProfilesToSubSpace(SpaceInst subSpace, SpaceInst space, boolean persist, boolean startNewTransaction) throws AdminException {
        SpaceInst currentSpace = space;
        if (currentSpace == null) {
            currentSpace = this.getSpaceInstById(subSpace.getDomainFatherId(), true);
        }
        this.setSpaceProfileToSubSpace(subSpace, currentSpace, SilverpeasRole.admin);
        this.setSpaceProfileToSubSpace(subSpace, currentSpace, SilverpeasRole.publisher);
        this.setSpaceProfileToSubSpace(subSpace, currentSpace, SilverpeasRole.writer);
        this.setSpaceProfileToSubSpace(subSpace, currentSpace, SilverpeasRole.reader);
        if (persist) {
            for (SpaceProfileInst profile : subSpace.getInheritedProfiles()) {
                if (StringUtil.isDefined(profile.getId())) {
                    this.updateSpaceProfileInst(profile, null, startNewTransaction);
                    continue;
                }
                this.addSpaceProfileInst(profile, null, startNewTransaction);
            }
        }
    }

    private void setSpaceProfileToSubSpace(SpaceInst subSpace, SpaceInst space, SilverpeasRole role) {
        SpaceProfileInst inheritedProfile;
        SpaceProfileInst profile;
        String profileName = role.toString();
        SpaceProfileInst subSpaceProfile = subSpace.getInheritedSpaceProfileInst(profileName);
        if (subSpaceProfile != null) {
            subSpaceProfile.removeAllGroups();
            subSpaceProfile.removeAllUsers();
        }
        if ((profile = space.getSpaceProfileInst(profileName)) != null) {
            if (subSpaceProfile == null) {
                subSpaceProfile = new SpaceProfileInst();
                subSpaceProfile.setName(profileName);
                subSpaceProfile.setInherited(true);
            }
            subSpaceProfile.addGroups(profile.getAllGroups());
            subSpaceProfile.addUsers(profile.getAllUsers());
        }
        if ((inheritedProfile = space.getInheritedSpaceProfileInst(profileName)) != null) {
            if (subSpaceProfile == null) {
                subSpaceProfile = new SpaceProfileInst();
                subSpaceProfile.setName(profileName);
                subSpaceProfile.setInherited(true);
            }
            subSpaceProfile.addGroups(inheritedProfile.getAllGroups());
            subSpaceProfile.addUsers(inheritedProfile.getAllUsers());
        }
        if (subSpaceProfile != null) {
            subSpace.addSpaceProfileInst(subSpaceProfile);
        }
    }

    private void setSpaceProfilesToComponent(ComponentInst component, SpaceInst space) throws AdminException {
        this.setSpaceProfilesToComponent(component, space, false);
    }

    public void setSpaceProfilesToComponent(ComponentInst component, SpaceInst space, boolean startNewTransaction) throws AdminException {
        WAComponent waComponent = Instanciateur.getWAComponent(component.getName());
        List<Profile> componentRoles = waComponent.getProfiles();
        if (space == null) {
            space = this.getSpaceInstById(component.getDomainFatherId(), false);
        }
        DomainDriverManager domainDriverManager = DomainDriverManagerFactory.getCurrentDomainDriverManager();
        try {
            if (startNewTransaction) {
                domainDriverManager.startTransaction(false);
            }
            for (Profile componentRole : componentRoles) {
                ProfileInst inheritedProfile = component.getInheritedProfileInst(componentRole.getName());
                if (inheritedProfile != null) {
                    inheritedProfile.removeAllGroups();
                    inheritedProfile.removeAllUsers();
                } else {
                    inheritedProfile = new ProfileInst();
                    inheritedProfile.setComponentFatherId(component.getId());
                    inheritedProfile.setInherited(true);
                    inheritedProfile.setName(componentRole.getName());
                }
                List<String> spaceRoles = this.componentRole2SpaceRoles(componentRole.getName(), component.getName());
                for (String spaceRole : spaceRoles) {
                    SpaceProfileInst spaceProfile = space.getSpaceProfileInst(spaceRole);
                    if (spaceProfile != null) {
                        inheritedProfile.addGroups(spaceProfile.getAllGroups());
                        inheritedProfile.addUsers(spaceProfile.getAllUsers());
                    }
                    if ((spaceProfile = space.getInheritedSpaceProfileInst(spaceRole)) == null) continue;
                    inheritedProfile.addGroups(spaceProfile.getAllGroups());
                    inheritedProfile.addUsers(spaceProfile.getAllUsers());
                }
                if (StringUtil.isDefined(inheritedProfile.getId())) {
                    this.updateProfileInst(inheritedProfile, null, false, null);
                    continue;
                }
                if (inheritedProfile.isEmpty()) continue;
                this.addProfileInst(inheritedProfile, null, false);
            }
            if (startNewTransaction) {
                domainDriverManager.commit();
            }
        }
        catch (Exception e) {
            if (startNewTransaction) {
                this.rollback();
            }
            throw new AdminException("Admin.setSpaceProfilesToComponent", 4, "admin.EX_ERR_SET_PROFILES", e);
        }
        finally {
            if (startNewTransaction) {
                domainDriverManager.releaseOrganizationSchema();
            }
        }
        this.checkObjectsProfiles(component.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkObjectsProfiles(String componentId) throws AdminException {
        DomainDriverManager ddManager = DomainDriverManagerFactory.getCurrentDomainDriverManager();
        List<ProfileInst> objectsProfiles = null;
        String shortComponentId = this.getDriverComponentId(componentId);
        try {
            objectsProfiles = profiledObjectManager.getProfiles(ddManager, Integer.parseInt(shortComponentId));
        }
        catch (Exception e) {
            SilverTrace.warn("admin", "admin.checkObjectsProfiles", PARAM_MSG_KEY, "Error when getting all component objects profiles " + componentId, e);
        }
        for (ProfileInst objectProfile : objectsProfiles) {
            try {
                ArrayList<String> groupIdsToRemove = new ArrayList<String>();
                ArrayList<String> userIdsToRemove = new ArrayList<String>();
                ArrayList<String> groupIds = objectProfile.getAllGroups();
                for (String groupId : groupIds) {
                    if (this.isComponentAvailableByGroup(componentId, groupId)) continue;
                    groupIdsToRemove.add(groupId);
                }
                ArrayList<String> userIds = objectProfile.getAllUsers();
                for (String userId : userIds) {
                    if (this.isComponentAvailable(componentId, userId)) continue;
                    userIdsToRemove.add(userId);
                }
                if (groupIdsToRemove.isEmpty() && userIdsToRemove.isEmpty()) continue;
                for (String groupId : groupIdsToRemove) {
                    objectProfile.removeGroup(groupId);
                }
                for (String userId : userIdsToRemove) {
                    objectProfile.removeUser(userId);
                }
                ddManager.startTransaction(false);
                profileManager.updateProfileInst(ddManager, objectProfile);
                ddManager.commit();
            }
            catch (Exception e) {
                SilverTrace.warn("admin", "admin.checkObjectsProfiles", PARAM_MSG_KEY, "Error when checking object profile " + objectProfile.getId(), e);
            }
            finally {
                ddManager.releaseOrganizationSchema();
            }
        }
    }

    private boolean isComponentAvailableByGroup(String componentId, String groupId) throws AdminException {
        try {
            DomainDriverManager domainDriverManager = DomainDriverManagerFactory.getCurrentDomainDriverManager();
            List<String> groupIds = this.groupManager.getPathToGroup(domainDriverManager, groupId);
            groupIds.add(groupId);
            return componentManager.getAllowedComponentIds(-1, groupIds).contains(componentId);
        }
        catch (Exception e) {
            throw new AdminException("Admin.isComponentAvailableByGroup", 4, "admin.EX_ERR_IS_COMPONENT_AVAILABLE", "groupId : '" + groupId + "', component Id : '" + componentId + "'", e);
        }
    }

    public void moveSpace(String spaceId, String fatherId) throws AdminException {
        String[] allComponentIds;
        DomainDriverManager domainDriverManager = DomainDriverManagerFactory.getFactory().getDomainDriverManager();
        if (this.isParent(spaceId, fatherId)) {
            return;
        }
        String shortSpaceId = this.getDriverSpaceId(spaceId);
        String shortFatherId = this.getDriverSpaceId(fatherId);
        if (!StringUtil.isDefined(shortFatherId)) {
            shortFatherId = "-1";
        }
        boolean moveOnTop = "-1".equals(shortFatherId);
        try {
            SpaceInst space = this.getSpaceInstById(shortSpaceId);
            String shortOldSpaceId = this.getDriverSpaceId(space.getDomainFatherId());
            domainDriverManager.startTransaction(false);
            spaceManager.moveSpace(domainDriverManager, Integer.parseInt(shortSpaceId), Integer.parseInt(shortFatherId));
            spaceManager.updateSpaceOrder(domainDriverManager, shortSpaceId, this.getAllSubSpaceIds(shortFatherId).length);
            if (useProfileInheritance) {
                space = spaceManager.getSpaceInstById(domainDriverManager, shortSpaceId);
                if (moveOnTop) {
                    List<SpaceProfileInst> inheritedProfiles = space.getInheritedProfiles();
                    for (SpaceProfileInst profile : inheritedProfiles) {
                        this.deleteSpaceProfileInst(profile.getId(), false);
                    }
                } else if (!space.isInheritanceBlocked()) {
                    SpaceInst father = this.getSpaceInstById(shortFatherId);
                    this.setSpaceProfilesToSubSpace(space, father, true, false);
                }
                HashMap<String, SpaceProfileInst> mergedProfiles = new HashMap<String, SpaceProfileInst>();
                ArrayList<SpaceProfileInst> allProfiles = new ArrayList<SpaceProfileInst>();
                allProfiles.addAll(space.getProfiles());
                if (!moveOnTop) {
                    allProfiles.addAll(space.getInheritedProfiles());
                }
                for (SpaceProfileInst profile : allProfiles) {
                    SpaceProfileInst mergedProfile = (SpaceProfileInst)mergedProfiles.get(profile.getName());
                    if (mergedProfile == null) {
                        mergedProfile = new SpaceProfileInst();
                        mergedProfile.setName(profile.getName());
                        mergedProfile.setInherited(true);
                        mergedProfiles.put(profile.getName(), mergedProfile);
                    }
                    mergedProfile.addGroups(profile.getAllGroups());
                    mergedProfile.addUsers(profile.getAllUsers());
                }
                for (SpaceProfileInst profile : mergedProfiles.values()) {
                    this.spreadSpaceProfile(shortSpaceId, profile);
                }
                if (moveOnTop) {
                    space.setInheritanceBlocked(false);
                    spaceManager.updateSpaceInst(domainDriverManager, space);
                }
            }
            domainDriverManager.commit();
            cache.resetSpaceInst();
            TreeCache.removeSpace(shortSpaceId);
            TreeCache.setSubspaces(shortOldSpaceId, spaceManager.getSubSpaces(domainDriverManager, shortOldSpaceId));
            this.addSpaceInTreeCache(spaceManager.getSpaceInstLightById(domainDriverManager, shortSpaceId), false);
            if (!moveOnTop) {
                TreeCache.setSubspaces(shortFatherId, spaceManager.getSubSpaces(domainDriverManager, shortFatherId));
            }
        }
        catch (Exception e) {
            this.rollback();
            throw new AdminException("Admin.moveSpace", 4, "admin.EX_ERR_MOVE_Space", "spaceId = " + spaceId + ",  fatherId =" + fatherId, e);
        }
        finally {
            domainDriverManager.releaseOrganizationSchema();
        }
        for (String componentId : allComponentIds = this.getAllComponentIdsRecur(spaceId)) {
            this.checkObjectsProfiles(componentId);
        }
    }

    public void moveComponentInst(String spaceId, String componentId, String idComponentBefore, ComponentInst[] componentInsts) throws AdminException {
        DomainDriverManager domainDriverManager = DomainDriverManagerFactory.getFactory().getDomainDriverManager();
        try {
            SilverTrace.info("admin", "admin.moveComponentInst", PARAM_MSG_KEY, "spaceId= " + spaceId + " componentId=" + componentId);
            String sDriverComponentId = this.getDriverComponentId(componentId);
            String sDriverSpaceId = this.getDriverSpaceId(spaceId);
            SilverTrace.info("admin", "admin.moveComponentInst", PARAM_MSG_KEY, "sDriverSpaceId= " + sDriverSpaceId + " sDriverComponentId=" + sDriverComponentId);
            ComponentInst componentInst = this.getComponentInst(componentId);
            String oldSpaceId = componentInst.getDomainFatherId();
            domainDriverManager.startTransaction(false);
            componentManager.moveComponentInst(domainDriverManager, sDriverSpaceId, sDriverComponentId);
            componentInst.setDomainFatherId(sDriverSpaceId);
            if (!componentInst.isInheritanceBlocked()) {
                this.setSpaceProfilesToComponent(componentInst, null);
            }
            if (StringUtil.isDefined(idComponentBefore) && componentInsts != null) {
                SilverTrace.info("admin", "admin.moveComponentInst", PARAM_MSG_KEY, "Avant setComponentPlace: componentId=" + componentId + " idComponentBefore=" + idComponentBefore);
                this.setComponentPlace(componentId, idComponentBefore, componentInsts);
            } else {
                this.updateComponentOrderNum(sDriverComponentId, this.getAllComponentIds(spaceId).length);
            }
            SpaceInst fromSpace = this.getSpaceInstById(this.getDriverSpaceId(oldSpaceId));
            String spaceHomePage = fromSpace.getFirstPageExtraParam();
            SilverTrace.info("admin", "admin.moveComponentInst", PARAM_MSG_KEY, "FirstPageExtraParam=" + spaceHomePage + " oldSpaceId=" + oldSpaceId);
            if (StringUtil.isDefined(spaceHomePage) && spaceHomePage.equals(componentId)) {
                fromSpace.setFirstPageExtraParam("");
                fromSpace.setFirstPageType(0);
                this.updateSpaceInst(fromSpace);
            }
            domainDriverManager.commit();
            cache.resetSpaceInst();
            cache.resetComponentInst();
            TreeCache.setComponents(this.getDriverSpaceId(oldSpaceId), componentManager.getComponentsInSpace(Integer.parseInt(this.getDriverSpaceId(oldSpaceId))));
            TreeCache.setComponents(this.getDriverSpaceId(spaceId), componentManager.getComponentsInSpace(Integer.parseInt(this.getDriverSpaceId(spaceId))));
        }
        catch (Exception e) {
            this.rollback();
            throw new AdminException("Admin.moveComponentInst", 4, "admin.EX_ERR_MOVE_COMPONENT", "spaceId = " + spaceId + " component Id: '" + componentId + " ", e);
        }
        finally {
            domainDriverManager.releaseOrganizationSchema();
        }
    }

    public void setComponentPlace(String componentId, String idComponentBefore, ComponentInst[] m_BrothersComponents) throws AdminException {
        int i;
        int orderNum = 0;
        ComponentInst theComponent = this.getComponentInst(componentId);
        for (i = 0; i < m_BrothersComponents.length; ++i) {
            if (idComponentBefore.equals(m_BrothersComponents[i].getId())) {
                theComponent.setOrderNum(orderNum);
                this.updateComponentOrderNum(theComponent.getId(), orderNum);
                ++orderNum;
            }
            if (m_BrothersComponents[i].getOrderNum() != orderNum) {
                m_BrothersComponents[i].setOrderNum(orderNum);
                this.updateComponentOrderNum(m_BrothersComponents[i].getId(), orderNum);
            }
            ++orderNum;
        }
        if (orderNum == i) {
            theComponent.setOrderNum(orderNum);
            this.updateComponentOrderNum(theComponent.getId(), orderNum);
        }
    }

    public String getRequestRouter(String sComponentName) {
        WAComponent wac = Instanciateur.getWAComponent(sComponentName);
        if (wac == null || !StringUtil.isDefined(wac.getRouter())) {
            return "R" + sComponentName;
        }
        return wac.getRouter();
    }

    public String[] getAllProfilesNames(String sComponentName) {
        String[] asProfiles = null;
        WAComponent wac = Instanciateur.getWAComponent(sComponentName);
        if (wac != null) {
            List<Profile> profiles = wac.getProfiles();
            ArrayList<String> profileNames = new ArrayList<String>(profiles.size());
            for (Profile profile : profiles) {
                profileNames.add(profile.getName());
            }
            asProfiles = profileNames.toArray(new String[profileNames.size()]);
        }
        if (asProfiles != null) {
            return asProfiles;
        }
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    public String getProfileLabelfromName(String sComponentName, String sProfileName, String lang) {
        WAComponent wac = Instanciateur.getWAComponent(sComponentName);
        if (wac != null) {
            List<Profile> profiles = wac.getProfiles();
            String sProfileLabel = sProfileName;
            for (Profile profile : profiles) {
                if (!profile.getName().equals(sProfileName)) continue;
                return profile.getLabel().get(lang);
            }
            return sProfileLabel;
        }
        return sProfileName;
    }

    public ProfileInst getProfileInst(String sProfileId) throws AdminException {
        DomainDriverManager domainDriverManager = DomainDriverManagerFactory.getCurrentDomainDriverManager();
        ProfileInst profileInst = cache.getProfileInst(sProfileId);
        if (profileInst == null) {
            profileInst = profileManager.getProfileInst(domainDriverManager, sProfileId, null);
            cache.putProfileInst(profileInst);
        }
        return profileInst;
    }

    public List<ProfileInst> getProfilesByObject(String objectId, String objectType, String componentId) throws AdminException {
        DomainDriverManager domainDriverManager = DomainDriverManagerFactory.getCurrentDomainDriverManager();
        return profiledObjectManager.getProfiles(domainDriverManager, Integer.parseInt(objectId), objectType, Integer.parseInt(this.getDriverComponentId(componentId)));
    }

    public String[] getProfilesByObjectAndUserId(int objectId, String objectType, String componentId, String userId) throws AdminException {
        List<String> groups = this.getAllGroupsOfUser(userId);
        return profiledObjectManager.getUserProfileNames(objectId, objectType, Integer.parseInt(this.getDriverComponentId(componentId)), Integer.parseInt(userId), groups);
    }

    public Map<Integer, List<String>> getProfilesByObjectTypeAndUserId(String objectType, String componentId, String userId) throws AdminException {
        List<String> groups = this.getAllGroupsOfUser(userId);
        return profiledObjectManager.getUserProfileNames(objectType, Integer.parseInt(this.getDriverComponentId(componentId)), Integer.parseInt(userId), groups);
    }

    public boolean isObjectAvailable(String componentId, int objectId, String objectType, String userId) throws AdminException {
        return userId == null || this.getProfilesByObjectAndUserId(objectId, objectType, componentId, userId).length > 0;
    }

    public String addProfileInst(ProfileInst profileInst) throws AdminException {
        return this.addProfileInst(profileInst, null, true);
    }

    public String addProfileInst(ProfileInst profileInst, String userId) throws AdminException {
        return this.addProfileInst(profileInst, userId, true);
    }

    private String addProfileInst(ProfileInst profileInst, String userId, boolean startNewTransaction) throws AdminException {
        DomainDriverManager domainDriverManager = DomainDriverManagerFactory.getCurrentDomainDriverManager();
        try {
            if (startNewTransaction) {
                domainDriverManager.startTransaction(false);
            }
            String sDriverFatherId = this.getDriverComponentId(profileInst.getComponentFatherId());
            String sProfileId = profileManager.createProfileInst(profileInst, domainDriverManager, sDriverFatherId);
            profileInst.setId(sProfileId);
            if (profileInst.getObjectId() == -1 || profileInst.getObjectId() == 0) {
                ComponentInst componentInstFather = this.getComponentInst(sDriverFatherId, true, null);
                componentInstFather.addProfileInst(profileInst);
                if (StringUtil.isDefined(userId)) {
                    componentInstFather.setUpdaterUserId(userId);
                    this.updateComponentInst(componentInstFather);
                }
            }
            if (startNewTransaction) {
                domainDriverManager.commit();
            }
            if (profileInst.getObjectId() == -1 || profileInst.getObjectId() == 0) {
                cache.opAddProfile(profileManager.getProfileInst(domainDriverManager, sProfileId, null));
            }
            String string = sProfileId;
            return string;
        }
        catch (Exception e) {
            if (startNewTransaction) {
                this.rollback();
            }
            throw new AdminException("Admin.addProfileInst", 4, "admin.EX_ERR_ADD_PROFILE", "profile name: '" + profileInst.getName() + "'", e);
        }
        finally {
            if (startNewTransaction) {
                domainDriverManager.releaseOrganizationSchema();
            }
        }
    }

    public String deleteProfileInst(String sProfileId, String userId) throws AdminException {
        return this.deleteProfileInst(sProfileId, userId, true);
    }

    private String deleteProfileInst(String sProfileId, boolean startNewTransaction) throws AdminException {
        return this.deleteProfileInst(sProfileId, null, startNewTransaction);
    }

    private String deleteProfileInst(String profileId, String userId, boolean startNewTransaction) throws AdminException {
        DomainDriverManager domainDriverManager = DomainDriverManagerFactory.getCurrentDomainDriverManager();
        ProfileInst profile = profileManager.getProfileInst(domainDriverManager, profileId, null);
        try {
            Object component;
            if (startNewTransaction) {
                domainDriverManager.startTransaction(false);
            }
            profileManager.deleteProfileInst(profile, domainDriverManager);
            if (StringUtil.isDefined(userId) && (profile.getObjectId() == -1 || profile.getObjectId() == 0)) {
                component = this.getComponentInst(profile.getComponentFatherId(), true, null);
                ((ComponentInst)component).setUpdaterUserId(userId);
                this.updateComponentInst((ComponentInst)component);
            }
            if (startNewTransaction) {
                domainDriverManager.commit();
            }
            if (profile.getObjectId() == -1 || profile.getObjectId() == 0) {
                cache.opRemoveProfile(profile);
            }
            component = profileId;
            return component;
        }
        catch (Exception e) {
            if (startNewTransaction) {
                this.rollback();
            }
            throw new AdminException("Admin.deleteProfileInst", 4, "admin.EX_ERR_DELETE_PROFILE", "profile Id: '" + profileId + "'", e);
        }
        finally {
            if (startNewTransaction) {
                domainDriverManager.releaseOrganizationSchema();
            }
        }
    }

    public String updateProfileInst(ProfileInst profileInstNew) throws AdminException {
        return this.updateProfileInst(profileInstNew, null, true, null);
    }

    public String updateProfileInst(ProfileInst profileInstNew, String userId) throws AdminException {
        return this.updateProfileInst(profileInstNew, userId, true, null);
    }

    private String updateProfileInst(ProfileInst newProfile, String userId, boolean startNewTransaction, RightAssignationContext.MODE rightAssignationMode) throws AdminException {
        DomainDriverManager domainDriverManager = DomainDriverManagerFactory.getCurrentDomainDriverManager();
        if (StringUtil.isDefined(userId)) {
            SilverTrace.spy("admin", "Admin.updateProfileInst", "unknown", newProfile.getComponentFatherId(), newProfile.getName(), userId, "3");
        }
        try {
            Object component;
            if (startNewTransaction) {
                domainDriverManager.startTransaction(false);
            }
            profileManager.updateProfileInst(domainDriverManager, newProfile);
            if (StringUtil.isDefined(userId) && (newProfile.getObjectId() == -1 || newProfile.getObjectId() == 0)) {
                component = this.getComponentInst(newProfile.getComponentFatherId(), true, null);
                ((ComponentInst)component).setUpdaterUserId(userId);
                this.updateComponentInst((ComponentInst)component);
            }
            if (startNewTransaction) {
                domainDriverManager.commit();
            }
            if (newProfile.getObjectId() == -1 || newProfile.getObjectId() == 0) {
                cache.opUpdateProfile(newProfile);
            }
            component = newProfile.getId();
            return component;
        }
        catch (Exception e) {
            if (startNewTransaction) {
                this.rollback();
            }
            throw new AdminException("Admin.updateProfileInst", 4, "admin.EX_ERR_UPDATE_PROFILE", "profile Id: '" + newProfile.getId() + "'", e);
        }
        finally {
            if (startNewTransaction) {
                domainDriverManager.releaseOrganizationSchema();
            }
        }
    }

    public SpaceProfileInst getSpaceProfileInst(String spaceProfileId) throws AdminException {
        DomainDriverManager domainDriverManager = DomainDriverManagerFactory.getCurrentDomainDriverManager();
        return spaceProfileManager.getSpaceProfileInst(domainDriverManager, spaceProfileId, null);
    }

    public String addSpaceProfileInst(SpaceProfileInst spaceProfile, String userId) throws AdminException {
        return this.addSpaceProfileInst(spaceProfile, userId, true);
    }

    private String addSpaceProfileInst(SpaceProfileInst spaceProfile, String userId, boolean startNewTransaction) throws AdminException {
        DomainDriverManager domainDriverManager = DomainDriverManagerFactory.getCurrentDomainDriverManager();
        try {
            SpaceInst spaceInst;
            if (startNewTransaction) {
                domainDriverManager.startTransaction(false);
            }
            String spaceId = this.getDriverComponentId(spaceProfile.getSpaceFatherId());
            String sSpaceProfileId = spaceProfileManager.createSpaceProfileInst(spaceProfile, domainDriverManager, spaceId);
            spaceProfile.setId(sSpaceProfileId);
            if (StringUtil.isDefined(userId)) {
                SpaceInst spaceInstFather = this.getSpaceInstById(spaceId, false);
                spaceInstFather.setUpdaterUserId(userId);
                this.updateSpaceInst(spaceInstFather);
            }
            if ((spaceInst = cache.getSpaceInst(spaceId)) != null) {
                spaceInst.addSpaceProfileInst(spaceProfile);
            }
            if (!spaceProfile.isManager()) {
                SpaceProfileInst inheritedProfile;
                if (!spaceProfile.isInherited() && (inheritedProfile = spaceProfileManager.getInheritedSpaceProfileInstByName(domainDriverManager, spaceId, spaceProfile.getName())) != null) {
                    spaceProfile.addGroups(inheritedProfile.getAllGroups());
                    spaceProfile.addUsers(inheritedProfile.getAllUsers());
                }
                this.spreadSpaceProfile(spaceId, spaceProfile);
            }
            if (startNewTransaction) {
                domainDriverManager.commit();
            }
            cache.opAddSpaceProfile(spaceProfile);
            String string = sSpaceProfileId;
            return string;
        }
        catch (Exception e) {
            if (startNewTransaction) {
                this.rollback();
            }
            throw new AdminException("Admin.addSpaceProfileInst", 4, "admin.EX_ERR_ADD_SPACE_PROFILE", "space profile name: '" + spaceProfile.getName() + "'", e);
        }
        finally {
            if (startNewTransaction) {
                domainDriverManager.releaseOrganizationSchema();
            }
        }
    }

    public String deleteSpaceProfileInst(String sSpaceProfileId, String userId) throws AdminException {
        return this.deleteSpaceProfileInst(sSpaceProfileId, userId, true);
    }

    private String deleteSpaceProfileInst(String sSpaceProfileId, boolean startNewTransaction) throws AdminException {
        return this.deleteSpaceProfileInst(sSpaceProfileId, null, startNewTransaction);
    }

    private String deleteSpaceProfileInst(String sSpaceProfileId, String userId, boolean startNewTransaction) throws AdminException {
        DomainDriverManager domainDriverManager = DomainDriverManagerFactory.getCurrentDomainDriverManager();
        SpaceProfileInst spaceProfileInst = spaceProfileManager.getSpaceProfileInst(domainDriverManager, sSpaceProfileId, null);
        try {
            SpaceProfileInst inheritedProfile;
            if (startNewTransaction) {
                domainDriverManager.startTransaction(false);
            }
            spaceProfileManager.deleteSpaceProfileInst(spaceProfileInst, domainDriverManager);
            cache.opRemoveSpaceProfile(spaceProfileInst);
            spaceProfileInst.removeAllGroups();
            spaceProfileInst.removeAllUsers();
            String spaceId = this.getDriverComponentId(spaceProfileInst.getSpaceFatherId());
            if (StringUtil.isDefined(userId)) {
                SpaceInst spaceInstFather = this.getSpaceInstById(spaceId, false);
                spaceInstFather.setUpdaterUserId(userId);
                this.updateSpaceInst(spaceInstFather);
            }
            if (!spaceProfileInst.isInherited() && (inheritedProfile = spaceProfileManager.getInheritedSpaceProfileInstByName(domainDriverManager, spaceId, spaceProfileInst.getName())) != null) {
                spaceProfileInst.addGroups(inheritedProfile.getAllGroups());
                spaceProfileInst.addUsers(inheritedProfile.getAllUsers());
            }
            this.spreadSpaceProfile(spaceId, spaceProfileInst);
            if (startNewTransaction) {
                domainDriverManager.commit();
            }
            String string = sSpaceProfileId;
            return string;
        }
        catch (Exception e) {
            if (startNewTransaction) {
                this.rollback();
            }
            throw new AdminException("Admin.deleteSpaceProfileInst", 4, "admin.EX_ERR_DELETE_SPACEPROFILE", "space profile Id: '" + sSpaceProfileId + "'", e);
        }
        finally {
            if (startNewTransaction) {
                domainDriverManager.releaseOrganizationSchema();
            }
        }
    }

    private String updateSpaceProfileInst(SpaceProfileInst newSpaceProfile) throws AdminException {
        return this.updateSpaceProfileInst(newSpaceProfile, null);
    }

    public String updateSpaceProfileInst(SpaceProfileInst newSpaceProfile, String userId) throws AdminException {
        return this.updateSpaceProfileInst(newSpaceProfile, userId, true);
    }

    public String updateSpaceProfileInst(SpaceProfileInst newSpaceProfile, String userId, boolean startNewTransaction) throws AdminException {
        DomainDriverManager domainDriverManager = DomainDriverManagerFactory.getCurrentDomainDriverManager();
        try {
            SpaceProfileInst oldSpaceProfile;
            if (startNewTransaction) {
                domainDriverManager.startTransaction(false);
            }
            if ((oldSpaceProfile = spaceProfileManager.getSpaceProfileInst(domainDriverManager, newSpaceProfile.getId(), null)) == null) {
                String string = null;
                return string;
            }
            String spaceProfileNewId = spaceProfileManager.updateSpaceProfileInst(oldSpaceProfile, domainDriverManager, newSpaceProfile);
            if (!oldSpaceProfile.isManager()) {
                String spaceId = this.getDriverSpaceId(newSpaceProfile.getSpaceFatherId());
                if (StringUtil.isDefined(userId)) {
                    SpaceInst spaceInstFather = this.getSpaceInstById(spaceId, false);
                    spaceInstFather.setUpdaterUserId(userId);
                    this.updateSpaceInst(spaceInstFather);
                }
                ArrayList<SpaceProfileInst> allProfileSources = new ArrayList<SpaceProfileInst>();
                allProfileSources.add(newSpaceProfile);
                if (newSpaceProfile.isInherited()) {
                    allProfileSources.add(spaceProfileManager.getSpaceProfileInstByName(domainDriverManager, spaceId, oldSpaceProfile.getName()));
                } else {
                    allProfileSources.add(spaceProfileManager.getInheritedSpaceProfileInstByName(domainDriverManager, spaceId, oldSpaceProfile.getName()));
                }
                SpaceProfileInst profileToSpread = new SpaceProfileInst();
                profileToSpread.setName(oldSpaceProfile.getName());
                profileToSpread.setInherited(true);
                allProfileSources.remove(null);
                for (SpaceProfileInst spaceProfile : allProfileSources) {
                    profileToSpread.addGroups(spaceProfile.getAllGroups());
                    profileToSpread.addUsers(spaceProfile.getAllUsers());
                }
                this.spreadSpaceProfile(spaceId, profileToSpread);
            }
            if (startNewTransaction) {
                domainDriverManager.commit();
            }
            cache.opUpdateSpaceProfile(spaceProfileManager.getSpaceProfileInst(domainDriverManager, newSpaceProfile.getId(), null));
            String string = spaceProfileNewId;
            return string;
        }
        catch (Exception e) {
            if (startNewTransaction) {
                this.rollback();
            }
            throw new AdminException("Admin.updateSpaceProfileInst", 4, "admin.EX_ERR_UPDATE_SPACEPROFILE", "space profile Id: '" + newSpaceProfile.getId() + "'", e);
        }
        finally {
            if (startNewTransaction) {
                domainDriverManager.releaseOrganizationSchema();
            }
        }
    }

    private String spaceRole2ComponentRole(String spaceRole, String componentName) {
        return roleMapping.getString(componentName + "_" + spaceRole, null);
    }

    private List<String> componentRole2SpaceRoles(String componentRole, String componentName) {
        ArrayList<String> roles = new ArrayList<String>();
        String role = this.spaceRole2ComponentRole(SilverpeasRole.admin.toString(), componentName);
        if (role != null && role.equalsIgnoreCase(componentRole)) {
            roles.add(SilverpeasRole.admin.toString());
        }
        if ((role = this.spaceRole2ComponentRole(SilverpeasRole.publisher.toString(), componentName)) != null && role.equalsIgnoreCase(componentRole)) {
            roles.add(SilverpeasRole.publisher.toString());
        }
        if ((role = this.spaceRole2ComponentRole(SilverpeasRole.writer.toString(), componentName)) != null && role.equalsIgnoreCase(componentRole)) {
            roles.add(SilverpeasRole.writer.toString());
        }
        if ((role = this.spaceRole2ComponentRole(SilverpeasRole.reader.toString(), componentName)) != null && role.equalsIgnoreCase(componentRole)) {
            roles.add(SilverpeasRole.reader.toString());
        }
        return roles;
    }

    private void spreadSpaceProfile(String spaceId, SpaceProfileInst spaceProfile) throws AdminException {
        SilverTrace.info("admin", "Admin.spreadSpaceProfile", "root.MSG_GEN_ENTER_METHOD", "spaceId = " + spaceId + ", profile = " + spaceProfile.getName());
        DomainDriverManager domainDriverManager = DomainDriverManagerFactory.getCurrentDomainDriverManager();
        List<ComponentInstLight> components = TreeCache.getComponents(spaceId);
        for (ComponentInstLight component : components) {
            String componentRole;
            if (component == null || component.isInheritanceBlocked() || (componentRole = this.spaceRole2ComponentRole(spaceProfile.getName(), component.getName())) == null) continue;
            ProfileInst inheritedProfile = profileManager.getInheritedProfileInst(domainDriverManager, this.getDriverComponentId(component.getId()), componentRole);
            if (inheritedProfile != null) {
                inheritedProfile.removeAllGroups();
                inheritedProfile.removeAllUsers();
                inheritedProfile.addGroups(spaceProfile.getAllGroups());
                inheritedProfile.addUsers(spaceProfile.getAllUsers());
                List<String> profilesToCheck = this.componentRole2SpaceRoles(componentRole, component.getName());
                profilesToCheck.remove(spaceProfile.getName());
                for (String profileToCheck : profilesToCheck) {
                    SpaceProfileInst spi = spaceProfileManager.getSpaceProfileInstByName(domainDriverManager, spaceId, profileToCheck);
                    if (spi == null) continue;
                    inheritedProfile.addGroups(spi.getAllGroups());
                    inheritedProfile.addUsers(spi.getAllUsers());
                }
                this.updateProfileInst(inheritedProfile);
                continue;
            }
            inheritedProfile = new ProfileInst();
            inheritedProfile.setComponentFatherId(component.getId());
            inheritedProfile.setName(componentRole);
            inheritedProfile.setInherited(true);
            inheritedProfile.addGroups(spaceProfile.getAllGroups());
            inheritedProfile.addUsers(spaceProfile.getAllUsers());
            if (inheritedProfile.getNumGroup() <= 0 && inheritedProfile.getNumUser() <= 0) continue;
            this.addProfileInst(inheritedProfile);
        }
        List<SpaceInstLight> subSpaces = TreeCache.getSubSpaces(spaceId);
        for (SpaceInstLight subSpace : subSpaces) {
            if (subSpace.isInheritanceBlocked()) continue;
            SpaceProfileInst subSpaceProfile = spaceProfileManager.getInheritedSpaceProfileInstByName(domainDriverManager, subSpace.getShortId(), spaceProfile.getName());
            if (subSpaceProfile != null) {
                subSpaceProfile.setGroups(spaceProfile.getAllGroups());
                subSpaceProfile.setUsers(spaceProfile.getAllUsers());
                this.updateSpaceProfileInst(subSpaceProfile);
                continue;
            }
            subSpaceProfile = new SpaceProfileInst();
            subSpaceProfile.setName(spaceProfile.getName());
            subSpaceProfile.setInherited(true);
            subSpaceProfile.setSpaceFatherId(subSpace.getShortId());
            subSpaceProfile.addGroups(spaceProfile.getAllGroups());
            subSpaceProfile.addUsers(spaceProfile.getAllUsers());
            if (subSpaceProfile.getAllGroups().isEmpty() && subSpaceProfile.getAllUsers().isEmpty()) continue;
            this.addSpaceProfileInst(subSpaceProfile, null);
        }
    }

    public String[] getGroupNames(String[] groupIds) throws AdminException {
        if (groupIds == null) {
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        String[] asGroupNames = new String[groupIds.length];
        for (int nI = 0; nI < groupIds.length; ++nI) {
            asGroupNames[nI] = this.getGroupName(groupIds[nI]);
        }
        return asGroupNames;
    }

    public String getGroupName(String sGroupId) throws AdminException {
        return this.getGroup(sGroupId).getName();
    }

    public String[] getAllGroupIds() throws AdminException {
        DomainDriverManager domainDriverManager = DomainDriverManagerFactory.getCurrentDomainDriverManager();
        return this.groupManager.getAllGroupIds(domainDriverManager);
    }

    public boolean isGroupExist(String groupName) throws AdminException {
        DomainDriverManager domainDriverManager = DomainDriverManagerFactory.getCurrentDomainDriverManager();
        return this.groupManager.isGroupExist(domainDriverManager, groupName);
    }

    public Group getGroup(String groupId) throws AdminException {
        DomainDriverManager domainDriverManager = DomainDriverManagerFactory.getCurrentDomainDriverManager();
        return this.groupManager.getGroup(domainDriverManager, groupId);
    }

    public List<String> getPathToGroup(String groupId) throws AdminException {
        DomainDriverManager domainDriverManager = DomainDriverManagerFactory.getCurrentDomainDriverManager();
        return this.groupManager.getPathToGroup(domainDriverManager, groupId);
    }

    public Group getGroupByNameInDomain(String groupName, String domainFatherId) throws AdminException {
        DomainDriverManager domainDriverManager = DomainDriverManagerFactory.getCurrentDomainDriverManager();
        return this.groupManager.getGroupByNameInDomain(domainDriverManager, groupName, domainFatherId);
    }

    public Group[] getGroups(String[] asGroupId) throws AdminException {
        if (asGroupId == null) {
            return ArrayUtil.EMPTY_GROUP_ARRAY;
        }
        Group[] aGroup = new Group[asGroupId.length];
        for (int nI = 0; nI < asGroupId.length; ++nI) {
            aGroup[nI] = this.getGroup(asGroupId[nI]);
        }
        return aGroup;
    }

    public String addGroup(Group group) throws AdminException {
        try {
            return this.addGroup(group, false);
        }
        catch (Exception e) {
            throw new AdminException("Admin.addGroup", 4, "admin.EX_ERR_ADD_GROUP", "group name: '" + group.getName() + "'", e);
        }
    }

    public String addGroup(Group group, boolean onlyInSilverpeas) throws AdminException {
        DomainDriverManager domainDriverManager = DomainDriverManagerFactory.getCurrentDomainDriverManager();
        try {
            domainDriverManager.startTransaction(false);
            if (group.getDomainId() != null && !onlyInSilverpeas) {
                domainDriverManager.startTransaction(group.getDomainId(), false);
            }
            String sGroupId = this.groupManager.addGroup(domainDriverManager, group, onlyInSilverpeas);
            group.setId(sGroupId);
            domainDriverManager.commit();
            if (group.getDomainId() != null && !onlyInSilverpeas) {
                domainDriverManager.commit(group.getDomainId());
            }
            if (group.isSynchronized()) {
                groupSynchroScheduler.addGroup(sGroupId);
            }
            cache.opAddGroup(group);
            String string = sGroupId;
            return string;
        }
        catch (Exception e) {
            try {
                domainDriverManager.rollback();
                if (group.getDomainId() != null && !onlyInSilverpeas) {
                    domainDriverManager.rollback(group.getDomainId());
                }
            }
            catch (Exception e1) {
                SilverTrace.error("admin", "Admin.addGroup", "root.EX_ERR_ROLLBACK", e1);
            }
            throw new AdminException("Admin.addGroup", 4, "admin.EX_ERR_ADD_GROUP", "group name: '" + group.getName() + "'", e);
        }
        finally {
            domainDriverManager.releaseOrganizationSchema();
            if (group.getDomainId() != null && !onlyInSilverpeas) {
                domainDriverManager.releaseOrganizationSchema();
            }
        }
    }

    public String deleteGroupById(String sGroupId) throws AdminException {
        try {
            return this.deleteGroupById(sGroupId, false);
        }
        catch (Exception e) {
            throw new AdminException("Admin.deleteGroupById", 4, "admin.EX_ERR_DELETE_GROUP", "group Id: '" + sGroupId + "'", e);
        }
    }

    public String deleteGroupById(String sGroupId, boolean onlyInSilverpeas) throws AdminException {
        Group group = null;
        DomainDriverManager domainDriverManager = DomainDriverManagerFactory.getCurrentDomainDriverManager();
        try {
            group = this.getGroup(sGroupId);
            if (group == null) {
                throw new AdminException("Admin.deleteGroupById", 4, "admin.EX_ERR_GROUP_NOT_FOUND", "group Id: '" + sGroupId + "'");
            }
            domainDriverManager.startTransaction(false);
            if (group.getDomainId() != null && !onlyInSilverpeas) {
                domainDriverManager.startTransaction(group.getDomainId(), false);
            }
            this.deleteGroupProfileInst(sGroupId, false);
            String sReturnGroupId = this.groupManager.deleteGroupById(domainDriverManager, group, onlyInSilverpeas);
            domainDriverManager.commit();
            if (group.getDomainId() != null && !onlyInSilverpeas) {
                domainDriverManager.commit(group.getDomainId());
            }
            if (group.isSynchronized()) {
                groupSynchroScheduler.removeGroup(sGroupId);
            }
            cache.opRemoveGroup(group);
            String string = sReturnGroupId;
            return string;
        }
        catch (Exception e) {
            try {
                domainDriverManager.rollback();
                if (group != null && group.getDomainId() != null && !onlyInSilverpeas) {
                    domainDriverManager.rollback(group.getDomainId());
                }
            }
            catch (Exception e1) {
                SilverTrace.error("admin", "Admin.deleteGroupById", "root.EX_ERR_ROLLBACK", e1);
            }
            throw new AdminException("Admin.deleteGroupById", 4, "admin.EX_ERR_GROUP_NOT_FOUND", "group Id: '" + sGroupId + "'", e);
        }
        finally {
            domainDriverManager.releaseOrganizationSchema();
            if (group.getDomainId() != null && !onlyInSilverpeas) {
                domainDriverManager.releaseOrganizationSchema();
            }
        }
    }

    public String updateGroup(Group group) throws AdminException {
        try {
            return this.updateGroup(group, false);
        }
        catch (Exception e) {
            throw new AdminException("Admin.updateGroup", 4, "admin.EX_ERR_UPDATE_GROUP", "group name: '" + group.getName() + "'", e);
        }
    }

    public String updateGroup(Group group, boolean onlyInSilverpeas) throws AdminException {
        DomainDriverManager domainDriverManager = DomainDriverManagerFactory.getCurrentDomainDriverManager();
        try {
            domainDriverManager.startTransaction(false);
            if (group.getDomainId() != null && !onlyInSilverpeas) {
                domainDriverManager.startTransaction(group.getDomainId(), false);
            }
            String sGroupId = this.groupManager.updateGroup(domainDriverManager, group, onlyInSilverpeas);
            domainDriverManager.commit();
            if (group.getDomainId() != null && !onlyInSilverpeas) {
                domainDriverManager.commit(group.getDomainId());
            }
            cache.opUpdateGroup(this.getGroup(sGroupId));
            String string = sGroupId;
            return string;
        }
        catch (Exception e) {
            try {
                domainDriverManager.rollback();
                if (group.getDomainId() != null && !onlyInSilverpeas) {
                    domainDriverManager.rollback(group.getDomainId());
                }
            }
            catch (Exception e1) {
                SilverTrace.error("admin", "Admin.updateGroup", "root.EX_ERR_ROLLBACK", e1);
            }
            throw new AdminException("Admin.updateGroup", 4, "admin.EX_ERR_UPDATE_GROUP", "group name: '" + group.getName() + "'", e);
        }
        finally {
            domainDriverManager.releaseOrganizationSchema();
            if (group.getDomainId() != null && !onlyInSilverpeas) {
                domainDriverManager.releaseOrganizationSchema();
            }
        }
    }

    public void removeUserFromGroup(String sUserId, String sGroupId) throws AdminException {
        DomainDriverManager domainDriverManager = DomainDriverManagerFactory.getCurrentDomainDriverManager();
        try {
            domainDriverManager.startTransaction(false);
            this.groupManager.removeUserFromGroup(domainDriverManager, sUserId, sGroupId);
            domainDriverManager.commit();
            cache.opUpdateGroup(this.getGroup(sGroupId));
        }
        catch (Exception e) {
            try {
                domainDriverManager.rollback();
            }
            catch (Exception e1) {
                SilverTrace.error("admin", "Admin.removeUserFromGroup", "root.EX_ERR_ROLLBACK", e1);
            }
            throw new AdminException("Admin.removeUserFromGroup", 4, "admin.EX_ERR_UPDATE_GROUP", "groupId = " + sGroupId + ", userId = " + sUserId, e);
        }
        finally {
            domainDriverManager.releaseOrganizationSchema();
        }
    }

    public void addUserInGroup(String sUserId, String sGroupId) throws AdminException {
        DomainDriverManager domainDriverManager = DomainDriverManagerFactory.getCurrentDomainDriverManager();
        try {
            domainDriverManager.startTransaction(false);
            this.groupManager.addUserInGroup(domainDriverManager, sUserId, sGroupId);
            domainDriverManager.commit();
            cache.opUpdateGroup(this.getGroup(sGroupId));
        }
        catch (Exception e) {
            try {
                domainDriverManager.rollback();
            }
            catch (Exception e1) {
                SilverTrace.error("admin", "Admin.addUserInGroup", "root.EX_ERR_ROLLBACK", e1);
            }
            throw new AdminException("Admin.addUserInGroup", 4, "admin.EX_ERR_UPDATE_GROUP", "groupId = " + sGroupId + ", userId = " + sUserId, e);
        }
        finally {
            domainDriverManager.releaseOrganizationSchema();
        }
    }

    public AdminGroupInst[] getAdminOrganization() throws AdminException {
        DomainDriverManager domainDriverManager = DomainDriverManagerFactory.getCurrentDomainDriverManager();
        return this.groupManager.getAdminOrganization(domainDriverManager);
    }

    public String[] getAllSubGroupIds(String groupId) throws AdminException {
        DomainDriverManager domainDriverManager = DomainDriverManagerFactory.getCurrentDomainDriverManager();
        return this.groupManager.getAllSubGroupIds(domainDriverManager, groupId);
    }

    public String[] getAllSubGroupIdsRecursively(String groupId) throws AdminException {
        List<String> groupIds = this.groupManager.getAllSubGroupIdsRecursively(groupId);
        return groupIds.toArray(new String[groupIds.size()]);
    }

    public String[] getAllRootGroupIds() throws AdminException {
        DomainDriverManager domainDriverManager = DomainDriverManagerFactory.getCurrentDomainDriverManager();
        return this.groupManager.getAllRootGroupIds(domainDriverManager);
    }

    public Group[] getAllRootGroups() throws AdminException {
        DomainDriverManager domainDriverManager = DomainDriverManagerFactory.getCurrentDomainDriverManager();
        return this.groupManager.getAllRootGroups(domainDriverManager);
    }

    public GroupProfileInst getGroupProfileInst(String groupId) throws AdminException {
        DomainDriverManager domainDriverManager = DomainDriverManagerFactory.getCurrentDomainDriverManager();
        return groupProfileManager.getGroupProfileInst(domainDriverManager, null, groupId);
    }

    public String addGroupProfileInst(GroupProfileInst spaceProfileInst) throws AdminException {
        return this.addGroupProfileInst(spaceProfileInst, true);
    }

    public String addGroupProfileInst(GroupProfileInst groupProfileInst, boolean startNewTransaction) throws AdminException {
        DomainDriverManager domainDriverManager = DomainDriverManagerFactory.getCurrentDomainDriverManager();
        try {
            if (startNewTransaction) {
                domainDriverManager.startTransaction(false);
            }
            Group group = this.getGroup(groupProfileInst.getGroupId());
            String sProfileId = groupProfileManager.createGroupProfileInst(groupProfileInst, domainDriverManager, group.getId());
            groupProfileInst.setId(sProfileId);
            if (startNewTransaction) {
                domainDriverManager.commit();
            }
            String string = sProfileId;
            return string;
        }
        catch (Exception e) {
            if (startNewTransaction) {
                this.rollback();
            }
            throw new AdminException("Admin.addGroupProfileInst", 4, "admin.EX_ERR_ADD_SPACE_PROFILE", "group roleName = " + groupProfileInst.getName(), e);
        }
        finally {
            domainDriverManager.releaseOrganizationSchema();
        }
    }

    public String deleteGroupProfileInst(String groupId) throws AdminException {
        return this.deleteGroupProfileInst(groupId, true);
    }

    public String deleteGroupProfileInst(String groupId, boolean startNewTransaction) throws AdminException {
        DomainDriverManager domainDriverManager = DomainDriverManagerFactory.getCurrentDomainDriverManager();
        GroupProfileInst groupProfileInst = groupProfileManager.getGroupProfileInst(domainDriverManager, null, groupId);
        try {
            if (startNewTransaction) {
                domainDriverManager.startTransaction(false);
            }
            groupProfileManager.deleteGroupProfileInst(groupProfileInst, domainDriverManager);
            if (startNewTransaction) {
                domainDriverManager.commit();
            }
            String string = groupId;
            return string;
        }
        catch (Exception e) {
            if (startNewTransaction) {
                this.rollback();
            }
            throw new AdminException("Admin.deleteGroupProfileInst", 4, "admin.EX_ERR_DELETE_GROUPPROFILE", "groupId = " + groupId, e);
        }
        finally {
            if (startNewTransaction) {
                domainDriverManager.releaseOrganizationSchema();
            }
        }
    }

    public String updateGroupProfileInst(GroupProfileInst groupProfileInstNew) throws AdminException {
        String sSpaceProfileNewId = groupProfileInstNew.getId();
        if (!StringUtil.isDefined(sSpaceProfileNewId)) {
            sSpaceProfileNewId = this.addGroupProfileInst(groupProfileInstNew);
        } else {
            DomainDriverManager domainDriverManager = DomainDriverManagerFactory.getCurrentDomainDriverManager();
            try {
                domainDriverManager.startTransaction(false);
                GroupProfileInst oldSpaceProfile = groupProfileManager.getGroupProfileInst(domainDriverManager, null, groupProfileInstNew.getGroupId());
                groupProfileManager.updateGroupProfileInst(oldSpaceProfile, domainDriverManager, groupProfileInstNew);
                domainDriverManager.commit();
            }
            catch (Exception e) {
                this.rollback();
                throw new AdminException("Admin.updateGroupProfileInst", 4, "admin.EX_ERR_UPDATE_SPACEPROFILE", "space profile Id: '" + groupProfileInstNew.getId() + "'", e);
            }
            finally {
                domainDriverManager.releaseOrganizationSchema();
            }
        }
        return sSpaceProfileNewId;
    }

    public void indexAllGroups() throws AdminException {
        Domain[] domains;
        for (Domain domain : domains = this.getAllDomains()) {
            try {
                this.indexGroups(domain.getId());
            }
            catch (Exception e) {
                SilverTrace.error("admin", "Admin.indexAllGroups", "admin.CANT_INDEX_GROUPS", "domainId = " + domain.getId(), e);
            }
        }
        try {
            this.indexGroups("-1");
        }
        catch (Exception e) {
            SilverTrace.error("admin", "Admin.indexAllGroups", "admin.CANT_INDEX_GROUPS", "domainId = -1", e);
        }
    }

    public void indexGroups(String domainId) throws AdminException {
        DomainDriverManager domainDriverManager = DomainDriverManagerFactory.getCurrentDomainDriverManager();
        try {
            domainDriverManager.indexAllGroups(domainId);
        }
        catch (Exception e) {
            throw new AdminException("Admin.indexGroups", 4, "admin.CANT_INDEX_GROUPS", "domainId = " + domainId, e);
        }
    }

    public String[] getAllUsersIds() throws AdminException {
        DomainDriverManager domainDriverManager = DomainDriverManagerFactory.getCurrentDomainDriverManager();
        return this.userManager.getAllUsersIds(domainDriverManager);
    }

    public UserDetail getUserDetail(String sUserId) throws AdminException {
        if (!StringUtil.isDefined(sUserId) || "-1".equals(sUserId)) {
            return null;
        }
        DomainDriverManager domainDriverManager = DomainDriverManagerFactory.getCurrentDomainDriverManager();
        UserDetail ud = cache.getUserDetail(sUserId);
        if (ud == null && (ud = this.userManager.getUserDetail(domainDriverManager, sUserId)) != null) {
            cache.putUserDetail(sUserId, ud);
        }
        return ud;
    }

    public UserDetail[] getUserDetails(String[] userIds) {
        if (userIds == null) {
            return ArrayUtil.EMPTY_USER_DETAIL_ARRAY;
        }
        ArrayList<UserDetail> users = new ArrayList<UserDetail>(userIds.length);
        for (String userId : userIds) {
            try {
                users.add(this.getUserDetail(userId));
            }
            catch (AdminException e) {
                SilverTrace.error("admin", "Admin.getUserDetails", "admin.EX_ERR_GET_USER_DETAILS", "user id: '" + userId + "'", e);
            }
        }
        return users.toArray(new UserDetail[users.size()]);
    }

    public List<UserDetail> getAllUsers() throws AdminException {
        return this.userManager.getAllUsers();
    }

    public List<UserDetail> getAllUsersFromNewestToOldest() throws AdminException {
        return this.userManager.getAllUsersFromNewestToOldest();
    }

    public boolean isEmailExisting(String email) throws AdminException {
        DomainDriverManager domainDriverManager = DomainDriverManagerFactory.getCurrentDomainDriverManager();
        return this.userManager.isEmailExisting(domainDriverManager, email);
    }

    public String getUserIdByLoginAndDomain(String sLogin, String sDomainId) throws AdminException {
        String valret = null;
        DomainDriverManager domainDriverManager = DomainDriverManagerFactory.getCurrentDomainDriverManager();
        if (!StringUtil.isDefined(sDomainId)) {
            Domain[] theDomains;
            try {
                theDomains = domainDriverManager.getAllDomains();
            }
            catch (Exception e) {
                throw new AdminException("Admin.getUserIdByLoginAndDomain", 4, "admin.EX_ERR_GET_USER_BY_LOGIN_DOMAIN", "login: '" + sLogin + "', domain id: '" + sDomainId + "'", e);
            }
            for (int i = 0; i < theDomains.length && valret == null; ++i) {
                try {
                    valret = this.userManager.getUserIdByLoginAndDomain(domainDriverManager, sLogin, theDomains[i].getId());
                    continue;
                }
                catch (Exception e) {
                    throw new AdminException("Admin.getUserIdByLoginAndDomain", 4, "admin.EX_ERR_GET_USER_BY_LOGIN_DOMAIN", "login: '" + sLogin + "', domain id: '" + sDomainId + "'", e);
                }
            }
            if (valret == null) {
                throw new AdminException("Admin.getUserIdByLoginAndDomain", 4, "admin.EX_ERR_USER_NOT_FOUND", "login: '" + sLogin + "', in all domains");
            }
        } else {
            valret = this.userManager.getUserIdByLoginAndDomain(domainDriverManager, sLogin, sDomainId);
        }
        return valret;
    }

    public String getUserIdByAuthenticationKey(String authenticationKey) throws Exception {
        DomainDriverManager domainDriverManager = DomainDriverManagerFactory.getCurrentDomainDriverManager();
        Map<String, String> userParameters = domainDriverManager.authenticate(authenticationKey);
        String login = userParameters.get("login");
        String domainId = userParameters.get("domainId");
        return this.userManager.getUserIdByLoginAndDomain(domainDriverManager, login, domainId);
    }

    public UserFull getUserFull(String sUserId) throws AdminException {
        DomainDriverManager domainDriverManager = DomainDriverManagerFactory.getCurrentDomainDriverManager();
        return this.userManager.getUserFull(domainDriverManager, sUserId);
    }

    public UserFull getUserFull(String domainId, String specificId) throws Exception {
        SilverTrace.info("admin", "admin.getUserFull", "root.MSG_GEN_ENTER_METHOD", "domainId=" + domainId);
        DomainDriverManager domainDriverManager = DomainDriverManagerFactory.getCurrentDomainDriverManager();
        DomainDriver synchroDomain = domainDriverManager.getDomainDriver(Integer.parseInt(domainId));
        return synchroDomain.getUserFull(specificId);
    }

    public String addUser(UserDetail userDetail) throws AdminException {
        try {
            return this.addUser(userDetail, false);
        }
        catch (Exception e) {
            throw new AdminException("Admin.addUser", 4, "admin.EX_ERR_ADD_USER", userDetail.getFirstName() + " " + userDetail.getLastName(), e);
        }
    }

    public String addUser(UserDetail userDetail, boolean addOnlyInSilverpeas) throws AdminException {
        DomainDriverManager domainDriverManager = DomainDriverManagerFactory.getCurrentDomainDriverManager();
        try {
            domainDriverManager.startTransaction(false);
            if (userDetail.getDomainId() != null && !addOnlyInSilverpeas) {
                domainDriverManager.startTransaction(userDetail.getDomainId(), false);
            }
            String sUserId = this.userManager.addUser(domainDriverManager, userDetail, addOnlyInSilverpeas);
            domainDriverManager.commit();
            if (userDetail.getDomainId() != null && !addOnlyInSilverpeas) {
                domainDriverManager.commit(userDetail.getDomainId());
            }
            cache.opAddUser(this.userManager.getUserDetail(domainDriverManager, sUserId));
            String string = sUserId;
            return string;
        }
        catch (Exception e) {
            try {
                domainDriverManager.rollback();
                if (userDetail.getDomainId() != null && !addOnlyInSilverpeas) {
                    domainDriverManager.rollback(userDetail.getDomainId());
                }
            }
            catch (Exception e1) {
                SilverTrace.error("admin", "Admin.addUser", "root.EX_ERR_ROLLBACK", e1);
            }
            throw new AdminException("Admin.addUser", 4, "admin.EX_ERR_ADD_USER", userDetail.getFirstName() + " " + userDetail.getLastName(), e);
        }
        finally {
            domainDriverManager.releaseOrganizationSchema();
            if (userDetail.getDomainId() != null && !addOnlyInSilverpeas) {
                domainDriverManager.releaseOrganizationSchema();
            }
        }
    }

    public void migrateUser(UserDetail userDetail, String targetDomainId) throws AdminException {
        DomainDriverManager domainDriverManager = DomainDriverManagerFactory.getCurrentDomainDriverManager();
        try {
            domainDriverManager.startTransaction(false);
            domainDriverManager.startTransaction(targetDomainId, false);
            this.userManager.migrateUser(domainDriverManager, userDetail, targetDomainId);
            domainDriverManager.commit();
            domainDriverManager.commit(targetDomainId);
            cache.opUpdateUser(userDetail);
        }
        catch (Exception e) {
            try {
                domainDriverManager.rollback();
                domainDriverManager.rollback(targetDomainId);
            }
            catch (Exception e1) {
                SilverTrace.error("admin", "Admin.migrateUserFromSilverpeasToAnotherDomain", "root.EX_ERR_ROLLBACK", e1);
            }
            throw new AdminException("Admin.migrateUserFromSilverpeasToAnotherDomain", 4, "admin.EX_ERR_M_USER", userDetail.getFirstName() + " " + userDetail.getLastName(), e);
        }
        finally {
            domainDriverManager.releaseOrganizationSchema();
        }
    }

    public void blockUser(String userId) throws AdminException {
        this.updateUserState(userId, UserState.BLOCKED);
    }

    public void unblockUser(String userId) throws AdminException {
        this.updateUserState(userId, UserState.VALID);
    }

    public void deactivateUser(String userId) throws AdminException {
        this.updateUserState(userId, UserState.DEACTIVATED);
    }

    public void activateUser(String userId) throws AdminException {
        this.updateUserState(userId, UserState.VALID);
    }

    private void updateUserState(String userId, UserState state) throws AdminException {
        try {
            UserDetail user = UserDetail.getById(userId);
            user.setState(state);
            user.setStateSaveDate(new Date());
            this.updateUser(user);
        }
        catch (Exception e) {
            throw new AdminException("Admin.updateUserState", 4, "admin.EX_ERR_UPDATE_USER_STATE", "user id : '" + userId + "', state : '" + state.name() + "'", e);
        }
    }

    public void userAcceptsTermsOfService(String userId) throws AdminException {
        try {
            UserDetail user = UserDetail.getById(userId);
            user.setTosAcceptanceDate(DateUtil.getNow());
            this.updateUser(user);
        }
        catch (Exception e) {
            throw new AdminException("Admin.updateTermsOfServiceAcceptanceDate", 4, "admin.EX_ERR_UPDATE_USER_TOS_ACCEPTANCE_DATE", "user id : '" + userId + "'", e);
        }
    }

    public String deleteUser(String sUserId) throws AdminException {
        try {
            if (m_sDAPIGeneralAdminId.equals(sUserId)) {
                SilverTrace.warn("admin", "Admin.deleteUser", "admin.MSG_WARN_TRY_TO_DELETE_GENERALADMIN");
                return null;
            }
            return this.deleteUser(sUserId, false);
        }
        catch (Exception e) {
            throw new AdminException("Admin.deleteUser", 4, "admin.EX_ERR_DELETE_USER", "user id : '" + sUserId + "'", e);
        }
    }

    public String deleteUser(String sUserId, boolean onlyInSilverpeas) throws AdminException {
        UserDetail user = null;
        boolean transactionStarted = false;
        DomainDriverManager domainDriverManager = DomainDriverManagerFactory.getCurrentDomainDriverManager();
        try {
            user = this.getUserDetail(sUserId);
            if (user == null) {
                throw new AdminException("Admin.deleteUser", 4, "admin.EX_ERR_USER_NOT_FOUND", "user id : '" + sUserId + "'");
            }
            domainDriverManager.startTransaction(false);
            if (user.getDomainId() != null && !onlyInSilverpeas) {
                transactionStarted = true;
                domainDriverManager.startTransaction(user.getDomainId(), false);
            }
            String sReturnUserId = this.userManager.deleteUser(domainDriverManager, user, onlyInSilverpeas);
            domainDriverManager.commit();
            if (user.getDomainId() != null && !onlyInSilverpeas) {
                domainDriverManager.commit(user.getDomainId());
            }
            cache.opRemoveUser(user);
            String string = sReturnUserId;
            return string;
        }
        catch (Exception e) {
            try {
                domainDriverManager.rollback();
                if (transactionStarted) {
                    domainDriverManager.rollback(user.getDomainId());
                }
            }
            catch (Exception e1) {
                SilverTrace.error("admin", "Admin.deleteUser", "root.EX_ERR_ROLLBACK", e1);
            }
            throw new AdminException("Admin.deleteUser", 4, "admin.EX_ERR_DELETE_USER", "user id : '" + sUserId + "'", e);
        }
        finally {
            domainDriverManager.releaseOrganizationSchema();
            if (transactionStarted) {
                domainDriverManager.releaseOrganizationSchema();
            }
        }
    }

    public String updateUser(UserDetail user) throws AdminException {
        DomainDriverManager domainDriverManager = DomainDriverManagerFactory.getCurrentDomainDriverManager();
        try {
            domainDriverManager.startTransaction(false);
            String sUserId = this.userManager.updateUser(domainDriverManager, user);
            domainDriverManager.commit();
            cache.opUpdateUser(this.userManager.getUserDetail(domainDriverManager, sUserId));
            String string = sUserId;
            return string;
        }
        catch (Exception e) {
            this.rollback();
            throw new AdminException("Admin.updateUser", 4, "admin.EX_ERR_UPDATE_USER", "user id : '" + user.getId() + "'", e);
        }
        finally {
            domainDriverManager.releaseOrganizationSchema();
        }
    }

    public String updateUserFull(UserFull user) throws AdminException {
        DomainDriverManager domainDriverManager = DomainDriverManagerFactory.getCurrentDomainDriverManager();
        try {
            domainDriverManager.startTransaction(false);
            if (user.getDomainId() != null) {
                domainDriverManager.startTransaction(user.getDomainId(), false);
            }
            String sUserId = this.userManager.updateUserFull(domainDriverManager, user);
            domainDriverManager.commit();
            if (user.getDomainId() != null) {
                domainDriverManager.commit(user.getDomainId());
            }
            cache.opUpdateUser(this.userManager.getUserDetail(domainDriverManager, sUserId));
            String string = sUserId;
            return string;
        }
        catch (Exception e) {
            try {
                domainDriverManager.rollback();
                if (user.getDomainId() != null) {
                    domainDriverManager.rollback(user.getDomainId());
                }
            }
            catch (Exception e1) {
                SilverTrace.error("admin", "Admin.updateUserFull", "root.EX_ERR_ROLLBACK", e1);
            }
            throw new AdminException("Admin.updateUserFull", 4, "admin.EX_ERR_UPDATE_USER", "user id : '" + user.getId() + "'", e);
        }
        finally {
            domainDriverManager.releaseOrganizationSchema();
            if (user.getDomainId() != null) {
                domainDriverManager.releaseOrganizationSchema();
            }
        }
    }

    private void instantiateComponents(String userId, String[] asComponentIds, String[] asComponentNames, String sSpaceId, Connection connectionProd) throws AdminException {
        try {
            for (int nI = 0; nI < asComponentIds.length; ++nI) {
                SilverTrace.debug("admin", "Admin.instantiateComponents", "root.MSG_GEN_ENTER_METHOD", "spaceid: " + sSpaceId + " and component " + asComponentIds[nI]);
                componentInstanciator.setConnection(connectionProd);
                componentInstanciator.setSpaceId(sSpaceId);
                componentInstanciator.setComponentId(asComponentIds[nI]);
                componentInstanciator.setUserId(userId);
                componentInstanciator.instantiateComponentName(asComponentNames[nI]);
            }
        }
        catch (Exception e) {
            throw new AdminException("Admin.instantiateComponents", 4, "admin.EX_ERR_INSTANTIATE_COMPONENTS", e);
        }
    }

    private void unInstantiateComponents(String userId, String[] asComponentIds, String[] asComponentNames, String sSpaceId, Connection connectionProd) {
        for (int nI = 0; nI < asComponentIds.length; ++nI) {
            try {
                SilverTrace.debug("admin", "Admin.instantiateComponents", "root.MSG_GEN_ENTER_METHOD", "spaceid: " + sSpaceId + " and component " + asComponentIds[nI]);
                componentInstanciator.setConnection(connectionProd);
                componentInstanciator.setSpaceId(sSpaceId);
                componentInstanciator.setComponentId(asComponentIds[nI]);
                componentInstanciator.setUserId(userId);
                componentInstanciator.unInstantiateComponentName(asComponentNames[nI]);
                continue;
            }
            catch (Exception e) {
                SilverTrace.warn("admin", "Admin.unInstantiateComponents", "admin.EX_ERR_UNINSTANTIATE_COMPONENTS", "Deleting data from component '" + asComponentNames[nI] + "' failed", e);
            }
        }
    }

    private String getDriverSpaceId(String sClientSpaceId) {
        if (sClientSpaceId != null && sClientSpaceId.startsWith(SPACE_KEY_PREFIX)) {
            return sClientSpaceId.substring(SPACE_KEY_PREFIX.length());
        }
        return sClientSpaceId;
    }

    public String getClientSpaceId(String sDriverSpaceId) {
        if (sDriverSpaceId != null && !sDriverSpaceId.startsWith(SPACE_KEY_PREFIX)) {
            return SPACE_KEY_PREFIX + sDriverSpaceId;
        }
        return sDriverSpaceId;
    }

    public String[] getClientSpaceIds(String[] asDriverSpaceIds) throws Exception {
        String[] asClientSpaceIds = new String[asDriverSpaceIds.length];
        for (int nI = 0; nI < asDriverSpaceIds.length; ++nI) {
            asClientSpaceIds[nI] = this.getClientSpaceId(asDriverSpaceIds[nI]);
        }
        return asClientSpaceIds;
    }

    private String getDriverComponentId(String sClientComponentId) {
        SilverTrace.debug("admin", "Admin.getDriverComponentId", "root.MSG_GEN_ENTER_METHOD", "component id: " + sClientComponentId);
        if (sClientComponentId == null) {
            return "";
        }
        return this.getTableClientComponentIdFromClientComponentId(sClientComponentId);
    }

    private String getTableClientComponentIdFromClientComponentId(String sClientComponentId) {
        String sTableClientId = "";
        char[] cBuf = sClientComponentId.toCharArray();
        for (int nI = 0; nI < cBuf.length && sTableClientId.length() == 0; ++nI) {
            if (cBuf[nI] != '0' && cBuf[nI] != '1' && cBuf[nI] != '2' && cBuf[nI] != '3' && cBuf[nI] != '4' && cBuf[nI] != '5' && cBuf[nI] != '6' && cBuf[nI] != '7' && cBuf[nI] != '8' && cBuf[nI] != '9') continue;
            sTableClientId = sClientComponentId.substring(nI);
        }
        return sTableClientId;
    }

    private String getClientComponentId(ComponentInst component) {
        return this.getClientComponentId(component.getName(), component.getId());
    }

    private String getClientComponentId(String componentName, String sDriverComponentId) {
        if (StringUtil.isInteger(sDriverComponentId)) {
            return componentName + sDriverComponentId;
        }
        return sDriverComponentId;
    }

    public String getNextDomainId() throws AdminException {
        DomainDriverManager domainDriverManager = DomainDriverManagerFactory.getCurrentDomainDriverManager();
        try {
            return domainDriverManager.getNextDomainId();
        }
        catch (Exception e) {
            throw new AdminException("Admin.getNextDomainId", 4, "admin.EX_ERR_ADD_DOMAIN", e);
        }
    }

    public String addDomain(Domain theDomain) throws AdminException {
        DomainDriverManager domainDriverManager = DomainDriverManagerFactory.getCurrentDomainDriverManager();
        try {
            String id = domainDriverManager.createDomain(theDomain);
            DomainDriver domainDriver = domainDriverManager.getDomainDriver(Integer.parseInt(id));
            if (domainDriver.isSynchroThreaded()) {
                domainSynchroScheduler.addDomain(id);
            }
            return id;
        }
        catch (Exception e) {
            throw new AdminException("Admin.addDomain", 4, "admin.EX_ERR_ADD_DOMAIN", "domain name : '" + theDomain.getName() + "'", e);
        }
    }

    public String updateDomain(Domain domain) throws AdminException {
        DomainDriverManager domainDriverManager = DomainDriverManagerFactory.getCurrentDomainDriverManager();
        try {
            DomainCache.removeDomain(domain.getId());
            return domainDriverManager.updateDomain(domain);
        }
        catch (Exception e) {
            throw new AdminException("Admin.updateDomain", 4, "admin.EX_ERR_UPDATE_DOMAIN", "domain name : '" + domain.getName() + "'", e);
        }
    }

    public String removeDomain(String domainId) throws AdminException {
        DomainDriverManager domainDriverManager = DomainDriverManagerFactory.getCurrentDomainDriverManager();
        try {
            Group[] toRemoveGroups;
            UserDetail[] toRemoveUDs = this.userManager.getUsersOfDomain(domainDriverManager, domainId);
            if (toRemoveUDs != null) {
                for (UserDetail user : toRemoveUDs) {
                    try {
                        this.deleteUser(user.getId(), false);
                    }
                    catch (Exception e) {
                        this.deleteUser(user.getId(), true);
                    }
                }
            }
            if ((toRemoveGroups = this.groupManager.getGroupsOfDomain(domainDriverManager, domainId)) != null) {
                for (Group group : toRemoveGroups) {
                    try {
                        this.deleteGroupById(group.getId(), false);
                    }
                    catch (Exception e) {
                        this.deleteGroupById(group.getId(), true);
                    }
                }
            }
            domainDriverManager.removeDomain(domainId);
            domainSynchroScheduler.removeDomain(domainId);
            DomainCache.removeDomain(domainId);
            return domainId;
        }
        catch (Exception e) {
            throw new AdminException("Admin.removeDomain", 4, "admin.MSG_ERR_DELETE_DOMAIN", "domain Id : '" + domainId + "'", e);
        }
    }

    public Domain[] getAllDomains() throws AdminException {
        DomainDriverManager domainDriverManager = DomainDriverManagerFactory.getCurrentDomainDriverManager();
        try {
            return domainDriverManager.getAllDomains();
        }
        catch (Exception e) {
            throw new AdminException("Admin.getAllDomains", 4, "admin.EX_ERR_GET_ALL_DOMAINS", e);
        }
    }

    public List<String> getAllDomainIdsForLogin(String login) throws AdminException {
        return this.userManager.getDomainsOfUser(login);
    }

    public Domain getDomain(String domainId) throws AdminException {
        try {
            if (!StringUtil.isDefined(domainId) || !StringUtil.isInteger(domainId)) {
                domainId = "-1";
            }
            DomainDriverManager domainDriverManager = DomainDriverManagerFactory.getCurrentDomainDriverManager();
            Domain domain = DomainCache.getDomain(domainId);
            if (domain == null) {
                domain = domainDriverManager.getDomain(domainId);
                DomainCache.addDomain(domain);
            }
            return domain;
        }
        catch (Exception e) {
            throw new AdminException("Admin.getDomain", 4, "admin.EX_ERR_GET_DOMAIN", "domain Id : '" + domainId + "'", e);
        }
    }

    public long getDomainActions(String domainId) throws AdminException {
        try {
            if (domainId != null && domainId.equals("-1")) {
                return 426L;
            }
            return DomainDriverManagerFactory.getCurrentDomainDriverManager().getDomainActions(domainId);
        }
        catch (Exception e) {
            throw new AdminException("Admin.getDomainActions", 4, "admin.EX_ERR_GET_DOMAIN", "domain Id : '" + domainId + "'", e);
        }
    }

    public Group[] getRootGroupsOfDomain(String domainId) throws AdminException {
        DomainDriverManager domainDriverManager = DomainDriverManagerFactory.getCurrentDomainDriverManager();
        try {
            return this.groupManager.getRootGroupsOfDomain(domainDriverManager, domainId);
        }
        catch (Exception e) {
            throw new AdminException("Admin.getGroupsOfDomain", 4, "admin.EX_ERR_GET_DOMAIN", "domain Id : '" + domainId + "'", e);
        }
    }

    public Group[] getSynchronizedGroups() throws AdminException {
        DomainDriverManager domainDriverManager = DomainDriverManagerFactory.getCurrentDomainDriverManager();
        try {
            return this.groupManager.getSynchronizedGroups(domainDriverManager);
        }
        catch (Exception e) {
            throw new AdminException("Admin.getGroupsOfDomain", 4, "admin.EX_ERR_GET_DOMAIN", e);
        }
    }

    public String[] getRootGroupIdsOfDomain(String domainId) throws AdminException {
        DomainDriverManager domainDriverManager = DomainDriverManagerFactory.getCurrentDomainDriverManager();
        try {
            return this.groupManager.getRootGroupIdsOfDomain(domainDriverManager, domainId);
        }
        catch (Exception e) {
            throw new AdminException("Admin.getRootGroupIdsOfDomain", 4, "admin.EX_ERR_GET_DOMAIN", "domain Id : '" + domainId + "'", e);
        }
    }

    public UserDetail[] getAllUsersOfGroup(String groupId) throws AdminException {
        try {
            ArrayList<String> groupIds = new ArrayList<String>();
            groupIds.add(groupId);
            groupIds.addAll(this.groupManager.getAllSubGroupIdsRecursively(groupId));
            return this.userManager.getAllUsersOfGroups(groupIds);
        }
        catch (Exception e) {
            throw new AdminException("Admin.getAllUsersOfGroup", 4, "admin.EX_ERR_GET_DOMAIN", "Group Id : '" + groupId + "'", e);
        }
    }

    public UserDetail[] getUsersOfDomain(String domainId) throws AdminException {
        DomainDriverManager domainDriverManager = DomainDriverManagerFactory.getCurrentDomainDriverManager();
        try {
            if (domainId != null && "-1".equals(domainId)) {
                return ArrayUtil.EMPTY_USER_DETAIL_ARRAY;
            }
            return this.userManager.getUsersOfDomain(domainDriverManager, domainId);
        }
        catch (Exception e) {
            throw new AdminException("Admin.getUsersOfDomain", 4, "admin.EX_ERR_GET_DOMAIN", "domain Id : '" + domainId + "'", e);
        }
    }

    public List<UserDetail> getUsersOfDomains(List<String> domainIds) throws AdminException {
        return this.userManager.getUsersOfDomains(domainIds);
    }

    public List<UserDetail> getUsersOfDomainsFromNewestToOldest(List<String> domainIds) throws AdminException {
        return this.userManager.getUsersOfDomainsFromNewestToOldest(domainIds);
    }

    public String[] getUserIdsOfDomain(String domainId) throws AdminException {
        DomainDriverManager domainDriverManager = DomainDriverManagerFactory.getCurrentDomainDriverManager();
        try {
            if (domainId != null && "-1".equals(domainId)) {
                return ArrayUtil.EMPTY_STRING_ARRAY;
            }
            return this.userManager.getUserIdsOfDomain(domainDriverManager, domainId);
        }
        catch (Exception e) {
            throw new AdminException("Admin.getUserIdsOfDomain", 4, "admin.EX_ERR_GET_DOMAIN", "domain Id : '" + domainId + "'", e);
        }
    }

    public String identify(String sKey, String sSessionId, boolean isAppInMaintenance) throws AdminException {
        return this.identify(sKey, sSessionId, isAppInMaintenance, true);
    }

    public String identify(String sKey, String sSessionId, boolean isAppInMaintenance, boolean removeKey) throws AdminException {
        DomainDriverManager domainDriverManager = DomainDriverManagerFactory.getCurrentDomainDriverManager();
        try {
            UserLog userLog;
            String sUserId;
            Map<String, String> loginDomain = domainDriverManager.authenticate(sKey, removeKey);
            if (!loginDomain.containsKey("login") || !loginDomain.containsKey("domainId")) {
                throw new AdminException("Admin.authenticate", 3, "admin.MSG_ERR_AUTHENTICATE_USER", "key : '" + sKey + "'");
            }
            String sLogin = loginDomain.get("login");
            String sDomainId = loginDomain.get("domainId");
            DomainDriver synchroDomain = domainDriverManager.getDomainDriver(Integer.parseInt(sDomainId));
            try {
                sUserId = this.userManager.getUserIdByLoginAndDomain(domainDriverManager, sLogin, sDomainId);
            }
            catch (Exception ex) {
                if (synchroDomain.isSynchroOnLoginEnabled() && !isAppInMaintenance) {
                    SilverTrace.warn("admin", "Admin.authenticate", "admin.EX_ERR_USER_NOT_FOUND", "Login: '" + sLogin + "', Domain: " + sDomainId, ex);
                    sUserId = this.synchronizeImportUserByLogin(sDomainId, sLogin, synchroDomain.isSynchroOnLoginRecursToGroups());
                }
                throw ex;
            }
            if (synchroDomain.isSynchroOnLoginEnabled() && !isAppInMaintenance) {
                try {
                    this.synchronizeUser(sUserId, synchroDomain.isSynchroOnLoginRecursToGroups());
                }
                catch (Exception ex) {
                    SilverTrace.warn("admin", "Admin.authenticate", "admin.MSG_ERR_SYNCHRONIZE_USER", "UserId=" + sUserId + " Login: '" + sLogin + "', Domain: " + sDomainId, ex);
                }
            }
            if ((userLog = loggedUsers.get(sUserId)) != null) {
                loggedUsers.remove(sUserId);
                SilverTrace.info("admin", "Admin.authenticate", "admin.MSG_USER_ALREADY_LOGGED", "user id: '" + sUserId + "', log time: " + formatter.format(userLog.getLogDate()));
            }
            userLog = new UserLog();
            userLog.setSessionId(sSessionId);
            userLog.setUserId(sUserId);
            userLog.setUserLogin(sLogin);
            userLog.setLogDate(new Date());
            loggedUsers.put(sUserId, userLog);
            return sUserId;
        }
        catch (Exception e) {
            throw new AdminException("Admin.authenticate", 3, "admin.MSG_ERR_AUTHENTICATE_USER", "key : '" + sKey + "'", e);
        }
    }

    public String[] getDirectGroupsIdsOfUser(String userId) throws AdminException {
        DomainDriverManager domainDriverManager = DomainDriverManagerFactory.getCurrentDomainDriverManager();
        try {
            return this.groupManager.getDirectGroupsOfUser(domainDriverManager, userId);
        }
        catch (Exception e) {
            throw new AdminException("Admin.getDirectGroupsIdsOfUser", 4, "admin.EX_ERR_GROUP_NOT_FOUND", "user Id : '" + userId + "'", e);
        }
    }

    public UserDetail[] searchUsers(UserDetail modelUser, boolean isAnd) throws AdminException {
        DomainDriverManager domainDriverManager = DomainDriverManagerFactory.getCurrentDomainDriverManager();
        try {
            return this.userManager.searchUsers(domainDriverManager, modelUser, isAnd);
        }
        catch (Exception e) {
            throw new AdminException("Admin.searchUsers", 4, "admin.EX_ERR_USER_NOT_FOUND", e);
        }
    }

    public Group[] searchGroups(Group modelGroup, boolean isAnd) throws AdminException {
        DomainDriverManager domainDriverManager = DomainDriverManagerFactory.getCurrentDomainDriverManager();
        try {
            return this.groupManager.searchGroups(domainDriverManager, modelGroup, isAnd);
        }
        catch (Exception e) {
            throw new AdminException("Admin.searchGroups", 4, "admin.EX_ERR_GROUP_NOT_FOUND", e);
        }
    }

    public String[] getUserSpaceIds(String sUserId) throws AdminException {
        ArrayList<String> spaceIds = new ArrayList<String>();
        List<String> componentIds = this.getAllowedComponentIds(sUserId);
        for (String componentId : componentIds) {
            List<SpaceInstLight> spaces = TreeCache.getComponentPath(componentId);
            for (SpaceInstLight space : spaces) {
                if (spaceIds.contains(space.getFullId())) continue;
                spaceIds.add(space.getFullId());
            }
        }
        return spaceIds.toArray(new String[spaceIds.size()]);
    }

    private List<String> getAllGroupsOfUser(String userId) throws AdminException {
        DomainDriverManager domainDriverManager = DomainDriverManagerFactory.getCurrentDomainDriverManager();
        List<String> allGroupsOfUser = GroupCache.getAllGroupIdsOfUser(userId);
        if (allGroupsOfUser == null) {
            allGroupsOfUser = this.groupManager.getAllGroupsOfUser(domainDriverManager, userId);
            GroupCache.setAllGroupIdsOfUser(userId, allGroupsOfUser);
        }
        return allGroupsOfUser;
    }

    private List<String> getAllowedComponentIds(String userId) throws AdminException {
        return this.getAllowedComponentIds(userId, null);
    }

    private List<String> getAllowedComponentIds(String userId, String componentName) throws AdminException {
        List<String> allGroupsOfUser = this.getAllGroupsOfUser(userId);
        return componentManager.getAllowedComponentIds(Integer.parseInt(userId), allGroupsOfUser, null, componentName);
    }

    public String[] getUserRootSpaceIds(String sUserId) throws AdminException {
        try {
            List<String> componentIds = this.getAllowedComponentIds(sUserId);
            return this.getUserRootSpaceIds(componentIds);
        }
        catch (Exception e) {
            throw new AdminException("Admin.getUserRootSpaceIds", 4, "admin.EX_ERR_GET_USER_ALLOWED_ROOTSPACE_IDS", "user Id : '" + sUserId + "'", e);
        }
    }

    private String[] getUserRootSpaceIds(List<String> componentIds) throws AdminException {
        String[] rootSpaceIds;
        ArrayList<String> result = new ArrayList<String>();
        for (String rootSpaceId : rootSpaceIds = this.getAllRootSpaceIds()) {
            if (!this.isSpaceContainsOneComponent(componentIds, this.getDriverSpaceId(rootSpaceId), true)) continue;
            result.add(rootSpaceId);
        }
        return result.toArray(new String[result.size()]);
    }

    public String[] getUserSubSpaceIds(String sUserId, String spaceId) throws AdminException {
        List<String> componentIds = this.getAllowedComponentIds(sUserId);
        return this.getUserSubSpaceIds(componentIds, spaceId);
    }

    private String[] getUserSubSpaceIds(List<String> componentIds, String spaceId) throws AdminException {
        try {
            ArrayList<String> result = new ArrayList<String>();
            List<SpaceInstLight> subspaces = TreeCache.getSubSpaces(this.getDriverSpaceId(spaceId));
            for (SpaceInstLight subspace : subspaces) {
                if (!this.isSpaceContainsOneComponent(componentIds, subspace.getShortId(), true)) continue;
                result.add(subspace.getShortId());
            }
            return result.toArray(new String[result.size()]);
        }
        catch (Exception e) {
            throw new AdminException("Admin.getUserSubSpaceIds", 4, "admin.EX_ERR_GET_USER_ALLOWED_SUBSPACE_IDS", "spaceId : " + spaceId, e);
        }
    }

    public boolean isSpaceAvailable(String userId, String spaceId) throws AdminException {
        List<String> componentIds = this.getAllowedComponentIds(userId);
        return this.isSpaceAvailable(componentIds, this.getDriverSpaceId(spaceId));
    }

    private boolean isSpaceAvailable(List<String> componentIds, String spaceId) throws AdminException {
        return this.isSpaceContainsOneComponent(componentIds, this.getDriverSpaceId(spaceId), true);
    }

    private boolean isSpaceContainsOneComponent(List<String> componentIds, String spaceId, boolean checkInSubspaces) {
        boolean find = false;
        ArrayList<ComponentInstLight> components = new ArrayList<ComponentInstLight>(TreeCache.getComponents(spaceId));
        for (int c = 0; !find && c < components.size(); ++c) {
            find = componentIds.contains(((ComponentInstLight)components.get(c)).getId());
        }
        if (find) {
            return true;
        }
        if (checkInSubspaces) {
            ArrayList<SpaceInstLight> subspaces = new ArrayList<SpaceInstLight>(TreeCache.getSubSpaces(spaceId));
            for (int s = 0; !find && s < subspaces.size(); ++s) {
                find = this.isSpaceContainsOneComponent(componentIds, ((SpaceInstLight)subspaces.get(s)).getShortId(), checkInSubspaces);
            }
        }
        return find;
    }

    public List<SpaceInstLight> getSubSpacesOfUser(String userId, String spaceId) throws AdminException {
        SilverTrace.info("admin", "Admin.getSubSpacesOfUser", "root.MSG_GEN_ENTER_METHOD", "userId = " + userId + ", spaceId = " + spaceId);
        try {
            ArrayList<SpaceInstLight> result = new ArrayList<SpaceInstLight>();
            List<String> componentIds = this.getAllowedComponentIds(userId);
            List<SpaceInstLight> subspaces = TreeCache.getSubSpaces(this.getDriverSpaceId(spaceId));
            for (SpaceInstLight subspace : subspaces) {
                if (!this.isSpaceContainsOneComponent(componentIds, subspace.getShortId(), true)) continue;
                result.add(subspace);
            }
            return result;
        }
        catch (Exception e) {
            throw new AdminException("Admin.getSubSpacesOfUser", 4, "admin.EX_ERR_GET_USER_ALLOWED_SUBSPACES", "userId = " + userId + ", spaceId = " + spaceId, e);
        }
    }

    public List<SpaceInstLight> getSubSpaces(String spaceId) throws AdminException {
        SilverTrace.info("admin", "Admin.getSubSpaces", "root.MSG_GEN_ENTER_METHOD", "spaceId = " + spaceId);
        DomainDriverManager domainDriverManager = DomainDriverManagerFactory.getCurrentDomainDriverManager();
        return spaceManager.getSubSpaces(domainDriverManager, this.getDriverSpaceId(spaceId));
    }

    public List<ComponentInstLight> getAvailCompoInSpace(String userId, String spaceId) throws AdminException {
        SilverTrace.info("admin", "Admin.getAvailCompoInSpace", "root.MSG_GEN_ENTER_METHOD", "userId = " + userId + ", spaceId = " + spaceId);
        try {
            List<String> allowedComponentIds = this.getAllowedComponentIds(userId);
            ArrayList<ComponentInstLight> allowedComponents = new ArrayList<ComponentInstLight>();
            List<ComponentInstLight> allComponents = TreeCache.getComponentsInSpaceAndSubspaces(this.getDriverSpaceId(spaceId));
            for (ComponentInstLight component : allComponents) {
                if (!allowedComponentIds.contains(component.getId())) continue;
                allowedComponents.add(component);
            }
            return allowedComponents;
        }
        catch (Exception e) {
            throw new AdminException("Admin.getAvailCompoInSpace", 4, "admin.EX_ERR_GET_USER_ALLOWED_COMPONENTS", "userId = " + userId + ", spaceId = " + spaceId, e);
        }
    }

    public Map<String, SpaceAndChildren> getTreeView(String userId, String spaceId) throws AdminException {
        SilverTrace.info("admin", "Admin.getTreeView", "root.MSG_GEN_ENTER_METHOD", "userId = " + userId + ", spaceId = " + spaceId);
        spaceId = this.getDriverSpaceId(spaceId);
        List<SpaceInstLight> spacesLight = this.getSubSpacesOfUser(userId, spaceId);
        List<ComponentInstLight> componentsLight = this.getAvailCompoInSpace(userId, spaceId);
        SilverTrace.info("admin", "Admin.getTreeView", PARAM_MSG_KEY, "SQL Queries done !");
        HashMap<String, SpaceAndChildren> spaceTrees = new HashMap<String, SpaceAndChildren>();
        for (SpaceInstLight space : spacesLight) {
            spaceTrees.put(space.getFullId(), new SpaceAndChildren(space));
        }
        SpaceInstLight rootSpace = this.getSpaceInstLight(spaceId);
        spaceTrees.put(rootSpace.getFullId(), new SpaceAndChildren(rootSpace));
        for (SpaceInstLight child : spacesLight) {
            String fatherId = SPACE_KEY_PREFIX + child.getFatherId();
            SpaceAndChildren father = (SpaceAndChildren)spaceTrees.get(fatherId);
            if (father == null) continue;
            father.addSubSpace(child);
        }
        for (ComponentInstLight child : componentsLight) {
            String fatherId = SPACE_KEY_PREFIX + child.getDomainFatherId();
            SpaceAndChildren father = (SpaceAndChildren)spaceTrees.get(fatherId);
            if (father == null) continue;
            father.addComponent(child);
        }
        SilverTrace.info("admin", "Admin.getTreeView", "root.MSG_GEN_EXIT_METHOD", "userId = " + userId + ", spaceId = " + spaceId);
        return spaceTrees;
    }

    public List<SpaceInstLight> getUserSpaceTreeview(String userId) throws Exception {
        SilverTrace.info("admin", "Admin.getUserSpaceTreeview", "root.MSG_GEN_ENTER_METHOD", "user id = " + userId);
        HashSet<String> componentsId = new HashSet<String>(Arrays.asList(this.getAvailCompoIds(userId)));
        HashSet<String> authorizedIds = new HashSet<String>(100);
        if (!componentsId.isEmpty()) {
            String componentId = (String)componentsId.iterator().next();
            componentsId.remove(componentId);
            this.filterSpaceFromComponents(authorizedIds, componentsId, componentId);
        }
        String[] rootSpaceIds = this.getAllRootSpaceIds(userId);
        ArrayList<SpaceInstLight> treeview = new ArrayList<SpaceInstLight>(authorizedIds.size());
        for (String spaceId : rootSpaceIds) {
            String currentSpaceId = this.getDriverSpaceId(spaceId);
            if (!authorizedIds.contains(currentSpaceId)) continue;
            treeview.add(TreeCache.getSpaceInstLight(currentSpaceId));
            this.addAuthorizedSpaceToTree(treeview, authorizedIds, currentSpaceId, 1);
        }
        return treeview;
    }

    void addAuthorizedSpaceToTree(List<SpaceInstLight> treeview, Set<String> authorizedIds, String spaceId, int level) {
        SilverTrace.debug("admin", "Admin.addAuthorizedSpaceToTree", "root.MSG_GEN_ENTER_METHOD", "size of treeview = " + treeview.size());
        List<SpaceInstLight> subSpaces = TreeCache.getSubSpaces(spaceId);
        for (SpaceInstLight space : subSpaces) {
            String subSpaceId = this.getDriverSpaceId(space.getFullId());
            if (!authorizedIds.contains(subSpaceId)) continue;
            space.setLevel(level);
            treeview.add(space);
            this.addAuthorizedSpaceToTree(treeview, authorizedIds, subSpaceId, level + 1);
        }
    }

    void addAuthorizedSpace(Set<String> spaces, Set<String> componentsId, SpaceInstLight space) {
        SilverTrace.debug("admin", "Admin.addAuthorizedSpace", "root.MSG_GEN_ENTER_METHOD", "#componentIds = " + componentsId.size());
        if (space != null && !"R".equals(space.getStatus()) && !spaces.contains(space.getShortId())) {
            String fatherId;
            SilverTrace.debug("admin", "Admin.addAuthorizedSpace", PARAM_MSG_KEY, "space = " + space.getFullId());
            String spaceId = this.getDriverSpaceId(space.getFullId());
            spaces.add(spaceId);
            componentsId.removeAll(TreeCache.getComponentIds(spaceId));
            if (!space.isRoot() && !spaces.contains(fatherId = this.getDriverSpaceId(space.getFatherId()))) {
                SpaceInstLight parent = TreeCache.getSpaceInstLight(fatherId);
                this.addAuthorizedSpace(spaces, componentsId, parent);
            }
        }
    }

    void filterSpaceFromComponents(Set<String> spaces, Set<String> componentsId, String componentId) {
        SilverTrace.debug("admin", "Admin.filterSpaceFromComponents", "root.MSG_GEN_ENTER_METHOD", "#componentIds = " + componentsId.size() + ", componentId = " + componentId);
        SpaceInstLight space = TreeCache.getSpaceContainingComponent(componentId);
        this.addAuthorizedSpace(spaces, componentsId, space);
        if (!componentsId.isEmpty()) {
            String newComponentId = componentsId.iterator().next();
            componentsId.remove(newComponentId);
            this.filterSpaceFromComponents(spaces, componentsId, newComponentId);
        }
    }

    public SpaceWithSubSpacesAndComponents getAllowedFullTreeview(String userId) throws AdminException {
        SpaceWithSubSpacesAndComponents root = new SpaceWithSubSpacesAndComponents(new SpaceInstLight());
        List<String> componentIds = this.getAllowedComponentIds(userId);
        String[] spaceIds = this.getUserRootSpaceIds(componentIds);
        ArrayList<SpaceWithSubSpacesAndComponents> spaces = new ArrayList<SpaceWithSubSpacesAndComponents>();
        for (String spaceId : spaceIds) {
            SpaceWithSubSpacesAndComponents space = this.getAllowedTreeview(componentIds, spaceId);
            spaces.add(space);
        }
        root.setSubSpaces(spaces);
        return root;
    }

    private SpaceWithSubSpacesAndComponents getAllowedTreeview(List<String> componentIds, String spaceId) throws AdminException {
        SpaceInstLight spaceInst = this.getSpaceInstLight(spaceId);
        SpaceWithSubSpacesAndComponents space = new SpaceWithSubSpacesAndComponents(spaceInst);
        ArrayList<SpaceWithSubSpacesAndComponents> subSpaces = new ArrayList<SpaceWithSubSpacesAndComponents>();
        for (String subSpaceId : this.getUserSubSpaceIds(componentIds, spaceId)) {
            subSpaces.add(this.getAllowedTreeview(componentIds, subSpaceId));
        }
        space.setSubSpaces(subSpaces);
        ArrayList<ComponentInstLight> allowedComponents = new ArrayList<ComponentInstLight>();
        List<ComponentInstLight> allComponents = TreeCache.getComponents(this.getDriverSpaceId(spaceId));
        for (ComponentInstLight component : allComponents) {
            if (!componentIds.contains(component.getId())) continue;
            allowedComponents.add(component);
        }
        space.setComponents(allowedComponents);
        return space;
    }

    public String[] getAllowedSubSpaceIds(String userId, String spaceFatherId) throws AdminException {
        return this.getUserSubSpaceIds(userId, spaceFatherId);
    }

    private SpaceInstLight getSpaceInstLight(String spaceId) throws AdminException {
        SilverTrace.info("admin", "Admin.getSpaceInstLight", "root.MSG_GEN_ENTER_METHOD", "spaceId = " + spaceId);
        return this.getSpaceInstLight(this.getDriverSpaceId(spaceId), -1);
    }

    private SpaceInstLight getSpaceInstLight(String spaceId, int level) throws AdminException {
        SilverTrace.info("admin", "Admin.getSpaceInstLight", "root.MSG_GEN_ENTER_METHOD", "spaceId = " + spaceId + ", level = " + level);
        SpaceInstLight sil = TreeCache.getSpaceInstLight(spaceId);
        DomainDriverManager domainDriverManager = DomainDriverManagerFactory.getCurrentDomainDriverManager();
        if (sil == null) {
            sil = spaceManager.getSpaceInstLightById(domainDriverManager, spaceId);
        }
        if (sil != null) {
            if (level != -1) {
                sil.setLevel(level);
            }
            if (sil.getLevel() == -1) {
                sil.setLevel(TreeCache.getSpaceLevel(spaceId));
            }
        }
        return sil;
    }

    public SpaceInstLight getSpaceInstLightById(String sClientSpaceId) throws AdminException {
        try {
            return this.getSpaceInstLight(this.getDriverSpaceId(sClientSpaceId));
        }
        catch (Exception e) {
            throw new AdminException("Admin.getSpaceInstLightById", 4, "admin.EX_ERR_GET_SPACE", " space Id : '" + sClientSpaceId + "'", e);
        }
    }

    public SpaceInstLight getRootSpace(String spaceId) throws AdminException {
        SpaceInstLight sil = this.getSpaceInstLight(this.getDriverSpaceId(spaceId));
        while (sil != null && !sil.isRoot()) {
            sil = this.getSpaceInstLight(sil.getFatherId());
        }
        return sil;
    }

    public String[] getGroupManageableSpaceIds(String sGroupId) throws AdminException {
        ArrayList<String> alManageableSpaceIds = new ArrayList<String>();
        DomainDriverManager domainDriverManager = DomainDriverManagerFactory.getCurrentDomainDriverManager();
        try {
            String[] asManageableSpaceIds;
            ArrayList<String> groupIds = new ArrayList<String>();
            groupIds.add(sGroupId);
            List<String> manageableSpaceIds = spaceManager.getManageableSpaceIds(null, groupIds);
            for (String asManageableSpaceId : asManageableSpaceIds = manageableSpaceIds.toArray(new String[manageableSpaceIds.size()])) {
                String[] childSpaceIds;
                if (!alManageableSpaceIds.contains(asManageableSpaceId)) {
                    alManageableSpaceIds.add(asManageableSpaceId);
                }
                for (String childSpaceId : childSpaceIds = spaceManager.getAllSubSpaceIds(domainDriverManager, asManageableSpaceId)) {
                    if (alManageableSpaceIds.contains(childSpaceId)) continue;
                    alManageableSpaceIds.add(childSpaceId);
                }
            }
            asManageableSpaceIds = alManageableSpaceIds.toArray(new String[alManageableSpaceIds.size()]);
            return asManageableSpaceIds;
        }
        catch (Exception e) {
            throw new AdminException("Admin.getGroupManageableSpaceIds", 4, "admin.EX_ERR_GET_USER_MANAGEABLE_SPACE_IDS", "group Id : '" + sGroupId + "'", e);
        }
    }

    public String[] getUserManageableSpaceIds(String sUserId) throws AdminException {
        ArrayList<String> alManageableSpaceIds = new ArrayList<String>();
        DomainDriverManager domainDriverManager = DomainDriverManagerFactory.getCurrentDomainDriverManager();
        try {
            String[] asManageableSpaceIds = cache.getManageableSpaceIds(sUserId);
            if (asManageableSpaceIds == null) {
                List<String> groupIds = this.getAllGroupsOfUser(sUserId);
                for (String asManageableSpaceId : asManageableSpaceIds = this.userManager.getManageableSpaceIds(sUserId, groupIds)) {
                    String[] childSpaceIds;
                    if (!alManageableSpaceIds.contains(asManageableSpaceId)) {
                        alManageableSpaceIds.add(asManageableSpaceId);
                    }
                    for (String childSpaceId : childSpaceIds = spaceManager.getAllSubSpaceIds(domainDriverManager, asManageableSpaceId)) {
                        if (alManageableSpaceIds.contains(childSpaceId)) continue;
                        alManageableSpaceIds.add(childSpaceId);
                    }
                }
                asManageableSpaceIds = alManageableSpaceIds.toArray(new String[alManageableSpaceIds.size()]);
                cache.putManageableSpaceIds(sUserId, asManageableSpaceIds);
            }
            return asManageableSpaceIds;
        }
        catch (Exception e) {
            throw new AdminException("Admin.getUserManageableSpaceIds", 4, "admin.EX_ERR_GET_USER_MANAGEABLE_SPACE_IDS", "user Id : '" + sUserId + "'", e);
        }
    }

    public String[] getUserManageableSpaceRootIds(String sUserId) throws AdminException {
        try {
            List<String> groupIds = this.getAllGroupsOfUser(sUserId);
            String[] asManageableSpaceIds = this.userManager.getManageableSpaceIds(sUserId, groupIds);
            ArrayList<String> manageableRootSpaceIds = new ArrayList<String>();
            for (String asManageableSpaceId : asManageableSpaceIds) {
                SpaceInstLight space = TreeCache.getSpaceInstLight(asManageableSpaceId);
                if (space == null || !space.isRoot()) continue;
                manageableRootSpaceIds.add(asManageableSpaceId);
            }
            return manageableRootSpaceIds.toArray(new String[manageableRootSpaceIds.size()]);
        }
        catch (Exception e) {
            throw new AdminException("Admin.getUserManageableSpaceRootIds", 4, "admin.EX_ERR_GET_USER_MANAGEABLE_SPACE_IDS", "user Id : '" + sUserId + "'", e);
        }
    }

    public String[] getUserManageableSubSpaceIds(String sUserId, String sParentSpaceId) throws AdminException {
        try {
            List<String> groupIds = this.getAllGroupsOfUser(sUserId);
            String[] asManageableSpaceIds = this.userManager.getManageableSpaceIds(sUserId, groupIds);
            String parentSpaceId = this.getDriverSpaceId(sParentSpaceId);
            ArrayList<String> manageableRootSpaceIds = new ArrayList<String>();
            for (String manageableSpaceId : asManageableSpaceIds) {
                boolean find = false;
                SpaceInstLight space = TreeCache.getSpaceInstLight(manageableSpaceId);
                while (space != null && !space.isRoot() && !find) {
                    if (parentSpaceId.equals(space.getFatherId())) {
                        manageableRootSpaceIds.add(manageableSpaceId);
                        find = true;
                        continue;
                    }
                    space = TreeCache.getSpaceInstLight(space.getFatherId());
                }
            }
            return manageableRootSpaceIds.toArray(new String[manageableRootSpaceIds.size()]);
        }
        catch (Exception e) {
            throw new AdminException("Admin.getManageableSubSpaceIds", 4, "admin.EX_ERR_GET_USER_MANAGEABLE_SPACE_IDS", "user Id : '" + sUserId + "' Space = " + sParentSpaceId, e);
        }
    }

    public SpaceProfile getSpaceProfile(String spaceId, SilverpeasRole role) throws AdminException {
        SpaceProfile spaceProfile = new SpaceProfile();
        SpaceInst space = this.getSpaceInstById(spaceId);
        SpaceProfileInst profile = space.getSpaceProfileInst(role.getName());
        if (profile != null) {
            spaceProfile.setProfile(profile);
        }
        if (role == SilverpeasRole.Manager) {
            boolean root = space.isRoot();
            String parentId = space.getDomainFatherId();
            while (!root) {
                SpaceInst parent = this.getSpaceInstById(parentId);
                SpaceProfileInst parentProfile = parent.getSpaceProfileInst(role.getName());
                spaceProfile.addInheritedProfile(parentProfile);
                root = parent.isRoot();
                parentId = parent.getDomainFatherId();
            }
        } else {
            spaceProfile.addInheritedProfile(space.getInheritedSpaceProfileInst(role.getName()));
        }
        return spaceProfile;
    }

    public List<String> getUserManageableGroupIds(String sUserId) throws AdminException {
        try {
            List<String> groupIds = this.getAllGroupsOfUser(sUserId);
            return this.groupManager.getManageableGroupIds(sUserId, groupIds);
        }
        catch (Exception e) {
            throw new AdminException("Admin.getUserManageableGroupIds", 4, "admin.EX_ERR_GET_USER_MANAGEABLE_GROUP_IDS", "userId + " + sUserId, e);
        }
    }

    public String[] getAvailCompoIds(String sClientSpaceId, String sUserId) throws AdminException {
        try {
            String spaceId = this.getDriverSpaceId(sClientSpaceId);
            String[] asAvailCompoIds = cache.getAvailCompoIds(spaceId, sUserId);
            if (asAvailCompoIds == null) {
                List<ComponentInstLight> components = this.getAvailCompoInSpace(sUserId, sClientSpaceId);
                ArrayList<String> componentIds = new ArrayList<String>();
                for (ComponentInstLight component : components) {
                    componentIds.add(component.getId());
                }
                asAvailCompoIds = componentIds.toArray(new String[componentIds.size()]);
                cache.putAvailCompoIds(spaceId, sUserId, asAvailCompoIds);
            }
            return asAvailCompoIds;
        }
        catch (Exception e) {
            throw new AdminException("Admin.getAvailCompoIds", 4, "admin.EX_ERR_GET_USER_AVAILABLE_COMPONENT_IDS", "user Id : '" + sUserId + "'", e);
        }
    }

    public boolean isAnAdminTool(String toolId) {
        return ADMIN_COMPONENT_ID.equals(toolId);
    }

    public boolean isComponentAvailable(String componentId, String userId) throws AdminException {
        try {
            return this.getAllowedComponentIds(userId).contains(componentId);
        }
        catch (Exception e) {
            throw new AdminException("Admin.isComponentAvailable", 4, "admin.EX_ERR_IS_COMPONENT_AVAILABLE", "user Id : '" + userId + "'" + " , component Id : '" + componentId + "'", e);
        }
    }

    public boolean isComponentManageable(String componentId, String userId) throws AdminException {
        boolean manageable = this.getUserDetail(userId).isAccessAdmin();
        if (!manageable) {
            List<String> toCheck = Arrays.asList(this.getUserManageableSpaceIds(userId));
            List<SpaceInstLight> path = this.getPathToComponent(componentId);
            for (SpaceInstLight space : path) {
                if (!toCheck.contains(space.getShortId())) continue;
                manageable = true;
                break;
            }
        }
        return manageable;
    }

    private boolean isSpaceManageable(String spaceId, String userId) throws AdminException {
        boolean manageable = this.getUserDetail(userId).isAccessAdmin();
        if (!manageable) {
            List<String> toCheck = Arrays.asList(this.getUserManageableSpaceIds(userId));
            List<SpaceInstLight> path = this.getPathToSpace(spaceId, true);
            for (SpaceInstLight space : path) {
                if (!toCheck.contains(space.getShortId())) continue;
                manageable = true;
                break;
            }
        }
        return manageable;
    }

    public String[] getAvailCompoIdsAtRoot(String sClientSpaceId, String sUserId) throws AdminException {
        try {
            String spaceId = this.getDriverSpaceId(sClientSpaceId);
            List<String> groupIds = this.getAllGroupsOfUser(sUserId);
            List<String> asAvailCompoIds = componentManager.getAllowedComponentIds(Integer.parseInt(sUserId), groupIds, spaceId);
            return asAvailCompoIds.toArray(new String[asAvailCompoIds.size()]);
        }
        catch (Exception e) {
            throw new AdminException("Admin.getAvailCompoIds", 4, "admin.EX_ERR_GET_USER_AVAILABLE_COMPONENT_IDS", "user Id : '" + sUserId + "'", e);
        }
    }

    public List<String> getAvailCompoIdsAtRoot(String sClientSpaceId, String sUserId, String componentNameRoot) throws AdminException {
        try {
            String spaceId = this.getDriverSpaceId(sClientSpaceId);
            List<ComponentInstLight> components = TreeCache.getComponents(spaceId);
            List<String> allowedComponentIds = this.getAllowedComponentIds(sUserId);
            ArrayList<String> result = new ArrayList<String>();
            for (ComponentInstLight component : components) {
                if (!allowedComponentIds.contains(component.getId()) || !component.getName().startsWith(componentNameRoot)) continue;
                result.add(component.getId());
            }
            return result;
        }
        catch (Exception e) {
            throw new AdminException("Admin.getAvailCompoIdsAtRoot", 4, "admin.EX_ERR_GET_USER_AVAILABLE_COMPONENT_IDS", "user Id : '" + sUserId + "'", e);
        }
    }

    public String[] getAvailCompoIds(String userId) throws AdminException {
        try {
            List<String> componentIds = this.getAllowedComponentIds(userId);
            return componentIds.toArray(new String[componentIds.size()]);
        }
        catch (Exception e) {
            throw new AdminException("Admin.getAvailCompoIds", 4, "admin.EX_ERR_GET_USER_AVAILABLE_COMPONENT_IDS", "user Id : '" + userId + "'", e);
        }
    }

    public String[] getAvailDriverCompoIds(String sClientSpaceId, String sUserId) throws AdminException {
        try {
            List<ComponentInstLight> components = this.getAvailCompoInSpace(sUserId, sClientSpaceId);
            ArrayList<String> componentIds = new ArrayList<String>();
            for (ComponentInstLight component : components) {
                componentIds.add(component.getId());
            }
            return componentIds.toArray(new String[componentIds.size()]);
        }
        catch (Exception e) {
            throw new AdminException("Admin.getAvailDriverCompoIds", 4, "admin.EX_ERR_GET_USER_AVAILABLE_COMPONENT_IDS", "user Id : '" + sUserId + "'", e);
        }
    }

    public String[] getComponentIdsByNameAndUserId(String sUserId, String sComponentName) throws AdminException {
        List<String> allowedComponentIds = this.getAllowedComponentIds(sUserId, sComponentName);
        return allowedComponentIds.toArray(new String[allowedComponentIds.size()]);
    }

    public List<ComponentInstLight> getAvailComponentInstLights(String userId, String componentName) throws AdminException {
        ArrayList<ComponentInstLight> components = new ArrayList<ComponentInstLight>();
        List<String> allowedComponentIds = this.getAllowedComponentIds(userId, componentName);
        for (String allowedComponentId : allowedComponentIds) {
            ComponentInstLight componentInst = this.getComponentInstLight(allowedComponentId);
            if (!componentInst.getName().equalsIgnoreCase(componentName)) continue;
            components.add(componentInst);
        }
        return components;
    }

    public List<SpaceInstLight> getRootSpacesContainingComponent(String userId, String componentName) throws AdminException {
        ArrayList<SpaceInstLight> spaces = new ArrayList<SpaceInstLight>();
        List<ComponentInstLight> components = this.getAvailComponentInstLights(userId, componentName);
        for (ComponentInstLight component : components) {
            SpaceInstLight root;
            List<SpaceInstLight> path = TreeCache.getComponentPath(component.getId());
            if (path == null || path.isEmpty() || spaces.contains(root = path.get(0))) continue;
            spaces.add(root);
        }
        return spaces;
    }

    public List<SpaceInstLight> getSubSpacesContainingComponent(String spaceId, String userId, String componentName) throws AdminException {
        ArrayList<SpaceInstLight> spaces = new ArrayList<SpaceInstLight>();
        spaceId = this.getDriverSpaceId(spaceId);
        List<ComponentInstLight> components = this.getAvailComponentInstLights(userId, componentName);
        for (ComponentInstLight component : components) {
            List<SpaceInstLight> path = TreeCache.getComponentPath(component.getId());
            for (SpaceInstLight space : path) {
                if (!space.getFatherId().equals(spaceId) || spaces.contains(space)) continue;
                spaces.add(space);
            }
        }
        return spaces;
    }

    public CompoSpace[] getCompoForUser(String sUserId, String sComponentName) throws AdminException {
        ArrayList<CompoSpace> alCompoSpace = new ArrayList<CompoSpace>();
        try {
            List<ComponentInstLight> components = this.getAvailComponentInstLights(sUserId, sComponentName);
            for (ComponentInstLight componentInst : components) {
                CompoSpace compoSpace = new CompoSpace();
                compoSpace.setComponentId(componentInst.getId());
                if (StringUtil.isDefined(componentInst.getLabel())) {
                    compoSpace.setComponentLabel(componentInst.getLabel());
                } else {
                    compoSpace.setComponentLabel(componentInst.getName());
                }
                compoSpace.setSpaceId(this.getClientSpaceId(componentInst.getDomainFatherId()));
                SpaceInstLight spaceInst = this.getSpaceInstLightById(componentInst.getDomainFatherId());
                compoSpace.setSpaceLabel(spaceInst.getName());
                alCompoSpace.add(compoSpace);
            }
            return alCompoSpace.toArray(new CompoSpace[alCompoSpace.size()]);
        }
        catch (Exception e) {
            throw new AdminException("Admin.getCompoForUser", 4, "admin.EX_ERR_GET_USER_AVAILABLE_INSTANCES_OF_COMPONENT", "user Id : '" + sUserId + "', component name: '" + sComponentName + "'", e);
        }
    }

    public String[] getCompoId(String sComponentName) throws AdminException {
        DomainDriverManager domainDriverManager = DomainDriverManagerFactory.getCurrentDomainDriverManager();
        try {
            String[] matchingComponentIds = componentManager.getAllCompoIdsByComponentName(domainDriverManager, sComponentName);
            ArrayList<String> shortIds = new ArrayList<String>();
            for (String componentId : matchingComponentIds) {
                ComponentInstLight component = TreeCache.getComponent(sComponentName + componentId);
                if (component == null) continue;
                shortIds.add(componentId);
            }
            return shortIds.toArray(new String[shortIds.size()]);
        }
        catch (Exception e) {
            throw new AdminException("Admin.getCompoId", 4, "admin.EX_ERR_GET_AVAILABLE_INSTANCES_OF_COMPONENT", "component name: '" + sComponentName + "'", e);
        }
    }

    public String[] getProfileIds(String sUserId) throws AdminException {
        try {
            String[] asProfilesIds = cache.getProfileIds(sUserId);
            if (asProfilesIds == null && (asProfilesIds = profileManager.getProfileIdsOfUser(sUserId, this.getAllGroupsOfUser(sUserId))) != null) {
                cache.putProfileIds(sUserId, asProfilesIds);
            }
            return asProfilesIds;
        }
        catch (Exception e) {
            throw new AdminException("Admin.getProfileIds", 4, "admin.EX_ERR_GET_USER_PROFILES", "user Id : '" + sUserId + "'", e);
        }
    }

    public String[] getProfileIdsOfGroup(String sGroupId) throws AdminException {
        return this.getDirectComponentProfileIdsOfGroup(sGroupId);
    }

    public String[] getCurrentProfiles(String sUserId, ComponentInst componentInst) {
        ArrayList<String> alProfiles = new ArrayList<String>();
        try {
            String[] asProfileIds;
            for (String asProfileId : asProfileIds = this.getProfileIds(sUserId)) {
                for (int nJ = 0; nJ < componentInst.getNumProfileInst(); ++nJ) {
                    if (!componentInst.getProfileInst(nJ).getId().equals(asProfileId)) continue;
                    alProfiles.add(componentInst.getProfileInst(nJ).getName());
                }
            }
            return this.arrayListToString(this.removeTuples(alProfiles));
        }
        catch (Exception e) {
            SilverTrace.error("admin", "Admin.getCurrentProfiles", "admin.MSG_ERR_GET_CURRENT_PROFILE", e);
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
    }

    public String[] getCurrentProfiles(String sUserId, String componentId) throws AdminException {
        return profileManager.getProfileNamesOfUser(sUserId, this.getAllGroupsOfUser(sUserId), Integer.parseInt(this.getDriverComponentId(componentId)));
    }

    public UserDetail[] getUsers(boolean bAllProfiles, String sProfile, String sClientSpaceId, String sClientComponentId) throws AdminException {
        ArrayList<String> alUserIds = new ArrayList<String>();
        try {
            ComponentInst componentInst = this.getComponentInst(this.getDriverComponentId(sClientComponentId), true, this.getDriverSpaceId(sClientSpaceId));
            for (ProfileInst profile : componentInst.getAllProfilesInst()) {
                if (profile == null || !profile.getName().equals(sProfile) && !bAllProfiles) continue;
                alUserIds.addAll(profile.getAllUsers());
                ArrayList<String> groupIds = profile.getAllGroups();
                for (String groupId : groupIds) {
                    UserDetail[] users;
                    List<String> subGroupIds = this.groupManager.getAllSubGroupIdsRecursively(groupId);
                    subGroupIds.add(groupId);
                    if (subGroupIds == null || subGroupIds.size() <= 0) continue;
                    for (UserDetail user : users = this.userManager.getAllUsersOfGroups(subGroupIds)) {
                        alUserIds.add(user.getId());
                    }
                }
            }
            this.removeTuples(alUserIds);
            UserDetail[] userDetails = new UserDetail[alUserIds.size()];
            for (int nI = 0; nI < userDetails.length; ++nI) {
                userDetails[nI] = this.getUserDetail(alUserIds.get(nI));
            }
            return userDetails;
        }
        catch (Exception e) {
            throw new AdminException("Admin.getUsers", 4, "admin.EX_ERR_GET_USERS_FOR_PROFILE_AND_COMPONENT", "profile : '" + sProfile + "', space Id: '" + sClientSpaceId + "' component Id: '" + sClientComponentId, e);
        }
    }

    public Group[] getAllSubGroups(String parentGroupId) throws AdminException {
        DomainDriverManager domainDriverManager = DomainDriverManagerFactory.getCurrentDomainDriverManager();
        String[] theIds = this.groupManager.getAllSubGroupIds(domainDriverManager, parentGroupId);
        return this.getGroups(theIds);
    }

    public UserDetail[] getFiltredDirectUsers(String sGroupId, String sUserLastNameFilter) throws AdminException {
        Group theGroup = this.getGroup(sGroupId);
        if (theGroup == null) {
            return ArrayUtil.EMPTY_USER_DETAIL_ARRAY;
        }
        String[] usersIds = theGroup.getUserIds();
        if (usersIds == null || usersIds.length <= 0) {
            return ArrayUtil.EMPTY_USER_DETAIL_ARRAY;
        }
        if (sUserLastNameFilter == null || sUserLastNameFilter.length() <= 0) {
            return this.getUserDetails(usersIds);
        }
        String upperFilter = sUserLastNameFilter.toUpperCase();
        ArrayList<UserDetail> matchedUsers = new ArrayList<UserDetail>();
        for (String usersId : usersIds) {
            UserDetail currentUser = this.getUserDetail(usersId);
            if (currentUser == null || !currentUser.getLastName().toUpperCase().startsWith(upperFilter)) continue;
            matchedUsers.add(currentUser);
        }
        return matchedUsers.toArray(new UserDetail[matchedUsers.size()]);
    }

    public int getAllSubUsersNumber(String sGroupId) throws AdminException {
        DomainDriverManager domainDriverManager = DomainDriverManagerFactory.getCurrentDomainDriverManager();
        if (!StringUtil.isDefined(sGroupId)) {
            return this.userManager.getUserNumber(domainDriverManager);
        }
        return this.groupManager.getTotalUserCountInGroup("", sGroupId);
    }

    public int getUsersNumberOfDomain(String domainId) throws AdminException {
        DomainDriverManager domainDriverManager = DomainDriverManagerFactory.getCurrentDomainDriverManager();
        try {
            if (!StringUtil.isDefined(domainId)) {
                return this.userManager.getUserNumber(domainDriverManager);
            }
            if ("-1".equals(domainId)) {
                return 0;
            }
            return this.userManager.getUsersNumberOfDomain(domainDriverManager, domainId);
        }
        catch (Exception e) {
            throw new AdminException("Admin.getUsersOfDomain", 4, "admin.EX_ERR_GET_DOMAIN", "domain Id : '" + domainId + "'", e);
        }
    }

    public String[] getAdministratorUserIds(String fromUserId) throws AdminException {
        DomainDriverManager domainDriverManager = DomainDriverManagerFactory.getCurrentDomainDriverManager();
        return this.userManager.getAllAdminIds(domainDriverManager, this.getUserDetail(fromUserId));
    }

    public String getAdministratorEmail() {
        return administratorMail;
    }

    public String getDAPIGeneralAdminId() {
        return "0";
    }

    public UserLog[] getUserConnected() {
        UserLog[] userLogs = new UserLog[loggedUsers.size()];
        int nI = 0;
        for (String user : loggedUsers.keySet()) {
            userLogs[nI++] = loggedUsers.get(user);
        }
        return userLogs;
    }

    private Connection openConnection(boolean bAutoCommit) throws AdminException {
        try {
            Connection connection = DBUtil.makeConnection(JNDINames.ADMIN_DATASOURCE);
            connection.setAutoCommit(bAutoCommit);
            return connection;
        }
        catch (Exception e) {
            throw new AdminException("Admin.openConnection", 5, "root.EX_CONNECTION_OPEN_FAILED", e);
        }
    }

    private String[] arrayListToString(ArrayList<String> al) {
        if (al == null) {
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        String[] as = new String[al.size()];
        for (int nI = 0; nI < al.size(); ++nI) {
            as[nI] = al.get(nI);
        }
        return as;
    }

    private ArrayList<String> removeTuples(ArrayList<String> al) {
        if (al == null) {
            return new ArrayList<String>();
        }
        for (int nI = 0; nI < al.size(); ++nI) {
            while (al.lastIndexOf(al.get(nI)) != al.indexOf(al.get(nI))) {
                al.remove(al.lastIndexOf(al.get(nI)));
            }
        }
        return al;
    }

    public String[] getAllSpaceIds(String sUserId) throws Exception {
        return this.getClientSpaceIds(this.getUserSpaceIds(sUserId));
    }

    public String[] getAllRootSpaceIds(String sUserId) throws Exception {
        return this.getClientSpaceIds(this.getUserRootSpaceIds(sUserId));
    }

    public String[] getAllSubSpaceIds(String sSpaceId, String sUserId) throws Exception {
        return this.getClientSpaceIds(this.getUserSubSpaceIds(sUserId, sSpaceId));
    }

    public String[] getAllComponentIds(String sSpaceId) throws Exception {
        ArrayList<String> alCompoIds = new ArrayList<String>();
        SpaceInst spaceInst = this.getSpaceInstById(sSpaceId);
        ArrayList<ComponentInst> alCompoInst = spaceInst.getAllComponentsInst();
        if (alCompoInst != null) {
            for (ComponentInst anAlCompoInst : alCompoInst) {
                alCompoIds.add(anAlCompoInst.getId());
            }
        }
        return alCompoIds.toArray(new String[alCompoIds.size()]);
    }

    public String[] getAllComponentIdsRecur(String sSpaceId) {
        List<ComponentInstLight> components = TreeCache.getComponentsInSpaceAndSubspaces(this.getDriverSpaceId(sSpaceId));
        ArrayList<String> componentIds = new ArrayList<String>();
        for (ComponentInstLight component : components) {
            componentIds.add(component.getId());
        }
        return componentIds.toArray(new String[componentIds.size()]);
    }

    public String[] getAllComponentIdsRecur(String sSpaceId, String sUserId, String componentNameRoot, boolean inCurrentSpace, boolean inAllSpaces) throws Exception {
        SilverTrace.info("admin", "Admin.getAllComponentIdsRecur", PARAM_MSG_KEY, "inCurrentSpace=" + inCurrentSpace + " inAllSpaces=" + inAllSpaces);
        ArrayList<String> alCompoIds = new ArrayList();
        if (inAllSpaces) {
            CompoSpace[] cs;
            for (CompoSpace c : cs = this.getCompoForUser(sUserId, componentNameRoot)) {
                alCompoIds.add(c.getComponentId());
            }
        } else {
            alCompoIds = this.getAllComponentIdsRecur(sSpaceId, sUserId, componentNameRoot, inCurrentSpace);
        }
        return this.arrayListToString(alCompoIds);
    }

    private ArrayList<String> getAllComponentIdsRecur(String sSpaceId, String sUserId, String componentNameRoot, boolean inCurrentSpace) throws Exception {
        String[] componentIds;
        ArrayList<String> alCompoIds = new ArrayList<String>();
        this.getComponentIdsByNameAndUserId(sUserId, componentNameRoot);
        if (inCurrentSpace && (componentIds = this.getAvailCompoIdsAtRoot(sSpaceId, sUserId)) != null) {
            for (String componentId : componentIds) {
                ComponentInstLight compo = this.getComponentInstLight(componentId);
                if (!compo.getName().equals(componentNameRoot)) continue;
                alCompoIds.add(compo.getId());
            }
        }
        String[] asSubSpaceIds = this.getAllSubSpaceIds(sSpaceId);
        for (int nI = 0; asSubSpaceIds != null && nI < asSubSpaceIds.length; ++nI) {
            SilverTrace.info("admin", "Admin.getAllComponentIdsRecur", "root.MSG_GEN_PARAM.VALUE", "Sub spaceId=" + asSubSpaceIds[nI]);
            SpaceInst spaceInst = this.getSpaceInstById(asSubSpaceIds[nI]);
            String[] componentIds2 = this.getAvailCompoIds(spaceInst.getId(), sUserId);
            if (componentIds2 == null) continue;
            for (String componentId : componentIds2) {
                ComponentInstLight compo = this.getComponentInstLight(componentId);
                if (!compo.getName().equals(componentNameRoot)) continue;
                SilverTrace.info("admin", "Admin.getAllComponentIdsRecur", "root.MSG_GEN_PARAM.VALUE", "componentId in subspace=" + compo.getId());
                alCompoIds.add(compo.getId());
            }
        }
        return alCompoIds;
    }

    public void synchronizeGroupByRule(String groupId, boolean scheduledMode) throws AdminException {
        SilverTrace.info("admin", "Admin.synchronizeGroup", "root.MSG_GEN_ENTER_METHOD", "groupId = " + groupId);
        Group group = this.getGroup(groupId);
        String rule = group.getRule();
        DomainDriverManager domainDriverManager = DomainDriverManagerFactory.getCurrentDomainDriverManager();
        if (StringUtil.isDefined(rule)) {
            try {
                if (!scheduledMode) {
                    SynchroGroupReport.setTraceLevel(1);
                    SynchroGroupReport.startSynchro();
                }
                SynchroGroupReport.warn("admin.synchronizeGroup", "Synchronisation du groupe '" + group.getName() + "' - Regle de synchronisation = \"" + rule + "\"", null);
                List<String> actualUserIds = Arrays.asList(group.getUserIds());
                domainDriverManager.startTransaction(false);
                List<String> userIds = GroupSynchronizationRule.from(group).getUserIds();
                ArrayList<String> newUsers = new ArrayList<String>();
                if (userIds != null) {
                    for (String userId : userIds) {
                        if (actualUserIds.contains(userId)) continue;
                        newUsers.add(userId);
                        SynchroGroupReport.info("admin.synchronizeGroup", "Ajout de l'utilisateur " + userId, null);
                    }
                }
                SynchroGroupReport.warn("admin.synchronizeGroup", "Ajout de " + newUsers.size() + " utilisateur(s)", null);
                if (!newUsers.isEmpty()) {
                    domainDriverManager.getOrganization().group.addUsersInGroup(newUsers.toArray(new String[newUsers.size()]), Integer.parseInt(groupId), false);
                }
                ArrayList<String> removedUsers = new ArrayList<String>();
                for (String actualUserId : actualUserIds) {
                    if (userIds != null && userIds.contains(actualUserId)) continue;
                    removedUsers.add(actualUserId);
                    SynchroGroupReport.info("admin.synchronizeGroup", "Suppression de l'utilisateur " + actualUserId, null);
                }
                SynchroGroupReport.warn("admin.synchronizeGroup", "Suppression de " + removedUsers.size() + " utilisateur(s)", null);
                if (removedUsers.size() > 0) {
                    domainDriverManager.getOrganization().group.removeUsersFromGroup(removedUsers.toArray(new String[removedUsers.size()]), Integer.parseInt(groupId), false);
                }
                domainDriverManager.commit();
            }
            catch (Exception e) {
                try {
                    domainDriverManager.rollback();
                }
                catch (Exception e1) {
                    SilverTrace.error("admin", "Admin.synchronizeGroup", "root.EX_ERR_ROLLBACK", e1);
                }
                SynchroGroupReport.error("admin.synchronizeGroup", "Error during the processing of synchronization rule of group '" + groupId + "': " + e.getMessage(), null);
                throw new AdminException("Admin.synchronizeGroup", 4, "admin.MSG_ERR_SYNCHRONIZE_GROUP", "groupId : '" + groupId + "'", e);
            }
            finally {
                if (!scheduledMode) {
                    SynchroGroupReport.stopSynchro();
                }
                domainDriverManager.releaseOrganizationSchema();
            }
        }
    }

    private List<String> translateGroupIds(String sDomainId, String[] groupSpecificIds, boolean recursGroups) throws Exception {
        ArrayList<String> convertedGroupIds = new ArrayList<String>();
        DomainDriverManager domainDriverManager = DomainDriverManagerFactory.getCurrentDomainDriverManager();
        for (String groupSpecificId : groupSpecificIds) {
            String groupId;
            block5: {
                try {
                    groupId = this.groupManager.getGroupIdBySpecificIdAndDomainId(domainDriverManager, groupSpecificId, sDomainId);
                }
                catch (AdminException e) {
                    groupId = null;
                    SilverTrace.warn("admin", "Admin.translateGroupIds", "admin.EX_ERR_GROUP_NOT_FOUND", "SpecId=" + groupSpecificId, e);
                    if (!recursGroups) break block5;
                    try {
                        groupId = this.synchronizeImportGroup(sDomainId, groupSpecificId, null, true, true);
                    }
                    catch (AdminException ex) {
                        SilverTrace.warn("admin", "Admin.translateGroupIds", "admin.MSG_ERR_SYNCHRONIZE_GROUP", "SpecId=" + groupSpecificId, ex);
                        groupId = null;
                    }
                }
            }
            if (groupId == null) continue;
            convertedGroupIds.add(groupId);
        }
        return convertedGroupIds;
    }

    private String[] translateUserIds(String sDomainId, String[] userSpecificIds) throws Exception {
        ArrayList<String> convertedUserIds = new ArrayList<String>();
        DomainDriverManager domainDriverManager = DomainDriverManagerFactory.getCurrentDomainDriverManager();
        for (String userSpecificId : userSpecificIds) {
            String userId;
            try {
                userId = this.userManager.getUserIdBySpecificIdAndDomainId(domainDriverManager, userSpecificId, sDomainId);
            }
            catch (AdminException e) {
                SilverTrace.warn("admin", "Admin.translateUserIds", "admin.EX_ERR_USER_NOT_FOUND", "SpecId=" + userSpecificId, e);
                try {
                    userId = this.synchronizeImportUser(sDomainId, userSpecificId, false);
                }
                catch (AdminException ex) {
                    SilverTrace.warn("admin", "Admin.translateUserIds", "admin.MSG_ERR_SYNCHRONIZE_USER", "SpecId=" + userSpecificId, ex);
                    userId = null;
                }
            }
            if (userId == null) continue;
            convertedUserIds.add(userId);
        }
        return convertedUserIds.toArray(new String[convertedUserIds.size()]);
    }

    public String synchronizeGroup(String groupId, boolean recurs) throws Exception {
        SilverTrace.info("admin", "admin.synchronizeGroup", "root.MSG_GEN_ENTER_METHOD", "GroupId=" + groupId);
        Group theGroup = this.getGroup(groupId);
        DomainDriverManager domainDriverManager = DomainDriverManagerFactory.getCurrentDomainDriverManager();
        if (theGroup.isSynchronized()) {
            this.synchronizeGroupByRule(groupId, false);
        } else {
            DomainDriver synchroDomain = domainDriverManager.getDomainDriver(Integer.parseInt(theGroup.getDomainId()));
            Group gr = synchroDomain.synchroGroup(theGroup.getSpecificId());
            gr.setId(groupId);
            gr.setDomainId(theGroup.getDomainId());
            gr.setSuperGroupId(theGroup.getSuperGroupId());
            this.internalSynchronizeGroup(synchroDomain, gr, recurs);
        }
        return groupId;
    }

    public String synchronizeImportGroup(String domainId, String groupKey, String askedParentId, boolean recurs, boolean isIdKey) throws Exception {
        SilverTrace.info("admin", "admin.synchronizeImportGroup", "root.MSG_GEN_ENTER_METHOD", "groupKey=" + groupKey);
        DomainDriverManager domainDriverManager = DomainDriverManagerFactory.getCurrentDomainDriverManager();
        DomainDriver synchroDomain = domainDriverManager.getDomainDriver(Integer.parseInt(domainId));
        Group gr = isIdKey ? synchroDomain.synchroGroup(groupKey) : synchroDomain.importGroup(groupKey);
        gr.setDomainId(domainId);
        String[] parentSpecificIds = synchroDomain.getGroupMemberGroupIds(gr.getSpecificId());
        String parentId = null;
        for (int i = 0; i < parentSpecificIds.length && parentId == null; ++i) {
            try {
                parentId = this.groupManager.getGroupIdBySpecificIdAndDomainId(domainDriverManager, parentSpecificIds[i], domainId);
                if (askedParentId == null || askedParentId.isEmpty() || askedParentId.equals(parentId)) continue;
                parentId = null;
                continue;
            }
            catch (AdminException e) {
                parentId = null;
            }
        }
        if (parentId == null && (parentSpecificIds.length > 0 || askedParentId != null && askedParentId.length() > 0)) {
            throw new AdminException("Admin.synchronizeImportGroup", 4, "admin.EX_ERR_GROUP_PARENT_NOT_PRESENT", "group name : '" + groupKey + "'");
        }
        gr.setSuperGroupId(parentId);
        String[] specificIds = gr.getUserIds();
        gr.setUserIds(ArrayUtil.EMPTY_STRING_ARRAY);
        String groupId = this.addGroup(gr, true);
        gr.setId(groupId);
        gr.setUserIds(specificIds);
        this.internalSynchronizeGroup(synchroDomain, gr, recurs);
        return groupId;
    }

    public String synchronizeRemoveGroup(String groupId) throws Exception {
        SilverTrace.info("admin", "admin.synchronizeRemoveGroup", "root.MSG_GEN_ENTER_METHOD", "GroupId=" + groupId);
        DomainDriverManager domainDriverManager = DomainDriverManagerFactory.getCurrentDomainDriverManager();
        Group theGroup = this.getGroup(groupId);
        DomainDriver synchroDomain = domainDriverManager.getDomainDriver(Integer.parseInt(theGroup.getDomainId()));
        synchroDomain.removeGroup(theGroup.getSpecificId());
        return this.deleteGroupById(groupId, true);
    }

    protected void internalSynchronizeGroup(DomainDriver synchroDomain, Group latestGroup, boolean recurs) throws Exception {
        DomainDriverManager domainDriverManager = DomainDriverManagerFactory.getCurrentDomainDriverManager();
        latestGroup.setUserIds(this.translateUserIds(latestGroup.getDomainId(), latestGroup.getUserIds()));
        this.updateGroup(latestGroup, true);
        if (recurs) {
            Group[] childs;
            for (Group child : childs = synchroDomain.getGroups(latestGroup.getSpecificId())) {
                String existingGroupId = null;
                try {
                    existingGroupId = this.groupManager.getGroupIdBySpecificIdAndDomainId(domainDriverManager, child.getSpecificId(), latestGroup.getDomainId());
                    Group existingGroup = this.getGroup(existingGroupId);
                    if (!existingGroup.getSuperGroupId().equals(latestGroup.getId())) continue;
                    this.synchronizeGroup(existingGroupId, recurs);
                }
                catch (AdminException e) {
                    if (existingGroupId != null) continue;
                    this.synchronizeImportGroup(latestGroup.getDomainId(), child.getSpecificId(), latestGroup.getId(), recurs, true);
                }
            }
        }
    }

    public String synchronizeUser(String userId, boolean recurs) throws Exception {
        ArrayList<UserDetail> listUsersUpdate = new ArrayList<UserDetail>();
        DomainDriverManager domainDriverManager = DomainDriverManagerFactory.getCurrentDomainDriverManager();
        SilverTrace.info("admin", "admin.synchronizeUser", "root.MSG_GEN_ENTER_METHOD", "userId=" + userId);
        try {
            String[] oldGroupsId;
            domainDriverManager.startTransaction(false);
            UserDetail theUserDetail = this.getUserDetail(userId);
            DomainDriver synchroDomain = domainDriverManager.getDomainDriver(Integer.parseInt(theUserDetail.getDomainId()));
            UserDetail ud = synchroDomain.synchroUser(theUserDetail.getSpecificId());
            ud.setId(userId);
            ud.setAccessLevel(theUserDetail.getAccessLevel());
            ud.setDomainId(theUserDetail.getDomainId());
            if (!ud.equals(theUserDetail) || ud.getState() != UserState.UNKNOWN && ud.getState() != theUserDetail.getState()) {
                this.copyDistantUserIntoSilverpeasUser(ud, theUserDetail);
                this.userManager.updateUser(domainDriverManager, theUserDetail);
                cache.opUpdateUser(this.userManager.getUserDetail(domainDriverManager, userId));
            }
            listUsersUpdate.add(ud);
            String[] incGroupsSpecificId = synchroDomain.getUserMemberGroupIds(theUserDetail.getSpecificId());
            List<String> incGroupsId = this.translateGroupIds(theUserDetail.getDomainId(), incGroupsSpecificId, recurs);
            for (String oldGroupId : oldGroupsId = this.groupManager.getDirectGroupsOfUser(domainDriverManager, userId)) {
                if (incGroupsId.contains(oldGroupId)) {
                    incGroupsId.remove(oldGroupId);
                    continue;
                }
                Group grpToRemove = this.groupManager.getGroup(domainDriverManager, oldGroupId);
                if (!theUserDetail.getDomainId().equals(grpToRemove.getDomainId())) continue;
                this.groupManager.removeUserFromGroup(domainDriverManager, userId, oldGroupId);
                cache.opRemoveUserFromGroup(userId, oldGroupId);
            }
            for (String includedGroupId : incGroupsId) {
                this.groupManager.addUserInGroup(domainDriverManager, userId, includedGroupId);
                cache.opAddUserInGroup(userId, includedGroupId);
            }
            this.processSpecificSynchronization(theUserDetail.getDomainId(), null, listUsersUpdate, null);
            domainDriverManager.commit();
            String string = userId;
            return string;
        }
        catch (Exception e) {
            this.rollback();
            throw new AdminException("Admin.synchronizeUser", 4, "admin.EX_ERR_UPDATE_USER", "user id : '" + userId + "'", e);
        }
        finally {
            domainDriverManager.releaseOrganizationSchema();
        }
    }

    public String synchronizeImportUserByLogin(String domainId, String userLogin, boolean recurs) throws Exception {
        DomainDriverManager domainDriverManager = DomainDriverManagerFactory.getCurrentDomainDriverManager();
        SilverTrace.info("admin", "admin.synchronizeImportUserByLogin", "root.MSG_GEN_ENTER_METHOD", "userLogin=" + userLogin);
        DomainDriver synchroDomain = domainDriverManager.getDomainDriver(Integer.parseInt(domainId));
        UserDetail ud = synchroDomain.importUser(userLogin);
        ud.setDomainId(domainId);
        String userId = this.addUser(ud, true);
        this.synchronizeUser(userId, recurs);
        return userId;
    }

    public String synchronizeImportUser(String domainId, String specificId, boolean recurs) throws Exception {
        DomainDriverManager domainDriverManager = DomainDriverManagerFactory.getCurrentDomainDriverManager();
        SilverTrace.info("admin", "admin.synchronizeImportUser", "root.MSG_GEN_ENTER_METHOD", "specificId=" + specificId);
        DomainDriver synchroDomain = domainDriverManager.getDomainDriver(Integer.parseInt(domainId));
        UserDetail ud = synchroDomain.getUser(specificId);
        ud.setDomainId(domainId);
        String userId = this.addUser(ud, true);
        this.synchronizeUser(userId, recurs);
        return userId;
    }

    public List<DomainProperty> getSpecificPropertiesToImportUsers(String domainId, String language) throws Exception {
        DomainDriverManager domainDriverManager = DomainDriverManagerFactory.getCurrentDomainDriverManager();
        SilverTrace.info("admin", "admin.getSpecificPropertiesToImportUsers", "root.MSG_GEN_ENTER_METHOD", "domainId=" + domainId);
        DomainDriver synchroDomain = domainDriverManager.getDomainDriver(Integer.parseInt(domainId));
        return synchroDomain.getPropertiesToImport(language);
    }

    public UserDetail[] searchUsers(String domainId, Map<String, String> query) throws Exception {
        DomainDriverManager domainDriverManager = DomainDriverManagerFactory.getCurrentDomainDriverManager();
        SilverTrace.info("admin", "admin.searchUsers", "root.MSG_GEN_ENTER_METHOD", "domainId=" + domainId);
        DomainDriver synchroDomain = domainDriverManager.getDomainDriver(Integer.parseInt(domainId));
        return synchroDomain.getUsersByQuery(query);
    }

    public String synchronizeRemoveUser(String userId) throws Exception {
        DomainDriverManager domainDriverManager = DomainDriverManagerFactory.getCurrentDomainDriverManager();
        SilverTrace.info("admin", "admin.synchronizeRemoveUser", "root.MSG_GEN_ENTER_METHOD", "userId=" + userId);
        UserDetail theUserDetail = this.getUserDetail(userId);
        DomainDriver synchroDomain = domainDriverManager.getDomainDriver(Integer.parseInt(theUserDetail.getDomainId()));
        synchroDomain.removeUser(theUserDetail.getSpecificId());
        this.deleteUser(userId, true);
        ArrayList<UserDetail> listUsersRemove = new ArrayList<UserDetail>();
        listUsersRemove.add(theUserDetail);
        this.processSpecificSynchronization(theUserDetail.getDomainId(), null, null, listUsersRemove);
        return userId;
    }

    public String synchronizeSilverpeasWithDomain(String sDomainId) throws Exception {
        return this.synchronizeSilverpeasWithDomain(sDomainId, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String synchronizeSilverpeasWithDomain(String sDomainId, boolean threaded) throws AdminException {
        String sReport = "Starting synchronization...\n\n";
        DomainDriverManager domainDriverManager = DomainDriverManagerFactory.getCurrentDomainDriverManager();
        Object object = semaphore;
        synchronized (object) {
            SilverTrace.info("admin", "admin.synchronizeSilverpeasWithDomain", "root.MSG_GEN_ENTER_METHOD", "domainID=" + sDomainId);
            if (threaded) {
                SynchroReport.setTraceLevel(3);
            }
            SynchroReport.startSynchro();
            try {
                SynchroReport.warn("admin.synchronizeSilverpeasWithDomain", "Domain '" + domainDriverManager.getDomain(sDomainId).getName() + "', Id : " + sDomainId, null);
                domainDriverManager.beginSynchronization(sDomainId);
                DomainDriver synchroDomain = domainDriverManager.getDomainDriver(Integer.parseInt(sDomainId));
                Domain theDomain = domainDriverManager.getDomain(sDomainId);
                String fromTimeStamp = theDomain.getTheTimeStamp();
                String toTimeStamp = synchroDomain.getTimeStamp(fromTimeStamp);
                SilverTrace.info("admin", "admin.synchronizeSilverpeasWithDomain", "root.MSG_GEN_ENTER_METHOD", "TimeStamps from " + fromTimeStamp + " to " + toTimeStamp);
                domainDriverManager.startTransaction(false);
                domainDriverManager.startTransaction(sDomainId, false);
                boolean importUsers = synchroDomain.mustImportUsers() || threaded;
                sReport = sReport + this.synchronizeUsers(sDomainId, fromTimeStamp, toTimeStamp, threaded, importUsers);
                UserDetail[] silverpeasUDs = this.userManager.getUsersOfDomain(domainDriverManager, sDomainId);
                HashMap<String, String> userIdsMapping = this.getUserIdsMapping(silverpeasUDs);
                sReport = sReport + "\n" + this.synchronizeGroups(sDomainId, userIdsMapping, fromTimeStamp, toTimeStamp);
                theDomain.setTheTimeStamp(toTimeStamp);
                this.updateDomain(theDomain);
                domainDriverManager.commit();
                domainDriverManager.commit(sDomainId);
                String sDomainSpecificErrors = domainDriverManager.endSynchronization(sDomainId, false);
                SynchroReport.warn("admin.synchronizeSilverpeasWithDomain", "----------------" + sDomainSpecificErrors, null);
                String string = sReport + "\n----------------\n" + sDomainSpecificErrors;
                return string;
            }
            catch (Exception e) {
                try {
                    domainDriverManager.endSynchronization(sDomainId, true);
                    domainDriverManager.rollback();
                    domainDriverManager.rollback(sDomainId);
                }
                catch (Exception e1) {
                    SilverTrace.error("admin", "Admin.synchronizeSilverpeasWithDomain", "root.EX_ERR_ROLLBACK", e1);
                }
                SynchroReport.error("admin.synchronizeSilverpeasWithDomain", "Probl\u00e8me lors de la synchronisation : " + e.getMessage(), null);
                throw new AdminException("Admin.synchronizeSilverpeasWithDomain", 4, "admin.EX_ERR_SYNCHRONIZE_DOMAIN", "domain id : '" + sDomainId + "'\nReport:" + sReport, e);
            }
            finally {
                SynchroReport.stopSynchro();
                cache.resetCache();
                domainDriverManager.releaseOrganizationSchema();
            }
        }
    }

    private void copyDistantUserIntoSilverpeasUser(UserDetail distantUser, UserDetail silverpeasUser) {
        silverpeasUser.setSpecificId(distantUser.getSpecificId());
        silverpeasUser.setFirstName(distantUser.getFirstName());
        silverpeasUser.setLastName(distantUser.getLastName());
        silverpeasUser.seteMail(distantUser.geteMail());
        silverpeasUser.setLogin(distantUser.getLogin());
        if (distantUser.isDeactivatedState()) {
            silverpeasUser.setState(distantUser.getState());
        } else if (distantUser.isValidState() && silverpeasUser.isDeactivatedState()) {
            silverpeasUser.setState(distantUser.getState());
        }
    }

    private String synchronizeUsers(String domainId, String fromTimeStamp, String toTimeStamp, boolean threaded, boolean importUsers) throws AdminException {
        String sReport = "User synchronization : \n";
        DomainDriverManager domainDriverManager = DomainDriverManagerFactory.getCurrentDomainDriverManager();
        ArrayList<UserDetail> addedUsers = new ArrayList<UserDetail>();
        ArrayList<UserDetail> updateUsers = new ArrayList<UserDetail>();
        ArrayList<UserDetail> removedUsers = new ArrayList<UserDetail>();
        SynchroReport.warn("admin.synchronizeUsers", "Starting users synchronization...", null);
        try {
            String specificId;
            DomainDriver domainDriver = domainDriverManager.getDomainDriver(Integer.parseInt(domainId));
            UserDetail[] distantUDs = domainDriver.getAllChangedUsers(fromTimeStamp, toTimeStamp);
            String message = distantUDs.length + " user(s) have been changed in LDAP since the last synchronization";
            sReport = sReport + message + "\n";
            SynchroReport.info("admin.synchronizeUsers", message, null);
            UserDetail[] silverpeasUDs = this.userManager.getUsersOfDomain(domainDriverManager, domainId);
            SynchroReport.info("admin.synchronizeUsers", "Adding or updating users in database...", null);
            for (UserDetail distantUD : distantUDs) {
                UserDetail userToUpdateFromDistantUser = null;
                specificId = distantUD.getSpecificId();
                SilverTrace.info("admin", "admin.synchronizeUsers", PARAM_MSG_KEY, "%%%%FULLSYNCHRO%%%%>Deal with user : " + specificId);
                for (UserDetail silverpeasUD : silverpeasUDs) {
                    if (!silverpeasUD.getSpecificId().equals(specificId) && (!shouldFallbackUserLogins || !silverpeasUD.getLogin().equals(distantUD.getLogin()))) continue;
                    userToUpdateFromDistantUser = silverpeasUD;
                    this.copyDistantUserIntoSilverpeasUser(distantUD, userToUpdateFromDistantUser);
                    break;
                }
                if (userToUpdateFromDistantUser != null) {
                    this.updateUserDuringSynchronization(domainDriverManager, userToUpdateFromDistantUser, updateUsers, sReport);
                    continue;
                }
                if (!importUsers) continue;
                distantUD.setDomainId(domainId);
                this.addUserDuringSynchronization(domainDriverManager, distantUD, addedUsers, sReport);
            }
            if (!threaded || threaded && delUsersOnDiffSynchro) {
                SynchroReport.info("admin.synchronizeUsers", "Removing users from database...", null);
                distantUDs = domainDriverManager.getAllUsers(domainId);
                for (UserDetail silverpeasUD : silverpeasUDs) {
                    boolean bFound = false;
                    specificId = silverpeasUD.getSpecificId();
                    for (UserDetail distantUD : distantUDs) {
                        if (!distantUD.getSpecificId().equals(specificId) && (!shouldFallbackUserLogins || !silverpeasUD.getLogin().equals(distantUD.getLogin()))) continue;
                        bFound = true;
                        break;
                    }
                    if (bFound) continue;
                    this.deleteUserDuringSynchronization(domainDriverManager, silverpeasUD, removedUsers, sReport);
                }
            }
            this.processSpecificSynchronization(domainId, addedUsers, updateUsers, removedUsers);
            message = "Users synchronization terminated";
            sReport = sReport + message + "\n";
            SynchroReport.warn("admin.synchronizeUsers", message, null);
            message = "# of updated users : " + updateUsers.size() + ", added : " + addedUsers.size() + ", removed : " + removedUsers.size();
            sReport = sReport + message + "\n";
            SynchroReport.warn("admin.synchronizeUsers", message, null);
            return sReport;
        }
        catch (Exception e) {
            SynchroReport.error("admin.synchronizeUsers", "Problem during synchronization of users : " + e.getMessage(), null);
            throw new AdminException("admin.synchronizeUsers", 4, "admin.EX_ERR_SYNCHRONIZE_DOMAIN_USERS", "domainId : '" + domainId + "'\nReport:" + sReport, e);
        }
    }

    private HashMap<String, String> getUserIdsMapping(UserDetail[] silverpeasUDs) {
        HashMap<String, String> ids = new HashMap<String, String>();
        for (UserDetail user : silverpeasUDs) {
            ids.put(user.getSpecificId(), user.getId());
        }
        return ids;
    }

    private void updateUserDuringSynchronization(DomainDriverManager domainDriverManager, UserDetail distantUD, Collection<UserDetail> updatedUsers, String sReport) {
        String specificId = distantUD.getSpecificId();
        try {
            SilverTrace.info("admin", "admin.updateUserDuringSynchronization", PARAM_MSG_KEY, "%%%%FULLSYNCHRO%%%%>Update User : " + distantUD.getId());
            String silverpeasId = this.userManager.updateUser(domainDriverManager, distantUD);
            updatedUsers.add(distantUD);
            String message = "user " + distantUD.getDisplayedName() + " updated (id:" + silverpeasId + " / specificId:" + specificId + ")";
            SynchroReport.warn("admin.synchronizeUsers", message, null);
            sReport = sReport + message + "\n";
        }
        catch (AdminException aeMaj) {
            SilverTrace.info("admin", "admin.updateUserDuringSynchronization", PARAM_MSG_KEY, "%%%%FULLSYNCHRO%%%%>PB Updating User ! " + specificId, aeMaj);
            String message = "problem updating user " + distantUD.getDisplayedName() + " (specificId:" + specificId + ") - " + aeMaj.getMessage();
            SynchroReport.warn("admin.synchronizeUsers", message, null);
            sReport = sReport + message + "\n";
            sReport = sReport + "user has not been updated\n";
        }
    }

    private void addUserDuringSynchronization(DomainDriverManager domainDriverManager, UserDetail distantUD, Collection<UserDetail> addedUsers, String sReport) {
        String specificId = distantUD.getSpecificId();
        try {
            String silverpeasId = this.userManager.addUser(domainDriverManager, distantUD, true);
            if (silverpeasId.equals("")) {
                SilverTrace.info("admin", "admin.addUserDuringSynchronization", PARAM_MSG_KEY, "%%%%FULLSYNCHRO%%%%>PB Adding User ! " + specificId);
                String message = "problem adding user " + distantUD.getDisplayedName() + "(specificId:" + specificId + ") - Login and LastName must be set !!!";
                sReport = sReport + message + "\n";
                SynchroReport.warn("admin.synchronizeUsers", message, null);
                sReport = sReport + "user has not been added\n";
            } else {
                SilverTrace.info("admin", "admin.addUserDuringSynchronization", PARAM_MSG_KEY, "%%%%FULLSYNCHRO%%%%>Add User : " + silverpeasId);
                addedUsers.add(distantUD);
                String message = "user " + distantUD.getDisplayedName() + " added (id:" + silverpeasId + " / specificId:" + specificId + ")";
                sReport = sReport + message + "\n";
                SynchroReport.warn("admin.synchronizeUsers", message, null);
            }
        }
        catch (AdminException ae) {
            SilverTrace.info("admin", "admin.addUserDuringSynchronization", PARAM_MSG_KEY, "%%%%FULLSYNCHRO%%%%>PB Adding User ! " + specificId, ae);
            String message = "problem adding user " + distantUD.getDisplayedName() + "(specificId:" + specificId + ") - " + ae.getMessage();
            SynchroReport.warn("admin.synchronizeUsers", message, null);
            sReport = sReport + message + "\n";
            sReport = sReport + "user has not been added\n";
        }
    }

    private void deleteUserDuringSynchronization(DomainDriverManager domainDriverManager, UserDetail silverpeasUD, Collection<UserDetail> deletedUsers, String sReport) {
        String specificId = silverpeasUD.getSpecificId();
        try {
            SilverTrace.info("admin", "admin.deleteUserDuringSynchronization", PARAM_MSG_KEY, "%%%%FULLSYNCHRO%%%%>Delete User : " + silverpeasUD);
            this.userManager.deleteUser(domainDriverManager, silverpeasUD, true);
            deletedUsers.add(silverpeasUD);
            String message = "user " + silverpeasUD.getDisplayedName() + " deleted (id:" + specificId + ")";
            sReport = sReport + message + "\n";
            SynchroReport.warn("admin.synchronizeUsers", message, null);
        }
        catch (AdminException aeDel) {
            SilverTrace.info("admin", "admin.deleteUserDuringSynchronization", PARAM_MSG_KEY, "%%%%FULLSYNCHRO%%%%>PB deleting User ! " + specificId, aeDel);
            String message = "problem deleting user " + silverpeasUD.getDisplayedName() + " (specificId:" + specificId + ") - " + aeDel.getMessage();
            sReport = sReport + message + "\n";
            SynchroReport.warn("admin.synchronizeUsers", message, null);
            sReport = sReport + "user has not been deleted\n";
        }
    }

    private void processSpecificSynchronization(String domainId, Collection<UserDetail> usersAdded, Collection<UserDetail> usersUpdated, Collection<UserDetail> usersRemoved) throws Exception {
        DomainDriverManager domainDriverManager = DomainDriverManagerFactory.getCurrentDomainDriverManager();
        Domain theDomain = domainDriverManager.getDomain(domainId);
        String propDomainFileName = theDomain.getPropFileName();
        ResourceLocator propDomainLdap = new ResourceLocator(propDomainFileName, "");
        String nomClasseSynchro = propDomainLdap.getString("synchro.Class");
        if (StringUtil.isDefined(nomClasseSynchro)) {
            Collection<UserDetail> added = usersAdded;
            Collection<UserDetail> updated = usersUpdated;
            Collection<UserDetail> removed = usersRemoved;
            if (added == null) {
                added = new ArrayList<UserDetail>();
            }
            if (updated == null) {
                updated = new ArrayList<UserDetail>();
            }
            if (removed == null) {
                removed = new ArrayList<UserDetail>();
            }
            try {
                LDAPSynchroUserItf synchroUser = (LDAPSynchroUserItf)Class.forName(nomClasseSynchro).newInstance();
                if (synchroUser != null) {
                    synchroUser.processUsers(added, updated, removed);
                }
            }
            catch (Exception e) {
                SilverTrace.warn("admin", "admin.synchronizeOnlyExistingUsers", PARAM_MSG_KEY, "Pb Loading class traitement Users ! ", e);
            }
        }
    }

    private String synchronizeGroups(String domainId, Map<String, String> userIds, String fromTimeStamp, String toTimeStamp) throws Exception {
        String sReport = "Group synchronization : \n";
        HashMap<String, Group> allDistantGroups = new HashMap<String, Group>();
        int iNbGroupsAdded = 0;
        int iNbGroupsMaj = 0;
        int iNbGroupsDeleted = 0;
        DomainDriverManager domainDriverManager = DomainDriverManagerFactory.getCurrentDomainDriverManager();
        SynchroReport.warn("admin.synchronizeGroups", "Starting groups synchronization...", null);
        try {
            Group[] distantRootGroups = domainDriverManager.getAllRootGroups(domainId);
            Group[] silverpeasGroups = this.groupManager.getGroupsOfDomain(domainDriverManager, domainId);
            SynchroReport.info("admin.synchronizeGroups", "Adding or updating groups in database...", null);
            sReport = sReport + this.checkOutGroups(domainId, silverpeasGroups, distantRootGroups, allDistantGroups, userIds, null, iNbGroupsAdded, iNbGroupsMaj, iNbGroupsDeleted);
            SynchroReport.info("admin.synchronizeGroups", "Removing groups from database...", null);
            Group[] distantGroups = allDistantGroups.values().toArray(new Group[allDistantGroups.size()]);
            for (Group silverpeasGroup : silverpeasGroups) {
                boolean bFound = false;
                String specificId = silverpeasGroup.getSpecificId();
                for (int nJ = 0; nJ < distantGroups.length && !bFound; ++nJ) {
                    if (distantGroups[nJ].getSpecificId().equals(specificId)) {
                        bFound = true;
                        continue;
                    }
                    if (!shouldFallbackGroupNames || !distantGroups[nJ].getName().equals(specificId)) continue;
                    bFound = true;
                }
                if (bFound) continue;
                try {
                    SilverTrace.info("admin", "admin.synchronizeGroups", PARAM_MSG_KEY, "%%%%FULLSYNCHRO%%%%>Delete group : " + silverpeasGroup.getId() + " - " + specificId);
                    this.groupManager.deleteGroupById(domainDriverManager, silverpeasGroup, true);
                    ++iNbGroupsDeleted;
                    sReport = sReport + "deleting group " + silverpeasGroup.getName() + "(id:" + specificId + ")\n";
                    SynchroReport.warn("admin.synchronizeGroups", "Group " + silverpeasGroup.getName() + " deleted (SpecificId:" + specificId + ")", null);
                }
                catch (AdminException aeDel) {
                    SilverTrace.info("admin", "admin.synchronizeGroups", PARAM_MSG_KEY, "%%%%FULLSYNCHRO%%%%>PB deleting group ! " + specificId, aeDel);
                    sReport = sReport + "problem deleting group " + silverpeasGroup.getName() + " (specificId:" + specificId + ") - " + aeDel.getMessage() + "\n";
                    sReport = sReport + "group has not been deleted\n";
                }
            }
            sReport = sReport + "Groups synchronization terminated\n";
            SynchroReport.info("admin.synchronizeGroups", "# of groups updated : " + iNbGroupsMaj + ", added : " + iNbGroupsAdded + ", deleted : " + iNbGroupsDeleted, null);
            SynchroReport.warn("admin.synchronizeGroups", "Groups synchronization terminated", null);
            return sReport;
        }
        catch (Exception e) {
            SynchroReport.error("admin.synchronizeGroups", "Probl\u00e8me lors de la synchronisation des groupes : " + e.getMessage(), null);
            throw new AdminException("admin.synchronizeGroups", 4, "admin.EX_ERR_SYNCHRONIZE_DOMAIN_GROUPS", "domain id : '" + domainId + "'\nReport:" + sReport, e);
        }
    }

    private String checkOutGroups(String domainId, Group[] existingGroups, Group[] testedGroups, Map<String, Group> allIncluededGroups, Map<String, String> userIds, String superGroupId, int iNbGroupsAdded, int iNbGroupsMaj, int iNbGroupsDeleted) throws Exception {
        String silverpeasId = null;
        String report = "";
        for (Group testedGroup : testedGroups) {
            allIncluededGroups.put(testedGroup.getSpecificId(), testedGroup);
        }
        DomainDriverManager domainDriverManager = DomainDriverManagerFactory.getCurrentDomainDriverManager();
        for (Group testedGroup : testedGroups) {
            Group[] cleanSubGroups;
            Group[] subGroups;
            String specificId;
            block19: {
                boolean bFound = false;
                specificId = testedGroup.getSpecificId();
                SilverTrace.info("admin", "admin.checkOutGroups", PARAM_MSG_KEY, "%%%%FULLSYNCHRO%%%%>Deal with group : " + specificId);
                for (int nJ = 0; nJ < existingGroups.length && !bFound; ++nJ) {
                    if (existingGroups[nJ].getSpecificId().equals(specificId)) {
                        bFound = true;
                        testedGroup.setId(existingGroups[nJ].getId());
                        continue;
                    }
                    if (!shouldFallbackGroupNames || !existingGroups[nJ].getSpecificId().equals(testedGroup.getName())) continue;
                    bFound = true;
                    testedGroup.setId(existingGroups[nJ].getId());
                }
                testedGroup.setDomainId(domainId);
                if (bFound) {
                    SynchroReport.debug("admin.checkOutGroups", "avant maj du groupe " + specificId + ", recherche de ses groupes parents", null);
                } else {
                    SynchroReport.debug("admin.checkOutGroups", "avant ajout du groupe " + specificId + ", recherche de ses groupes parents", null);
                }
                String[] groupParentsIds = domainDriverManager.getGroupMemberGroupIds(domainId, testedGroup.getSpecificId());
                if (groupParentsIds == null || groupParentsIds.length == 0) {
                    testedGroup.setSuperGroupId(null);
                    SynchroReport.debug("admin.checkOutGroups", "le groupe " + specificId + " n'a pas de p\u00e8re", null);
                } else {
                    testedGroup.setSuperGroupId(superGroupId);
                    if (superGroupId != null) {
                        SynchroReport.debug("admin.checkOutGroups", "le groupe " + specificId + " a pour p\u00e8re le groupe " + domainDriverManager.getGroup(superGroupId).getSpecificId() + " d'Id base " + superGroupId, null);
                    }
                }
                String[] userSpecificIds = testedGroup.getUserIds();
                ArrayList<String> convertedUserIds = new ArrayList<String>();
                for (String userSpecificId : userSpecificIds) {
                    if (userIds.get(userSpecificId) == null) continue;
                    convertedUserIds.add(userIds.get(userSpecificId));
                }
                testedGroup.setUserIds(convertedUserIds.toArray(new String[convertedUserIds.size()]));
                if (bFound) {
                    try {
                        SilverTrace.info("admin", "admin.checkOutGroups", PARAM_MSG_KEY, "%%%%FULLSYNCHRO%%%%>Update group : " + testedGroup.getId());
                        String result = this.groupManager.updateGroup(domainDriverManager, testedGroup, true);
                        if (StringUtil.isDefined(result)) {
                            ++iNbGroupsMaj;
                            silverpeasId = testedGroup.getId();
                            report = report + "updating group " + testedGroup.getName() + "(id:" + specificId + ")\n";
                            SynchroReport.warn("admin.checkOutGroups", "maj groupe " + testedGroup.getName() + " (id:" + silverpeasId + ") OK", null);
                            break block19;
                        }
                        SilverTrace.info("admin", "admin.checkOutGroups", PARAM_MSG_KEY, "%%%%FULLSYNCHRO%%%%>PB Updating Group ! " + specificId);
                        report = report + "problem updating group id : " + specificId + "\n";
                    }
                    catch (AdminException aeMaj) {
                        SilverTrace.info("admin", "admin.checkOutGroups", PARAM_MSG_KEY, "%%%%FULLSYNCHRO%%%%>PB Updating Group ! " + specificId, aeMaj);
                        report = report + "problem updating group " + testedGroup.getName() + " (id:" + specificId + ") " + aeMaj.getMessage() + "\n";
                        report = report + "group has not been updated\n";
                    }
                } else {
                    try {
                        silverpeasId = this.groupManager.addGroup(domainDriverManager, testedGroup, true);
                        if (StringUtil.isDefined(silverpeasId)) {
                            ++iNbGroupsAdded;
                            SilverTrace.info("admin", "admin.checkOutGroups", PARAM_MSG_KEY, "%%%%FULLSYNCHRO%%%%>Add group : " + silverpeasId);
                            report = report + "adding group " + testedGroup.getName() + "(id:" + specificId + ")\n";
                            SynchroReport.warn("admin.checkOutGroups", "ajout groupe " + testedGroup.getName() + " (id:" + silverpeasId + ") OK", null);
                        } else {
                            SilverTrace.info("admin", "admin.checkOutGroups", PARAM_MSG_KEY, "%%%%FULLSYNCHRO%%%%>PB Adding Group ! " + specificId);
                            report = report + "problem adding group id : " + specificId + "\n";
                        }
                    }
                    catch (AdminException aeAdd) {
                        SilverTrace.info("admin", "admin.checkOutGroups", PARAM_MSG_KEY, "%%%%FULLSYNCHRO%%%%>PB Adding Group ! " + specificId, aeAdd);
                        report = report + "problem adding group " + testedGroup.getName() + " (id:" + specificId + ") " + aeAdd.getMessage() + "\n";
                        report = report + "group has not been added\n";
                    }
                }
            }
            if (silverpeasId == null || silverpeasId.length() <= 0 || (subGroups = domainDriverManager.getGroups(silverpeasId)) == null || subGroups.length <= 0 || (cleanSubGroups = this.removeCrossReferences(subGroups, allIncluededGroups, specificId)) == null || cleanSubGroups.length <= 0) continue;
            SynchroReport.info("admin.checkOutGroups", "Ajout ou mise \u00e0 jour de " + cleanSubGroups.length + " groupes fils du groupe " + specificId + "...", null);
            report = report + this.checkOutGroups(domainId, existingGroups, cleanSubGroups, allIncluededGroups, userIds, silverpeasId, iNbGroupsAdded, iNbGroupsMaj, iNbGroupsDeleted);
        }
        return report;
    }

    private Group[] removeCrossReferences(Group[] subGroups, Map<String, Group> allIncluededGroups, String fatherId) throws Exception {
        ArrayList<Group> cleanSubGroups = new ArrayList<Group>();
        for (Group subGroup : subGroups) {
            if (allIncluededGroups.get(subGroup.getSpecificId()) == null) {
                cleanSubGroups.add(subGroup);
                continue;
            }
            SilverTrace.warn("admin", "Admin.removeCrossReferences", PARAM_MSG_KEY, "Cross removed for child : " + subGroup.getSpecificId() + " of father : " + fatherId);
        }
        return cleanSubGroups.toArray(new Group[cleanSubGroups.size()]);
    }

    public String[] searchUsersIds(String sGroupId, String componentId, String[] profileIds, UserDetail modelUser) throws AdminException {
        DomainDriverManager domainDriverManager = DomainDriverManagerFactory.getCurrentDomainDriverManager();
        try {
            ArrayList<String> userIds = new ArrayList<String>();
            if (StringUtil.isDefined(sGroupId)) {
                UserDetail[] users;
                for (UserDetail user : users = this.getAllUsersOfGroup(sGroupId)) {
                    userIds.add(user.getId());
                }
                if (userIds.isEmpty()) {
                    userIds = null;
                }
            } else if (profileIds != null && profileIds.length > 0) {
                for (String profileId : profileIds) {
                    ProfileInst profile = profileManager.getProfileInst(domainDriverManager, profileId, null);
                    userIds.addAll(profile.getAllUsers());
                    ArrayList<String> groupIds = profile.getAllGroups();
                    ArrayList<String> allGroupIds = new ArrayList<String>();
                    for (String groupId : groupIds) {
                        allGroupIds.add(groupId);
                        allGroupIds.addAll(this.groupManager.getAllSubGroupIdsRecursively(groupId));
                    }
                    userIds.addAll(this.userManager.getAllUserIdsOfGroups(allGroupIds));
                }
                if (userIds.isEmpty()) {
                    userIds = null;
                }
            } else if (StringUtil.isDefined(componentId)) {
                userIds.addAll(this.getUserIdsForComponent(componentId));
                if (userIds.isEmpty()) {
                    userIds = null;
                }
            } else {
                userIds = new ArrayList();
            }
            if (userIds == null) {
                return ArrayUtil.EMPTY_STRING_ARRAY;
            }
            return this.userManager.searchUsersIds(domainDriverManager, userIds, modelUser);
        }
        catch (Exception e) {
            throw new AdminException("Admin.searchUsersIds", 4, "admin.EX_ERR_USER_NOT_FOUND", e);
        }
    }

    private List<String> getUserIdsForComponent(String componentId) throws AdminException {
        ArrayList<String> userIds = new ArrayList<String>();
        ComponentInst component = this.getComponentInst(componentId);
        if (component != null) {
            if (component.isPublic()) {
                return Arrays.asList(this.getAllUsersIds());
            }
            List<ProfileInst> profiles = component.getAllProfilesInst();
            for (ProfileInst profile : profiles) {
                userIds.addAll(this.getUserIdsForComponentProfile(profile));
            }
        }
        return userIds;
    }

    private List<String> getUserIdsForComponentProfile(ProfileInst profile) throws AdminException {
        ArrayList<String> userIds = new ArrayList<String>();
        userIds.addAll(profile.getAllUsers());
        ArrayList<String> groupIds = profile.getAllGroups();
        ArrayList<String> allGroupIds = new ArrayList<String>();
        for (String groupId : groupIds) {
            allGroupIds.add(groupId);
            allGroupIds.addAll(this.groupManager.getAllSubGroupIdsRecursively(groupId));
        }
        userIds.addAll(this.userManager.getAllUserIdsOfGroups(allGroupIds));
        return userIds;
    }

    public ListSlice<UserDetail> searchUsers(UserDetailsSearchCriteria searchCriteria) throws AdminException {
        List<String> userIds = null;
        if (searchCriteria.isCriterionOnComponentInstanceIdSet()) {
            List<String> listOfRoleNames = null;
            if (searchCriteria.isCriterionOnRoleNamesSet()) {
                listOfRoleNames = Arrays.asList(searchCriteria.getCriterionOnRoleNames());
            }
            ComponentInst instance = this.getComponentInst(searchCriteria.getCriterionOnComponentInstanceId());
            if (listOfRoleNames != null && !listOfRoleNames.isEmpty() || !instance.isPublic()) {
                List<ProfileInst> profiles = searchCriteria.isCriterionOnResourceIdSet() ? this.getProfileInstsFor(searchCriteria.getCriterionOnResourceId(), instance.getId()) : instance.getAllProfilesInst();
                userIds = new ArrayList<String>();
                for (ProfileInst aProfile : profiles) {
                    if (listOfRoleNames != null && !listOfRoleNames.isEmpty() && !listOfRoleNames.contains(aProfile.getName())) continue;
                    userIds.addAll(aProfile.getAllUsers());
                    ArrayList<String> groupIds = aProfile.getAllGroups();
                    ArrayList<String> allGroupIds = new ArrayList<String>();
                    for (String aGroupId : groupIds) {
                        allGroupIds.add(aGroupId);
                        allGroupIds.addAll(this.groupManager.getAllSubGroupIdsRecursively(aGroupId));
                    }
                    userIds.addAll(this.userManager.getAllUserIdsOfGroups(allGroupIds));
                }
                if (userIds.isEmpty()) {
                    userIds = null;
                }
            }
        }
        if (searchCriteria.isCriterionOnUserIdsSet()) {
            if (userIds == null) {
                userIds = Arrays.asList(searchCriteria.getCriterionOnUserIds());
            } else {
                List<String> userIdsInCriterion = Arrays.asList(searchCriteria.getCriterionOnUserIds());
                ArrayList<String> userIdsToTake = new ArrayList<String>();
                for (String userId : userIds) {
                    if (!userIdsInCriterion.contains(userId)) continue;
                    userIdsToTake.add(userId);
                }
                userIds = userIdsToTake;
            }
        }
        SearchCriteriaDAOFactory factory = SearchCriteriaDAOFactory.getFactory();
        UserSearchCriteriaForDAO criteria = factory.getUserSearchCriteriaDAO();
        if (userIds != null) {
            criteria.onUserIds(userIds.toArray(new String[userIds.size()]));
        }
        if (searchCriteria.isCriterionOnGroupIdsSet()) {
            String[] theGroupIds = searchCriteria.getCriterionOnGroupIds();
            if (theGroupIds == UserDetailsSearchCriteria.ANY_GROUPS) {
                criteria.and().onGroupIds(SearchCriteria.ANY);
            } else {
                HashSet<String> groupIds = new HashSet<String>();
                for (String aGroupId : theGroupIds) {
                    groupIds.addAll(this.groupManager.getAllSubGroupIdsRecursively(aGroupId));
                    groupIds.add(aGroupId);
                }
                criteria.and().onGroupIds(groupIds.toArray(new String[groupIds.size()]));
            }
        }
        if (searchCriteria.isCriterionOnDomainIdSet()) {
            criteria.and().onDomainId(searchCriteria.getCriterionOnDomainId());
        }
        if (searchCriteria.isCriterionOnAccessLevelsSet()) {
            criteria.and().onAccessLevels(searchCriteria.getCriterionOnAccessLevels());
        }
        if (searchCriteria.isCriterionOnUserStatesToExcludeSet()) {
            criteria.and().onUserStatesToExclude(searchCriteria.getCriterionOnUserStatesToExclude());
        }
        if (searchCriteria.isCriterionOnNameSet()) {
            criteria.and().onName(searchCriteria.getCriterionOnName());
        }
        if (searchCriteria.isCriterionOnPaginationSet()) {
            criteria.onPagination(searchCriteria.getCriterionOnPagination());
        }
        return this.userManager.getUsersMatchingCriteria(criteria);
    }

    public ListSlice<Group> searchGroups(GroupsSearchCriteria searchCriteria) throws AdminException {
        SearchCriteriaDAOFactory factory = SearchCriteriaDAOFactory.getFactory();
        GroupSearchCriteriaForDAO criteria = factory.getGroupSearchCriteriaDAO();
        if (searchCriteria.isCriterionOnComponentInstanceIdSet()) {
            List<Object> listOfRoleNames = new ArrayList();
            if (searchCriteria.isCriterionOnRoleNamesSet()) {
                listOfRoleNames = Arrays.asList(searchCriteria.getCriterionOnRoleNames());
            }
            ComponentInst instance = this.getComponentInst(searchCriteria.getCriterionOnComponentInstanceId());
            if (!listOfRoleNames.isEmpty() || !instance.isPublic()) {
                List<ProfileInst> profiles = searchCriteria.isCriterionOnResourceIdSet() ? this.getProfileInstsFor(searchCriteria.getCriterionOnResourceId(), instance.getId()) : instance.getAllProfilesInst();
                ArrayList<String> roleIds = new ArrayList<String>();
                for (ProfileInst aProfile : profiles) {
                    if (!listOfRoleNames.isEmpty() && !listOfRoleNames.contains(aProfile.getName())) continue;
                    roleIds.add(aProfile.getId());
                }
                criteria.onRoleNames(roleIds.toArray(new String[roleIds.size()]));
            }
        }
        if (searchCriteria.mustBeRoot()) {
            criteria.onAsRootGroup();
        }
        if (searchCriteria.isCriterionOnDomainIdSet()) {
            String domainId = searchCriteria.getCriterionOnDomainId();
            if (searchCriteria.isCriterionOnMixedDomainIdSet()) {
                criteria.onMixedDomainOronDomainId(domainId);
            } else {
                criteria.onDomainId(domainId);
            }
        }
        if (searchCriteria.isCriterionOnGroupIdsSet()) {
            criteria.and().onGroupIds(searchCriteria.getCriterionOnGroupIds());
        }
        if (searchCriteria.isCriterionOnNameSet()) {
            criteria.and().onName(searchCriteria.getCriterionOnName());
        }
        if (searchCriteria.isCriterionOnAccessLevelsSet()) {
            criteria.and().onAccessLevels(searchCriteria.getCriterionOnAccessLevels());
        }
        if (searchCriteria.isCriterionOnUserStatesToExcludeSet()) {
            criteria.and().onUserStatesToExclude(searchCriteria.getCriterionOnUserStatesToExclude());
        }
        if (searchCriteria.isCriterionOnSuperGroupIdSet()) {
            criteria.and().onSuperGroupId(searchCriteria.getCriterionOnSuperGroupId());
        }
        if (searchCriteria.isCriterionOnPaginationSet()) {
            criteria.onPagination(searchCriteria.getCriterionOnPagination());
        }
        return this.groupManager.getGroupsMatchingCriteria(criteria);
    }

    public String[] searchGroupsIds(boolean isRootGroup, String componentId, String[] profileId, Group modelGroup) throws AdminException {
        DomainDriverManager domainDriverManager = DomainDriverManagerFactory.getCurrentDomainDriverManager();
        try {
            ComponentInst component = this.getComponentInst(componentId);
            if (component != null && component.isPublic()) {
                componentId = null;
            }
            return this.groupManager.searchGroupsIds(domainDriverManager, isRootGroup, this.getDriverComponentId(componentId), profileId, modelGroup);
        }
        catch (Exception e) {
            throw new AdminException("Admin.searchGroupsIds", 4, "admin.EX_ERR_GROUP_NOT_FOUND", e);
        }
    }

    public void resetAllDBConnections(boolean isScheduled) throws AdminException {
        try {
            SilverTrace.info("admin", "Admin.resetAllDBConnections", "root.MSG_GEN_ENTER_METHOD", "RESET ALL DB CONNECTIONS ! (Scheduled : " + isScheduled + ")");
            OrganizationSchemaPool.releaseConnections();
            ConnectionPool.releaseConnections();
        }
        catch (Exception e) {
            throw new AdminException("Admin.resetAllDBConnections", 4, "root.EX_CONNECTION_CLOSE_FAILED", e);
        }
    }

    private void rollback() {
        DomainDriverManager domainDriverManager = DomainDriverManagerFactory.getCurrentDomainDriverManager();
        try {
            domainDriverManager.rollback();
        }
        catch (Exception e1) {
            SilverTrace.error("admin", "Admin.rollback", "root.EX_ERR_ROLLBACK", e1);
        }
    }

    private String getSpaceId(SpaceInst spaceInst) {
        if (spaceInst.getId().startsWith(SPACE_KEY_PREFIX)) {
            return spaceInst.getId();
        }
        return SPACE_KEY_PREFIX + spaceInst.getId();
    }

    public void indexAllUsers() throws AdminException {
        Domain[] domains;
        for (Domain domain : domains = this.getAllDomains()) {
            try {
                this.indexUsers(domain.getId());
            }
            catch (Exception e) {
                SilverTrace.error("admin", "Admin.indexAllUsers", "admin.CANT_INDEX_USERS", "domainId = " + domain.getId(), e);
            }
        }
    }

    public void indexUsers(String domainId) throws AdminException {
        DomainDriverManager domainDriverManager = DomainDriverManagerFactory.getCurrentDomainDriverManager();
        try {
            domainDriverManager.indexAllUsers(domainId);
        }
        catch (Exception e) {
            throw new AdminException("Admin.indexUsers", 4, "admin.CANT_INDEX_USERS", "domainId = " + domainId, e);
        }
    }

    public String copyAndPasteComponent(PasteDetail pasteDetail) throws AdminException, QuotaException {
        if (!StringUtil.isDefined(pasteDetail.getToSpaceId())) {
            return null;
        }
        ComponentInst newCompo = (ComponentInst)this.getComponentInst(pasteDetail.getFromComponentId()).clone();
        SpaceInst destinationSpace = this.getSpaceInstById(pasteDetail.getToSpaceId());
        String lang = newCompo.getLanguage();
        if (StringUtil.isNotDefined(lang)) {
            lang = I18NHelper.defaultLanguage;
        }
        newCompo.setId("-1");
        newCompo.setDomainFatherId(destinationSpace.getId());
        newCompo.setOrderNum(destinationSpace.getNumComponentInst());
        newCompo.setCreateDate(new Date());
        newCompo.setCreatorUserId(pasteDetail.getUserId());
        newCompo.setLanguage(lang);
        String label = this.renameComponentName(newCompo.getLabel(lang), destinationSpace.getAllComponentsInst());
        newCompo.setLabel(label);
        ComponentI18N translation = (ComponentI18N)newCompo.getTranslation(lang);
        if (translation != null) {
            translation.setName(label);
        }
        newCompo.removeInheritedProfiles();
        String sComponentId = this.addComponentInst(pasteDetail.getUserId(), newCompo);
        try {
            pasteDetail.setToComponentId(sComponentId);
            String componentRootName = URLManager.getComponentNameFromComponentId(pasteDetail.getFromComponentId());
            String className = "com.silverpeas.component." + componentRootName + "." + componentRootName.substring(0, 1).toUpperCase() + componentRootName.substring(1) + "Paste";
            if (Class.forName(className).getClass() != null) {
                ComponentPasteInterface componentPaste = (ComponentPasteInterface)Class.forName(className).newInstance();
                componentPaste.paste(pasteDetail);
            }
        }
        catch (Exception e) {
            SilverTrace.warn("admin", "Admin.copyAndPasteComponent()", "root.GEN_EXIT_METHOD", e);
        }
        return sComponentId;
    }

    private String renameComponentName(String label, ArrayList<ComponentInst> listComponents) {
        String newComponentLabel = label;
        for (ComponentInst componentInst : listComponents) {
            if (!componentInst.getLabel().equals(newComponentLabel)) continue;
            newComponentLabel = "Copie de " + label;
            return this.renameComponentName(newComponentLabel, listComponents);
        }
        return newComponentLabel;
    }

    private boolean isParent(String spaceId, String anotherSpaceId) throws AdminException {
        if (anotherSpaceId == null) {
            return false;
        }
        List<SpaceInstLight> path = TreeCache.getSpacePath(anotherSpaceId);
        if (path.isEmpty()) {
            path = this.getPathToSpace(anotherSpaceId, true);
        }
        for (SpaceInstLight space : path) {
            if (!spaceId.equalsIgnoreCase(space.getFullId())) continue;
            return true;
        }
        return false;
    }

    public String copyAndPasteSpace(PasteDetail pasteDetail) throws AdminException, QuotaException {
        String toSpaceId;
        boolean pasteAllowed;
        String newSpaceId = null;
        String spaceId = pasteDetail.getFromSpaceId();
        boolean bl = pasteAllowed = !this.isParent(spaceId, toSpaceId = pasteDetail.getToSpaceId());
        if (pasteAllowed) {
            String[] subSpaceIds;
            Quota componentQuota;
            List<String> newBrotherIds;
            SpaceInst oldSpace = this.getSpaceInstById(spaceId);
            SpaceInst newSpace = oldSpace.clone();
            newSpace.setId("-1");
            if (StringUtil.isDefined(toSpaceId)) {
                SpaceInst destinationSpace = this.getSpaceInstById(toSpaceId);
                newSpace.setDomainFatherId(destinationSpace.getId());
                newBrotherIds = Arrays.asList(destinationSpace.getSubSpaceIds());
            } else {
                newSpace.setDomainFatherId("-1");
                newBrotherIds = Arrays.asList(this.getAllRootSpaceIds());
            }
            newSpace.setOrderNum(newBrotherIds.size());
            newSpace.setCreateDate(new Date());
            newSpace.setCreatorUserId(pasteDetail.getUserId());
            String lang = oldSpace.getLanguage();
            if (StringUtil.isNotDefined(lang)) {
                lang = I18NHelper.defaultLanguage;
            }
            newSpace.setLanguage(lang);
            ArrayList<SpaceInstLight> subSpaces = new ArrayList<SpaceInstLight>();
            for (String subSpaceId : newBrotherIds) {
                subSpaces.add(this.getSpaceInstLight(this.getDriverSpaceId(subSpaceId)));
            }
            String name = this.renameSpace(newSpace.getName(lang), subSpaces);
            newSpace.setName(name);
            newSpace.removeInheritedProfiles();
            ArrayList<ComponentInst> components = newSpace.getAllComponentsInst();
            newSpace.removeAllComponentsInst();
            newSpaceId = this.addSpaceInst(pasteDetail.getUserId(), newSpace);
            Quota dataStorageQuota = SpaceServiceFactory.getDataStorageSpaceQuotaService().get(DataStorageSpaceQuotaKey.from(oldSpace));
            if (dataStorageQuota.exists()) {
                SpaceServiceFactory.getDataStorageSpaceQuotaService().initialize(DataStorageSpaceQuotaKey.from(newSpace), dataStorageQuota);
            }
            if ((componentQuota = SpaceServiceFactory.getComponentSpaceQuotaService().get(ComponentSpaceQuotaKey.from(oldSpace))).exists()) {
                SpaceServiceFactory.getComponentSpaceQuotaService().initialize(ComponentSpaceQuotaKey.from(newSpace), componentQuota);
            }
            String componentIdAsHomePage = null;
            if (newSpace.getFirstPageType() == 1) {
                componentIdAsHomePage = newSpace.getFirstPageExtraParam();
            }
            PasteDetail componentPasteDetail = new PasteDetail(pasteDetail.getUserId());
            componentPasteDetail.setOptions(pasteDetail.getOptions());
            componentPasteDetail.setToSpaceId(newSpaceId);
            for (ComponentInst component : components) {
                componentPasteDetail.setFromComponentId(component.getId());
                String componentId = this.copyAndPasteComponent(componentPasteDetail);
                if (componentIdAsHomePage == null || !componentIdAsHomePage.equals(component.getId())) continue;
                componentIdAsHomePage = componentId;
            }
            PasteDetail subSpacePasteDetail = new PasteDetail(pasteDetail.getUserId());
            subSpacePasteDetail.setOptions(pasteDetail.getOptions());
            subSpacePasteDetail.setToSpaceId(newSpaceId);
            for (String subSpaceId : subSpaceIds = newSpace.getSubSpaceIds()) {
                subSpacePasteDetail.setFromSpaceId(subSpaceId);
                this.copyAndPasteSpace(subSpacePasteDetail);
            }
            String newFirstPageExtraParam = null;
            if (StringUtil.isDefined(componentIdAsHomePage)) {
                newFirstPageExtraParam = componentIdAsHomePage;
            } else if (newSpace.getFirstPageType() == 3) {
                String oldURL = newSpace.getFirstPageExtraParam();
                newFirstPageExtraParam = oldURL.replaceAll(spaceId, newSpaceId);
            }
            if (StringUtil.isDefined(newFirstPageExtraParam)) {
                SpaceInst space = this.getSpaceInstById(newSpaceId);
                space.setFirstPageExtraParam(newFirstPageExtraParam);
                space.setUpdaterUserId(pasteDetail.getUserId());
                this.updateSpaceInst(space);
            }
        }
        return newSpaceId;
    }

    private String renameSpace(String label, List<SpaceInstLight> listSpaces) {
        String newSpaceLabel = label;
        for (SpaceInstLight space : listSpaces) {
            if (!space.getName().equals(newSpaceLabel)) continue;
            newSpaceLabel = "Copie de " + label;
            return this.renameSpace(newSpaceLabel, listSpaces);
        }
        return newSpaceLabel;
    }

    private List<ProfileInst> getProfileInstsFor(String resourceId, String instanceId) throws AdminException {
        Pattern objectIdPattern = Pattern.compile("([a-zA-Z]+)(\\d+)");
        Matcher matcher = objectIdPattern.matcher(resourceId);
        if (matcher.matches() && matcher.groupCount() == 2) {
            String type = matcher.group(1);
            String id = matcher.group(2);
            return this.getProfilesByObject(id, type, instanceId);
        }
        throw new AdminPersistenceException("Admin.getProfileInstFor", 4, "Bad resource identifier: " + resourceId);
    }

    private String[] getDirectSpaceProfileIdsOfUser(String sUserId) throws AdminException {
        try {
            DomainDriverManager domainDriverManager = DomainDriverManagerFactory.getCurrentDomainDriverManager();
            return spaceProfileManager.getSpaceProfileIdsOfUserType(domainDriverManager, sUserId);
        }
        catch (Exception e) {
            throw new AdminException("Admin.getSpaceProfileIdsOfUserType", 4, "admin.EX_ERR_GET_USER_PROFILES", "user Id : '" + sUserId + "'", e);
        }
    }

    private String[] getDirectSpaceProfileIdsOfGroup(String groupId) throws AdminException {
        try {
            DomainDriverManager domainDriverManager = DomainDriverManagerFactory.getCurrentDomainDriverManager();
            return spaceProfileManager.getSpaceProfileIdsOfGroupType(domainDriverManager, groupId);
        }
        catch (Exception e) {
            throw new AdminException("Admin.getSpaceProfileIdsOfGroupType", 4, "admin.EX_ERR_GET_USER_PROFILES", "group Id : '" + groupId + "'", e);
        }
    }

    private String[] getDirectComponentProfileIdsOfUser(String sUserId) throws AdminException {
        try {
            return profileManager.getProfileIdsOfUser(sUserId, Collections.EMPTY_LIST);
        }
        catch (Exception e) {
            throw new AdminException("Admin.getComponentProfileIdsOfUserType", 4, "admin.EX_ERR_GET_GROUP_COMPONENT_PROFILES", "user Id : '" + sUserId + "'", e);
        }
    }

    private String[] getDirectComponentProfileIdsOfGroup(String groupId) throws AdminException {
        try {
            return profileManager.getProfileIdsOfGroup(groupId);
        }
        catch (Exception e) {
            throw new AdminException("Admin.getComponentProfileIdsOfGroupType", 4, "admin.EX_ERR_GET_GROUP_COMPONENT_PROFILES", "group Id : '" + groupId + "'", e);
        }
    }

    private String[] getComponentObjectProfileIdsOfUserType(String userId) throws AdminException {
        try {
            return profileManager.getAllComponentObjectProfileIdsOfUser(userId, Collections.EMPTY_LIST);
        }
        catch (Exception e) {
            throw new AdminException("Admin.getComponentObjectProfileIdsOfUserType", 4, "admin.EX_ERR_GET_USER_PROFILES", "user Id : '" + userId + "'", e);
        }
    }

    private String[] getComponentObjectProfileIdsOfGroupType(String sGroupId) throws AdminException {
        try {
            return profileManager.getAllComponentObjectProfileIdsOfGroup(sGroupId);
        }
        catch (Exception e) {
            throw new AdminException("Admin.getComponentObjectProfileIdsOfGroupType", 4, "admin.EX_ERR_GET_GROUP_PROFILES", "group Id : '" + sGroupId + "'", e);
        }
    }

    private void addTargetProfiles(RightAssignationContext context, String[] sourceSpaceProfileIds, String[] sourceComponentProfileIds, String[] sourceNodeProfileIds) throws AdminException {
        SpaceInstLight spaceInst;
        String spaceId;
        ComponentInst currentComponent;
        ProfileInst currentSourceProfile;
        for (String spaceProfileId : sourceSpaceProfileIds) {
            SpaceProfileInst currentSourceSpaceProfile = this.getSpaceProfileInst(spaceProfileId);
            SpaceInstLight spaceInst2 = this.getSpaceInstLight(this.getDriverSpaceId(currentSourceSpaceProfile.getSpaceFatherId()));
            if (spaceInst2.isPersonalSpace()) continue;
            switch (context.getTargetType()) {
                case USER: {
                    currentSourceSpaceProfile.addUser(context.getTargetId());
                    break;
                }
                case GROUP: {
                    currentSourceSpaceProfile.addGroup(context.getTargetId());
                }
            }
            this.updateSpaceProfileInst(currentSourceSpaceProfile, context.getAuthor(), false);
        }
        for (String profileId : sourceComponentProfileIds) {
            currentSourceProfile = this.getProfileInst(profileId);
            currentComponent = this.getComponentInst(currentSourceProfile.getComponentFatherId());
            spaceId = currentComponent.getDomainFatherId();
            spaceInst = this.getSpaceInstLight(this.getDriverSpaceId(spaceId));
            if (currentComponent.getStatus() != null || spaceInst.isPersonalSpace()) continue;
            switch (context.getTargetType()) {
                case USER: {
                    currentSourceProfile.addUser(context.getTargetId());
                    break;
                }
                case GROUP: {
                    currentSourceProfile.addGroup(context.getTargetId());
                }
            }
            this.updateProfileInst(currentSourceProfile, context.getAuthor(), false, context.getMode());
        }
        for (String profileId : sourceNodeProfileIds) {
            currentSourceProfile = this.getProfileInst(profileId);
            currentComponent = this.getComponentInst(currentSourceProfile.getComponentFatherId());
            spaceId = currentComponent.getDomainFatherId();
            spaceInst = this.getSpaceInstLight(this.getDriverSpaceId(spaceId));
            if (currentComponent.getStatus() != null || spaceInst.isPersonalSpace()) continue;
            switch (context.getTargetType()) {
                case USER: {
                    currentSourceProfile.addUser(context.getTargetId());
                    break;
                }
                case GROUP: {
                    currentSourceProfile.addGroup(context.getTargetId());
                }
            }
            this.updateProfileInst(currentSourceProfile, context.getAuthor(), false, context.getMode());
        }
    }

    private void deleteTargetProfiles(RightAssignationContext context, String[] spaceProfileIdsToDeleteForTarget, String[] componentProfileIdsForTarget) throws AdminException {
        for (String spaceProfileId : spaceProfileIdsToDeleteForTarget) {
            SpaceProfileInst currentTargetSpaceProfile = this.getSpaceProfileInst(spaceProfileId);
            SpaceInstLight spaceInst = this.getSpaceInstLight(this.getDriverSpaceId(currentTargetSpaceProfile.getSpaceFatherId()));
            if (spaceInst.isPersonalSpace()) continue;
            switch (context.getTargetType()) {
                case USER: {
                    currentTargetSpaceProfile.removeUser(context.getTargetId());
                    break;
                }
                case GROUP: {
                    currentTargetSpaceProfile.removeGroup(context.getTargetId());
                }
            }
            this.updateSpaceProfileInst(currentTargetSpaceProfile, context.getAuthor(), false);
        }
        for (String profileId : componentProfileIdsForTarget) {
            ProfileInst currentTargetProfile = this.getProfileInst(profileId);
            ComponentInst currentComponent = this.getComponentInst(currentTargetProfile.getComponentFatherId());
            String spaceId = currentComponent.getDomainFatherId();
            SpaceInstLight spaceInst = this.getSpaceInstLight(this.getDriverSpaceId(spaceId));
            if (currentComponent.getStatus() != null || spaceInst.isPersonalSpace()) continue;
            switch (context.getTargetType()) {
                case USER: {
                    currentTargetProfile.removeUser(context.getTargetId());
                    break;
                }
                case GROUP: {
                    currentTargetProfile.removeGroup(context.getTargetId());
                }
            }
            this.updateProfileInst(currentTargetProfile, context.getAuthor(), false, context.getMode());
        }
    }

    private void assignRightsFromSourceToTarget(RightAssignationContext context) throws AdminException {
        DomainDriverManager ddManager = DomainDriverManagerFactory.getCurrentDomainDriverManager();
        try {
            ddManager.startTransaction(false);
            if (context.areSourceAndTargetEqual()) {
                return;
            }
            String[] spaceProfileIdsToCopy = new String[]{};
            String[] componentProfileIdsToCopy = new String[]{};
            String[] componentObjectProfileIdsToCopy = new String[]{};
            String[] spaceProfileIdsToReplace = new String[]{};
            String[] componentProfileIdsToReplace = new String[]{};
            switch (context.getSourceType()) {
                case USER: {
                    spaceProfileIdsToCopy = this.getDirectSpaceProfileIdsOfUser(context.getSourceId());
                    componentProfileIdsToCopy = this.getDirectComponentProfileIdsOfUser(context.getSourceId());
                    if (!context.isAssignObjectRights()) break;
                    componentObjectProfileIdsToCopy = this.getComponentObjectProfileIdsOfUserType(context.getSourceId());
                    break;
                }
                case GROUP: {
                    spaceProfileIdsToCopy = this.getDirectSpaceProfileIdsOfGroup(context.getSourceId());
                    componentProfileIdsToCopy = this.getDirectComponentProfileIdsOfGroup(context.getSourceId());
                    if (!context.isAssignObjectRights()) break;
                    componentObjectProfileIdsToCopy = this.getComponentObjectProfileIdsOfGroupType(context.getSourceId());
                }
            }
            if (RightAssignationContext.MODE.REPLACE.equals((Object)context.getMode())) {
                switch (context.getTargetType()) {
                    case USER: {
                        spaceProfileIdsToReplace = this.getDirectSpaceProfileIdsOfUser(context.getTargetId());
                        componentProfileIdsToReplace = this.getDirectComponentProfileIdsOfUser(context.getTargetId());
                        break;
                    }
                    case GROUP: {
                        spaceProfileIdsToReplace = this.getDirectSpaceProfileIdsOfGroup(context.getTargetId());
                        componentProfileIdsToReplace = this.getDirectComponentProfileIdsOfGroup(context.getTargetId());
                    }
                }
            }
            this.deleteTargetProfiles(context, spaceProfileIdsToReplace, componentProfileIdsToReplace);
            this.addTargetProfiles(context, spaceProfileIdsToCopy, componentProfileIdsToCopy, componentObjectProfileIdsToCopy);
            ddManager.commit();
        }
        catch (Exception e) {
            try {
                ddManager.rollback();
                cache.resetCache();
            }
            catch (Exception e1) {
                SilverTrace.error("admin", "Admin.addSpaceInst", "root.EX_ERR_ROLLBACK", e1);
            }
            throw new AdminException("Admin.assignRightsFromSourceToTarget", 4, "admin.EX_ERR_ASSIGN_RIGHTS", e);
        }
        finally {
            ddManager.releaseOrganizationSchema();
        }
    }

    public void assignRightsFromUserToUser(RightAssignationContext.MODE operationMode, String sourceUserId, String targetUserId, boolean nodeAssignRights, String authorId) throws AdminException {
        RightAssignationContext context = this.initializeRightAssignationContext(operationMode, nodeAssignRights, authorId).fromUserId(sourceUserId).toUserId(targetUserId);
        this.assignRightsFromSourceToTarget(context);
    }

    public void assignRightsFromUserToGroup(RightAssignationContext.MODE operationMode, String sourceUserId, String targetGroupId, boolean nodeAssignRights, String authorId) throws AdminException {
        RightAssignationContext context = this.initializeRightAssignationContext(operationMode, nodeAssignRights, authorId).fromUserId(sourceUserId).toGroupId(targetGroupId);
        this.assignRightsFromSourceToTarget(context);
    }

    public void assignRightsFromGroupToUser(RightAssignationContext.MODE operationMode, String sourceGroupId, String targetUserId, boolean nodeAssignRights, String authorId) throws AdminException {
        RightAssignationContext context = this.initializeRightAssignationContext(operationMode, nodeAssignRights, authorId).fromGroupId(sourceGroupId).toUserId(targetUserId);
        this.assignRightsFromSourceToTarget(context);
    }

    public void assignRightsFromGroupToGroup(RightAssignationContext.MODE operationMode, String sourceGroupId, String targetGroupId, boolean nodeAssignRights, String authorId) throws AdminException {
        RightAssignationContext context = this.initializeRightAssignationContext(operationMode, nodeAssignRights, authorId).fromGroupId(sourceGroupId).toGroupId(targetGroupId);
        this.assignRightsFromSourceToTarget(context);
    }

    private RightAssignationContext initializeRightAssignationContext(RightAssignationContext.MODE operationMode, boolean nodeAssignRights, String authorId) {
        RightAssignationContext context;
        switch (operationMode) {
            default: {
                context = RightAssignationContext.copy();
                break;
            }
            case REPLACE: {
                context = RightAssignationContext.replace();
            }
        }
        if (!nodeAssignRights) {
            context.withoutAssigningComponentObjectRights();
        }
        return context.setAuthor(authorId);
    }

    public boolean isDomainManagerUser(String userId, String domainId) {
        UserDetail userDetail = null;
        try {
            userDetail = this.getUserDetail(userId);
        }
        catch (AdminException e) {
            SilverTrace.error("admin", "Admin.isDomainManagerUser", "cannot load user " + userId, e);
        }
        return userDetail != null && userDetail.getDomainId().equals(domainId) && UserAccessLevel.DOMAIN_ADMINISTRATOR.equals((Object)userDetail.getAccessLevel());
    }

    static {
        groupSynchroScheduler = null;
        domainSynchroScheduler = null;
        roleMapping = null;
        useProfileInheritance = false;
        cacheLoaded = false;
        ResourceLocator resources = new ResourceLocator("org.silverpeas.beans.admin.admin", "");
        roleMapping = new ResourceLocator("org.silverpeas.admin.roleMapping", "");
        useProfileInheritance = resources.getBoolean("UseProfileInheritance", false);
        m_nEntrepriseClientSpaceId = Integer.parseInt(resources.getString("EntrepriseClientSpaceId"));
        administratorMail = resources.getString("AdministratorEMail");
        m_sDAPIGeneralAdminId = resources.getString("DAPIGeneralAdminId");
        scheduledDBReset = new ScheduledDBReset();
        scheduledDBReset.initialize(resources.getString("DBConnectionResetScheduler", ""));
        shouldFallbackGroupNames = resources.getBoolean("FallbackGroupNames", true);
        shouldFallbackUserLogins = resources.getBoolean("FallbackUserLogins", false);
        m_domainSynchroCron = resources.getString("DomainSynchroCron", "* 4 * * *");
        m_groupSynchroCron = resources.getString("GroupSynchroCron", "* 5 * * *");
        delUsersOnDiffSynchro = resources.getBoolean("DelUsersOnThreadedSynchro", true);
        cache.setCacheAvailable(StringUtil.getBooleanValue(resources.getString("UseCache", "1")));
        componentInstanciator = new Instanciateur();
    }
}

