/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.webactiv.beans.admin;

import com.silverpeas.util.StringUtil;
import com.stratelia.webactiv.beans.admin.PaginationPage;
import com.stratelia.webactiv.beans.admin.SearchCriteria;
import java.util.HashMap;
import java.util.Map;
import org.silverpeas.admin.user.constant.UserAccessLevel;
import org.silverpeas.admin.user.constant.UserState;

public class GroupsSearchCriteria
implements SearchCriteria {
    private static final String USER_ACCESS_LEVELS = "userAccessLevels";
    private static final String USER_STATES_TO_EXCLUDE = "userStatesToExclude";
    private static final String GROUP_ID = "groupId";
    private static final String SUPERGROUP_ID = "parentId";
    private static final String ROLE_NAMES = "roleIds";
    private static final String DOMAIN_IDS = "domainIds";
    private static final String INSTANCE_ID = "instanceId";
    private static final String RESOURCE_ID = "resourceId";
    private static final String ROOT_GROUP = "mustBeRoot";
    private static final String NAME = "name";
    private static final String PAGINATION = "pagination";
    private Map<String, Object> criteria = new HashMap<String, Object>();

    @Override
    public GroupsSearchCriteria onName(String name) {
        if (StringUtil.isDefined(name)) {
            this.criteria.put(NAME, name);
        }
        return this;
    }

    @Override
    public GroupsSearchCriteria onComponentInstanceId(String instanceId) {
        if (StringUtil.isDefined(instanceId)) {
            this.criteria.put(INSTANCE_ID, instanceId);
        }
        return this;
    }

    @Override
    public GroupsSearchCriteria onRoleNames(String[] roleIds) {
        if (roleIds != null && roleIds.length > 0) {
            this.criteria.put(ROLE_NAMES, roleIds);
        }
        return this;
    }

    @Override
    public GroupsSearchCriteria onGroupIds(String ... groupIds) {
        if (groupIds != null && groupIds.length > 0) {
            this.criteria.put(GROUP_ID, groupIds);
        }
        return this;
    }

    public GroupsSearchCriteria onAsRootGroup() {
        this.criteria.put(ROOT_GROUP, true);
        return this;
    }

    public GroupsSearchCriteria onSuperGroupId(String superGroupId) {
        if (StringUtil.isDefined(superGroupId)) {
            this.criteria.put(SUPERGROUP_ID, superGroupId);
        }
        return this;
    }

    @Override
    public GroupsSearchCriteria onDomainId(String domainId) {
        if (StringUtil.isDefined(domainId)) {
            this.criteria.put(DOMAIN_IDS, new String[]{domainId});
        }
        return this;
    }

    @Override
    public GroupsSearchCriteria onAccessLevels(UserAccessLevel ... accessLevels) {
        this.criteria.put(USER_ACCESS_LEVELS, accessLevels);
        return this;
    }

    @Override
    public SearchCriteria onUserStatesToExclude(UserState ... userStates) {
        this.criteria.put(USER_STATES_TO_EXCLUDE, userStates);
        return null;
    }

    public GroupsSearchCriteria onMixedDomainOrOnDomainId(String domainId) {
        if (StringUtil.isDefined(domainId)) {
            this.criteria.put(DOMAIN_IDS, new String[]{"-1", domainId});
        } else {
            this.criteria.put(DOMAIN_IDS, new String[]{"-1"});
        }
        return this;
    }

    public boolean isCriterionOnRoleNamesSet() {
        return this.criteria.containsKey(ROLE_NAMES);
    }

    public boolean isCriterionOnResourceIdSet() {
        return this.criteria.containsKey(RESOURCE_ID);
    }

    public boolean isCriterionOnComponentInstanceIdSet() {
        return this.criteria.containsKey(INSTANCE_ID);
    }

    public boolean isCriterionOnSuperGroupIdSet() {
        return this.criteria.containsKey(SUPERGROUP_ID);
    }

    public boolean isCriterionOnGroupIdsSet() {
        return this.criteria.containsKey(GROUP_ID);
    }

    public boolean isCriterionOnDomainIdSet() {
        return this.criteria.containsKey(DOMAIN_IDS);
    }

    public boolean isCriterionOnAccessLevelsSet() {
        return this.criteria.containsKey(USER_ACCESS_LEVELS);
    }

    public boolean isCriterionOnUserStatesToExcludeSet() {
        return this.criteria.containsKey(USER_STATES_TO_EXCLUDE);
    }

    public boolean isCriterionOnMixedDomainIdSet() {
        String[] domainIds;
        for (String domainId : domainIds = (String[])this.criteria.get(DOMAIN_IDS)) {
            if (!domainId.equals("-1")) continue;
            return true;
        }
        return false;
    }

    public boolean isCriterionOnNameSet() {
        return this.criteria.containsKey(NAME);
    }

    public boolean isCriterionOnPaginationSet() {
        return this.criteria.containsKey(PAGINATION);
    }

    public boolean mustBeRoot() {
        return this.criteria.containsKey(ROOT_GROUP);
    }

    public String[] getCriterionOnRoleNames() {
        return (String[])this.criteria.get(ROLE_NAMES);
    }

    public String getCriterionOnResourceId() {
        return (String)this.criteria.get(RESOURCE_ID);
    }

    public String getCriterionOnComponentInstanceId() {
        return (String)this.criteria.get(INSTANCE_ID);
    }

    public String getCriterionOnSuperGroupId() {
        return (String)this.criteria.get(SUPERGROUP_ID);
    }

    public String[] getCriterionOnGroupIds() {
        return (String[])this.criteria.get(GROUP_ID);
    }

    public String getCriterionOnDomainId() {
        String[] domainIds = (String[])this.criteria.get(DOMAIN_IDS);
        if (domainIds != null) {
            if (domainIds.length == 2) {
                return domainIds[1];
            }
            if (!domainIds[0].equals("-1")) {
                return domainIds[0];
            }
        }
        return null;
    }

    public UserAccessLevel[] getCriterionOnAccessLevels() {
        return (UserAccessLevel[])this.criteria.get(USER_ACCESS_LEVELS);
    }

    public UserState[] getCriterionOnUserStatesToExclude() {
        return (UserState[])this.criteria.get(USER_STATES_TO_EXCLUDE);
    }

    public String getCriterionOnName() {
        return (String)this.criteria.get(NAME);
    }

    public PaginationPage getCriterionOnPagination() {
        return (PaginationPage)this.criteria.get(PAGINATION);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GroupsSearchCriteria other = (GroupsSearchCriteria)obj;
        return this.criteria == other.criteria || this.criteria != null && ((Object)this.criteria).equals(other.criteria);
    }

    public int hashCode() {
        int hash = 5;
        hash = 53 * hash + (this.criteria != null ? ((Object)this.criteria).hashCode() : 0);
        return hash;
    }

    @Override
    public SearchCriteria and() {
        return this;
    }

    @Override
    public SearchCriteria or() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isEmpty() {
        return this.criteria.isEmpty();
    }

    @Override
    public SearchCriteria onUserIds(String ... userIds) {
        return this;
    }

    @Override
    public SearchCriteria onResourceId(String resourceId) {
        if (StringUtil.isDefined(resourceId)) {
            this.criteria.put(RESOURCE_ID, resourceId);
        }
        return this;
    }

    @Override
    public SearchCriteria onPagination(PaginationPage page) {
        this.criteria.put(PAGINATION, page);
        return this;
    }
}

