/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.webactiv.beans.admin;

import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.util.DBUtil;
import com.stratelia.webactiv.util.ResourceLocator;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

public class SQLRequest {
    private ArrayList<String> dbName = new ArrayList();
    private static String dbServerName;
    private String fullPathName;
    Hashtable<String, String> internalTag = new Hashtable();
    private String allQueries;
    private ResourceLocator resourceLocation = new ResourceLocator();

    public SQLRequest(String fullPathName, String dbServerName) {
        this.init();
        SQLRequest.dbServerName = this.dbName.contains(dbServerName) ? dbServerName : "default";
        this.fullPathName = fullPathName;
    }

    public SQLRequest(String fullPathName) {
        this(fullPathName, "default");
    }

    public SQLRequest() {
        this("com.stratelia.webactiv.util.node", "default");
    }

    protected void setCreateQueries() {
        this.resourceLocation.setPropertyLocation(this.fullPathName + "." + dbServerName + "_create", "fr");
        this.allQueries = this.resourceLocation.getString("cle");
    }

    protected void setDeleteQueries() {
        this.resourceLocation.setPropertyLocation(this.fullPathName + "." + dbServerName + "_delete", "fr");
        this.allQueries = this.resourceLocation.getString("cle");
    }

    protected void setInsertQueries() {
        this.resourceLocation.setPropertyLocation(this.fullPathName + "." + dbServerName + "_insert", "fr");
        this.allQueries = this.resourceLocation.getString("cle");
    }

    protected void setUpdateQueries() {
        this.resourceLocation.setPropertyLocation(this.fullPathName + "." + dbServerName + "_update", "fr");
        this.allQueries = this.resourceLocation.getString("cle");
    }

    protected String getCreateQuery(String tableName, String tableType) {
        SilverTrace.info("peasCore", "SQLRequest.getCreateQuery", "root.MSG_GEN_PARAM_VALUE", "tableName=" + tableName + " | tableType=" + tableType);
        this.internalTag.put("__tableName__", tableName);
        return this.substituteInternalTag(this.getSubQuery(tableType));
    }

    protected String getDeleteQuery(String instanceId, String tableType) {
        this.internalTag.put("__ID__", instanceId);
        return this.substituteInternalTag(this.getSubQuery(tableType));
    }

    protected String getUpdateQuery(String instanceId, String tableType) {
        SilverTrace.info("peasCore", "SQLRequest.getUpdateQuery", "root.MSG_GEN_PARAM_VALUE", "instanceId=" + instanceId + " | tableType=" + tableType);
        this.internalTag.put("__ID__", instanceId);
        return this.substituteInternalTag(this.getSubQuery(tableType));
    }

    protected String getInsertQuery(String instanceId, String tableType) {
        SilverTrace.info("peasCore", "SQLRequest.getInsertQuery", "root.MSG_GEN_PARAM_VALUE", "instanceId=" + instanceId + " | tableType=" + tableType);
        this.internalTag.put("__ID__", instanceId);
        return this.substituteInternalTag(this.getSubQuery(tableType));
    }

    private void init() {
        this.dbName.add("oracle");
        this.dbName.add("postgreSQL");
        this.dbName.add("SQLserver");
        this.internalTag.put("__TextFieldLength__", String.valueOf(DBUtil.getTextFieldLength()));
        this.internalTag.put("__TextAreaLength__", String.valueOf(DBUtil.getTextAreaLength()));
        this.internalTag.put("__DateFieldLength__", String.valueOf(DBUtil.getDateFieldLength()));
        this.internalTag.put("__TextMaxiLength__", String.valueOf(DBUtil.getTextMaxiLength()));
    }

    private String substituteInternalTag(String localQuery) {
        String queryBeforeTag = "";
        String queryAfterTag = "";
        Enumeration<String> e = this.internalTag.keys();
        while (e.hasMoreElements()) {
            String currentTag = e.nextElement();
            int posTag = localQuery.indexOf(currentTag);
            while (posTag != -1) {
                int endPosition = posTag + currentTag.length();
                queryBeforeTag = localQuery.substring(0, posTag);
                queryAfterTag = localQuery.substring(endPosition);
                localQuery = queryBeforeTag + this.internalTag.get(currentTag) + queryAfterTag;
                posTag = localQuery.indexOf(currentTag);
            }
        }
        SilverTrace.info("peasCore", "SQLRequest.substituteInternalTag", "root.MSG_GEN_PARAM_VALUE", "RequestResult=" + localQuery);
        return localQuery;
    }

    private String getSubQuery(String tableType) {
        int endTableType;
        int beginTableType = this.allQueries.indexOf("<" + tableType.toUpperCase() + ">") + tableType.length() + 2;
        if (beginTableType >= (endTableType = this.allQueries.indexOf("</" + tableType.toUpperCase() + ">"))) {
            SilverTrace.warn("peasCore", "SQLRequest.getSubQuery", "root.MSG_GEN_PARAM_VALUE", "begin(" + beginTableType + ") >= end(" + endTableType + ")");
            this.allQueries.indexOf("<BONUSTABLE>");
            return null;
        }
        String localQuery = this.allQueries.substring(beginTableType, endTableType);
        SilverTrace.info("peasCore", "SQLRequest.getSubQuery", "root.MSG_GEN_PARAM_VALUE", "RequestResult=" + localQuery);
        return localQuery;
    }
}

