/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.webactiv.beans.admin;

import com.silverpeas.util.StringUtil;
import com.silverpeas.util.i18n.AbstractI18NBean;
import com.stratelia.webactiv.beans.admin.SpaceI18N;
import com.stratelia.webactiv.beans.admin.SpaceInst;
import com.stratelia.webactiv.organization.SpaceRow;
import com.stratelia.webactiv.util.GeneralPropertiesManager;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;

public class SpaceInstLight
extends AbstractI18NBean<SpaceI18N>
implements Serializable,
Comparable<SpaceInstLight> {
    private static final long serialVersionUID = 8772050454345960478L;
    private String id = null;
    private int orderNum = 0;
    private int level = -1;
    private String fatherId = null;
    private Date createDate = null;
    private Date updateDate = null;
    private Date removeDate = null;
    private String status = null;
    private int createdBy = -1;
    private int updatedBy = -1;
    private int removedBy = -1;
    private String creatorName = null;
    private String updaterName = null;
    private String removerName = null;
    private String look = null;
    private List<SpaceInstLight> path = null;
    private boolean displaySpaceFirst = true;
    private boolean isPersonalSpace = false;
    private boolean inheritanceBlocked = false;

    public SpaceInstLight() {
        this.id = "";
        this.fatherId = "";
        this.orderNum = 0;
        this.level = -1;
        this.displaySpaceFirst = true;
        this.isPersonalSpace = false;
        this.inheritanceBlocked = false;
    }

    public SpaceInstLight(SpaceRow spaceRow) {
        if (spaceRow != null) {
            this.setId(spaceRow.id);
            this.setName(spaceRow.name);
            this.setFatherId(spaceRow.domainFatherId);
            this.setDescription(spaceRow.description);
            this.orderNum = spaceRow.orderNum;
            if (spaceRow.createTime != null) {
                this.createDate = new Date(Long.parseLong(spaceRow.createTime));
            }
            if (spaceRow.updateTime != null) {
                this.updateDate = new Date(Long.parseLong(spaceRow.updateTime));
            }
            if (spaceRow.removeTime != null) {
                this.removeDate = new Date(Long.parseLong(spaceRow.removeTime));
            }
            this.status = spaceRow.status;
            this.createdBy = spaceRow.createdBy;
            this.updatedBy = spaceRow.updatedBy;
            this.removedBy = spaceRow.removedBy;
            this.look = spaceRow.look;
            this.displaySpaceFirst = spaceRow.displaySpaceFirst == 1;
            this.isPersonalSpace = spaceRow.isPersonalSpace == 1;
            this.inheritanceBlocked = spaceRow.inheritanceBlocked == 1;
        }
    }

    public SpaceInstLight(SpaceInst spaceInst) {
        if (spaceInst != null) {
            this.setId(spaceInst.getId());
            this.setName(spaceInst.getName());
            this.setFatherId(spaceInst.getDomainFatherId());
            this.setDescription(spaceInst.getDescription());
            this.orderNum = spaceInst.getOrderNum();
            this.setLevel(spaceInst.getLevel());
            this.createDate = spaceInst.getCreateDate();
            this.updateDate = spaceInst.getUpdateDate();
            this.removeDate = spaceInst.getRemoveDate();
            this.status = spaceInst.getStatus();
            this.look = spaceInst.getLook();
            this.setTranslations(spaceInst.getTranslations());
            this.displaySpaceFirst = spaceInst.isDisplaySpaceFirst();
            this.isPersonalSpace = spaceInst.isPersonalSpace();
            this.inheritanceBlocked = spaceInst.isInheritanceBlocked();
        }
    }

    public String getShortId() {
        return this.id;
    }

    public String getFullId() {
        return "WA" + this.getShortId();
    }

    public String getFatherId() {
        return this.fatherId;
    }

    public int getLevel() {
        return this.level;
    }

    @Override
    public String getName(String language) {
        if (this.isPersonalSpace) {
            return GeneralPropertiesManager.getGeneralMultilang(language).getString("GML.personalSpace", "Mon espace");
        }
        return super.getName(language);
    }

    public void setFatherId(int fatherId) {
        this.fatherId = Integer.toString(fatherId);
    }

    public void setFatherId(String fatherId) {
        this.fatherId = fatherId;
    }

    public void setId(int id) {
        this.id = Integer.toString(id);
    }

    public void setId(String id) {
        if (StringUtil.isDefined(id) && id.startsWith("WA")) {
            id = id.substring(2);
        }
        this.id = id;
    }

    public void setLevel(int i) {
        this.level = i;
    }

    public boolean isRoot() {
        return SpaceInstLight.isRoot(this.getFatherId());
    }

    public static boolean isRoot(String spaceId) {
        return "0".equals(spaceId);
    }

    public int getOrderNum() {
        return this.orderNum;
    }

    public void setOrderNum(int orderNum) {
        this.orderNum = orderNum;
    }

    public Date getCreateDate() {
        return this.createDate;
    }

    public Date getRemoveDate() {
        return this.removeDate;
    }

    public String getStatus() {
        return this.status;
    }

    public Date getUpdateDate() {
        return this.updateDate;
    }

    public String getCreatorName() {
        return this.creatorName;
    }

    public void setCreatorName(String creatorName) {
        this.creatorName = creatorName;
    }

    public String getRemoverName() {
        return this.removerName;
    }

    public void setRemoverName(String removerName) {
        this.removerName = removerName;
    }

    public String getUpdaterName() {
        return this.updaterName;
    }

    public void setUpdaterName(String updaterName) {
        this.updaterName = updaterName;
    }

    public int getCreatedBy() {
        return this.createdBy;
    }

    public int getRemovedBy() {
        return this.removedBy;
    }

    public int getUpdatedBy() {
        return this.updatedBy;
    }

    @Override
    public int compareTo(SpaceInstLight o) {
        return this.getOrderNum() - o.getOrderNum();
    }

    public String getPath(String separator) {
        String sPath = "";
        if (this.path != null) {
            SpaceInstLight space = null;
            for (int i = 0; i < this.path.size(); ++i) {
                if (i > 0) {
                    sPath = sPath + separator;
                }
                space = this.path.get(i);
                sPath = sPath + space.getName();
            }
        }
        return sPath;
    }

    public void setPath(List<SpaceInstLight> path) {
        this.path = path;
    }

    public String getLook() {
        return this.look;
    }

    public void setLook(String look) {
        this.look = look;
    }

    public boolean isDisplaySpaceFirst() {
        return this.displaySpaceFirst;
    }

    public void setDisplaySpaceFirst(boolean displaySpaceFirst) {
        this.displaySpaceFirst = displaySpaceFirst;
    }

    public boolean isPersonalSpace() {
        return this.isPersonalSpace;
    }

    public void setPersonalSpace(boolean isPersonalSpace) {
        this.isPersonalSpace = isPersonalSpace;
    }

    public boolean isInheritanceBlocked() {
        return this.inheritanceBlocked;
    }

    public void setInheritanceBlocked(boolean isInheritanceBlocked) {
        this.inheritanceBlocked = isInheritanceBlocked;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SpaceInstLight other = (SpaceInstLight)obj;
        return ObjectUtils.equals((Object)this.getFullId(), (Object)other.getFullId());
    }
}

