/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.webactiv.organization;

import com.silverpeas.admin.components.Parameter;
import com.silverpeas.util.i18n.I18NHelper;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.organization.AdminPersistenceException;
import com.stratelia.webactiv.organization.InstanceDataRow;
import com.stratelia.webactiv.organization.OrganizationSchema;
import com.stratelia.webactiv.organization.Table;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class InstanceDataTable
extends Table<InstanceDataRow> {
    private static final String INSTANCEDATA_COLUMNS = "id,componentId,name,label,value";
    private static final String SELECT_ALL_COMPONENTS_BY_PARAMETER_VALUE = "select id,componentId,name,label,value from ST_Instance_Data where name = ? and value = ? order by id";
    private static final String INSERT_INSTANCEDATA = "insert into ST_Instance_Data(id,componentId,name,label,value) values (?,?,?,?,?)";
    private static final String SELECT_INSTANCEDATA_BY_ID = "select id,componentId,name,label,value from ST_Instance_Data where id = ?";
    private static final String SELECT_ALL_COMPONENT_PARAMETERS = "select id,componentId,name,label,value from ST_Instance_Data where componentId = ? order by id";
    private static final String UPDATE_INSTANCEDATA = "UPDATE ST_Instance_Data SET value = ? where componentId = ? and name = ?";
    private static final String REMOVE_INSTANCEDATA = "delete from ST_Instance_Data where componentid = ?";

    public InstanceDataTable(OrganizationSchema organization) {
        super(organization, "ST_Instance_Data");
    }

    protected InstanceDataRow fetchUserSet(ResultSet rs) throws SQLException {
        InstanceDataRow idr = new InstanceDataRow();
        idr.id = rs.getInt(1);
        idr.componentId = rs.getInt(2);
        idr.name = rs.getString(3);
        idr.label = rs.getString(4);
        idr.value = rs.getString(5);
        return idr;
    }

    public void createInstanceData(int componentId, Parameter parameter) throws AdminPersistenceException, SQLException {
        SilverTrace.info("admin", "InstanceDataTable.createInstanceData", "root.MSG_GEN_PARAM_VALUE", "componentId = " + componentId + ", parameter = " + parameter.toString());
        InstanceDataRow idr = new InstanceDataRow();
        idr.id = this.getNextId();
        idr.componentId = componentId;
        idr.name = parameter.getName();
        idr.label = parameter.getLabel().get(I18NHelper.defaultLanguage);
        idr.value = parameter.getValue();
        this.insertRow(INSERT_INSTANCEDATA, idr);
    }

    public InstanceDataRow getInstanceData(int id) throws AdminPersistenceException {
        return (InstanceDataRow)this.getUniqueRow(SELECT_INSTANCEDATA_BY_ID, id);
    }

    @Override
    protected void prepareInsert(String insertQuery, PreparedStatement insert, InstanceDataRow row) throws SQLException {
        insert.setInt(1, row.id);
        insert.setInt(2, row.componentId);
        insert.setString(3, row.name);
        insert.setString(4, row.label);
        insert.setString(5, row.value);
    }

    public List<Parameter> getAllParametersInComponent(int componentId) throws AdminPersistenceException {
        List rows = this.getRows(SELECT_ALL_COMPONENT_PARAMETERS, componentId);
        ArrayList<Parameter> params = new ArrayList<Parameter>();
        for (InstanceDataRow row : rows) {
            Parameter param = new Parameter();
            param.setName(row.name);
            param.setValue(row.value);
            HashMap<String, String> multilang = new HashMap<String, String>();
            multilang.put(I18NHelper.defaultLanguage, row.label);
            param.setLabel(multilang);
            params.add(param);
        }
        return params;
    }

    public void updateInstanceData(int componentId, Parameter parameter) throws AdminPersistenceException, SQLException {
        InstanceDataRow idr = new InstanceDataRow();
        idr.componentId = componentId;
        idr.name = parameter.getName();
        idr.value = parameter.getValue();
        int nbRowUpdated = this.updateRow(UPDATE_INSTANCEDATA, idr);
        if (nbRowUpdated < 1) {
            this.createInstanceData(componentId, parameter);
        }
    }

    public void removeInstanceData(int id) throws AdminPersistenceException {
        this.updateRelation(REMOVE_INSTANCEDATA, id);
    }

    @Override
    protected InstanceDataRow fetchRow(ResultSet rs) throws SQLException {
        return this.fetchInstanceData(rs);
    }

    protected InstanceDataRow fetchInstanceData(ResultSet rs) throws SQLException {
        InstanceDataRow idr = new InstanceDataRow();
        idr.id = rs.getInt(1);
        idr.componentId = rs.getInt(2);
        idr.name = rs.getString(3);
        idr.label = rs.getString(4);
        idr.value = rs.getString(5);
        return idr;
    }

    @Override
    protected void prepareUpdate(String updateQuery, PreparedStatement update, InstanceDataRow row) throws SQLException {
        update.setString(1, row.value);
        update.setInt(2, row.componentId);
        update.setString(3, row.name);
    }

    public List<String> getComponentIdsWithParameterValue(Parameter param) throws AdminPersistenceException {
        ArrayList<String> queryParams = new ArrayList<String>();
        queryParams.add(param.getName());
        queryParams.add(param.getValue());
        List rows = this.getRows(SELECT_ALL_COMPONENTS_BY_PARAMETER_VALUE, queryParams);
        ArrayList<String> ids = new ArrayList<String>();
        for (InstanceDataRow row : rows) {
            ids.add(Integer.toString(row.componentId));
        }
        return ids;
    }
}

