/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.webactiv.util;

import com.stratelia.webactiv.util.ResourceLocator;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;

public class GeneralPropertiesManager {
    public static final int DVIS_ALL = 0;
    public static final int DVIS_ONE = 1;
    public static final int DVIS_EACH = 2;
    public static final String GENERAL_PROPERTIES_FILE = "org.silverpeas.multilang.generalMultilang";
    static final ResourceLocator generalProperties = new ResourceLocator("org.silverpeas.general", "");
    static int dvis = Integer.parseInt(generalProperties.getString("domainVisibility", "0"));
    static final Map<String, Collection<String>> listProperties = new HashMap<String, Collection<String>>();

    @Deprecated
    public static ResourceLocator getGeneralResourceLocator() {
        return generalProperties;
    }

    public static int getInteger(String property, int defaultValue) {
        return generalProperties.getInteger(property, defaultValue);
    }

    public static String getString(String property, String defaultValue) {
        return generalProperties.getString(property, defaultValue);
    }

    public static String getString(String property) {
        return generalProperties.getString(property);
    }

    public static boolean getBoolean(String property, boolean defaultValue) {
        return generalProperties.getBoolean(property, defaultValue);
    }

    public static Collection<String> getStringCollection(String property) {
        return GeneralPropertiesManager.getStringCollection(property, "[ ,;]");
    }

    public static Collection<String> getStringCollection(String property, String regexValueSeparator) {
        Collection<String> propertyValues = listProperties.get(property);
        if (propertyValues == null) {
            propertyValues = new LinkedHashSet<String>();
            listProperties.put(property, propertyValues);
            String stringValues = generalProperties.getString(property, null);
            if (stringValues != null && !"".equals(stringValues.trim())) {
                for (String value : stringValues.split(regexValueSeparator)) {
                    if (value == null || "".equals(value.trim())) continue;
                    propertyValues.add(value.trim());
                }
            }
        }
        return propertyValues;
    }

    public static int getDomainVisibility() {
        return dvis;
    }

    public static ResourceLocator getGeneralMultilang(String language) {
        return new ResourceLocator(GENERAL_PROPERTIES_FILE, language);
    }

    private GeneralPropertiesManager() {
    }
}

