/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.webactiv.util;

import com.silverpeas.util.ConfigurationClassLoader;
import com.silverpeas.util.StringUtil;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.silverpeas.util.ResourceBundleWrapper;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;

public class ResourceLocator
implements Serializable {
    private static final long serialVersionUID = -2389291572691404932L;
    private static ClassLoader loader = new ConfigurationClassLoader(ResourceLocator.class.getClassLoader());
    static final String DEFAULT_EXTENSION = ".properties";
    private String propertyFile = null;
    private Locale propertyLocale = null;
    private ResourceLocator defaultResource = null;

    public ResourceLocator() {
    }

    public ResourceLocator(String propertyFile, String language) {
        this(propertyFile, language, null);
    }

    public ResourceLocator(String propertyFile, String language, ResourceLocator defaultResource) {
        this.defaultResource = defaultResource;
        this.propertyFile = propertyFile;
        this.propertyLocale = StringUtil.isDefined(language) ? new Locale(language) : Locale.getDefault();
    }

    public ResourceLocator(String sPropertyFile, Locale sLocale) {
        this.propertyFile = sPropertyFile;
        this.propertyLocale = sLocale != null ? sLocale : Locale.getDefault();
    }

    public void setPropertyLocation(String sPropertyFile, String sLanguage) {
        this.propertyFile = sPropertyFile;
        this.propertyLocale = sLanguage != null ? new Locale(sLanguage) : Locale.getDefault();
    }

    public void setLanguage(String sLanguage) {
        this.propertyLocale = sLanguage != null ? new Locale(sLanguage) : Locale.getDefault();
    }

    private ResourceBundle getResourceBundle(String sPropertyFile, Locale locale) {
        return new ResourceBundleWrapper(sPropertyFile, this.propertyLocale);
    }

    public String getString(String sAttribut) {
        ResourceBundle bundle = this.getResourceBundle(this.propertyFile, this.propertyLocale);
        try {
            if (!bundle.containsKey(sAttribut) && this.defaultResource != null) {
                return this.defaultResource.getString(sAttribut);
            }
            return bundle.getString(sAttribut);
        }
        catch (MissingResourceException msrex) {
            SilverTrace.warn("util", "ResourceLocator.getString", "util.MSG_NO_ATTR_VALUE", "File : " + this.propertyFile + " | Attribut : " + sAttribut, msrex);
            return null;
        }
    }

    public String getString(String sAttribut, String defaultValue) {
        String sReturn = this.getString(sAttribut);
        if (!StringUtil.isDefined(sReturn)) {
            sReturn = defaultValue;
        }
        return sReturn;
    }

    public boolean getBoolean(String sAttribut, boolean defaultValue) {
        String value = this.getString(sAttribut);
        if (value == null || value.trim().isEmpty()) {
            return defaultValue;
        }
        return StringUtil.getBooleanValue(value);
    }

    public long getLong(String sAttribute, long defaultValue) {
        String value = this.getString(sAttribute);
        if (value == null || value.trim().isEmpty() && !StringUtil.isLong(value)) {
            return defaultValue;
        }
        return Long.parseLong(value);
    }

    public float getFloat(String sAttribute, float defaultValue) {
        String value = this.getString(sAttribute);
        if (value == null || value.trim().isEmpty() && !StringUtil.isFloat(value)) {
            return defaultValue;
        }
        return Float.parseFloat(value);
    }

    public int getInteger(String sAttribute, int defaultValue) {
        String value = this.getString(sAttribute);
        if (value == null || value.trim().isEmpty() && !StringUtil.isInteger(value)) {
            return defaultValue;
        }
        return Integer.parseInt(value);
    }

    public String getStringWithParam(String resName, String param) {
        String[] params = new String[]{param};
        return this.getStringWithParams(resName, params);
    }

    public String getStringWithParams(String resName, String[] params) {
        String theSt = this.getString(resName);
        if (theSt != null) {
            StringBuilder theResult = new StringBuilder();
            int theStarIndex = -1;
            int theParamIndex = 0;
            int thePreviousIndex = 0;
            theStarIndex = theSt.indexOf(42);
            while (theStarIndex >= 0 && theParamIndex < params.length) {
                theResult.append(theSt.substring(thePreviousIndex, theStarIndex));
                theResult.append(params[theParamIndex++]);
                thePreviousIndex = theStarIndex + 1;
                if (thePreviousIndex < theSt.length()) {
                    theStarIndex = theSt.indexOf(42, thePreviousIndex);
                    continue;
                }
                theStarIndex = -1;
            }
            theResult.append(theSt.substring(thePreviousIndex));
            return theResult.toString();
        }
        return null;
    }

    public String[] getStringArray(String propNamePrefix, String propNameSufix, int max) {
        ArrayList<String> valret = new ArrayList<String>();
        for (int i = 1; i <= max || max == -1; ++i) {
            String s = this.getString(propNamePrefix + Integer.toString(i) + propNameSufix, null);
            if (s != null) {
                valret.add(s);
                continue;
            }
            if (max == -1) {
                max = i;
                continue;
            }
            valret.add("");
        }
        return valret.toArray(new String[valret.size()]);
    }

    public Enumeration<String> getKeys() {
        ResourceBundle bundle = this.getResourceBundle(this.propertyFile, this.propertyLocale);
        return bundle.getKeys();
    }

    public ResourceBundle getResourceBundle() {
        return this.getResourceBundle(this.propertyFile, this.propertyLocale);
    }

    public Properties getProperties() {
        ResourceBundle bundle = this.getResourceBundle(this.propertyFile, this.propertyLocale);
        Properties props = this.defaultResource != null ? new Properties(this.defaultResource.getProperties()) : new Properties();
        Enumeration<String> keys = bundle.getKeys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            props.setProperty(key, bundle.getString(key));
        }
        return props;
    }

    public String getLanguage() {
        return this.propertyLocale.getLanguage();
    }

    public static void resetResourceLocator() {
        SilverTrace.info("util", "ResourceLocator.resetResourceLocator", "root.MSG_GEN_ENTER_METHOD", "Reset Cache Resource Locator");
        ResourceBundle.clearCache();
    }

    public static URL getResource(Object object, Locale loc, String configFile, String extension) {
        URL url;
        String ext = extension;
        if (ext == null) {
            ext = DEFAULT_EXTENSION;
        }
        if (!ext.startsWith(".")) {
            ext = '.' + ext;
        }
        if ((url = ResourceLocator.locateResource(object, loc, configFile, ext)) == null && loc != null && (url = ResourceLocator.locateResource(object, null, configFile, ext)) == null && object != null && (url = object.getClass().getResource(configFile)) == null) {
            url = object.getClass().getResource(configFile + ext);
        }
        return url;
    }

    public static InputStream getResourceAsStream(Object object, Locale loc, String configFile, String extension) {
        String fileExtension = extension;
        if (extension == null) {
            fileExtension = DEFAULT_EXTENSION;
        }
        if (!fileExtension.startsWith(".")) {
            fileExtension = '.' + fileExtension;
        }
        SilverTrace.debug("util", "ResourceLocator.getResourceAsStream", "Starting with args:Object = " + object + ", loc=" + loc + ", ConfigFile=" + configFile + ", extension=" + fileExtension);
        InputStream inputStream = ResourceLocator.locateResourceAsStream(object, loc, configFile, fileExtension);
        if (inputStream == null) {
            if (loc != null) {
                inputStream = ResourceLocator.locateResourceAsStream(object, null, configFile, fileExtension);
            }
            if (inputStream == null && object != null) {
                SilverTrace.debug("util", "ResourceLocator.getResourceAsStream", "Calling getClass for object '" + object + "'");
                Class<?> clazz = object.getClass();
                SilverTrace.debug("util", "ResourceLocator.getResourceAsStream", "calling getResourceAsStream(" + configFile + ")");
                inputStream = clazz.getResourceAsStream(configFile);
                if (inputStream == null) {
                    String extendedFile = configFile + fileExtension;
                    SilverTrace.debug("util", "ResourceLocator.getResourceAsStream", "calling getResourceAsStream(" + extendedFile + ")");
                    inputStream = clazz.getResourceAsStream(extendedFile);
                    if (inputStream == null && (inputStream = ResourceLocator.loadResourceAsStream(configFile, extendedFile, clazz.getClassLoader())) == null) {
                        SilverTrace.debug("util", "ResourceLocator.getResourceAsStream", "calling getSystemResourceAsStream", extendedFile);
                        inputStream = ClassLoader.getSystemResourceAsStream(extendedFile);
                        if (inputStream == null) {
                            SilverTrace.debug("util", "ResourceLocator.getResourceAsStream", "resource not found. Trying doPriviledged(" + extendedFile + ")" + inputStream);
                            inputStream = ResourceLocator.getPrivileged(clazz.getClassLoader(), extendedFile);
                        }
                    }
                }
            }
        }
        SilverTrace.debug("util", "ResourceLocator.getResourceAsStream", "returning " + inputStream);
        return inputStream;
    }

    private static InputStream loadResourceAsStream(String configFile, String extendedFile, ClassLoader loader) {
        InputStream inputStream = loader.getResourceAsStream(configFile);
        if (inputStream == null) {
            inputStream = loader.getResourceAsStream(extendedFile);
        }
        return inputStream;
    }

    private static URL locateResource(Object o, Locale loc, String ConfigFile, String Extension) {
        Locale lloc = loc == null ? Locale.getDefault() : loc;
        String lang = lloc.getLanguage();
        String var = lloc.getVariant();
        String country = lloc.getCountry();
        URL u = ResourceLocator.locateResource(o, ConfigFile, Extension, lang, country, var);
        return u;
    }

    private static InputStream locateResourceAsStream(Object o, Locale loc, String configFile, String extension) {
        Locale lloc = loc == null ? Locale.getDefault() : loc;
        String lang = lloc.getLanguage();
        String var = lloc.getVariant();
        String country = lloc.getCountry();
        InputStream is = ResourceLocator.locateResourceAsStream(o, configFile, extension, lang, country, var);
        return is;
    }

    private static URL locateResource(Object object, String configFile, String extension, String lang, String country, String var) {
        Class<?> clazz;
        URL url = null;
        boolean vardone = false;
        if (object != null && (clazz = object.getClass()) != null) {
            String fileName = configFile + "_" + lang + "_" + country;
            if (StringUtil.isDefined(var)) {
                fileName = fileName + "_" + var;
                vardone = true;
            }
            if ((url = clazz.getResource(fileName)) == null && (url = clazz.getResource(fileName = fileName + extension)) == null) {
                if (vardone) {
                    fileName = configFile + "_" + lang + "_" + country;
                    url = clazz.getResource(fileName);
                    if (url == null) {
                        fileName = fileName + extension;
                        url = clazz.getResource(fileName);
                    }
                    if (url != null) {
                        return url;
                    }
                }
                if ((url = clazz.getResource(fileName = configFile + "_" + lang)) == null) {
                    fileName = fileName + extension;
                    url = clazz.getResource(fileName);
                }
            }
        }
        return url;
    }

    private static InputStream locateResourceAsStream(Object o, String configFile, String fileExtension, String lang, String country, String var) {
        InputStream is;
        SilverTrace.debug("util", "ResourceLocator.locateResourceAsStream", "Starting with args:Object = " + o + ", ConfigFile=" + configFile + ", extension=" + fileExtension + ", lang=" + lang + ", country=" + country + ", var =" + var);
        if (o == null) {
            SilverTrace.debug("util", "ResourceLocator.locateResourceAsStream", "o is null. returning immediately.");
            return null;
        }
        Class<?> clazz = o.getClass();
        if (clazz == null) {
            SilverTrace.debug("util", "ResourceLocator.locateResourceAsStream", "getClass() returned null");
            return null;
        }
        boolean vardone = false;
        String fileName = configFile + "_" + lang;
        if (StringUtil.isDefined(country)) {
            fileName = fileName + "_" + country;
            if (StringUtil.isDefined(var)) {
                fileName = fileName + "_" + var;
                vardone = true;
            }
        } else {
            SilverTrace.debug("util", "ResourceLocator.locateResourceAsStream", "no country specified");
        }
        if (vardone && (is = ResourceLocator.loadResourceAsStream(clazz, fileName, fileExtension)) != null) {
            return is;
        }
        fileName = configFile + "_" + lang;
        SilverTrace.debug("util", "ResourceLocator.locateResourceAsStream", "calling getResourceAsStream", fileName);
        is = ResourceLocator.loadResourceAsStream(clazz, configFile + "_" + lang, fileExtension);
        if (is != null) {
            return is;
        }
        return ResourceLocator.loadResourceAsStream(clazz, configFile, fileExtension);
    }

    private static InputStream loadResourceAsStream(Class<?> clazz, String configFile, String fileExtension) {
        String fileName;
        InputStream is = ResourceLocator.loadResourceAsStream(clazz, configFile);
        if (is == null && (is = ResourceLocator.loadResourceAsStream(clazz, fileName = configFile + fileExtension)) == null) {
            fileName = clazz.getPackage().getName().replace('.', '/') + '/' + fileName;
            is = ResourceLocator.loadResourceAsStream(clazz, fileName);
        }
        return is;
    }

    private static InputStream loadResourceAsStream(Class<?> clazz, String fileName) {
        InputStream is = clazz.getResourceAsStream(fileName);
        if (is != null) {
            SilverTrace.debug("util", "ResourceLocator.getFileInputStream", "found resource", fileName);
            return is;
        }
        is = loader.getResourceAsStream(fileName);
        if (is != null) {
            SilverTrace.debug("util", "ResourceLocator.getFileInputStream", "found resource", fileName);
        }
        return is;
    }

    private static InputStream getPrivileged(final ClassLoader l, final String s) {
        InputStream stream = (InputStream)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                if (l != null) {
                    return l.getResourceAsStream(s);
                }
                return ClassLoader.getSystemResourceAsStream(s);
            }
        });
        return stream;
    }
}

