/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.admin.domain.repository;

import com.silverpeas.util.StringUtil;
import com.stratelia.webactiv.beans.admin.Domain;
import com.stratelia.webactiv.util.FileRepositoryManager;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.inject.Named;
import javax.sql.DataSource;
import org.apache.commons.io.IOUtils;
import org.silverpeas.admin.domain.exception.SQLDomainDAOException;
import org.silverpeas.admin.domain.repository.SQLDomainRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Repository
@Named(value="sqlInternalDomainRepository")
public class SQLInternalDomainRepository
implements SQLDomainRepository {
    private JdbcTemplate jdbcTemplate;

    @Autowired
    public void setDataSource(DataSource dataSource) {
        this.jdbcTemplate = new JdbcTemplate(dataSource);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void createDomainStorage(Domain domain) throws SQLDomainDAOException {
        String domainName = domain.getName();
        try {
            this.jdbcTemplate.update(this.generateUserTableCreateStatement(domainName));
            this.jdbcTemplate.update(this.generateGroupTableCreateStatement(domainName));
            this.jdbcTemplate.update(this.generateGroupUserRelTableCreateStatement(domainName));
        }
        catch (Exception e) {
            throw new SQLDomainDAOException("SQLInternalDomainDAO.createDomainStorage", "admin.CANNOT_CREATE_DOMAIN_STORAGE", e);
        }
    }

    @Override
    public void deleteDomainStorage(Domain domain) {
        String domainName = domain.getName();
        this.jdbcTemplate.update(this.generateUserTableDropStatement(domainName));
        this.jdbcTemplate.update(this.generateGroupTableDropStatement(domainName));
        this.jdbcTemplate.update(this.generateGroupUserRelTableDropStatement(domainName));
    }

    private String generateGroupUserRelTableCreateStatement(String domainName) {
        StringBuilder createStatement = new StringBuilder();
        createStatement.append(" CREATE TABLE Domain").append(domainName).append("_Group_User_Rel ");
        createStatement.append(" (");
        createStatement.append(" groupId int NOT NULL , userId int NOT NULL ");
        createStatement.append(" )");
        return createStatement.toString();
    }

    private String generateGroupUserRelTableDropStatement(String domainName) {
        StringBuilder dropStatement = new StringBuilder();
        dropStatement.append(" DROP TABLE Domain").append(domainName).append("_Group_User_Rel ");
        return dropStatement.toString();
    }

    private String generateGroupTableCreateStatement(String domainName) {
        StringBuilder createStatement = new StringBuilder();
        createStatement.append(" CREATE TABLE Domain").append(domainName).append("_Group ");
        createStatement.append(" (");
        createStatement.append(" id int NOT NULL , superGroupId int NULL ,");
        createStatement.append(" name varchar(100) NOT NULL , description varchar(400) NULL ,");
        createStatement.append(" grSpecificInfo varchar(50) NULL ");
        createStatement.append(" )");
        return createStatement.toString();
    }

    private String generateGroupTableDropStatement(String domainName) {
        StringBuilder dropStatement = new StringBuilder();
        dropStatement.append(" DROP TABLE Domain").append(domainName).append("_Group ");
        return dropStatement.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String generateUserTableCreateStatement(String domainName) throws IOException {
        Properties props = new Properties();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(FileRepositoryManager.getDomainPropertiesPath(domainName));
            props.load(fis);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fis);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)fis);
        int numberOfColumns = Integer.parseInt(props.getProperty("property.Number"));
        StringBuilder createStatement = new StringBuilder();
        createStatement.append("CREATE TABLE Domain").append(domainName).append("_User ");
        createStatement.append("(");
        createStatement.append("id int NOT NULL , firstName varchar(100) NULL , ");
        createStatement.append("lastName varchar(100) NULL ,email varchar(200) NULL , ");
        createStatement.append("login varchar(50) NOT NULL ,password varchar(123) NULL , ");
        createStatement.append("passwordValid char(1) NULL , ");
        for (int i = 1; i <= numberOfColumns; ++i) {
            String specificColumnType = props.getProperty("property_" + String.valueOf(i) + ".Type");
            String specificColumnName = props.getProperty("property_" + String.valueOf(i) + ".MapParameter");
            String maxLengthPropertyValue = props.getProperty("property_" + String.valueOf(i) + ".MaxLength");
            int specificColumnMaxLength = StringUtil.isInteger(maxLengthPropertyValue) ? Integer.parseInt(maxLengthPropertyValue) : 50;
            createStatement.append(specificColumnName);
            if ("BOOLEAN".equals(specificColumnType)) {
                createStatement.append(" int NOT NULL DEFAULT (0) ");
            } else {
                createStatement.append(" varchar(").append(specificColumnMaxLength).append(") NULL ");
            }
            if (i == numberOfColumns) continue;
            createStatement.append(", ");
        }
        createStatement.append(")");
        return createStatement.toString();
    }

    private String generateUserTableDropStatement(String domainName) {
        StringBuilder dropStatement = new StringBuilder();
        dropStatement.append("DROP TABLE Domain").append(domainName).append("_User ");
        return dropStatement.toString();
    }
}

