/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.attachment.model;

import com.silverpeas.accesscontrol.AccessControlContext;
import com.silverpeas.accesscontrol.AccessControlOperation;
import com.silverpeas.accesscontrol.AccessController;
import com.silverpeas.accesscontrol.AccessControllerProvider;
import com.silverpeas.jcrutil.converter.ConverterUtil;
import com.silverpeas.util.CollectionUtil;
import com.silverpeas.util.FileUtil;
import com.silverpeas.util.StringUtil;
import com.silverpeas.util.i18n.I18NHelper;
import com.stratelia.silverpeas.peasCore.URLManager;
import com.stratelia.webactiv.SilverpeasRole;
import com.stratelia.webactiv.beans.admin.UserDetail;
import com.stratelia.webactiv.util.DBUtil;
import com.stratelia.webactiv.util.DateUtil;
import com.stratelia.webactiv.util.FileRepositoryManager;
import com.stratelia.webactiv.util.FileServerUtils;
import com.stratelia.webactiv.util.GeneralPropertiesManager;
import com.stratelia.webactiv.util.ResourceLocator;
import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.Set;
import org.silverpeas.attachment.WebdavServiceFactory;
import org.silverpeas.attachment.model.DocumentType;
import org.silverpeas.attachment.model.SimpleAttachment;
import org.silverpeas.attachment.model.SimpleDocumentPK;
import org.silverpeas.core.admin.OrganisationControllerFactory;
import org.silverpeas.util.URLUtils;

public class SimpleDocument
implements Serializable {
    private static final long serialVersionUID = 8778738762037114180L;
    private static final ResourceLocator resources = new ResourceLocator("org.silverpeas.util.attachment.Attachment", "");
    public static final String WEBDAV_FOLDER = "webdav";
    public static final String ATTACHMENT_PREFIX = "attach_";
    public static final String VERSION_PREFIX = "version_";
    public static final String FILE_PREFIX = "file_";
    public static final String DOCUMENT_PREFIX = "simpledoc_";
    private String repositoryPath;
    private SimpleDocument versionMaster = this;
    private int versionIndex = 0;
    private SimpleDocumentPK pk;
    private String foreignId;
    private int order;
    private boolean versioned;
    private String webdavContentEditionLanguage;
    private long webdavContentEditionSize = -1L;
    private String editedBy;
    private Date reservation;
    private Date alert;
    private Date expiry;
    private String status;
    private String cloneId;
    private int minorVersion = 0;
    private int majorVersion = 0;
    private boolean publicDocument = true;
    private String nodeName;
    private String comment;
    private DocumentType documentType = DocumentType.attachment;
    private Set<SilverpeasRole> forbiddenDownloadForRoles = null;
    private SimpleAttachment attachment;

    public void setDocumentType(DocumentType documentType) {
        this.documentType = documentType;
    }

    public DocumentType getDocumentType() {
        return this.documentType;
    }

    public String getCloneId() {
        return this.cloneId;
    }

    public void setCloneId(String cloneId) {
        this.cloneId = cloneId;
    }

    public SimpleDocument(SimpleDocumentPK pk, String foreignId, int order, boolean versioned, SimpleAttachment attachment) {
        this(pk, foreignId, order, versioned, null, attachment);
    }

    public SimpleDocument(SimpleDocumentPK pk, String foreignId, int order, boolean versioned, String editedBy, SimpleAttachment attachment) {
        this(pk, foreignId, order, versioned, editedBy, null, null, null, null, attachment);
    }

    public SimpleDocument(SimpleDocumentPK pk, String foreignId, int order, boolean versioned, Date reservation, Date alert, Date expiry, String comment, SimpleAttachment attachment) {
        this.pk = pk;
        this.foreignId = foreignId;
        this.order = order;
        this.versioned = versioned;
        this.setReservation(reservation);
        this.alert = DateUtil.getBeginOfDay(alert);
        this.expiry = DateUtil.getBeginOfDay(expiry);
        this.comment = comment;
        this.attachment = attachment;
    }

    public SimpleDocument(SimpleDocumentPK pk, String foreignId, int order, boolean versioned, String editedBy, Date reservation, Date alert, Date expiry, String comment, SimpleAttachment attachment) {
        this.pk = pk;
        this.foreignId = foreignId;
        this.order = order;
        this.versioned = versioned;
        this.editedBy = editedBy;
        this.setReservation(reservation);
        this.alert = DateUtil.getBeginOfDay(alert);
        this.expiry = DateUtil.getBeginOfDay(expiry);
        this.comment = comment;
        this.attachment = attachment;
    }

    public SimpleDocument() {
    }

    public SimpleDocument(SimpleDocument simpleDocument) {
        this.repositoryPath = simpleDocument.getRepositoryPath();
        this.versionMaster = simpleDocument.getVersionMaster();
        this.versionIndex = simpleDocument.getVersionIndex();
        this.pk = simpleDocument.getPk();
        this.foreignId = simpleDocument.getForeignId();
        this.order = simpleDocument.getOrder();
        this.versioned = simpleDocument.isVersioned();
        this.editedBy = simpleDocument.getEditedBy();
        this.reservation = simpleDocument.getReservation();
        this.alert = simpleDocument.getAlert();
        this.expiry = simpleDocument.getExpiry();
        this.status = simpleDocument.getStatus();
        this.cloneId = simpleDocument.getCloneId();
        this.minorVersion = simpleDocument.getMinorVersion();
        this.majorVersion = simpleDocument.getMajorVersion();
        this.publicDocument = simpleDocument.isPublic();
        this.nodeName = simpleDocument.getNodeName();
        this.comment = simpleDocument.getComment();
        this.documentType = simpleDocument.getDocumentType();
        this.forbiddenDownloadForRoles = simpleDocument.forbiddenDownloadForRoles;
        this.attachment = simpleDocument.getAttachment();
    }

    public String getFilename() {
        return this.getAttachment().getFilename();
    }

    public void setFilename(String filename) {
        this.getAttachment().setFilename(filename);
    }

    public String getLanguage() {
        return this.getAttachment().getLanguage();
    }

    public void setLanguage(String language) {
        this.getAttachment().setLanguage(language);
    }

    public String getTitle() {
        return this.getAttachment().getTitle();
    }

    public void setTitle(String title) {
        this.getAttachment().setTitle(title);
    }

    public String getDescription() {
        return this.getAttachment().getDescription();
    }

    public void setDescription(String description) {
        this.getAttachment().setDescription(description);
    }

    public long getSize() {
        return this.getAttachment().getSize();
    }

    public void setSize(long size) {
        this.getAttachment().setSize(size);
    }

    public String getContentType() {
        return this.getAttachment().getContentType();
    }

    public void setContentType(String contentType) {
        this.getAttachment().setContentType(contentType);
    }

    public String getCreatedBy() {
        return this.getAttachment().getCreatedBy();
    }

    public Date getCreated() {
        return this.getAttachment().getCreated();
    }

    public void setCreated(Date created) {
        this.getAttachment().setCreated(created);
    }

    public String getUpdatedBy() {
        return this.getAttachment().getUpdatedBy();
    }

    public void setUpdatedBy(String updatedBy) {
        this.getAttachment().setUpdatedBy(updatedBy);
    }

    public Date getUpdated() {
        return this.getAttachment().getUpdated();
    }

    public void setUpdated(Date updated) {
        this.getAttachment().setUpdated(updated);
    }

    public Date getReservation() {
        if (this.reservation == null) {
            return null;
        }
        return new Date(this.reservation.getTime());
    }

    public final void setReservation(Date reservationDate) {
        this.reservation = reservationDate == null ? null : new Date(reservationDate.getTime());
    }

    public Date getAlert() {
        if (this.alert == null) {
            return null;
        }
        return new Date(this.alert.getTime());
    }

    public void setAlert(Date alert) {
        this.alert = alert == null ? null : DateUtil.getBeginOfDay(alert);
    }

    public Date getExpiry() {
        if (this.expiry == null) {
            return null;
        }
        return new Date(this.expiry.getTime());
    }

    public void setExpiry(Date expiry) {
        this.expiry = expiry == null ? null : DateUtil.getBeginOfDay(expiry);
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public void setMinorVersion(int minorVersion) {
        this.minorVersion = minorVersion;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public void setMajorVersion(int majorVersion) {
        this.majorVersion = majorVersion;
    }

    public String getVersion() {
        return this.getMajorVersion() + "." + this.getMinorVersion();
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    protected void resetWebdavContentEditionContext() {
        this.webdavContentEditionLanguage = null;
        this.webdavContentEditionSize = -1L;
    }

    public String getWebdavContentEditionLanguage() {
        if (this.webdavContentEditionLanguage == null) {
            if (this.isOpenOfficeCompatible() && this.isReadOnly()) {
                this.webdavContentEditionLanguage = WebdavServiceFactory.getWebdavService().getContentEditionLanguage(this.getVersionMaster());
            }
            if (this.webdavContentEditionLanguage == null) {
                this.webdavContentEditionLanguage = "";
            }
        }
        return this.webdavContentEditionLanguage;
    }

    public long getWebdavContentEditionSize() {
        if (this.webdavContentEditionSize < 0L) {
            if (this.isOpenOfficeCompatible() && this.isReadOnly()) {
                this.webdavContentEditionSize = WebdavServiceFactory.getWebdavService().getContentEditionSize(this.getVersionMaster());
            }
            if (this.webdavContentEditionSize < 0L) {
                this.webdavContentEditionSize = 0L;
            }
        }
        return this.webdavContentEditionSize;
    }

    public String getEditedBy() {
        return this.editedBy;
    }

    public void edit(String currentEditor) {
        this.resetWebdavContentEditionContext();
        this.editedBy = currentEditor;
        this.setReservation(new Date());
        String day = OrganisationControllerFactory.getOrganisationController().getComponentParameterValue(this.getInstanceId(), "nbDayForReservation");
        if (StringUtil.isInteger(day)) {
            int result;
            int nbDay = Integer.parseInt(day);
            Calendar calendar = Calendar.getInstance();
            DateUtil.addDaysExceptWeekEnds(calendar, nbDay);
            this.setExpiry(calendar.getTime());
            int delayReservedFile = resources.getInteger("DelayReservedFile", -1);
            if (delayReservedFile >= 0 && delayReservedFile <= 100 && (result = nbDay * delayReservedFile / 100) > 2) {
                calendar = Calendar.getInstance();
                DateUtil.addDaysExceptWeekEnds(calendar, result);
                this.setAlert(calendar.getTime());
            }
        }
    }

    public void release() {
        this.resetWebdavContentEditionContext();
        this.editedBy = null;
        this.setReservation(null);
        this.setExpiry(null);
        this.setAlert(null);
    }

    public String getXmlFormId() {
        return this.getAttachment().getXmlFormId();
    }

    public void setXmlFormId(String xmlFormId) {
        this.getAttachment().setXmlFormId(xmlFormId);
    }

    public String getId() {
        if (this.getPk() != null) {
            return this.getPk().getId();
        }
        return null;
    }

    public void setId(String id) {
        if (this.getPk() != null) {
            this.getPk().setId(id);
        } else {
            this.setPK(new SimpleDocumentPK(id));
        }
    }

    public void setPK(SimpleDocumentPK pk) {
        this.pk = pk;
    }

    public String getInstanceId() {
        return this.getPk().getInstanceId();
    }

    public long getOldSilverpeasId() {
        return this.getPk().getOldSilverpeasId();
    }

    public void setOldSilverpeasId(long oldSilverpeasId) {
        this.getPk().setOldSilverpeasId(oldSilverpeasId);
    }

    public String getForeignId() {
        return this.foreignId;
    }

    public void setForeignId(String foreignId) {
        this.foreignId = foreignId;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public boolean isVersioned() {
        return this.versioned;
    }

    public SimpleAttachment getAttachment() {
        return this.attachment;
    }

    public SimpleDocumentPK getPk() {
        return this.pk;
    }

    public void setAttachment(SimpleAttachment attachment) {
        this.attachment = attachment;
    }

    public boolean isPublic() {
        return this.publicDocument;
    }

    public void setPublicDocument(boolean publicDocument) {
        this.publicDocument = publicDocument;
    }

    public void unlock() {
        this.resetWebdavContentEditionContext();
        this.editedBy = null;
        this.setExpiry(null);
        this.setAlert(null);
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    public String computeNodeName() {
        if (!StringUtil.isDefined(this.getNodeName())) {
            if (this.getOldSilverpeasId() <= 0L) {
                this.setOldSilverpeasId(DBUtil.getNextId("sb_simple_document", "id"));
            }
            this.setNodeName(DOCUMENT_PREFIX + this.getOldSilverpeasId());
            return this.getNodeName();
        }
        return this.getNodeName();
    }

    public String getFullJcrContentPath() {
        return this.getFullJcrPath() + '/' + this.getAttachment().getNodeName();
    }

    public String getFullJcrPath() {
        return '/' + this.getInstanceId() + '/' + this.getFolder() + '/' + this.getNodeName();
    }

    public String getDisplayIcon() {
        return FileRepositoryManager.getFileIcon(FileRepositoryManager.getFileExtension(this.getFilename()));
    }

    public boolean isOpenOfficeCompatible() {
        return FileUtil.isOpenOfficeCompatible(this.getFilename());
    }

    public boolean isReadOnly() {
        return StringUtil.isDefined(this.getEditedBy());
    }

    public String getAttachmentPath() {
        String lang = this.getLanguage();
        if (!StringUtil.isDefined(lang)) {
            lang = I18NHelper.defaultLanguage;
        }
        return this.getDirectoryPath(lang) + this.getFilename();
    }

    public String getDirectoryPath(String language) {
        String directory = FileRepositoryManager.getAbsolutePath(this.getInstanceId());
        directory = directory.replace('/', File.separatorChar);
        String versionDir = this.getMajorVersion() + "_" + this.getMinorVersion();
        String lang = language;
        if (!StringUtil.isDefined(lang)) {
            lang = I18NHelper.defaultLanguage;
        }
        return directory + this.getNodeName() + File.separatorChar + versionDir + File.separatorChar + lang + File.separatorChar;
    }

    public String toString() {
        return "SimpleDocument{" + this.getNodeName() + " pk=" + this.getPk() + ", foreignId=" + this.getForeignId() + ", order=" + this.getOrder() + ", versioned=" + this.isVersioned() + ", editedBy=" + this.getEditedBy() + ", reservation=" + this.getReservation() + ", alert=" + this.getAlert() + ", expiry=" + this.getExpiry() + ", status=" + this.getStatus() + ", cloneId=" + this.getCloneId() + ", attachment=" + this.getAttachment() + ", minorVersion=" + this.getMinorVersion() + ", majorVersion=" + this.getMajorVersion() + ", comment=" + this.getComment() + '}';
    }

    public int hashCode() {
        int hash = 3;
        hash = 31 * hash + (this.getPk() != null ? this.getPk().hashCode() : 0);
        hash = 31 * hash + this.getMinorVersion();
        hash = 31 * hash + this.getMajorVersion();
        hash = 31 * hash + this.getVersionIndex();
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SimpleDocument)) {
            return false;
        }
        SimpleDocument other = (SimpleDocument)obj;
        if (!(this.getPk() == other.getPk() || this.getPk() != null && this.getPk().equals(other.getPk()))) {
            return false;
        }
        if (this.getMinorVersion() != other.getMinorVersion()) {
            return false;
        }
        if (this.getMajorVersion() != other.getMajorVersion()) {
            return false;
        }
        return this.getVersionIndex() == other.getVersionIndex();
    }

    public String getAttachmentURL() {
        return FileServerUtils.getAttachmentURL(this.getPk().getInstanceId(), this.getFilename(), this.getPk().getId(), this.getLanguage());
    }

    public String getUniversalURL() {
        return URLManager.getSimpleURL(4, this.getId()) + "?ContentLanguage=" + this.getLanguage();
    }

    public String getOnlineURL() {
        String onlineUrl = FileServerUtils.getOnlineURL(this.getPk().getComponentName(), this.getFilename(), "", this.getContentType(), "");
        String extension = FileRepositoryManager.getFileExtension(this.getFilename());
        if ("exe".equalsIgnoreCase(extension) || "pdf".equalsIgnoreCase(extension)) {
            onlineUrl = onlineUrl + "&logicalName=" + URLUtils.encodePathParamValue(this.getFilename());
        }
        return onlineUrl;
    }

    public String getAliasURL() {
        String extension;
        String aliasUrl = FileServerUtils.getAliasURL(this.getPk().getInstanceId(), this.getFilename(), this.getPk().getId());
        if (I18NHelper.isI18nContentActivated && !I18NHelper.isDefaultLanguage(this.getLanguage())) {
            aliasUrl = aliasUrl + "&lang=" + this.getLanguage();
        }
        if ("exe".equalsIgnoreCase(extension = FileRepositoryManager.getFileExtension(this.getFilename())) || "pdf".equalsIgnoreCase(extension)) {
            aliasUrl = aliasUrl + "&logicalName=" + URLUtils.encodePathParamValue(this.getFilename());
        }
        return aliasUrl;
    }

    public String getWebdavUrl() {
        StringBuilder url = new StringBuilder(500);
        String webAppContext = URLManager.getApplicationURL();
        url.append(webAppContext);
        if (!webAppContext.endsWith("/")) {
            url.append('/');
        }
        url.append(GeneralPropertiesManager.getString("webdav.respository")).append('/').append(GeneralPropertiesManager.getString("webdav.workspace")).append('/').append(this.getWebdavJcrPath());
        return url.toString();
    }

    public String getWebdavJcrPath() {
        StringBuilder jcrPath = new StringBuilder(500);
        jcrPath.append(WEBDAV_FOLDER).append('/').append(DocumentType.attachment.getFolderName()).append('/').append(this.getVersionMaster().getInstanceId()).append('/');
        if (this.getVersionMaster().getId() != null) {
            jcrPath.append(this.getVersionMaster().getId()).append('/');
        }
        if (this.getLanguage() != null) {
            jcrPath.append(this.getVersionMaster().getLanguage()).append('/');
        }
        jcrPath.append(ConverterUtil.escapeIllegalJcrChars(this.getVersionMaster().getFilename()));
        return jcrPath.toString();
    }

    @Deprecated
    public String getWebURL() {
        return FileServerUtils.getAttachmentURL(this.getPk().getInstanceId(), this.getFilename(), this.getPk().getId(), this.getLanguage());
    }

    public SimpleDocument getVersionMaster() {
        return this.versionMaster;
    }

    public void setVersionMaster(SimpleDocument versionMaster) {
        this.versionMaster = versionMaster;
    }

    public boolean isVersionMaster() {
        return this == this.getVersionMaster();
    }

    public String getRepositoryPath() {
        return this.repositoryPath;
    }

    public void setRepositoryPath(String repositoryPath) {
        this.repositoryPath = repositoryPath;
    }

    public int getVersionIndex() {
        return this.versionIndex;
    }

    public void setVersionIndex(int versionIndex) {
        this.versionIndex = versionIndex;
    }

    public SimpleDocument getLastPublicVersion() {
        return this;
    }

    public String getFolder() {
        return this.getDocumentType().getFolderName();
    }

    public boolean isSharingAllowedForRolesFrom(UserDetail user) {
        if (user == null || StringUtil.isNotDefined(user.getId()) || !user.isValidState()) {
            return false;
        }
        AccessController<SimpleDocument> accessController = AccessControllerProvider.getAccessController("simpleDocumentAccessController");
        return accessController.isUserAuthorized(user.getId(), this.getVersionMaster(), AccessControlContext.init().onOperationsOf(AccessControlOperation.sharing));
    }

    public boolean canBeAccessedBy(UserDetail user) {
        AccessController<SimpleDocument> accessController = AccessControllerProvider.getAccessController("simpleDocumentAccessController");
        return accessController.isUserAuthorized(user.getId(), this);
    }

    public boolean canBeModifiedBy(UserDetail user) {
        AccessController<SimpleDocument> accessController = AccessControllerProvider.getAccessController("simpleDocumentAccessController");
        return accessController.isUserAuthorized(user.getId(), this, AccessControlContext.init().onOperationsOf(AccessControlOperation.modification));
    }

    public boolean isDownloadAllowedForRolesFrom(UserDetail user) {
        if (user == null || StringUtil.isNotDefined(user.getId()) || !user.isValidState()) {
            return false;
        }
        if (CollectionUtil.isEmpty(this.getVersionMaster().forbiddenDownloadForRoles)) {
            return true;
        }
        AccessController<SimpleDocument> accessController = AccessControllerProvider.getAccessController("simpleDocumentAccessController");
        return accessController.isUserAuthorized(user.getId(), this.getVersionMaster(), AccessControlContext.init().onOperationsOf(AccessControlOperation.download));
    }

    public boolean isDownloadAllowedForRoles(Set<SilverpeasRole> roles) {
        if (CollectionUtil.isEmpty(roles)) {
            return false;
        }
        if (CollectionUtil.isEmpty(this.getVersionMaster().forbiddenDownloadForRoles)) {
            return true;
        }
        return SilverpeasRole.getGreaterFrom(roles).isGreaterThan(SilverpeasRole.getGreaterFrom(this.getVersionMaster().forbiddenDownloadForRoles));
    }

    public boolean isDownloadAllowedForReaders() {
        return this.isDownloadAllowedForRoles(SilverpeasRole.READER_ROLES);
    }

    public boolean addRolesForWhichDownloadIsForbidden(SilverpeasRole ... forbiddenRoles) {
        return this.addRolesForWhichDownloadIsForbidden(Arrays.asList(forbiddenRoles));
    }

    public boolean addRolesForWhichDownloadIsForbidden(Collection<SilverpeasRole> forbiddenRoles) {
        if (CollectionUtil.isNotEmpty(forbiddenRoles)) {
            if (this.getVersionMaster().forbiddenDownloadForRoles == null) {
                this.getVersionMaster().forbiddenDownloadForRoles = EnumSet.noneOf(SilverpeasRole.class);
            }
            return this.getVersionMaster().forbiddenDownloadForRoles.addAll(forbiddenRoles);
        }
        return false;
    }

    public boolean addRolesForWhichDownloadIsAllowed(SilverpeasRole ... allowedRoles) {
        return this.addRolesForWhichDownloadIsAllowed(Arrays.asList(allowedRoles));
    }

    public boolean addRolesForWhichDownloadIsAllowed(Collection<SilverpeasRole> allowedRoles) {
        return CollectionUtil.isNotEmpty(allowedRoles) && CollectionUtil.isNotEmpty(this.getVersionMaster().forbiddenDownloadForRoles) && this.getVersionMaster().forbiddenDownloadForRoles.removeAll(allowedRoles);
    }

    public Set<SilverpeasRole> getForbiddenDownloadForRoles() {
        return this.getVersionMaster().forbiddenDownloadForRoles != null ? Collections.unmodifiableSet(this.getVersionMaster().forbiddenDownloadForRoles) : null;
    }

    public boolean isContentImage() {
        return FileUtil.isImage(this.getAttachmentPath());
    }

    public boolean isContentSpinfire() {
        return FileUtil.isSpinfireDocument(this.getAttachmentPath());
    }

    public boolean isContentArchive() {
        return FileUtil.isArchive(this.getAttachmentPath());
    }

    public boolean isContentMail() {
        return FileUtil.isMail(this.getAttachmentPath());
    }

    public boolean isContentPdf() {
        return FileUtil.isPdf(this.getAttachmentPath());
    }
}

