/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.chart;

import com.silverpeas.util.StringUtil;
import java.util.LinkedHashMap;
import java.util.Map;
import org.json.JSONObject;
import org.silverpeas.chart.ChartItem;

public abstract class AbstractChartItem<DATA_TYPE>
implements ChartItem {
    private String title = "";
    private Map<String, Object> extra = null;

    @Override
    public String getTitle() {
        return this.title;
    }

    public <T extends AbstractChartItem<DATA_TYPE>> T addExtra(String key, Object value) {
        if (this.extra == null) {
            this.extra = new LinkedHashMap<String, Object>();
        }
        this.extra.put(key, value);
        return (T)this;
    }

    public Object getExtra(String key) {
        return this.extra == null ? null : this.extra.get(key);
    }

    public <T extends AbstractChartItem<DATA_TYPE>> T withTitle(String title) {
        this.title = StringUtil.defaultStringIfNotDefined(title);
        return (T)this;
    }

    @Override
    public final String asJson() {
        JSONObject itemAsJson = new JSONObject();
        itemAsJson.put("title", (Object)this.getTitle());
        if (this.extra != null) {
            JSONObject jsonExtra = new JSONObject();
            for (Map.Entry<String, Object> entry : this.extra.entrySet()) {
                jsonExtra.put(entry.getKey(), entry.getValue());
            }
            itemAsJson.put("extra", (Object)jsonExtra);
        }
        this.computeDataAsJson(itemAsJson);
        return itemAsJson.toString();
    }

    protected abstract void computeDataAsJson(JSONObject var1);
}

