/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.file;

import com.silverpeas.util.StringUtil;
import com.silverpeas.util.i18n.I18NHelper;
import com.stratelia.silverpeas.peasCore.URLManager;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import javax.inject.Named;
import org.apache.commons.io.FileUtils;
import org.silverpeas.attachment.AttachmentServiceFactory;
import org.silverpeas.attachment.model.SimpleDocument;
import org.silverpeas.attachment.model.SimpleDocumentPK;
import org.silverpeas.file.AbstractSilverpeasFileProcessor;
import org.silverpeas.file.SilverpeasFile;
import org.silverpeas.file.SilverpeasFileProcessor;
import org.silverpeas.util.StringDataExtractor;

@Named(value="attachmentUrlLinkProcessor")
public class AttachmentUrlLinkProcessor
extends AbstractSilverpeasFileProcessor {
    private static List<Pattern> ATTACHMENT_ID_FROM_LINK_PATTERNS = Arrays.asList(Pattern.compile("(?i)/attachmentId/([a-z\\-0-9]+)/"), Pattern.compile("(?i)/File/([a-z\\-0-9]+)"));
    private static List<Pattern> ATTACHMENT_LANG_FROM_LINK_PATTERNS = Arrays.asList(Pattern.compile("(?i)/lang/([a-z]+)/"), Pattern.compile("(?i)ContentLanguage=([a-z]+)"));
    private static Pattern SIZE_DIRECTIVE_FROM_LINK = Pattern.compile("(?i)/size/([0-9 x]+)");

    @Override
    public String processBefore(String attachmentLink, SilverpeasFileProcessor.ProcessingContext context) {
        if (context == SilverpeasFileProcessor.ProcessingContext.GETTING && attachmentLink.contains(URLManager.getApplicationURL())) {
            String attachmentId = StringDataExtractor.from(attachmentLink).withDirectives(StringDataExtractor.RegexpPatternDirective.regexps(ATTACHMENT_ID_FROM_LINK_PATTERNS, 1)).extractUnique();
            if (!StringUtil.isDefined(attachmentId)) {
                return attachmentLink;
            }
            String contentLanguage = StringDataExtractor.from(attachmentLink).withDirectives(StringDataExtractor.RegexpPatternDirective.regexps(ATTACHMENT_LANG_FROM_LINK_PATTERNS, 1)).extractUnique();
            contentLanguage = I18NHelper.checkLanguage(contentLanguage);
            SimpleDocumentPK sdPK = new SimpleDocumentPK(attachmentId);
            SimpleDocument attachment = AttachmentServiceFactory.getAttachmentService().searchDocumentById(sdPK, contentLanguage);
            if (attachment == null) {
                return SilverpeasFile.NO_FILE.getPath();
            }
            String specifiedSize = StringDataExtractor.from(attachmentLink).withDirective(StringDataExtractor.RegexpPatternDirective.regexp(SIZE_DIRECTIVE_FROM_LINK, 1)).extractUnique();
            File attachmentFile = new File(attachment.getAttachmentPath());
            if (StringUtil.isDefined(specifiedSize)) {
                attachmentFile = FileUtils.getFile((File)attachmentFile.getParentFile(), (String[])new String[]{specifiedSize, attachmentFile.getName()});
            }
            return attachmentFile.getPath();
        }
        return attachmentLink;
    }

    @Override
    public SilverpeasFile processAfter(SilverpeasFile file, SilverpeasFileProcessor.ProcessingContext context) {
        return file;
    }

    @Override
    public int getPriority() {
        return 100;
    }
}

