/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.file;

import com.stratelia.webactiv.util.FileRepositoryManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.silverpeas.file.SilverpeasFile;
import org.silverpeas.file.SilverpeasFileDescriptor;
import org.silverpeas.file.SilverpeasFileProcessor;

public class SilverpeasFileProvider {
    private static final SilverpeasFileProvider instance = new SilverpeasFileProvider();
    private List<SilverpeasFileProcessor> processors = new ArrayList<SilverpeasFileProcessor>();

    public static SilverpeasFileProvider getInstance() {
        return instance;
    }

    private SilverpeasFileProvider() {
    }

    public static SilverpeasFile getFile(SilverpeasFileDescriptor descriptor) {
        return SilverpeasFileProvider.getInstance().getSilverpeasFile(descriptor);
    }

    public static SilverpeasFile getFile(String absolutePath) {
        return SilverpeasFileProvider.getInstance().getSilverpeasFile(absolutePath);
    }

    public static SilverpeasFile newFile(String absolutePath) {
        return SilverpeasFileProvider.getInstance().newSilverpeasFile(absolutePath);
    }

    public static SilverpeasFile newFile(SilverpeasFileDescriptor descriptor) {
        return SilverpeasFileProvider.getInstance().newSilverpeasFile(descriptor);
    }

    public SilverpeasFile newSilverpeasFile(String absolutePath) {
        return new SilverpeasFile("", absolutePath);
    }

    public SilverpeasFile newSilverpeasFile(SilverpeasFileDescriptor descriptor) {
        return new SilverpeasFile(descriptor.getComponentInstanceId(), this.getFilePathFrom(descriptor), descriptor.getMimeType());
    }

    public SilverpeasFile getSilverpeasFile(SilverpeasFileDescriptor descriptor) {
        String filePath = this.processPath(this.getFilePathFrom(descriptor), SilverpeasFileProcessor.ProcessingContext.GETTING);
        return this.processSilverpeasFile(new SilverpeasFile(descriptor.getComponentInstanceId(), filePath, descriptor.getMimeType()), SilverpeasFileProcessor.ProcessingContext.GETTING);
    }

    public SilverpeasFile getSilverpeasFile(String absolutePath) {
        String filePath = this.processPath(absolutePath, SilverpeasFileProcessor.ProcessingContext.GETTING);
        return this.processSilverpeasFile(new SilverpeasFile("", filePath), SilverpeasFileProcessor.ProcessingContext.GETTING);
    }

    public synchronized void addProcessor(SilverpeasFileProcessor processor) {
        if (!this.processors.contains(processor)) {
            this.processors.add(processor);
            Collections.sort(this.processors);
        }
    }

    protected static SilverpeasFile processAfter(SilverpeasFile file, SilverpeasFileProcessor.ProcessingContext context) {
        return SilverpeasFileProvider.getInstance().processSilverpeasFile(file, context);
    }

    private String processPath(String path, SilverpeasFileProcessor.ProcessingContext context) {
        String processedPath = path;
        for (SilverpeasFileProcessor processor : this.processors) {
            processedPath = processor.processBefore(processedPath, context);
        }
        return processedPath;
    }

    private SilverpeasFile processSilverpeasFile(SilverpeasFile file, SilverpeasFileProcessor.ProcessingContext context) {
        SilverpeasFile processedFile = file;
        for (SilverpeasFileProcessor processor : this.processors) {
            processedFile = processor.processAfter(processedFile, context);
        }
        return processedFile;
    }

    private String getFilePathFrom(SilverpeasFileDescriptor descriptor) {
        String filePath = descriptor.isTemporaryFile() ? FileRepositoryManager.getTemporaryPath("useless", descriptor.getComponentInstanceId()) + descriptor.getFilePath() : (descriptor.isAbsolutePath() ? descriptor.getFilePath() : FileRepositoryManager.getAbsolutePath(descriptor.getComponentInstanceId()) + descriptor.getFilePath());
        return filePath;
    }
}

