/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.notification.message;

import com.silverpeas.util.i18n.I18NHelper;
import com.stratelia.webactiv.util.ResourceLocator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.silverpeas.notification.message.Message;
import org.silverpeas.notification.message.MessageListener;

public class MessageContainer {
    private final Map<String, ResourceLocator> resourceLocators = new HashMap<String, ResourceLocator>();
    private final List<MessageListener> listeners = new ArrayList<MessageListener>();
    private String language = I18NHelper.defaultLanguage;
    private final Set<Message> messages = new LinkedHashSet<Message>();

    MessageContainer() {
    }

    public ResourceLocator getResourceLocator(String propertyFileBaseName, String lang) {
        String cacheKey = propertyFileBaseName + "@" + lang;
        ResourceLocator resourceLocator = this.resourceLocators.get(cacheKey);
        if (resourceLocator == null) {
            resourceLocator = new ResourceLocator(propertyFileBaseName, lang);
            this.resourceLocators.put(cacheKey, resourceLocator);
        }
        return resourceLocator;
    }

    public void addListener(MessageListener listener) {
        this.listeners.add(listener);
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getLanguage() {
        for (MessageListener messageListener : this.listeners) {
            messageListener.beforeGetLanguage(this);
        }
        return this.language;
    }

    public void addMessage(Message message) {
        for (MessageListener messageListener : this.listeners) {
            messageListener.beforeAddMessage(this, message);
        }
        this.messages.add(message);
        for (MessageListener messageListener : this.listeners) {
            messageListener.afterMessageAdded(this, message);
        }
    }

    public Set<Message> getMessages() {
        return this.messages;
    }
}

