/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.password.rule;

import com.silverpeas.util.StringUtil;
import org.silverpeas.password.constant.PasswordRuleType;
import org.silverpeas.password.rule.AbstractPasswordRule;

public class MinLengthPasswordRule
extends AbstractPasswordRule {
    private Integer value = settings.getInteger(this.getType().getSettingKey(), 8);

    public MinLengthPasswordRule() {
        super(PasswordRuleType.MIN_LENGTH);
        if (settings.getInteger(PasswordRuleType.MAX_LENGTH.getSettingKey() + ".value", 8) < this.value) {
            this.value = 8;
        }
    }

    public Integer getValue() {
        return this.value;
    }

    @Override
    public boolean check(String password) {
        return StringUtil.isDefined(password) && password.length() >= this.getValue();
    }

    @Override
    public String random() {
        return "";
    }
}

