/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.password.service;

import com.silverpeas.annotation.Service;
import com.silverpeas.util.StringUtil;
import com.silverpeas.util.template.SilverpeasTemplateFactory;
import com.stratelia.webactiv.util.ResourceLocator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.apache.commons.lang.StringUtils;
import org.silverpeas.password.constant.PasswordRuleType;
import org.silverpeas.password.rule.AtLeastXDigitPasswordRule;
import org.silverpeas.password.rule.AtLeastXLowercasePasswordRule;
import org.silverpeas.password.rule.AtLeastXSpecialCharPasswordRule;
import org.silverpeas.password.rule.AtLeastXUppercasePasswordRule;
import org.silverpeas.password.rule.BlankForbiddenPasswordRule;
import org.silverpeas.password.rule.MaxLengthPasswordRule;
import org.silverpeas.password.rule.MinLengthPasswordRule;
import org.silverpeas.password.rule.PasswordRule;
import org.silverpeas.password.rule.SequentialForbiddenPasswordRule;
import org.silverpeas.password.service.PasswordCheck;
import org.silverpeas.password.service.PasswordService;

@Service
public class DefaultPasswordService
implements PasswordService {
    protected static ResourceLocator settings = new ResourceLocator("org.silverpeas.password.settings.password", "");
    protected static int nbMatchingCombinedRules = settings.getInteger("password.combination.nbMatchingRules", 0);
    private Map<PasswordRuleType, PasswordRule> allPasswordRules = new LinkedHashMap<PasswordRuleType, PasswordRule>(PasswordRuleType.values().length);
    private Map<PasswordRuleType, PasswordRule> requiredPasswordRules = new LinkedHashMap<PasswordRuleType, PasswordRule>(PasswordRuleType.values().length);
    private Map<PasswordRuleType, PasswordRule> combinedPasswordRules = new LinkedHashMap<PasswordRuleType, PasswordRule>(PasswordRuleType.values().length);

    @PostConstruct
    protected void loadRules() {
        this.allPasswordRules.clear();
        this.requiredPasswordRules.clear();
        for (PasswordRule rule : new PasswordRule[]{new MinLengthPasswordRule(), new MaxLengthPasswordRule(), new BlankForbiddenPasswordRule(), new SequentialForbiddenPasswordRule(), new AtLeastXUppercasePasswordRule(), new AtLeastXLowercasePasswordRule(), new AtLeastXDigitPasswordRule(), new AtLeastXSpecialCharPasswordRule()}) {
            this.allPasswordRules.put(rule.getType(), rule);
            if (rule.isRequired()) {
                this.requiredPasswordRules.put(rule.getType(), rule);
            }
            if (!rule.isCombined()) continue;
            this.combinedPasswordRules.put(rule.getType(), rule);
        }
    }

    @Override
    public PasswordRule getRule(PasswordRuleType passwordRuleType) {
        return this.allPasswordRules.get((Object)passwordRuleType);
    }

    @Override
    public Collection<PasswordRule> getRules() {
        return new ArrayList<PasswordRule>(this.allPasswordRules.values());
    }

    @Override
    public Collection<PasswordRule> getRequiredRules() {
        return new ArrayList<PasswordRule>(this.requiredPasswordRules.values());
    }

    @Override
    public Collection<PasswordRule> getCombinedRules() {
        return new ArrayList<PasswordRule>(this.combinedPasswordRules.values());
    }

    @Override
    public PasswordCheck check(String password) {
        PasswordCheck passwordCheck = new PasswordCheck(this.getCombinedRules(), nbMatchingCombinedRules);
        for (PasswordRule rule : this.getRequiredRules()) {
            if (rule.check(password)) continue;
            passwordCheck.addRequiredError(rule);
        }
        for (PasswordRule rule : this.getCombinedRules()) {
            if (rule.check(password)) continue;
            passwordCheck.addCombinedError(rule);
        }
        return passwordCheck;
    }

    @Override
    public String generate() {
        long start = System.currentTimeMillis();
        PasswordRule sequentialForbidden = this.getRule(PasswordRuleType.SEQUENTIAL_FORBIDDEN);
        String generatedPassword = this.generate(sequentialForbidden);
        if (sequentialForbidden.isRequired()) {
            while (System.currentTimeMillis() - start <= 5000L && !sequentialForbidden.check(generatedPassword)) {
                generatedPassword = this.generate(sequentialForbidden);
            }
        }
        return generatedPassword;
    }

    private String generate(PasswordRule sequentialForbidden) {
        String currentRandomPasswordPart;
        ArrayList<PasswordRule> rules = new ArrayList<PasswordRule>(this.getRules());
        ArrayList<PasswordRule> requiredRules = new ArrayList<PasswordRule>(this.getRequiredRules());
        ArrayList<PasswordRule> combinedRules = new ArrayList<PasswordRule>(this.getCombinedRules());
        int minLength = (Integer)this.getRule(PasswordRuleType.MIN_LENGTH).getValue();
        int maxLength = (Integer)this.getRule(PasswordRuleType.MAX_LENGTH).getValue();
        int requiredPasswordLength = minLength + this.random(maxLength - minLength + 1);
        List<Object> randomPasswordParts = new ArrayList();
        HashSet<PasswordRule> combinedRulesPerformed = new HashSet<PasswordRule>();
        for (int currentPasswordLength = 0; currentPasswordLength < requiredPasswordLength; currentPasswordLength += currentRandomPasswordPart.length()) {
            PasswordRule currentRule = !requiredRules.isEmpty() ? (PasswordRule)requiredRules.remove(this.random(requiredRules.size())) : (!combinedRules.isEmpty() && combinedRulesPerformed.size() < nbMatchingCombinedRules ? (PasswordRule)combinedRules.remove(this.random(combinedRules.size())) : (PasswordRule)rules.get(this.random(rules.size())));
            if (currentRule.isCombined()) {
                combinedRulesPerformed.add(currentRule);
            }
            if (!StringUtil.isDefined(currentRandomPasswordPart = currentRule.random())) continue;
            while (currentPasswordLength + currentRandomPasswordPart.length() > maxLength) {
                currentRandomPasswordPart = currentRandomPasswordPart.substring(0, currentRandomPasswordPart.length() - 1);
            }
            randomPasswordParts.add(currentRandomPasswordPart);
        }
        Collections.shuffle(randomPasswordParts);
        String generatedPassword = StringUtils.join(randomPasswordParts, (String)"");
        for (int i = 0; i < 10 && sequentialForbidden.isRequired() && !sequentialForbidden.check(generatedPassword); ++i) {
            randomPasswordParts = Arrays.asList(generatedPassword.split(""));
            Collections.shuffle(randomPasswordParts);
            generatedPassword = StringUtils.join(randomPasswordParts, (String)"");
        }
        return generatedPassword;
    }

    private int random(int maxValue) {
        return (int)((double)maxValue * Math.random());
    }

    @Override
    public String getExtraRuleMessage(String language) {
        return SilverpeasTemplateFactory.createSilverpeasTemplateOnCore("password").applyFileTemplate("extraRules_" + language).trim();
    }
}

