/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.persistence.repository;

import com.silverpeas.util.AssertArgument;
import com.stratelia.webactiv.beans.admin.UserDetail;
import org.silverpeas.cache.service.CacheServiceFactory;
import org.silverpeas.persistence.model.Entity;

public class OperationContext {
    private static final String CACHE_KEY = OperationContext.class.getName();
    private boolean updatingInCaseOfCreation = false;
    private UserDetail user = null;

    public static OperationContext createInstance() {
        return new OperationContext();
    }

    public static OperationContext fromUser(String userId) {
        return OperationContext.fromUser(UserDetail.getById(userId));
    }

    public static OperationContext fromUser(UserDetail user) {
        return new OperationContext().withUser(user);
    }

    public static OperationContext getFromCache() {
        return CacheServiceFactory.getRequestCacheService().get(CACHE_KEY, OperationContext.class);
    }

    private OperationContext() {
    }

    private OperationContext withUser(UserDetail user) {
        this.user = user;
        return this;
    }

    public OperationContext setUpdatingInCaseOfCreation() {
        return this.setUpdatingInCaseOfCreation(true);
    }

    public OperationContext setUpdatingInCaseOfCreation(boolean updatingInCaseOfCreation) {
        this.updatingInCaseOfCreation = updatingInCaseOfCreation;
        return this;
    }

    public boolean isUpdatingInCaseOfCreation() {
        return this.updatingInCaseOfCreation;
    }

    public UserDetail getUser() {
        return this.user;
    }

    public void putIntoCache() {
        CacheServiceFactory.getRequestCacheService().put(CACHE_KEY, this);
    }

    public void applyToPersistOperation(Entity entity) {
        String errorMessage = "the user identifier must exist when performing persist operation";
        AssertArgument.assertNotNull(this.user, errorMessage);
        AssertArgument.assertDefined(this.user.getId(), errorMessage);
        entity.setCreator(this.user);
        entity.setLastUpdater(this.user);
    }

    public void applyToUpdateOperation(Entity entity) {
        String errorMessage = "the user identifier must exist when performing update operation";
        AssertArgument.assertNotNull(this.user, errorMessage);
        AssertArgument.assertDefined(this.user.getId(), errorMessage);
        entity.setLastUpdater(this.user);
    }
}

