/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.search.indexEngine.model;

import com.stratelia.silverpeas.silvertrace.SilverTrace;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.silverpeas.search.indexEngine.model.IndexReadersCache;
import org.silverpeas.search.searchEngine.model.ParseException;

public class IndexProcessor {
    private static final Object UPDATED_MUTEX = new Object();
    private static final Object MUTEX = new Object();
    private static final List<String> UPDATED_INDEXES = new ArrayList<String>();
    private static int currentSearchProcessing = 0;

    private IndexProcessor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <R> R doSearch(SearchIndexProcess<R> searchIndexProcess) throws ParseException {
        try {
            Object object = MUTEX;
            synchronized (object) {
                SilverTrace.debug("searchEngine", IndexProcessor.class.toString(), "starts search processing and there are currently " + ++currentSearchProcessing + " search process(es) performing");
            }
            object = searchIndexProcess.process();
            return (R)object;
        }
        finally {
            Object object = MUTEX;
            synchronized (object) {
                --currentSearchProcessing;
                IndexProcessor.closeIndexReaders();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doFlush(FlushIndexProcess flushIndexProcess) {
        List<String> updatedPaths = flushIndexProcess.process();
        SilverTrace.debug("searchEngine", IndexProcessor.class.toString(), "flushes " + updatedPaths.size() + " writer(s)");
        Object object = UPDATED_MUTEX;
        synchronized (object) {
            UPDATED_INDEXES.addAll(updatedPaths);
        }
        object = MUTEX;
        synchronized (object) {
            IndexProcessor.closeIndexReaders();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void closeIndexReaders() {
        if (currentSearchProcessing == 0) {
            Object object = UPDATED_MUTEX;
            synchronized (object) {
                SilverTrace.debug("searchEngine", IndexProcessor.class.toString(), "no search is currently being performed, so closing readers if any");
                Iterator<String> it = UPDATED_INDEXES.iterator();
                while (it.hasNext()) {
                    String path = it.next();
                    SilverTrace.debug("searchEngine", IndexProcessor.class.toString(), "closing reader on path " + path);
                    IndexReadersCache.closeIndexReader(path);
                    it.remove();
                }
            }
        } else {
            SilverTrace.debug("searchEngine", IndexProcessor.class.toString(), "no reader close is performed as " + currentSearchProcessing + " search process(es) are currently performed");
        }
    }

    public static interface FlushIndexProcess {
        public List<String> process();
    }

    public static interface SearchIndexProcess<R> {
        public R process() throws ParseException;
    }
}

