/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.search.searchEngine.model;

import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.util.DBUtil;
import com.stratelia.webactiv.util.JNDINames;
import com.stratelia.webactiv.util.ResourceLocator;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Set;
import java.util.TreeSet;

public class SearchCompletion {
    private static int pdcMaxRow = 100;
    private static int thesaurusMaxRow = 100;
    private static int keywordMaxRow = 100;
    private final String pdcQuery = "SELECT DISTINCT name FROM sb_tree_tree where lower(name) like ?";
    private final String thesaurusQuery = "SELECT DISTINCT name FROM  sb_thesaurus_synonym where lower(name) like ?";
    private final String keywordsQuery = "SELECT DISTINCT label FROM sb_tagcloud_tagcloud  where lower(label) like ?";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getSuggestions(String query) {
        query = query.toLowerCase();
        SilverTrace.debug("searchEngine", "SearchCompletion.getSuggestions()", "root.MSG_GEN_PARAM_VALUE", "query = " + query);
        TreeSet<String> set = new TreeSet<String>();
        Connection con = null;
        Statement ps = null;
        ResultSet rs = null;
        ResourceLocator resource = new ResourceLocator("com.stratelia.silverpeas.pdcPeas.settings.pdcPeasSettings", "");
        int autocompletionMaxResults = Integer.parseInt(resource.getString("autocompletionMaxResults"));
        try {
            con = DBUtil.makeConnection(JNDINames.DATABASE_DATASOURCE);
            ArrayList<String> pdcList = this.executeQuery(con, pdcMaxRow, query, "SELECT DISTINCT name FROM sb_tree_tree where lower(name) like ?");
            ArrayList<String> thesauruslist = this.executeQuery(con, thesaurusMaxRow, query, "SELECT DISTINCT name FROM  sb_thesaurus_synonym where lower(name) like ?");
            ArrayList<String> keywordsList = this.executeQuery(con, keywordMaxRow, query, "SELECT DISTINCT label FROM sb_tagcloud_tagcloud  where lower(label) like ?");
            int numberOfPdcSuggest = this.getSize(autocompletionMaxResults, pdcList);
            int numberOfThesaurusSuggest = this.getSize(autocompletionMaxResults, thesauruslist);
            int numberOfKeywordsSuggest = this.getSize(autocompletionMaxResults, keywordsList);
            set.addAll(pdcList.subList(0, numberOfPdcSuggest));
            set.addAll(thesauruslist.subList(0, numberOfThesaurusSuggest));
            set.addAll(keywordsList.subList(0, numberOfKeywordsSuggest));
        }
        catch (Exception e) {
            SilverTrace.error("searchEngine", "SearchCompletion.getSuggestions()", "root.EX_SQL_QUERY_FAILED", e);
        }
        finally {
            DBUtil.close(rs, ps);
            try {
                if (con != null && !con.isClosed()) {
                    con.close();
                }
            }
            catch (SQLException e) {
                SilverTrace.error("searchEngine", "SearchCompletion.getSuggestions()()", "root.EX_CONNECTION_CLOSE_FAILED", e);
            }
        }
        return set;
    }

    private int getSize(int autocompletionMaxResults, ArrayList<String> list) {
        int numberOfSuggest = 0;
        int pdcSize = list.size();
        if (pdcSize > 0) {
            numberOfSuggest = autocompletionMaxResults / 3 > pdcSize ? pdcSize : pdcSize - autocompletionMaxResults / 3;
        }
        return numberOfSuggest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<String> executeQuery(Connection con, int maxRow, String query, String sqlQuery) throws SQLException {
        ArrayList<String> list = new ArrayList<String>();
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = con.prepareStatement(sqlQuery);
            ps.setString(1, query + "%");
            ps.setMaxRows(maxRow);
            rs = ps.executeQuery();
            while (rs.next()) {
                list.add(rs.getString(1).toLowerCase());
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (ps != null) {
                ps.close();
            }
        }
        return list;
    }
}

