/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.util;

import java.math.BigDecimal;
import org.silverpeas.util.memory.MemoryData;
import org.silverpeas.util.memory.MemoryUnit;
import org.silverpeas.util.time.TimeData;
import org.silverpeas.util.time.TimeUnit;

public class UnitUtil {
    public static long convertTo(long byteValue, MemoryUnit to) {
        return UnitUtil.getMemData(byteValue).getRoundedSizeConverted(to).longValue();
    }

    public static BigDecimal convertTo(BigDecimal byteValue, MemoryUnit to) {
        return UnitUtil.getMemData(byteValue).getSizeConverted(to);
    }

    public static long convertTo(long value, MemoryUnit from, MemoryUnit to) {
        return UnitUtil.getMemData(value, from).getRoundedSizeConverted(to).longValue();
    }

    public static BigDecimal convertTo(BigDecimal value, MemoryUnit from, MemoryUnit to) {
        return UnitUtil.getMemData(value, from).getSizeConverted(to);
    }

    public static BigDecimal convertAndRoundTo(MemoryData memoryData, MemoryUnit to) {
        return memoryData.getRoundedSizeConverted(to);
    }

    public static String formatValue(long byteValue, MemoryUnit to) {
        return UnitUtil.getMemData(byteValue).getFormattedValue(to);
    }

    public static String formatValue(BigDecimal byteValue, MemoryUnit to) {
        return UnitUtil.getMemData(byteValue).getFormattedValue(to);
    }

    public static String formatValue(long value, MemoryUnit from, MemoryUnit to) {
        return UnitUtil.getMemData(value, from).getFormattedValue(to);
    }

    public static String formatValue(BigDecimal value, MemoryUnit from, MemoryUnit to) {
        return UnitUtil.getMemData(value, from).getFormattedValue(to);
    }

    public static String formatMemSize(long memSize) {
        return UnitUtil.getMemData(memSize).getBestDisplayValue();
    }

    public static String formatMemSize(BigDecimal memSize) {
        return UnitUtil.getMemData(memSize).getBestDisplayValue();
    }

    public static String formatMemSize(long memSize, MemoryUnit from) {
        return UnitUtil.getMemData(memSize, from).getBestDisplayValue();
    }

    public static String formatMemSize(BigDecimal memSize, MemoryUnit from) {
        return UnitUtil.getMemData(memSize, from).getBestDisplayValue();
    }

    public static MemoryData getMemData(long memSize) {
        return UnitUtil.getMemData(memSize, MemoryUnit.B);
    }

    public static MemoryData getMemData(BigDecimal memSize) {
        return UnitUtil.getMemData(memSize, MemoryUnit.B);
    }

    public static MemoryData getMemData(long memSize, MemoryUnit from) {
        BigDecimal byteMemSize = MemoryData.convertTo(new BigDecimal(String.valueOf(memSize)), from, MemoryUnit.B);
        return new MemoryData(byteMemSize.setScale(0, 4).longValue());
    }

    public static MemoryData getMemData(BigDecimal memSize, MemoryUnit from) {
        BigDecimal byteMemSize = MemoryData.convertTo(memSize, from, MemoryUnit.B);
        return new MemoryData(byteMemSize);
    }

    public static long convertTo(long millisecondValue, TimeUnit to) {
        return UnitUtil.getTimeData(millisecondValue).getRoundedTimeConverted(to).longValue();
    }

    public static BigDecimal convertTo(BigDecimal millisecondValue, TimeUnit to) {
        return UnitUtil.getTimeData(millisecondValue).getTimeConverted(to);
    }

    public static long convertTo(long value, TimeUnit from, TimeUnit to) {
        return UnitUtil.getTimeData(value, from).getRoundedTimeConverted(to).longValue();
    }

    public static BigDecimal convertTo(BigDecimal value, TimeUnit from, TimeUnit to) {
        return UnitUtil.getTimeData(value, from).getTimeConverted(to);
    }

    public static BigDecimal convertAndRoundTo(TimeData timeData, TimeUnit to) {
        return timeData.getRoundedTimeConverted(to);
    }

    public static String formatValue(long millisecondValue, TimeUnit to) {
        return UnitUtil.getTimeData(millisecondValue).getFormattedValue(to);
    }

    public static String formatValue(BigDecimal millisecondValue, TimeUnit to) {
        return UnitUtil.getTimeData(millisecondValue).getFormattedValue(to);
    }

    public static String formatValue(long value, TimeUnit from, TimeUnit to) {
        return UnitUtil.getTimeData(value, from).getFormattedValue(to);
    }

    public static String formatValue(BigDecimal value, TimeUnit from, TimeUnit to) {
        return UnitUtil.getTimeData(value, from).getFormattedValue(to);
    }

    public static String formatTime(long time) {
        return UnitUtil.getTimeData(time).getBestDisplayValue();
    }

    public static String formatTime(BigDecimal time) {
        return UnitUtil.getTimeData(time).getBestDisplayValue();
    }

    public static String formatTime(long time, TimeUnit from) {
        return UnitUtil.getTimeData(time, from).getBestDisplayValue();
    }

    public static String formatTime(BigDecimal time, TimeUnit from) {
        return UnitUtil.getTimeData(time, from).getBestDisplayValue();
    }

    public static TimeData getTimeData(long time) {
        return UnitUtil.getTimeData(time, TimeUnit.MILLI);
    }

    public static TimeData getTimeData(BigDecimal time) {
        return UnitUtil.getTimeData(time, TimeUnit.MILLI);
    }

    public static TimeData getTimeData(long time, TimeUnit from) {
        BigDecimal millisecondTime = TimeData.convertTo(new BigDecimal(String.valueOf(time)), from, TimeUnit.MILLI);
        return new TimeData(millisecondTime.setScale(0, 4).longValue());
    }

    public static TimeData getTimeData(BigDecimal time, TimeUnit from) {
        BigDecimal millisecondTime = TimeData.convertTo(time, from, TimeUnit.MILLI);
        return new TimeData(millisecondTime);
    }
}

