/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.util.mail;

import com.silverpeas.converter.DocumentFormat;
import com.silverpeas.converter.DocumentFormatConverterFactory;
import com.silverpeas.converter.option.FilterOption;
import com.silverpeas.util.EncodeHelper;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.util.FileRepositoryManager;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.mail.Address;
import javax.mail.internet.InternetAddress;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hsmf.MAPIMessage;
import org.apache.poi.hsmf.datatypes.AttachmentChunks;
import org.apache.poi.hsmf.datatypes.Chunks;
import org.apache.poi.hsmf.datatypes.RecipientChunks;
import org.apache.poi.hsmf.exceptions.ChunkNotFoundException;
import org.silverpeas.util.Charsets;
import org.silverpeas.util.mail.ExtractorException;
import org.silverpeas.util.mail.Mail;
import org.silverpeas.util.mail.MailAttachment;
import org.silverpeas.util.mail.MailExtractor;

public class MSGExtractor
implements MailExtractor {
    private MAPIMessage message;

    public MSGExtractor(File file) throws ExtractorException {
        try {
            this.message = new MAPIMessage(file.getPath());
        }
        catch (IOException e) {
            throw new ExtractorException("MSGExtractor.constructor", 4, "", e);
        }
        this.message.setReturnNullOnMissingChunk(true);
    }

    public MSGExtractor(InputStream file) throws ExtractorException {
        this.init(file);
    }

    private void init(InputStream file) throws ExtractorException {
        try {
            this.message = new MAPIMessage(file);
        }
        catch (IOException e) {
            throw new ExtractorException("MSGExtractor.init", 4, "", e);
        }
        this.message.setReturnNullOnMissingChunk(true);
    }

    @Override
    public Mail getMail() throws Exception {
        Mail mail = new Mail();
        try {
            if (this.message.getMessageDate() != null) {
                mail.setDate(this.message.getMessageDate().getTime());
            } else {
                mail.setDate(this.extractDateOfReception());
            }
        }
        catch (ChunkNotFoundException e) {
            SilverTrace.warn("util", "MSGExtractor.getMail()", "", e);
        }
        try {
            mail.setSubject(this.message.getSubject());
        }
        catch (ChunkNotFoundException e) {
            SilverTrace.warn("util", "MSGExtractor.getMail()", "", e);
        }
        Chunks mainChunks = this.message.getMainChunks();
        InternetAddress from = new InternetAddress(mainChunks.emailFromChunk.getValue(), mainChunks.displayFromChunk.getValue());
        mail.setFrom(from);
        String[] toNames = StringUtils.split((String)this.message.getDisplayTo(), (char)';');
        mail.setTo(this.getInChunks(toNames).toArray(new Address[toNames.length]));
        String[] ccNames = StringUtils.split((String)this.message.getDisplayCC(), (char)';');
        List<InternetAddress> ccAddresses = this.getInChunks(ccNames);
        if (ccAddresses != null && !ccAddresses.isEmpty()) {
            mail.setCc(this.getInChunks(ccNames).toArray(new Address[ccNames.length]));
        }
        try {
            String body = this.message.getHtmlBody();
            if (body == null && (body = this.getRtfText(this.message.getRtfBody())) == null) {
                body = EncodeHelper.javaStringToHtmlParagraphe(this.message.getTextBody());
            }
            mail.setBody(body);
        }
        catch (ChunkNotFoundException e) {
            SilverTrace.warn("util", "MSGExtractor.getMail()", "", e);
        }
        return mail;
    }

    private List<InternetAddress> getInChunks(String[] names) throws UnsupportedEncodingException {
        ArrayList<InternetAddress> result = new ArrayList<InternetAddress>(names.length);
        for (String name : names) {
            InternetAddress address = this.getInChunks(name.trim());
            if (address == null) continue;
            result.add(address);
        }
        return result;
    }

    private InternetAddress getInChunks(String name) throws UnsupportedEncodingException {
        RecipientChunks[] recipientChunks;
        for (RecipientChunks recipient : recipientChunks = this.message.getRecipientDetailsChunks()) {
            if (!name.equals(recipient.getRecipientName())) continue;
            InternetAddress address = new InternetAddress(recipient.getRecipientEmailAddress(), recipient.getRecipientName());
            return address;
        }
        return null;
    }

    private Date extractDateOfReception() throws ParseException {
        String chunkContent;
        int dateIdx;
        if (this.message.getMainChunks().messageHeaders != null && (dateIdx = (chunkContent = this.message.getMainChunks().messageHeaders.getValue()).indexOf("Date: ")) >= 0) {
            chunkContent = chunkContent.substring(dateIdx + 6, chunkContent.indexOf(10, dateIdx)).replaceAll("[\r\n]", "");
            return new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss Z", Locale.ENGLISH).parse(chunkContent);
        }
        return null;
    }

    private String getRtfText(String rtfText) {
        try {
            ByteArrayOutputStream htmlText = new ByteArrayOutputStream();
            DocumentFormatConverterFactory.getFactory().getToHTMLConverter().convert(new ByteArrayInputStream(rtfText.getBytes(Charsets.UTF_8)), DocumentFormat.inFormat(DocumentFormat.rtf), htmlText, DocumentFormat.inFormat(DocumentFormat.html), new FilterOption[0]);
            return htmlText.toString("UTF-8");
        }
        catch (Exception e) {
            SilverTrace.warn("util", "MSGExtractor.getRtfText()", "CANT_CONVERT_RTF_TO_HMTL_BODY", e);
            return null;
        }
    }

    @Override
    public List<MailAttachment> getAttachments() throws Exception {
        AttachmentChunks[] attachmentChunks = this.message.getAttachmentFiles();
        ArrayList<MailAttachment> mailAttachments = new ArrayList<MailAttachment>(attachmentChunks.length);
        for (AttachmentChunks attachment : attachmentChunks) {
            byte[] data = attachment.attachData.getValue();
            String fileName = attachment.attachLongFileName.getValue();
            MailAttachment mailAttachment = new MailAttachment(fileName);
            String dir = FileRepositoryManager.getTemporaryPath() + "mail" + Calendar.getInstance().getTimeInMillis();
            File file = new File(dir, fileName);
            FileUtils.writeByteArrayToFile((File)file, (byte[])data);
            mailAttachment.setPath(file.getAbsolutePath());
            mailAttachment.setSize(file.length());
            mailAttachments.add(mailAttachment);
        }
        return mailAttachments;
    }
}

