/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.wysiwyg.control;

import com.silverpeas.util.ForeignPK;
import com.silverpeas.util.StringUtil;
import com.silverpeas.util.i18n.I18NHelper;
import com.stratelia.silverpeas.silverpeasinitialize.CallBackManager;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.beans.admin.ComponentInstLight;
import com.stratelia.webactiv.util.FileRepositoryManager;
import com.stratelia.webactiv.util.ResourceLocator;
import com.stratelia.webactiv.util.WAPrimaryKey;
import com.stratelia.webactiv.util.exception.UtilException;
import com.stratelia.webactiv.util.fileFolder.FileFolderManager;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.silverpeas.attachment.AttachmentException;
import org.silverpeas.attachment.AttachmentServiceFactory;
import org.silverpeas.attachment.model.DocumentType;
import org.silverpeas.attachment.model.SimpleAttachment;
import org.silverpeas.attachment.model.SimpleDocument;
import org.silverpeas.attachment.model.SimpleDocumentPK;
import org.silverpeas.attachment.model.UnlockContext;
import org.silverpeas.attachment.util.SimpleDocumentList;
import org.silverpeas.core.admin.OrganisationController;
import org.silverpeas.core.admin.OrganisationControllerFactory;
import org.silverpeas.search.indexEngine.model.FullIndexEntry;
import org.silverpeas.util.Charsets;
import org.silverpeas.wysiwyg.WysiwygException;

public class WysiwygManager {
    public static final String WYSIWYG_CONTEXT = DocumentType.wysiwyg.name();
    public static final String WYSIWYG_IMAGES = "Images";
    public static final String WYSIWYG_WEBSITES = "webSites";

    protected WysiwygManager() {
    }

    private String loadFromFileSystemDirectly(ForeignPK foreignPK, String language) throws IOException {
        File wysiwygFile = new File(this.getLegacyWysiwygPath(WYSIWYG_CONTEXT, foreignPK.getInstanceId()), this.getWysiwygFileName(foreignPK.getId(), language));
        if (!wysiwygFile.exists() || !wysiwygFile.isFile()) {
            wysiwygFile = new File(this.getLegacyWysiwygPath(WYSIWYG_CONTEXT, foreignPK.getInstanceId()), this.getOldWysiwygFileName(foreignPK.getId()));
        }
        String content = null;
        if (wysiwygFile.exists() && wysiwygFile.isFile()) {
            content = FileUtils.readFileToString((File)wysiwygFile);
        }
        return content;
    }

    private String getLegacyWysiwygPath(String context, String componentId) {
        String path;
        if (StringUtil.isDefined(context)) {
            String strAt = "Attachment,";
            strAt = strAt.concat(context);
            String[] ctx = StringUtil.split((String)strAt, (char)',');
            path = FileRepositoryManager.getAbsolutePath(componentId, ctx);
        } else {
            String[] ctx = new String[]{"Attachment"};
            path = FileRepositoryManager.getAbsolutePath(componentId, ctx);
        }
        return path;
    }

    public List<SimpleDocument> getImages(String id, String componentId) {
        SimpleDocumentList<SimpleDocument> attachments = AttachmentServiceFactory.getAttachmentService().listDocumentsByForeignKeyAndType(new ForeignPK(id, componentId), DocumentType.image, null);
        Iterator it = attachments.iterator();
        while (it.hasNext()) {
            SimpleDocument document = (SimpleDocument)it.next();
            if (document.isContentImage()) continue;
            it.remove();
        }
        return attachments;
    }

    public String getWebsiteRepository() {
        ResourceLocator websiteSettings = new ResourceLocator("org.silverpeas.webSites.settings.webSiteSettings", "");
        return websiteSettings.getString("uploadsPath");
    }

    public String[][] getWebsiteImages(String path, String componentId) throws WysiwygException {
        this.checkPath(path);
        try {
            Collection<File> listImages = FileFolderManager.getAllImages(path);
            Iterator<File> i = listImages.iterator();
            int nbImages = listImages.size();
            String[][] images = new String[nbImages][2];
            SilverTrace.info("wysiwyg", "WysiwygController.getWebsiteImages()", "root.MSG_GEN_PARAM_VALUE", "nbImages=" + nbImages + " path=" + path);
            for (int j = 0; j < nbImages; ++j) {
                File image = i.next();
                SilverTrace.info("wysiwyg", "WysiwygController.getWebsiteImages()", "root.MSG_GEN_PARAM_VALUE", "image=" + image.getAbsolutePath());
                images[j][0] = this.finNode2(image.getAbsolutePath(), componentId).replace('\\', '/');
                images[j][1] = image.getName();
            }
            return images;
        }
        catch (UtilException e) {
            throw new WysiwygException("WebSiteSessionController.getWebsiteImages()", 4, "wysisyg.EX_GET_ALL_IMAGES_FAIL", e);
        }
    }

    public String[][] getWebsitePages(String path, String componentId) throws WysiwygException {
        this.checkPath(path);
        try {
            Collection<File> listPages = FileFolderManager.getAllWebPages(this.getNodePath(path, componentId));
            Iterator<File> i = listPages.iterator();
            int nbPages = listPages.size();
            String[][] pages = new String[nbPages][2];
            SilverTrace.info("wysiwyg", "WysiwygController.getWebsitePages()", "root.MSG_GEN_PARAM_VALUE", "nbPages=" + nbPages + " path=" + path);
            for (int j = 0; j < nbPages; ++j) {
                File page = i.next();
                SilverTrace.info("wysiwyg", "WysiwygController.getWebsitePages()", "root.MSG_GEN_PARAM_VALUE", "page=" + page.getAbsolutePath());
                pages[j][0] = this.finNode2(page.getAbsolutePath(), componentId).replace('\\', '/');
                pages[j][1] = page.getName();
            }
            return pages;
        }
        catch (UtilException e) {
            throw new WysiwygException("WebSiteSessionController.getWebsitePages()", 4, "wysisyg.EX_GET_ALL_PAGES_FAIL", e);
        }
    }

    String finNode(String path, String componentId) {
        int longueur = componentId.length();
        int index = path.lastIndexOf(componentId);
        String chemin = path.substring(index + longueur);
        chemin = this.suppressLeadingSlashesOrAntislashes(chemin);
        chemin = this.supprDoubleAntiSlash(chemin);
        return chemin;
    }

    String finNode2(String path, String componentId) {
        SilverTrace.info("wysiwyg", "WysiwygController.finNode2()", "root.MSG_GEN_PARAM_VALUE", "path=" + path);
        String finNode = this.doubleAntiSlash(path);
        finNode = this.finNode(finNode, componentId);
        int index = finNode.indexOf(92);
        if (index < 0) {
            index = finNode.indexOf(47);
        }
        return finNode.substring(index + 1);
    }

    String getNodePath(String currentPath, String componentId) {
        String chemin = currentPath;
        if (chemin != null) {
            chemin = this.suppressFinalSlash(chemin);
            int indexComponent = chemin.lastIndexOf(componentId) + componentId.length();
            String finChemin = this.suppressLeadingSlashesOrAntislashes(chemin.substring(indexComponent));
            int index = -1;
            if (finChemin.contains("/")) {
                index = finChemin.indexOf(47);
            } else if (finChemin.contains("\\")) {
                index = finChemin.indexOf(92);
            }
            SilverTrace.info("wysiwyg", "WysiwygController.getNodePath()", "root.MSG_GEN_PARAM_VALUE", "finChemin = " + finChemin);
            if (index == -1) {
                return chemin;
            }
            return chemin.substring(0, chemin.indexOf(finChemin) + index);
        }
        return "";
    }

    String suppressFinalSlash(String path) {
        if (path.endsWith("/")) {
            return this.suppressFinalSlash(path.substring(0, path.length() - 1));
        }
        return path;
    }

    String ignoreLeadingSlash(String chemin) {
        if (chemin.startsWith("/")) {
            return this.ignoreLeadingSlash(chemin.substring(1));
        }
        return chemin;
    }

    String supprDoubleAntiSlash(String chemin) {
        StringBuilder res = new StringBuilder("");
        for (int i = 0; i < chemin.length(); ++i) {
            char car = chemin.charAt(i);
            if (car == '\\' && chemin.charAt(i + 1) == '\\') {
                res.append(car);
                ++i;
                continue;
            }
            res.append(car);
        }
        return res.toString();
    }

    String suppressLeadingSlashesOrAntislashes(String chemin) {
        if (chemin.startsWith("\\") || chemin.startsWith("/")) {
            return this.suppressLeadingSlashesOrAntislashes(chemin.substring(1));
        }
        return chemin;
    }

    String doubleAntiSlash(String chemin) {
        int i = 0;
        String res = chemin;
        boolean ok = true;
        while (ok) {
            int j = i + 1;
            if (i < res.length() && j < res.length()) {
                char car1 = res.charAt(i);
                char car2 = res.charAt(j);
                if (!(car1 == '\\' && car2 == '\\' || car1 != '\\' && car2 != '\\')) {
                    String avant = res.substring(0, j);
                    String apres = res.substring(j);
                    if (!apres.startsWith("\\\\") && !avant.endsWith("\\\\")) {
                        res = avant + '\\' + apres;
                        ++i;
                    }
                }
            } else {
                char car;
                if (i < res.length() && (car = res.charAt(i)) == '\\') {
                    res = res + '\\';
                }
                ok = false;
            }
            i += 2;
        }
        return res;
    }

    public String getOldWysiwygFileName(String objectId) {
        return objectId + WYSIWYG_CONTEXT + ".txt";
    }

    public String getWysiwygFileName(String objectId, String currentLanguage) {
        String language = I18NHelper.checkLanguage(currentLanguage);
        return objectId + WYSIWYG_CONTEXT + "_" + language + ".txt";
    }

    public String getImagesFileName(String objectId) {
        return objectId + WYSIWYG_IMAGES;
    }

    public void deleteFileAndAttachment(String componentId, String id) {
        ForeignPK foreignKey = new ForeignPK(id, componentId);
        SimpleDocumentList<SimpleDocument> documents = AttachmentServiceFactory.getAttachmentService().listDocumentsByForeignKey(foreignKey, null);
        for (SimpleDocument doc : documents) {
            AttachmentServiceFactory.getAttachmentService().deleteAttachment(doc);
        }
    }

    public void deleteFile(String componentId, String objectId, String language) {
        ForeignPK foreignKey = new ForeignPK(objectId, componentId);
        SimpleDocumentList<SimpleDocument> files = AttachmentServiceFactory.getAttachmentService().listDocumentsByForeignKey(foreignKey, null);
        for (SimpleDocument file : files) {
            if (file == null || !file.getFilename().equalsIgnoreCase(this.getWysiwygFileName(objectId, language))) continue;
            AttachmentServiceFactory.getAttachmentService().removeContent(file, language, false);
        }
    }

    public void createFileAndAttachment(String textHtml, WAPrimaryKey foreignKey, String context, String userId, String contentLanguage) {
        this.createFileAndAttachment(textHtml, foreignKey, DocumentType.valueOf(context), userId, contentLanguage, true, true);
    }

    private void createFileAndAttachment(String textHtml, WAPrimaryKey foreignKey, DocumentType context, String userId, String contentLanguage, boolean indexIt, boolean invokeCallback) {
        String fileName = this.getWysiwygFileName(foreignKey.getId(), contentLanguage);
        if (!StringUtil.isDefined(textHtml)) {
            return;
        }
        String language = I18NHelper.checkLanguage(contentLanguage);
        SimpleDocumentPK docPk = new SimpleDocumentPK(null, foreignKey.getInstanceId());
        SimpleDocument document = new SimpleDocument(docPk, foreignKey.getId(), 0, false, userId, new SimpleAttachment(fileName, language, fileName, null, textHtml.length(), "text/html", userId, new Date(), null));
        document.setDocumentType(context);
        AttachmentServiceFactory.getAttachmentService().createAttachment(document, new ByteArrayInputStream(textHtml.getBytes(Charsets.UTF_8)), indexIt, false);
        if (invokeCallback) {
            this.invokeCallback(userId, foreignKey);
        }
        AttachmentServiceFactory.getAttachmentService().unlock(new UnlockContext(document.getId(), userId, document.getLanguage()));
    }

    private void invokeCallback(String userId, WAPrimaryKey objectPK) {
        int iUserId = -1;
        if (userId != null) {
            iUserId = Integer.parseInt(userId);
        }
        CallBackManager callBackManager = CallBackManager.get();
        callBackManager.invoke(8, iUserId, objectPK.getInstanceId(), objectPK.getId());
    }

    public void createFileAndAttachment(String textHtml, WAPrimaryKey foreignKey, String userId, String contentLanguage) {
        this.createFileAndAttachment(textHtml, foreignKey, WYSIWYG_CONTEXT, userId, contentLanguage);
    }

    public void createUnindexedFileAndAttachment(String textHtml, WAPrimaryKey foreignKey, String userId, String contentLanguage) {
        this.createFileAndAttachment(textHtml, foreignKey, DocumentType.wysiwyg, userId, contentLanguage, false, false);
    }

    public void addToIndex(FullIndexEntry indexEntry, ForeignPK pk, String language) {
        SimpleDocumentList<SimpleDocument> docs = AttachmentServiceFactory.getAttachmentService().listDocumentsByForeignKeyAndType(pk, DocumentType.wysiwyg, language);
        if (!docs.isEmpty()) {
            for (SimpleDocument wysiwyg : docs) {
                String wysiwygPath = wysiwyg.getAttachmentPath();
                indexEntry.addFileContent(wysiwygPath, null, "text/html", language);
                String wysiwygContent = this.loadContent(wysiwyg, language);
                List<String> embeddedAttachmentIds = this.getEmbeddedAttachmentIds(wysiwygContent);
                this.indexEmbeddedLinkedFiles(indexEntry, embeddedAttachmentIds);
            }
        }
    }

    private void saveFile(String textHtml, WAPrimaryKey foreignKey, String userId, String language, boolean indexIt) {
        String lang = I18NHelper.checkLanguage(language);
        DocumentType wysiwygType = DocumentType.wysiwyg;
        String fileName = this.getWysiwygFileName(foreignKey.getId(), lang);
        SilverTrace.info("wysiwyg", "WysiwygController.updateFileAndAttachment()", "root.MSG_GEN_PARAM_VALUE", "fileName=" + fileName + " context=" + (Object)((Object)wysiwygType) + "objectId=" + foreignKey.getId());
        SimpleDocument document = this.searchAttachmentDetail(foreignKey, wysiwygType, lang);
        if (document != null) {
            if (!document.getLanguage().equals(lang)) {
                document.setFilename(fileName);
            }
            document.setLanguage(lang);
            document.setSize(textHtml.getBytes(Charsets.UTF_8).length);
            document.setDocumentType(wysiwygType);
            document.setUpdatedBy(userId);
            if (document.getSize() > 0L) {
                AttachmentServiceFactory.getAttachmentService().updateAttachment(document, new ByteArrayInputStream(textHtml.getBytes(Charsets.UTF_8)), indexIt, false);
                this.invokeCallback(userId, foreignKey);
            } else {
                AttachmentServiceFactory.getAttachmentService().removeContent(document, lang, true);
            }
        } else {
            this.createFileAndAttachment(textHtml, foreignKey, wysiwygType, userId, lang, indexIt, true);
        }
    }

    public void updateFileAndAttachment(String textHtml, String componentId, String objectId, String userId, String language) {
        this.updateFileAndAttachment(textHtml, componentId, objectId, userId, language, true);
    }

    public void updateFileAndAttachment(String textHtml, String componentId, String objectId, String userId, String language, boolean indexIt) {
        this.saveFile(textHtml, new ForeignPK(objectId, componentId), userId, language, indexIt);
    }

    public void save(String textHtml, String componentId, String objectId, String userId, String language, boolean indexIt) {
        this.saveFile(textHtml, new ForeignPK(objectId, componentId), userId, language, indexIt);
    }

    public void deleteWysiwygAttachments(String componentId, String objectId) {
        try {
            ForeignPK foreignKey = new ForeignPK(objectId, componentId);
            SimpleDocumentList<SimpleDocument> documents = AttachmentServiceFactory.getAttachmentService().listAllDocumentsByForeignKey(foreignKey, null);
            for (SimpleDocument document : documents) {
                AttachmentServiceFactory.getAttachmentService().deleteAttachment(document);
            }
        }
        catch (AttachmentException exc) {
            SilverTrace.error("wysiwyg", "WysiwygController.deleteWysiwygAttachments()", "wysiwyg.DELETING_WYSIWYG_ATTACHMENTS_FAILED", exc);
            throw exc;
        }
    }

    public void deleteWysiwygAttachmentsOnly(String componentId, String objectId) throws WysiwygException {
        try {
            ForeignPK foreignKey = new ForeignPK(objectId, componentId);
            SimpleDocumentList<SimpleDocument> docs = AttachmentServiceFactory.getAttachmentService().listDocumentsByForeignKeyAndType(foreignKey, DocumentType.wysiwyg, null);
            for (SimpleDocument wysiwygAttachment : docs) {
                AttachmentServiceFactory.getAttachmentService().deleteAttachment(wysiwygAttachment, false);
            }
            docs = AttachmentServiceFactory.getAttachmentService().listDocumentsByForeignKeyAndType(foreignKey, DocumentType.image, null);
            for (SimpleDocument document : docs) {
                AttachmentServiceFactory.getAttachmentService().deleteAttachment(document, false);
            }
        }
        catch (Exception exc) {
            throw new WysiwygException("WysiwygController.deleteWysiwygAttachments()", 4, "wysiwyg.DELETING_WYSIWYG_ATTACHMENTS_FAILED", exc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String loadContent(SimpleDocument document, String lang) {
        if (this.isEmptyWysiwygContent(document, lang)) {
            return "";
        }
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        try {
            AttachmentServiceFactory.getAttachmentService().getBinaryContent(buffer, document.getPk(), lang);
            String string = new String(buffer.toByteArray(), Charsets.UTF_8);
            return string;
        }
        finally {
            IOUtils.closeQuietly((OutputStream)buffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isEmptyWysiwygContent(SimpleDocument document, String lang) {
        if (document.getDocumentType() == DocumentType.wysiwyg) {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            try {
                AttachmentServiceFactory.getAttachmentService().getBinaryContent(buffer, document.getPk(), lang, 0L, 1L);
                if (buffer.size() == 0) {
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                IOUtils.closeQuietly((OutputStream)buffer);
            }
        }
        return false;
    }

    public String load(String componentId, String objectId, String language) {
        String content = this.internalLoad(componentId, objectId, language);
        if (I18NHelper.isI18nContentEnabled() && content != null && StringUtil.isNotDefined(content)) {
            String lang;
            ArrayList<String> languages = new ArrayList<String>(I18NHelper.getAllSupportedLanguages());
            languages.remove(language);
            Iterator i$ = languages.iterator();
            while (i$.hasNext() && (content = this.internalLoad(componentId, objectId, lang = (String)i$.next())) != null && !StringUtil.isDefined(content)) {
            }
        }
        if (content == null) {
            content = "";
        }
        return content;
    }

    private String internalLoad(String componentId, String objectId, String language) {
        String currentLanguage;
        String finalLanguage = currentLanguage = I18NHelper.checkLanguage(language);
        String content = "";
        SimpleDocument document = this.searchAttachmentDetail(new ForeignPK(objectId, componentId), DocumentType.wysiwyg, currentLanguage);
        if (document != null) {
            content = this.loadContent(document, currentLanguage);
            finalLanguage = document.getLanguage();
        }
        if (!StringUtil.isDefined(content)) {
            try {
                String contentFromSystem = this.loadFromFileSystemDirectly(new ForeignPK(objectId, componentId), currentLanguage);
                if (StringUtil.isDefined(contentFromSystem)) {
                    content = contentFromSystem;
                    finalLanguage = currentLanguage;
                }
            }
            catch (IOException ex) {
                SilverTrace.error("wysiwyg", "WysiwygController.load()", "Error loading content", ex);
            }
        }
        if (StringUtil.isNotDefined(content) && !finalLanguage.equals(currentLanguage)) {
            content = null;
        }
        return content;
    }

    public List<String> getEmbeddedAttachmentIds(String content) {
        ArrayList<String> attachmentIds = new ArrayList<String>();
        if (content != null) {
            String fileId;
            Pattern attachmentLinkPattern = Pattern.compile("href=\\\"\\/silverpeas\\/File\\/(.*?)\\\"");
            Matcher linkMatcher = attachmentLinkPattern.matcher(content);
            while (linkMatcher.find()) {
                fileId = linkMatcher.group(1);
                attachmentIds.add(fileId);
            }
            attachmentLinkPattern = Pattern.compile("href=\\\"\\/silverpeas\\/FileServer\\/(.*?)attachmentId=(\\d*)");
            linkMatcher = attachmentLinkPattern.matcher(content);
            while (linkMatcher.find()) {
                fileId = linkMatcher.group(2);
                attachmentIds.add(fileId);
            }
        }
        return attachmentIds;
    }

    public String loadFileWebsite(String path, String fileName) throws WysiwygException {
        this.checkPath(path);
        try {
            return FileFolderManager.getCode(path, fileName);
        }
        catch (UtilException e) {
            throw new WysiwygException("WysiwygController.loadFileWebsite()", 3, "wysiwyg.NO_WYSIWYG_DOCUMENT_ASSOCIATED");
        }
    }

    public boolean haveGotWysiwygToDisplay(String componentId, String objectId, String language) {
        return this.haveGotWysiwyg(componentId, objectId, language);
    }

    public boolean haveGotWysiwyg(String componentId, String objectId, String language) {
        String wysiwygContent = this.load(componentId, objectId, language);
        return StringUtil.isDefined(wysiwygContent);
    }

    private SimpleDocument searchAttachmentDetail(WAPrimaryKey foreignKey, DocumentType context, String lang) {
        String language = I18NHelper.checkLanguage(lang);
        SimpleDocumentList<SimpleDocument> documents = AttachmentServiceFactory.getAttachmentService().listDocumentsByForeignKeyAndType(foreignKey, context, language);
        if (!documents.isEmpty()) {
            return (SimpleDocument)documents.orderByLanguageAndLastUpdate(lang).get(0);
        }
        return null;
    }

    public void updateWebsite(String cheminFichier, String nomFichier, String contenuFichier) throws WysiwygException {
        this.checkPath(cheminFichier);
        SilverTrace.info("wysiwyg", "WysiwygController.updateWebsite()", "root.MSG_GEN_PARAM_VALUE", "cheminFichier=" + cheminFichier + " nomFichier=" + nomFichier);
        this.createFile(cheminFichier, nomFichier, contenuFichier);
    }

    protected File createFile(String cheminFichier, String nomFichier, String contenuFichier) throws WysiwygException {
        this.checkPath(cheminFichier);
        SilverTrace.info("wysiwyg", "WysiwygController.createFile()", "root.MSG_GEN_ENTER_METHOD", "cheminFichier=" + cheminFichier + " nomFichier=" + nomFichier);
        FileFolderManager.createFile(cheminFichier, nomFichier, contenuFichier);
        File directory = new File(cheminFichier);
        return FileUtils.getFile((File)directory, (String[])new String[]{nomFichier});
    }

    public Map<String, String> copy(String oldComponentId, String oldObjectId, String componentId, String objectId, String userId) {
        SilverTrace.info("wysiwyg", "WysiwygController.copy()", "root.MSG_GEN_ENTER_METHOD");
        ForeignPK foreignKey = new ForeignPK(oldObjectId, oldComponentId);
        ForeignPK targetPk = new ForeignPK(objectId, componentId);
        SimpleDocument copy = null;
        ArrayList<Pair> oldNewImagePkMapping = new ArrayList<Pair>();
        HashMap<String, String> fileIds = new HashMap<String, String>();
        ArrayList<String> languagesWithEmptyContent = new ArrayList<String>();
        for (String language : I18NHelper.getAllSupportedLanguages()) {
            SimpleDocumentList<SimpleDocument> documents = AttachmentServiceFactory.getAttachmentService().listDocumentsByForeignKeyAndType(foreignKey, DocumentType.wysiwyg, language).removeLanguageFallbacks();
            for (SimpleDocument doc : documents) {
                if (!this.isEmptyWysiwygContent(doc, doc.getLanguage())) {
                    doc.getAttachment().setCreatedBy(userId);
                    if (copy == null) {
                        SimpleDocumentPK pk = AttachmentServiceFactory.getAttachmentService().copyDocument(doc, targetPk);
                        copy = AttachmentServiceFactory.getAttachmentService().searchDocumentById(pk, doc.getLanguage());
                        SimpleDocumentList<SimpleDocument> images = AttachmentServiceFactory.getAttachmentService().listDocumentsByForeignKeyAndType(foreignKey, DocumentType.image, null);
                        for (SimpleDocument image : images) {
                            SimpleDocumentPK imageCopyPk = AttachmentServiceFactory.getAttachmentService().copyDocument(image, targetPk);
                            fileIds.put(image.getId(), imageCopyPk.getId());
                            oldNewImagePkMapping.add(Pair.of((Object)image.getPk(), (Object)imageCopyPk));
                        }
                    }
                    copy.setLanguage(language);
                    String content = this.replaceInternalImagesPath(this.loadContent(copy, doc.getLanguage()), oldComponentId, oldObjectId, componentId, objectId);
                    for (Pair oldNewPk : oldNewImagePkMapping) {
                        content = this.replaceInternalImageId(content, (SimpleDocumentPK)oldNewPk.getLeft(), (SimpleDocumentPK)oldNewPk.getRight());
                    }
                    AttachmentServiceFactory.getAttachmentService().updateAttachment(copy, new ByteArrayInputStream(content.getBytes(Charsets.UTF_8)), false, false);
                    continue;
                }
                languagesWithEmptyContent.add(language);
            }
        }
        if (copy != null) {
            for (String languageWithEmptyContent : languagesWithEmptyContent) {
                AttachmentServiceFactory.getAttachmentService().removeContent(copy, languageWithEmptyContent, false);
            }
        }
        return fileIds;
    }

    public void move(String fromComponentId, String fromObjectId, String componentId, String objectId) {
        ForeignPK fromForeignPK = new ForeignPK(fromObjectId, fromComponentId);
        SimpleDocumentList<SimpleDocument> documents = AttachmentServiceFactory.getAttachmentService().listAllDocumentsByForeignKey(fromForeignPK, null);
        ForeignPK toForeignPK = new ForeignPK(objectId, componentId);
        for (SimpleDocument document : documents) {
            AttachmentServiceFactory.getAttachmentService().moveDocument(document, toForeignPK);
        }
        this.wysiwygPlaceHaveChanged(fromComponentId, fromObjectId, componentId, objectId);
    }

    String replaceInternalImageId(String wysiwygContent, SimpleDocumentPK oldPK, SimpleDocumentPK newPK) {
        String from = "/componentId/" + oldPK.getInstanceId() + "/attachmentId/" + oldPK.getId() + "/";
        String fromOldId = "/componentId/" + oldPK.getInstanceId() + "/attachmentId/" + oldPK.getOldSilverpeasId() + "/";
        String to = "/componentId/" + newPK.getInstanceId() + "/attachmentId/" + newPK.getId() + "/";
        return wysiwygContent.replaceAll(from, to).replaceAll(fromOldId, to);
    }

    private String replaceInternalImagesPath(String wysiwygContent, String oldComponentId, String oldObjectId, String componentId, String objectId) {
        String newStr = "";
        if (wysiwygContent.contains("FileServer")) {
            String co = "ComponentId=" + oldComponentId;
            String di = "Directory=Attachment/" + this.getImagesFileName(oldObjectId);
            String diBis = "Directory=Attachment%2F" + this.getImagesFileName(oldObjectId);
            String diTer = "Directory=Attachment\\" + this.getImagesFileName(oldObjectId);
            String diQua = "Directory=Attachment%5C" + this.getImagesFileName(oldObjectId);
            int begin = 0;
            int end = wysiwygContent.indexOf(co, begin);
            while (end != -1) {
                newStr = newStr + wysiwygContent.substring(begin, end);
                newStr = newStr + "ComponentId=" + componentId;
                begin = end + co.length();
                end = wysiwygContent.indexOf(co, begin);
            }
            wysiwygContent = newStr = newStr + wysiwygContent.substring(begin, wysiwygContent.length());
            newStr = "";
            begin = 0;
            end = wysiwygContent.indexOf(di, begin);
            while (end != -1) {
                newStr = newStr + wysiwygContent.substring(begin, end);
                newStr = newStr + "Directory=Attachment/" + this.getImagesFileName(objectId);
                begin = end + di.length();
                end = wysiwygContent.indexOf(di, begin);
            }
            wysiwygContent = newStr = newStr + wysiwygContent.substring(begin, wysiwygContent.length());
            newStr = "";
            begin = 0;
            end = wysiwygContent.indexOf(diBis, begin);
            while (end != -1) {
                newStr = newStr + wysiwygContent.substring(begin, end);
                newStr = newStr + "Directory=Attachment%2F" + this.getImagesFileName(objectId);
                begin = end + diBis.length();
                end = wysiwygContent.indexOf(diBis, begin);
            }
            wysiwygContent = newStr = newStr + wysiwygContent.substring(begin, wysiwygContent.length());
            newStr = "";
            begin = 0;
            end = wysiwygContent.indexOf(diTer, begin);
            while (end != -1) {
                newStr = newStr + wysiwygContent.substring(begin, end);
                newStr = newStr + "Directory=Attachment\\" + this.getImagesFileName(objectId);
                begin = end + diTer.length();
                end = wysiwygContent.indexOf(diTer, begin);
            }
            wysiwygContent = newStr = newStr + wysiwygContent.substring(begin, wysiwygContent.length());
            newStr = "";
            begin = 0;
            end = wysiwygContent.indexOf(diQua, begin);
            while (end != -1) {
                newStr = newStr + wysiwygContent.substring(begin, end);
                newStr = newStr + "Directory=Attachment%5C" + this.getImagesFileName(objectId);
                begin = end + diQua.length();
                end = wysiwygContent.indexOf(diQua, begin);
            }
            newStr = newStr + wysiwygContent.substring(begin, wysiwygContent.length());
        } else {
            newStr = wysiwygContent;
        }
        return newStr;
    }

    public void wysiwygPlaceHaveChanged(String oldComponentId, String oldObjectId, String newComponentId, String newObjectId) {
        ForeignPK foreignKey = new ForeignPK(newObjectId, newComponentId);
        SimpleDocumentList<SimpleDocument> images = null;
        for (String language : I18NHelper.getAllSupportedLanguages()) {
            SimpleDocumentList<SimpleDocument> documents = AttachmentServiceFactory.getAttachmentService().listDocumentsByForeignKeyAndType(foreignKey, DocumentType.wysiwyg, language).removeLanguageFallbacks();
            for (SimpleDocument document : documents) {
                String wysiwyg = this.loadContent(document, language);
                if (!StringUtil.isDefined(wysiwyg)) continue;
                wysiwyg = this.replaceInternalImagesPath(wysiwyg, oldComponentId, oldObjectId, newComponentId, newObjectId);
                if (images == null) {
                    images = AttachmentServiceFactory.getAttachmentService().listDocumentsByForeignKeyAndType(foreignKey, DocumentType.image, null);
                }
                for (SimpleDocument image : images) {
                    image.getPk().setComponentName(oldComponentId);
                    SimpleDocumentPK imageCopyPk = new SimpleDocumentPK(image.getId(), newComponentId);
                    imageCopyPk.setOldSilverpeasId(image.getOldSilverpeasId());
                    wysiwyg = this.replaceInternalImageId(wysiwyg, image.getPk(), imageCopyPk);
                }
                AttachmentServiceFactory.getAttachmentService().updateAttachment(document, new ByteArrayInputStream(wysiwyg.getBytes(Charsets.UTF_8)), true, true);
            }
        }
    }

    public String getWysiwygPath(String componentId, String objectId, String language) {
        SimpleDocumentList<SimpleDocument> attachements = AttachmentServiceFactory.getAttachmentService().listDocumentsByForeignKeyAndType(new ForeignPK(objectId, componentId), DocumentType.wysiwyg, language);
        if (!attachements.isEmpty()) {
            return ((SimpleDocument)attachements.get(0)).getAttachmentPath();
        }
        return "";
    }

    public String getWysiwygPath(String componentId, String objectId) {
        return this.getWysiwygPath(componentId, objectId, null);
    }

    public List<ComponentInstLight> getGalleries() {
        OrganisationController controller = OrganisationControllerFactory.getOrganisationController();
        return controller.getComponentsWithParameterValue("viewInWysiwyg", "yes");
    }

    public List<ComponentInstLight> getStorageFile() {
        OrganisationController controller = OrganisationControllerFactory.getOrganisationController();
        return controller.getComponentsWithParameterValue("publicFiles", "yes");
    }

    public void indexEmbeddedLinkedFiles(FullIndexEntry indexEntry, List<String> embeddedAttachmentIds) {
        for (String attachmentId : embeddedAttachmentIds) {
            try {
                SimpleDocument attachment = AttachmentServiceFactory.getAttachmentService().searchDocumentById(new SimpleDocumentPK(attachmentId), null);
                if (attachment == null) continue;
                indexEntry.addLinkedFileContent(attachment.getAttachmentPath(), "UTF-8", attachment.getContentType(), attachment.getLanguage());
                indexEntry.addLinkedFileId(attachmentId);
            }
            catch (Exception e) {
                SilverTrace.warn("wisiwyg", "WysiwygController", "root.MSG_GEN_PARAM_VALUE", "Erreur dans l'indexation d'un fichier joint li\u00e9 au contenu wysiwyg - attachmentId:" + attachmentId);
            }
        }
    }

    public String createPath(String componentId, String context) {
        String path = this.getLegacyWysiwygPath(context, componentId);
        try {
            File folder = new File(path);
            if (!folder.exists()) {
                FileFolderManager.createFolder(path);
            }
            return path;
        }
        catch (UtilException e) {
            throw new AttachmentException("Wysiwyg.createPath(spaceId, componentId, context)", 4, "root.EX_CANT_CREATE_FILE", e);
        }
    }

    private void checkPath(String path) throws WysiwygException {
        if (path.contains("..")) {
            throw new WysiwygException(WysiwygManager.class.getSimpleName() + ".checkPath", 4, "peasCore.RESOURCE_ACCESS_FORBIDDEN");
        }
    }
}

