/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.domains;

import com.stratelia.webactiv.beans.admin.DomainDriver;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class DomainDriverFactory
implements ApplicationContextAware {
    private static final DomainDriverFactory instance = new DomainDriverFactory();
    private ApplicationContext context;

    private DomainDriverFactory() {
    }

    static DomainDriverFactory getDomainDriverFactory() {
        return instance;
    }

    private static DomainDriver loadDomainDriverFromSpring(String name) throws ClassNotFoundException {
        if (DomainDriverFactory.getDomainDriverFactory() == null || DomainDriverFactory.getDomainDriverFactory().getApplicationContext() == null) {
            return null;
        }
        if (DomainDriverFactory.getDomainDriverFactory().getApplicationContext().containsBean(name)) {
            return (DomainDriver)DomainDriverFactory.getDomainDriverFactory().getApplicationContext().getBean(name, DomainDriver.class);
        }
        Class<?> driverClass = Class.forName(name);
        String[] names = DomainDriverFactory.getDomainDriverFactory().getApplicationContext().getBeanNamesForType(driverClass);
        if (names.length > 0) {
            return (DomainDriver)DomainDriverFactory.getDomainDriverFactory().getApplicationContext().getBean(names[0], driverClass);
        }
        return null;
    }

    public static DomainDriver getDriver(String name) throws IllegalAccessException, InstantiationException, ClassNotFoundException {
        DomainDriver domainDriver = DomainDriverFactory.loadDomainDriverFromSpring(name);
        if (domainDriver == null) {
            Class<?> driverClass = Class.forName(name);
            domainDriver = (DomainDriver)driverClass.newInstance();
        }
        return domainDriver;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
    }

    protected ApplicationContext getApplicationContext() {
        return this.context;
    }
}

