/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.form.displayers;

import com.novell.ldap.LDAPConnection;
import com.silverpeas.form.FieldTemplate;
import com.silverpeas.form.FormException;
import com.silverpeas.form.PagesContext;
import com.silverpeas.form.Util;
import com.silverpeas.form.displayers.AbstractFieldDisplayer;
import com.silverpeas.form.fieldType.LdapField;
import com.silverpeas.util.EncodeHelper;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class LdapFieldDisplayer
extends AbstractFieldDisplayer<LdapField> {
    private static final String[] MANAGED_TYPES = new String[]{"ldap"};
    private static final String mandatoryImg = Util.getIcon("mandatoryField");

    public String[] getManagedTypes() {
        return MANAGED_TYPES;
    }

    @Override
    public void displayScripts(PrintWriter out, FieldTemplate template, PagesContext pagesContext) throws IOException {
        String language = pagesContext.getLanguage();
        if (!template.getTypeName().equals("ldap")) {
            SilverTrace.info("form", "LdapFieldDisplayer.displayScripts", "form.INFO_NOT_CORRECT_TYPE", "ldap");
        }
        if (template.isMandatory() && pagesContext.useMandatory()) {
            out.println("\tif (isWhitespace(stripInitialWhitespace(field.value))) {");
            out.println("\t\terrorMsg+=\"  - '" + template.getLabel(language) + "' " + Util.getString("GML.MustBeFilled", language) + "\\n\";");
            out.println("\t\terrorNb++;");
            out.println("\t}");
        }
        Util.getJavascriptChecker(template.getFieldName(), pagesContext, out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void display(PrintWriter out, LdapField field, FieldTemplate template, PagesContext pagesContext) throws FormException {
        LdapField ldapField;
        String value = "";
        String currentUserId = pagesContext.getUserId();
        String language = pagesContext.getLanguage();
        String fieldName = template.getFieldName();
        Map<String, String> parameters = template.getParameters(language);
        if (!field.getTypeName().equals("ldap")) {
            SilverTrace.info("form", "LdapFieldDisplayer.display", "form.INFO_NOT_CORRECT_TYPE", "ldap");
            ldapField = new LdapField();
        } else {
            ldapField = field;
        }
        if (!field.isNull()) {
            value = field.getValue(language);
        }
        Collection<String> listRes = null;
        String host = null;
        String port = null;
        String version = null;
        String baseDN = null;
        String password = null;
        String searchBase = null;
        String searchScope = null;
        String searchFilter = null;
        String searchAttribute = null;
        String searchTypeOnly = null;
        String maxResultDisplayed = null;
        String valueFieldType = "1";
        if (parameters.containsKey("host")) {
            host = parameters.get("host");
        }
        if (parameters.containsKey("port")) {
            port = parameters.get("port");
        }
        if (parameters.containsKey("version")) {
            version = parameters.get("version");
        }
        if (parameters.containsKey("baseDN")) {
            baseDN = parameters.get("baseDN");
        }
        if (parameters.containsKey("password")) {
            password = parameters.get("password");
        }
        if (parameters.containsKey("searchBase")) {
            searchBase = parameters.get("searchBase");
        }
        if (parameters.containsKey("searchScope")) {
            searchScope = parameters.get("searchScope");
        }
        if (parameters.containsKey("searchFilter")) {
            searchFilter = parameters.get("searchFilter");
        }
        if (parameters.containsKey("searchAttribute")) {
            searchAttribute = parameters.get("searchAttribute");
        }
        if (parameters.containsKey("searchTypeOnly")) {
            searchTypeOnly = parameters.get("searchTypeOnly");
        }
        if (parameters.containsKey("maxResultDisplayed")) {
            maxResultDisplayed = parameters.get("maxResultDisplayed");
        }
        if (parameters.containsKey("valueFieldType")) {
            valueFieldType = parameters.get("valueFieldType");
        }
        if (ldapField != null) {
            LDAPConnection ldapConnection = null;
            try {
                ldapConnection = ldapField.connectLdap(host, port);
                byte[] tabPassword = null;
                if (password != null) {
                    tabPassword = password.getBytes();
                }
                ldapField.bindLdap(ldapConnection, version, baseDN, tabPassword);
                if (maxResultDisplayed != null) {
                    ldapField.setConstraintLdap(ldapConnection, maxResultDisplayed);
                }
                boolean boolSearchTypeOnly = "true".equals(searchTypeOnly);
                listRes = ldapField.searchLdap(ldapConnection, searchBase, searchScope, searchFilter, searchAttribute, boolSearchTypeOnly, currentUserId);
            }
            finally {
                ldapField.disconnectLdap(ldapConnection);
            }
        }
        StringBuilder html = new StringBuilder(10000);
        if (listRes != null && !listRes.isEmpty()) {
            int zindex = 100;
            html.append("<style type=\"text/css\">\n").append("\t#listAutocomplete").append(fieldName);
            html.append(" {\n").append("\t\twidth:15em;\n").append("\t\tpadding-bottom:2em;\n");
            html.append("\t}\n").append("\t#container").append(fieldName).append(" {\n");
            html.append("\t\tz-index:").append(zindex);
            html.append("; /* z-index needed on top instance for ie & sf absolute inside relative issue ");
            html.append("*/\n").append("\t}\n").append("\t#").append(fieldName).append(" {\n");
            html.append("\t\t_position:absolute; /* abs pos needed for ie quirks */\n").append("\t}\n");
            html.append("</style>\n").append("<div id=\"listAutocomplete").append(fieldName).append("\">\n");
            html.append("<input id=\"").append(fieldName).append("\" name=\"").append(fieldName);
            html.append("\" type=\"text\"");
            if (value != null) {
                html.append(" value=\"").append(value).append("\"");
            }
            if (template.isDisabled() || template.isReadOnly()) {
                html.append(" disabled");
            }
            html.append("/>\n").append("<div id=\"container").append(fieldName).append("\"/>\n");
            html.append("</div>\n");
            if (template.isMandatory() && !template.isDisabled() && !template.isReadOnly() && !template.isHidden() && pagesContext.useMandatory()) {
                html.append("<img src=\"").append(mandatoryImg).append("\" width=\"5\" height=\"5\" ");
                html.append("border=\"0\" alt=\"\" style=\"position:absolute;left:16em;top:5px\"/>\n");
            }
            html.append("<script type=\"text/javascript\">\n");
            html.append("listArray").append(fieldName).append(" = [\n");
            Iterator<String> itRes = listRes.iterator();
            while (itRes.hasNext()) {
                html.append("\"").append(EncodeHelper.javaStringToJsString(itRes.next())).append("\"");
                if (!itRes.hasNext()) continue;
                html.append(",\n");
            }
            html.append("];\n");
            html.append("</script>\n");
            html.append("<script type=\"text/javascript\">\n");
            html.append(" this.oACDS").append(fieldName);
            html.append(" = new YAHOO.util.LocalDataSource(listArray").append(fieldName).append(");\n");
            html.append("\tthis.oAutoComp").append(fieldName).append(" = new YAHOO.widget.AutoComplete('");
            html.append(fieldName).append("','container").append(fieldName).append("', this.oACDS");
            html.append(fieldName).append(");\n").append("\tthis.oAutoComp").append(fieldName);
            html.append(".prehighlightClassName = \"yui-ac-prehighlight\";\n");
            html.append("\tthis.oAutoComp").append(fieldName).append(".typeAhead = true;\n");
            html.append("\tthis.oAutoComp").append(fieldName).append(".useShadow = true;\n");
            html.append("\tthis.oAutoComp").append(fieldName).append(".minQueryLength = 0;\n");
            if ("1".equals(valueFieldType)) {
                html.append("\tthis.oAutoComp").append(fieldName).append(".forceSelection = true;\n");
            }
            html.append("\tthis.oAutoComp").append(fieldName).append(".textboxFocusEvent.subscribe(function(){\n");
            html.append("\t\tvar sInputValue = YAHOO.util.Dom.get('").append(fieldName).append("').value;\n");
            html.append("\t\tif(sInputValue.length == 0) {\n");
            html.append("\t\t\tvar oSelf = this;\n");
            html.append("\t\t\tsetTimeout(function(){oSelf.sendQuery(sInputValue);},0);\n");
            html.append("\t\t}\n");
            html.append("\t});\n");
            html.append("</script>\n");
        } else if ("1".equals(valueFieldType)) {
            html.append("<select name=\"").append(fieldName).append("\"");
            if (template.isDisabled() || template.isReadOnly()) {
                html.append(" disabled=\"disabled\"");
            }
            html.append(" >\n");
            html.append("</select>\n");
            if (template.isMandatory() && !template.isDisabled() && !template.isReadOnly() && !template.isHidden()) {
                html.append("&nbsp;<img src=\"").append(mandatoryImg).append("\" width=\"5\" height=\"5\" border=\"0\" alt=\"\"/>&nbsp;\n");
            }
        } else {
            html.append("<input type=\"text\" name=\"").append(fieldName).append("\"");
            if (template.isDisabled() || template.isReadOnly()) {
                html.append(" disabled=\"disabled\"");
            }
            html.append(" />\n");
            if (template.isMandatory() && !template.isDisabled() && !template.isReadOnly() && !template.isHidden()) {
                html.append("&nbsp;<img src=\"").append(mandatoryImg);
                html.append("\" width=\"5\" height=\"5\" border=\"0\" alt=\"\"/>&nbsp;\n");
            }
        }
        out.println(html.toString());
    }

    @Override
    public List<String> update(String newValue, LdapField field, FieldTemplate template, PagesContext pagesContext) throws FormException {
        if (!"ldap".equals(field.getTypeName())) {
            throw new FormException("LdapFieldDisplayer.update", "form.EX_NOT_CORRECT_TYPE", "ldap");
        }
        if (!field.acceptValue(newValue, pagesContext.getLanguage())) {
            throw new FormException("LdapFieldDisplayer.update", "form.EX_NOT_CORRECT_VALUE", "ldap");
        }
        field.setValue(newValue, pagesContext.getLanguage());
        return new ArrayList<String>();
    }

    @Override
    public boolean isDisplayedMandatory() {
        return true;
    }

    @Override
    public int getNbHtmlObjectsDisplayed(FieldTemplate template, PagesContext pagesContext) {
        return 1;
    }
}

