/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.form.displayers;

import com.silverpeas.form.FieldTemplate;
import com.silverpeas.form.FormException;
import com.silverpeas.form.PagesContext;
import com.silverpeas.form.Util;
import com.silverpeas.form.displayers.AbstractTextFieldDisplayer;
import com.silverpeas.form.fieldType.TextField;
import com.silverpeas.form.fieldType.TextFieldImpl;
import com.silverpeas.util.EncodeHelper;
import com.silverpeas.util.StringUtil;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import java.io.PrintWriter;
import java.util.List;
import java.util.Map;
import org.apache.ecs.Element;
import org.apache.ecs.ElementContainer;
import org.apache.ecs.xhtml.img;
import org.apache.ecs.xhtml.input;

public class TextFieldDisplayer
extends AbstractTextFieldDisplayer<TextField> {
    @Override
    public void display(PrintWriter out, TextField field, FieldTemplate template, PagesContext pageContext) throws FormException {
        String value;
        String defaultValue;
        if (field == null) {
            return;
        }
        if (!field.getTypeName().equals("text")) {
            SilverTrace.info("form", "TextFieldDisplayer.display", "form.INFO_NOT_CORRECT_TYPE", "text");
        }
        String fieldName = Util.getFieldOccurrenceName(template.getFieldName(), field.getOccurrence());
        Map<String, String> parameters = template.getParameters(pageContext.getLanguage());
        String paramSuggestions = parameters.containsKey("suggestions") ? parameters.get("suggestions") : "false";
        boolean useSuggestions = Boolean.valueOf(paramSuggestions);
        List<String> suggestions = null;
        if (useSuggestions) {
            TextFieldImpl textField = (TextFieldImpl)field;
            suggestions = textField.getSuggestions(fieldName, template.getTemplateName(), pageContext.getComponentId());
        }
        String cssClass = null;
        if (parameters.containsKey("class") && (cssClass = parameters.get("class")) != null) {
            cssClass = "class=\"" + cssClass + "\"";
        }
        String string = defaultValue = parameters.containsKey("default") ? parameters.get("default") : "";
        if (pageContext.isIgnoreDefaultValues()) {
            defaultValue = "";
        }
        String string2 = value = !field.isNull() ? field.getValue(pageContext.getLanguage()) : defaultValue;
        if (pageContext.isBlankFieldsUse()) {
            value = "";
        }
        input textInput = new input();
        textInput.setName(fieldName);
        textInput.setID(fieldName);
        textInput.setValue(EncodeHelper.javaStringToHtmlString(value));
        textInput.setType(template.isHidden() ? "hidden" : "text");
        textInput.setMaxlength(parameters.containsKey("maxLength") ? parameters.get("maxLength") : "1000");
        textInput.setSize(parameters.containsKey("size") ? parameters.get("size") : "50");
        if (parameters.containsKey("border")) {
            textInput.setBorder(Integer.parseInt(parameters.get("border")));
        }
        if (template.isDisabled()) {
            textInput.setDisabled(true);
        } else if (template.isReadOnly()) {
            textInput.setReadOnly(true);
        }
        if (StringUtil.isDefined(cssClass)) {
            textInput.setClass(cssClass);
        }
        img image = null;
        if (template.isMandatory() && !template.isDisabled() && !template.isReadOnly() && !template.isHidden() && pageContext.useMandatory()) {
            image = new img();
            image.setSrc(Util.getIcon("mandatoryField"));
            image.setWidth(5);
            image.setHeight(5);
            image.setBorder(0);
        }
        if (suggestions != null && suggestions.size() > 0) {
            TextFieldImpl.printSuggestionsIncludes(pageContext, fieldName, out);
            out.println("<div id=\"listAutocomplete" + fieldName + "\">\n");
            out.println(textInput.toString());
            out.println("<div id=\"container" + fieldName + "\"/>\n");
            out.println("</div>\n");
            if (image != null) {
                image.setStyle("position:absolute;left:16em;top:5px");
                out.println(image.toString());
            }
            TextFieldImpl.printSuggestionsScripts(pageContext, fieldName, suggestions, out);
        } else if (image != null) {
            ElementContainer container = new ElementContainer();
            container.addElement((Element)textInput);
            container.addElement("&nbsp;");
            container.addElement((Element)image);
            out.println(container.toString());
        } else {
            out.println(textInput.toString());
        }
    }
}

