/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.form.fieldType;

import com.silverpeas.form.FormException;
import com.silverpeas.form.fieldType.TextField;
import com.stratelia.webactiv.util.DBUtil;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;

public class JdbcField
extends TextField {
    private static final long serialVersionUID = 1L;
    public static final String TYPE = "jdbc";
    public static final String VARIABLE_USER_ID = "$$userId";
    private static final String VARIABLE_REGEX_USER_ID = "\\$\\$userId";
    private String value = "";

    @Override
    public String getTypeName() {
        return TYPE;
    }

    @Override
    public String getStringValue() {
        return this.value;
    }

    @Override
    public void setStringValue(String value) {
        this.value = value;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    public Connection connectJdbc(String driverName, String url, String login, String password) throws FormException {
        Connection result = null;
        try {
            Class.forName(driverName);
        }
        catch (ClassNotFoundException e) {
            throw new FormException("JdbcField.connectJdbc", "form.EX_CANT_FIND_DRIVER_JDBC", e);
        }
        try {
            result = DriverManager.getConnection(url, login, password);
        }
        catch (SQLException e) {
            throw new FormException("JdbcField.connectJdbc", "form.EX_CANT_CONNECT_JDBC", e);
        }
        return result;
    }

    public Collection<String> selectSql(Connection jdbcConnection, String query, String currentUserId) throws FormException {
        ArrayList<String> result = new ArrayList<String>();
        query = query.replaceAll(VARIABLE_REGEX_USER_ID, currentUserId);
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        if (jdbcConnection != null) {
            try {
                prepStmt = jdbcConnection.prepareStatement(query);
            }
            catch (SQLException e) {
                throw new FormException("JdbcField.selectSql", "form.EX_CANT_PREPARE_STATEMENT_JDBC", e);
            }
            try {
                rs = prepStmt.executeQuery();
            }
            catch (SQLException e) {
                throw new FormException("JdbcField.selectSql", "form.EX_CANT_EXECUTE_QUERY_JDBC", e);
            }
            try {
                while (rs.next()) {
                    result.add(rs.getString(1));
                }
            }
            catch (SQLException e) {
                throw new FormException("JdbcField.selectSql", "form.EX_CANT_BROWSE_RESULT_JDBC", e);
            }
            finally {
                DBUtil.close(rs, prepStmt);
            }
        }
        return result;
    }
}

