/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.form.record;

import com.silverpeas.form.DataRecord;
import com.silverpeas.form.Field;
import com.silverpeas.form.FieldTemplate;
import com.silverpeas.form.FormException;
import com.silverpeas.form.FormRuntimeException;
import com.silverpeas.form.RecordSet;
import com.silverpeas.form.RecordTemplate;
import com.silverpeas.form.dummy.DummyRecordSet;
import com.silverpeas.form.record.FormEncryptionContentIterator;
import com.silverpeas.form.record.GenericDataRecord;
import com.silverpeas.form.record.GenericFieldTemplate;
import com.silverpeas.form.record.GenericRecordSet;
import com.silverpeas.form.record.GenericRecordTemplate;
import com.silverpeas.form.record.IdentifiedRecordTemplate;
import com.silverpeas.form.record.RecordRow;
import com.silverpeas.publicationTemplate.PublicationTemplate;
import com.silverpeas.publicationTemplate.PublicationTemplateException;
import com.silverpeas.publicationTemplate.PublicationTemplateManager;
import com.silverpeas.util.StringUtil;
import com.silverpeas.util.i18n.I18NHelper;
import com.silverpeas.util.security.ContentEncryptionService;
import com.silverpeas.util.security.ContentEncryptionServiceFactory;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.util.DBUtil;
import com.stratelia.webactiv.util.JNDINames;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.silverpeas.util.crypto.CryptoException;

public class GenericRecordSetManager {
    private static final GenericRecordSetManager instance = new GenericRecordSetManager();
    private static final String SEPARATOR = "|";
    private final Map<String, GenericRecordSet> cache = new HashMap<String, GenericRecordSet>();
    private static final String TEMPLATE_TABLE = "SB_FormTemplate_Template";
    private static final String TEMPLATE_COLUMNS = "templateId,externalId,templateName";
    private static final String SELECT_TEMPLATE = "select templateId,externalId,templateName from SB_FormTemplate_Template where externalId=?";
    private static final String INSERT_TEMPLATE = "insert into SB_FormTemplate_Template(templateId,externalId,templateName) values (?,?,?)";
    private static final String DELETE_TEMPLATE = "delete from SB_FormTemplate_Template where templateId=?";
    private static final String TEMPLATE_FIELDS_TABLE = "SB_FormTemplate_TemplateField";
    private static final String TEMPLATE_FIELDS_COLUMNS = "templateId,fieldName,fieldIndex,fieldType,isMandatory,isReadOnly,isHidden";
    private static final String SELECT_TEMPLATE_FIELDS = "select templateId,fieldName,fieldIndex,fieldType,isMandatory,isReadOnly,isHidden from SB_FormTemplate_TemplateField where templateId=? order by fieldIndex";
    private static final String INSERT_TEMPLATE_FIELD = "insert into SB_FormTemplate_TemplateField(templateId,fieldName,fieldIndex,fieldType,isMandatory,isReadOnly,isHidden) values (?,?,?,?,?,?,?)";
    private static final String DELETE_TEMPLATE_FIELDS = "delete from SB_FormTemplate_TemplateField where templateId=?";
    private static final String RECORD_TABLE = "SB_FormTemplate_Record";
    private static final String RECORD_COLUMNS = "recordId,templateId,externalId,lang";
    private static final String SELECT_RECORD = "SELECT recordId, templateId, externalId, lang FROM sb_formtemplate_record WHERE templateId=? AND externalId=?";
    private static final String INSERT_RECORD = "insert into SB_FormTemplate_Record(recordId,templateId,externalId,lang) values (?,?,?,?)";
    private static final String DELETE_TEMPLATE_RECORDS = "delete from SB_FormTemplate_Record where templateId=?";
    private static final String DELETE_RECORD = "delete from SB_FormTemplate_Record where recordId=?";
    private static final String MOVE_RECORD = "update SB_FormTemplate_Record set templateId = ? where recordId = ? ";
    private static final String FIELDS_TABLE = "SB_FormTemplate_TextField";
    private static final String FIELDS_COLUMNS = "recordId,fieldName,fieldValue,fieldValueIndex";
    private static final String SELECT_FIELDS = "SELECT recordId, fieldName, fieldValue, fieldValueIndex FROM sb_formtemplate_textfield WHERE recordId=? order by fieldName, fieldValueIndex";
    private static final String INSERT_FIELD = "insert into SB_FormTemplate_TextField(recordId,fieldName,fieldValue,fieldValueIndex) values (?,?,?,?)";
    private static final String UPDATE_FIELD = "update SB_FormTemplate_TextField set fieldValue=? where recordId=? and fieldName=? and fieldValueIndex=?";
    private static final String DELETE_TEMPLATE_RECORDS_FIELDS = "delete from SB_FormTemplate_TextField where recordId in (select recordId from SB_FormTemplate_Record where templateId=?)";
    private static final String DELETE_RECORD_FIELDS = "delete from SB_FormTemplate_TextField where recordId=?";
    private static final String SELECT_TEMPLATE_RECORD_VALUES = "select fieldValue from SB_FormTemplate_TextField tf, SB_FormTemplate_Record rec, SB_FormTemplate_Template tpl where tf.fieldName= ? and tf.recordId = rec.recordId and rec.externalId = ? and rec.templateId = tpl.templateId and tpl.externalId = ?";
    private static final String SELECT_TEMPLATE_RECORD_ENTRIES = "SELECT * FROM SB_FormTemplate_TextField tf, SB_FormTemplate_Record rec, SB_FormTemplate_Template tpl WHERE tpl.templatename = ? AND rec.templateId = tpl.templateId AND tf.recordId = rec.recordId";

    private GenericRecordSetManager() {
    }

    public static GenericRecordSetManager getInstance() {
        return instance;
    }

    public GenericRecordSet createRecordSet(String externalId, RecordTemplate template) throws FormException {
        return this.createRecordSet(externalId, template, null, false);
    }

    public GenericRecordSet createRecordSet(String externalId, RecordTemplate template, String templateName, boolean encrypted) throws FormException {
        Connection con = null;
        IdentifiedRecordTemplate identifiedTemplate = new IdentifiedRecordTemplate(template);
        identifiedTemplate.setExternalId(externalId);
        identifiedTemplate.setTemplateName(templateName);
        identifiedTemplate.setEncrypted(encrypted);
        try {
            con = this.getConnection();
            IdentifiedRecordTemplate existingOne = this.selectTemplateRow(con, externalId);
            if (existingOne == null) {
                this.insertTemplateRow(con, identifiedTemplate);
                if (templateName == null) {
                    this.insertTemplateFieldRows(con, identifiedTemplate);
                }
                GenericRecordSet newSet = new GenericRecordSet(identifiedTemplate);
                this.cacheRecordSet(externalId, newSet);
                GenericRecordSet genericRecordSet = newSet;
                return genericRecordSet;
            }
            GenericRecordSet genericRecordSet = (GenericRecordSet)this.getRecordSet(externalId);
            return genericRecordSet;
        }
        catch (SQLException e) {
            throw new FormException("GenericRecordSetManager", "form.EXP_INSERT_FAILED", e);
        }
        finally {
            this.closeConnection(con);
        }
    }

    public String getRawValue(String templateExternalId, String recordExternalId, String fieldName) throws FormException {
        Connection con = null;
        try {
            con = this.getConnection();
            String string = this.selectRecordFieldsRow(con, templateExternalId, recordExternalId, fieldName);
            return string;
        }
        catch (SQLException e) {
            throw new FormException("GenericRecordSetManager.getRawValues", "form.EXP_INSERT_FAILED", "templateExternalId : " + templateExternalId + ", recordExternalId : " + recordExternalId, (Exception)e);
        }
        finally {
            this.closeConnection(con);
        }
    }

    public RecordSet getRecordSet(String externalId) throws FormException {
        SilverTrace.debug("form", "GenericRecordSetManager.getRecordSet", "root.MSG_GEN_ENTER_METHOD", "externalId = " + externalId);
        GenericRecordSet cachedSet = this.getCachedRecordSet(externalId);
        if (cachedSet != null) {
            return cachedSet;
        }
        Connection con = null;
        IdentifiedRecordTemplate template = null;
        try {
            con = this.getConnection();
            template = this.selectTemplateRow(con, externalId);
            if (template == null) {
                DummyRecordSet dummyRecordSet = new DummyRecordSet();
                return dummyRecordSet;
            }
            String templateName = template.getTemplateName();
            if (templateName != null && templateName.length() > 0) {
                this.selectTemplateFieldsFromXML(template);
            } else {
                this.selectTemplateFieldRows(con, template);
            }
            cachedSet = new GenericRecordSet(template);
            this.cacheRecordSet(externalId, cachedSet);
            GenericRecordSet genericRecordSet = cachedSet;
            return genericRecordSet;
        }
        catch (SQLException e) {
            throw new FormException("GenericRecordSetManager", "form.EXP_SELECT_FAILED", e);
        }
        finally {
            this.closeConnection(con);
        }
    }

    public void removeRecordSet(String externalId) throws FormException {
        this.removeCachedRecordSet(externalId);
        Connection con = null;
        IdentifiedRecordTemplate template = null;
        try {
            con = this.getConnection();
            template = this.selectTemplateRow(con, externalId);
            if (template == null) {
                SilverTrace.error("form", "GenericRecordSetManager.removeRecordSet", "form.EXP_UNKNOWN_TEMPLATE", "externalId = " + externalId);
            } else {
                this.deleteFieldRows(con, template);
                this.deleteRecordRows(con, template);
                this.deleteTemplateFieldRows(con, template);
                this.deleteTemplateRow(con, template);
            }
        }
        catch (SQLException e) {
            throw new FormException("GenericRecordSetManager", "form.EXP_DELETE_FAILED", e);
        }
        finally {
            this.closeConnection(con);
        }
    }

    private GenericRecordSet getCachedRecordSet(String externalId) {
        return this.cache.get(externalId);
    }

    private void cacheRecordSet(String externalId, GenericRecordSet set) {
        this.cache.put(externalId, set);
    }

    private void removeCachedRecordSet(String externalId) {
        this.cache.remove(externalId);
    }

    public void removeTemplateFromCache(String templateName) {
        SilverTrace.debug("form", "GenericRecordSetManager.removeTemplateFromCache", "root.MSG_GEN_ENTER_METHOD", "templateName = " + templateName);
        ArrayList<String> ids = new ArrayList<String>();
        for (String id : this.cache.keySet()) {
            GenericRecordSet rs = this.cache.get(id);
            IdentifiedRecordTemplate template = (IdentifiedRecordTemplate)rs.getRecordTemplate();
            if (template == null || !templateName.equalsIgnoreCase(template.getTemplateName())) continue;
            ids.add(id);
        }
        SilverTrace.debug("form", "GenericRecordSetManager.removeTemplateFromCache", "root.MSG_GEN_PARAM_VALUE", "externalIds to remove = " + ((Object)ids).toString());
        for (String id : ids) {
            this.removeCachedRecordSet(id);
        }
    }

    public DataRecord getRecord(IdentifiedRecordTemplate template, String objectId) throws FormException {
        return this.getRecord(template, objectId, null);
    }

    public DataRecord getRecord(IdentifiedRecordTemplate template, String objectId, String language) throws FormException {
        SilverTrace.debug("form", "GenericRecordSetManager.getRecord", "root.MSG_GEN_PARAM_VALUE", "objectId = " + objectId + ", language = " + language);
        Connection con = null;
        try {
            con = this.getConnection();
            GenericDataRecord record = this.selectRecordRow(con, template, objectId, language);
            if (record != null) {
                record.setLanguage(language);
            } else if (I18NHelper.isI18nContentEnabled()) {
                ArrayList<String> languages = new ArrayList<String>(I18NHelper.getAllSupportedLanguages());
                languages.remove(language);
                for (String lang : languages) {
                    record = this.selectRecordRow(con, template, objectId, lang);
                    if (record == null) continue;
                    record.setLanguage(lang);
                    break;
                }
            }
            if (record != null) {
                try {
                    this.selectFieldRows(con, template, record);
                }
                catch (CryptoException e) {
                    throw new FormException("GenericRecordSetManager", "form.DECRYPTING_DATA_FAILED", e);
                }
            }
            GenericDataRecord genericDataRecord = record;
            return genericDataRecord;
        }
        catch (SQLException e) {
            throw new FormException("GenericRecordSetManager", "form.EXP_SELECT_FAILED", e);
        }
        finally {
            this.closeConnection(con);
        }
    }

    public List<String> getLanguagesOfRecord(IdentifiedRecordTemplate template, String externalId) throws FormException {
        SilverTrace.debug("form", "GenericRecordSetManager.getLanguagesOfRecord", "root.MSG_GEN_PARAM_VALUE", "externalId = " + externalId);
        Connection con = null;
        try {
            con = this.getConnection();
            List<String> list = this.selectLanguagesOfRecord(con, template, externalId);
            return list;
        }
        catch (SQLException e) {
            throw new FormException("GenericRecordSetManager", "form.EXP_SELECT_FAILED", e);
        }
        finally {
            this.closeConnection(con);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void insertRecord(IdentifiedRecordTemplate template, DataRecord insertedRecord) throws FormException {
        Connection con = null;
        try {
            GenericDataRecord record = (GenericDataRecord)insertedRecord;
            con = this.getConnection();
            this.insertRecordRow(con, template, record);
            try {
                this.insertFieldRows(con, template, record);
            }
            catch (CryptoException e) {
                throw new FormException("GenericRecordSetManager", "form.ENCRYPTING_DATA_FAILED", e);
            }
        }
        catch (ClassCastException e) {
            try {
                throw new FormException("GenericRecordSetManager", "form.EXP_UNKNOWN_TEMPLATE", e);
                catch (SQLException e2) {
                    throw new FormException("GenericRecordSetManager", "form.EXP_INSERT_FAILED", e2);
                }
            }
            catch (Throwable throwable) {
                this.closeConnection(con);
                throw throwable;
            }
        }
        this.closeConnection(con);
    }

    public void cloneRecord(IdentifiedRecordTemplate templateFrom, String objectIdFrom, IdentifiedRecordTemplate templateTo, String objectIdTo, Map<String, String> fileIds) throws FormException {
        SilverTrace.debug("form", "GenericRecordSetManager.cloneRecord", "root.MSG_GEN_ENTER_METHOD", "objectIdFrom = " + objectIdFrom + ", objectIdTo = " + objectIdTo);
        Iterator<String> languages = I18NHelper.getLanguages();
        while (languages.hasNext()) {
            Field[] fields;
            String language = languages.next();
            GenericDataRecord record = (GenericDataRecord)this.getRecord(templateFrom, objectIdFrom, language);
            if (record == null) continue;
            record.setInternalId(-1);
            record.setId(objectIdTo);
            for (Field field : fields = record.getFields()) {
                if ("file".equals(field.getTypeName())) {
                    String oldId = field.getStringValue();
                    if (oldId == null || fileIds == null) continue;
                    String newId = fileIds.get(oldId);
                    field.setStringValue(newId);
                    continue;
                }
                String oldValue = field.getStringValue();
                if (oldValue == null || !oldValue.startsWith("xmlWysiwygField_")) continue;
                String newValue = oldValue.replaceAll(objectIdFrom, objectIdTo);
                field.setStringValue(newValue);
            }
            this.insertRecord(templateTo, record);
        }
    }

    public void moveRecord(int recordId, IdentifiedRecordTemplate templateTo) throws FormException {
        SilverTrace.debug("form", "GenericRecordSetManager.moveRecord", "root.MSG_GEN_ENTER_METHOD", "recordId = " + recordId + ", toInstanceId = " + templateTo.getInternalId());
        Connection con = null;
        try {
            con = this.getConnection();
            this.updateTemplateId(con, templateTo.getInternalId(), recordId);
        }
        catch (SQLException e) {
            throw new FormException("GenericRecordSetManager.moveRecord", "form.CANT_MOVE_RECORD_FROM_TEMPLATE_TO_ANOTHER", e);
        }
        finally {
            this.closeConnection(con);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void updateRecord(IdentifiedRecordTemplate template, DataRecord updatedRecord) throws FormException {
        Connection con = null;
        try {
            GenericDataRecord record = (GenericDataRecord)updatedRecord;
            con = this.getConnection();
            try {
                this.updateFieldRows(con, template, record);
            }
            catch (CryptoException e) {
                throw new FormException("GenericRecordSetManager", "form.ENCRYPTING_DATA_FAILED", e);
            }
        }
        catch (ClassCastException e) {
            try {
                throw new FormException("GenericRecordSetManager", "form.EXP_UNKNOWN_TEMPLATE", e);
                catch (SQLException e2) {
                    throw new FormException("GenericRecordSetManager", "form.EXP_UPDATED_FAILED", e2);
                }
            }
            catch (Throwable throwable) {
                this.closeConnection(con);
                throw throwable;
            }
        }
        this.closeConnection(con);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deleteRecord(IdentifiedRecordTemplate template, DataRecord deletedRecord) throws FormException {
        Connection con = null;
        try {
            GenericDataRecord record = (GenericDataRecord)deletedRecord;
            con = this.getConnection();
            this.deleteFieldRows(con, template, record);
            this.deleteRecordRows(con, template, record);
        }
        catch (ClassCastException e) {
            try {
                throw new FormException("GenericRecordSetManager", "form.EXP_UNKNOWN_TEMPLATE", e);
                catch (SQLException e2) {
                    throw new FormException("GenericRecordSetManager", "form.EXP_DELETE_FAILED", e2);
                }
            }
            catch (Throwable throwable) {
                this.closeConnection(con);
                throw throwable;
            }
        }
        this.closeConnection(con);
    }

    public void encryptData(String templateName) throws CryptoException {
        this.encryptOrDecryptData(templateName, true);
    }

    public void decryptData(String templateName) throws CryptoException {
        this.encryptOrDecryptData(templateName, false);
    }

    private void encryptOrDecryptData(String templateName, boolean encrypt) throws CryptoException {
        ContentEncryptionService encryptionService = this.getEncryptionService();
        FormEncryptionContentIterator contentIterator = new FormEncryptionContentIterator(templateName);
        if (encrypt) {
            try {
                encryptionService.encryptContents(contentIterator);
            }
            catch (FormRuntimeException e) {
                throw new CryptoException("The encryption failed!", e);
            }
        }
        try {
            encryptionService.decryptContents(contentIterator);
        }
        catch (Exception e) {
            throw new CryptoException("The decryption failed!", e);
        }
    }

    private ContentEncryptionService getEncryptionService() {
        return ContentEncryptionServiceFactory.getFactory().getContentEncryptionService();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateFieldRows(Connection con, List<RecordRow> rows) throws SQLException {
        PreparedStatement update = con.prepareStatement(UPDATE_FIELD);
        try {
            for (RecordRow row : rows) {
                update.setString(1, row.getFieldValue());
                update.setInt(2, row.getRecordId());
                update.setString(3, row.getFieldName());
                int nbRowsUpdated = update.executeUpdate();
                if (nbRowsUpdated == 1) continue;
                SilverTrace.error("form", this.getClass().getName() + ".updateFieldRows()", "root.MSG_GEN_PARAM_VALUE", "Update failed for record " + row.getRecordId() + " and field '" + row.getFieldName() + "' with value " + row.getFieldValue());
            }
        }
        finally {
            DBUtil.close(update);
        }
    }

    protected List<RecordRow> getAllRecordsOfTemplate(String templateName) throws FormException {
        Object row;
        Connection con = null;
        PreparedStatement select = null;
        ResultSet rs = null;
        ArrayList<RecordRow> rows = new ArrayList<RecordRow>();
        try {
            con = this.getConnection();
            select = con.prepareStatement(SELECT_TEMPLATE_RECORD_ENTRIES);
            select.setString(1, templateName);
            rs = select.executeQuery();
            while (rs.next()) {
                row = new RecordRow(rs.getInt("recordId"), rs.getString("fieldName"), rs.getString("fieldValue"));
                rows.add((RecordRow)row);
            }
            row = rows;
        }
        catch (SQLException e) {
            try {
                throw new FormException("GenericRecordSetManager", "form.EXP_SELECT_FAILED", e);
            }
            catch (Throwable throwable) {
                DBUtil.close(rs, select);
                DBUtil.close(con);
                throw throwable;
            }
        }
        DBUtil.close(rs, select);
        DBUtil.close(con);
        return row;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String selectRecordFieldsRow(Connection con, String templateExternalId, String recordExternalId, String fieldName) throws SQLException {
        ResultSet rs;
        PreparedStatement select;
        block3: {
            String string;
            select = null;
            rs = null;
            try {
                select = con.prepareStatement(SELECT_TEMPLATE_RECORD_VALUES);
                select.setString(1, fieldName);
                select.setString(2, recordExternalId);
                select.setString(3, templateExternalId);
                rs = select.executeQuery();
                if (rs.next()) break block3;
                string = null;
            }
            catch (Throwable throwable) {
                DBUtil.close(rs, select);
                throw throwable;
            }
            DBUtil.close(rs, select);
            return string;
        }
        String string = rs.getString("fieldValue");
        DBUtil.close(rs, select);
        return string;
    }

    private void selectTemplateFieldsFromXML(IdentifiedRecordTemplate template) throws FormException {
        FieldTemplate[] fields;
        GenericRecordTemplate genericRecordTemplate = null;
        try {
            PublicationTemplate publicationTemplateImpl = PublicationTemplateManager.getInstance().loadPublicationTemplate(template.getTemplateName());
            genericRecordTemplate = (GenericRecordTemplate)publicationTemplateImpl.getRecordTemplate();
            template.setEncrypted(publicationTemplateImpl.isDataEncrypted());
        }
        catch (PublicationTemplateException e) {
            throw new FormException("GenericRecordSetManager", "form.EXP_UNKNOWN_TEMPLATE", e);
        }
        GenericRecordTemplate wrapped = (GenericRecordTemplate)template.getWrappedTemplate();
        for (FieldTemplate field : fields = genericRecordTemplate.getFieldTemplates()) {
            String displayName = field.getDisplayerName();
            GenericFieldTemplate fieldTemplate = new GenericFieldTemplate(field.getFieldName(), field.getTypeName());
            fieldTemplate.setMandatory(field.isMandatory());
            fieldTemplate.setReadOnly(field.isReadOnly());
            fieldTemplate.setHidden(field.isHidden());
            fieldTemplate.setDisabled(field.isDisabled());
            fieldTemplate.setSearchable(field.isSearchable());
            fieldTemplate.setDisplayerName(displayName != null ? displayName : "");
            fieldTemplate.setLabel(field.getLabel());
            fieldTemplate.setUsedAsFacet(field.isUsedAsFacet());
            fieldTemplate.setParametersObj(field.getParametersObj());
            fieldTemplate.setMaximumNumberOfOccurrences(field.getMaximumNumberOfOccurrences());
            wrapped.addFieldTemplate(fieldTemplate);
        }
    }

    private Connection getConnection() throws FormException {
        SilverTrace.info("formTemplate", "GenericRecordSetManager.getConnection()", "root.MSG_GEN_ENTER_METHOD");
        try {
            return DBUtil.makeConnection(JNDINames.FORMTEMPLATE_DATASOURCE);
        }
        catch (Exception e) {
            throw new FormException("GenericRecordSetManager.getConnection()", "root.EX_CONNECTION_OPEN_FAILED", e);
        }
    }

    private int getNextId(String tableName, String idColumn) throws SQLException {
        int nextId = 0;
        try {
            nextId = DBUtil.getNextId(tableName, idColumn);
        }
        catch (Exception e) {
            throw new SQLException(e.toString());
        }
        if (nextId == 0) {
            return 1;
        }
        return nextId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertTemplateRow(Connection con, IdentifiedRecordTemplate template) throws SQLException {
        PreparedStatement insert = null;
        try {
            int internalId = this.getNextId(TEMPLATE_TABLE, "templateId");
            template.setInternalId(internalId);
            String externalId = template.getExternalId();
            String templateName = template.getTemplateName();
            insert = con.prepareStatement(INSERT_TEMPLATE);
            insert.setInt(1, internalId);
            insert.setString(2, externalId);
            insert.setString(3, templateName);
            insert.execute();
        }
        catch (Throwable throwable) {
            DBUtil.close(insert);
            throw throwable;
        }
        DBUtil.close(insert);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertTemplateFieldRows(Connection con, IdentifiedRecordTemplate template) throws SQLException, FormException {
        PreparedStatement insert = null;
        try {
            insert = con.prepareStatement(INSERT_TEMPLATE_FIELD);
            int internalId = template.getInternalId();
            FieldTemplate[] fields = template.getFieldTemplates();
            for (int i = 0; i < fields.length; ++i) {
                insert.setInt(1, internalId);
                insert.setString(2, fields[i].getFieldName());
                insert.setInt(3, i);
                insert.setString(4, fields[i].getTypeName());
                if (fields[i].isMandatory()) {
                    insert.setInt(5, 1);
                } else {
                    insert.setInt(5, 0);
                }
                if (fields[i].isReadOnly()) {
                    insert.setInt(6, 1);
                } else {
                    insert.setInt(6, 0);
                }
                insert.setInt(7, 1);
                insert.execute();
            }
        }
        finally {
            DBUtil.close(insert);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IdentifiedRecordTemplate selectTemplateRow(Connection con, String externalId) throws SQLException {
        ResultSet rs;
        PreparedStatement select;
        block3: {
            IdentifiedRecordTemplate identifiedRecordTemplate;
            select = null;
            rs = null;
            try {
                select = con.prepareStatement(SELECT_TEMPLATE);
                select.setString(1, externalId);
                rs = select.executeQuery();
                if (rs.next()) break block3;
                identifiedRecordTemplate = null;
            }
            catch (Throwable throwable) {
                DBUtil.close(rs, select);
                throw throwable;
            }
            DBUtil.close(rs, select);
            return identifiedRecordTemplate;
        }
        int internalId = rs.getInt(1);
        String templateName = rs.getString(3);
        IdentifiedRecordTemplate template = new IdentifiedRecordTemplate(new GenericRecordTemplate());
        template.setInternalId(internalId);
        template.setExternalId(externalId);
        template.setTemplateName(templateName);
        IdentifiedRecordTemplate identifiedRecordTemplate = template;
        DBUtil.close(rs, select);
        return identifiedRecordTemplate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void selectTemplateFieldRows(Connection con, IdentifiedRecordTemplate template) throws SQLException, FormException {
        PreparedStatement select = null;
        ResultSet rs = null;
        GenericRecordTemplate wrapped = (GenericRecordTemplate)template.getWrappedTemplate();
        try {
            select = con.prepareStatement(SELECT_TEMPLATE_FIELDS);
            select.setInt(1, template.getInternalId());
            rs = select.executeQuery();
            GenericFieldTemplate fieldTemplate = null;
            while (rs.next()) {
                String fieldName = rs.getString(2);
                String fieldType = rs.getString(4);
                boolean isMandatory = rs.getBoolean(5);
                boolean isReadOnly = rs.getBoolean(6);
                boolean isHidden = rs.getBoolean(7);
                fieldTemplate = new GenericFieldTemplate(fieldName, fieldType);
                fieldTemplate.setMandatory(isMandatory);
                fieldTemplate.setReadOnly(isReadOnly);
                fieldTemplate.setHidden(isHidden);
                wrapped.addFieldTemplate(fieldTemplate);
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, select);
            throw throwable;
        }
        DBUtil.close(rs, select);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteFieldRows(Connection con, IdentifiedRecordTemplate template) throws SQLException {
        PreparedStatement delete = null;
        try {
            int internalId = template.getInternalId();
            delete = con.prepareStatement(DELETE_TEMPLATE_RECORDS_FIELDS);
            delete.setInt(1, internalId);
            delete.execute();
        }
        catch (Throwable throwable) {
            DBUtil.close(delete);
            throw throwable;
        }
        DBUtil.close(delete);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteRecordRows(Connection con, IdentifiedRecordTemplate template) throws SQLException {
        PreparedStatement delete = null;
        try {
            int internalId = template.getInternalId();
            delete = con.prepareStatement(DELETE_TEMPLATE_RECORDS);
            delete.setInt(1, internalId);
            delete.execute();
        }
        catch (Throwable throwable) {
            DBUtil.close(delete);
            throw throwable;
        }
        DBUtil.close(delete);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteTemplateFieldRows(Connection con, IdentifiedRecordTemplate template) throws SQLException {
        PreparedStatement delete = null;
        try {
            int internalId = template.getInternalId();
            delete = con.prepareStatement(DELETE_TEMPLATE_FIELDS);
            delete.setInt(1, internalId);
            delete.execute();
        }
        catch (Throwable throwable) {
            DBUtil.close(delete);
            throw throwable;
        }
        DBUtil.close(delete);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteTemplateRow(Connection con, IdentifiedRecordTemplate template) throws SQLException {
        PreparedStatement delete = null;
        try {
            int internalId = template.getInternalId();
            delete = con.prepareStatement(DELETE_TEMPLATE);
            delete.setInt(1, internalId);
            delete.execute();
        }
        catch (Throwable throwable) {
            DBUtil.close(delete);
            throw throwable;
        }
        DBUtil.close(delete);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertRecordRow(Connection con, IdentifiedRecordTemplate template, GenericDataRecord record) throws SQLException {
        PreparedStatement insert = null;
        try {
            int internalId = this.getNextId(RECORD_TABLE, "recordId");
            record.setInternalId(internalId);
            int templateId = template.getInternalId();
            String externalId = record.getId();
            SilverTrace.debug("form", "GenericRecordSetManager.insertRecordRow", "root.MSG_GEN_PARAM_VALUE", "internalId = " + internalId + ", templateId = " + templateId + ", externalId = " + externalId + ", language = " + record.getLanguage());
            insert = con.prepareStatement(INSERT_RECORD);
            insert.setInt(1, internalId);
            insert.setInt(2, templateId);
            insert.setString(3, externalId);
            if (!I18NHelper.isI18nContentActivated || I18NHelper.isDefaultLanguage(record.getLanguage())) {
                insert.setNull(4, 12);
            } else {
                insert.setString(4, record.getLanguage());
            }
            insert.execute();
        }
        catch (Throwable throwable) {
            DBUtil.close(insert);
            throw throwable;
        }
        DBUtil.close(insert);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertFieldRows(Connection con, IdentifiedRecordTemplate template, GenericDataRecord record) throws SQLException, FormException, CryptoException {
        PreparedStatement insert = null;
        try {
            insert = con.prepareStatement(INSERT_FIELD);
            int recordId = record.getInternalId();
            Map<String, String> rows = this.getRowsToStore(record, template.isEncrypted());
            for (String fieldNameIndexed : rows.keySet()) {
                String[] fieldNameAndIndex = StringUtil.split((String)fieldNameIndexed, (String)SEPARATOR);
                String fieldName = fieldNameAndIndex[0];
                int fieldValueIndex = Integer.parseInt(fieldNameAndIndex[1]);
                String fieldValue = rows.get(fieldNameIndexed);
                insert.setInt(1, recordId);
                insert.setString(2, fieldName);
                insert.setString(3, fieldValue);
                insert.setInt(4, fieldValueIndex);
                insert.execute();
            }
        }
        finally {
            DBUtil.close(insert);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GenericDataRecord selectRecordRow(Connection con, IdentifiedRecordTemplate template, String externalId, String language) throws SQLException, FormException {
        ResultSet rs;
        PreparedStatement select;
        block5: {
            GenericDataRecord genericDataRecord;
            SilverTrace.debug("form", "GenericRecordSetManager.selectRecordRow", "root.MSG_GEN_ENTER_METHOD", "templateId = " + template.getInternalId() + ", externalId = " + externalId + ", language = " + language);
            select = null;
            rs = null;
            try {
                if (!I18NHelper.isI18nContentActivated || I18NHelper.isDefaultLanguage(language)) {
                    language = null;
                }
                select = language != null ? con.prepareStatement("SELECT recordId, templateId, externalId, lang FROM sb_formtemplate_record WHERE templateId=? AND externalId=? AND lang = ? ") : con.prepareStatement("SELECT recordId, templateId, externalId, lang FROM sb_formtemplate_record WHERE templateId=? AND externalId=? AND lang is null");
                select.setInt(1, template.getInternalId());
                select.setString(2, externalId);
                if (language != null) {
                    select.setString(3, language);
                }
                if ((rs = select.executeQuery()).next()) break block5;
                genericDataRecord = null;
            }
            catch (Throwable throwable) {
                DBUtil.close(rs, select);
                throw throwable;
            }
            DBUtil.close(rs, select);
            return genericDataRecord;
        }
        int internalId = rs.getInt(1);
        GenericDataRecord record = new GenericDataRecord(template);
        record.setInternalId(internalId);
        record.setId(externalId);
        record.setLanguage(language);
        GenericDataRecord genericDataRecord = record;
        DBUtil.close(rs, select);
        return genericDataRecord;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void selectFieldRows(Connection con, IdentifiedRecordTemplate template, GenericDataRecord record) throws SQLException, FormException, CryptoException {
        PreparedStatement select = null;
        ResultSet rs = null;
        try {
            select = con.prepareStatement(SELECT_FIELDS);
            select.setInt(1, record.getInternalId());
            rs = select.executeQuery();
            Map<String, String> rows = new TreeMap<String, String>();
            while (rs.next()) {
                String fieldName = rs.getString("fieldName");
                String fieldValue = rs.getString("fieldValue");
                int fieldValueIndex = rs.getInt("fieldvalueindex");
                rows.put(fieldName + SEPARATOR + fieldValueIndex, fieldValue);
            }
            if (template.isEncrypted()) {
                rows = this.getEncryptionService().decryptContent(rows);
            }
            for (String fieldNameIndexed : rows.keySet()) {
                String[] fieldNameAndIndex = StringUtil.split((String)fieldNameIndexed, (String)SEPARATOR);
                String fieldName = fieldNameAndIndex[0];
                int fieldValueIndex = Integer.parseInt(fieldNameAndIndex[1]);
                Field field = record.getField(fieldName, fieldValueIndex);
                String fieldValue = rows.get(fieldNameIndexed);
                if (field == null) continue;
                SilverTrace.debug("form", "GenericRecordSetManager.selectFieldRows", "root.MSG_GEN_PARAM_VALUE", "fieldName=" + fieldName + ", fieldValue=" + fieldValue);
                field.setStringValue(fieldValue);
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, select);
            throw throwable;
        }
        DBUtil.close(rs, select);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> selectLanguagesOfRecord(Connection con, IdentifiedRecordTemplate template, String externalId) throws SQLException {
        ArrayList<String> arrayList;
        PreparedStatement select = null;
        ResultSet rs = null;
        ArrayList<String> languages = new ArrayList<String>();
        try {
            select = con.prepareStatement(SELECT_RECORD);
            select.setInt(1, template.getInternalId());
            select.setString(2, externalId);
            rs = select.executeQuery();
            while (rs.next()) {
                String language = rs.getString("lang");
                if (!StringUtil.isDefined(language)) {
                    language = I18NHelper.defaultLanguage;
                }
                languages.add(language);
            }
            arrayList = languages;
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, select);
            throw throwable;
        }
        DBUtil.close(rs, select);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateFieldRows(Connection con, IdentifiedRecordTemplate template, GenericDataRecord record) throws SQLException, FormException, CryptoException {
        PreparedStatement update = null;
        PreparedStatement insert = null;
        try {
            update = con.prepareStatement(UPDATE_FIELD);
            int recordId = record.getInternalId();
            Map<String, String> rows = this.getRowsToStore(record, template.isEncrypted());
            for (String fieldNameIndexed : rows.keySet()) {
                String[] fieldNameAndIndex = StringUtil.split((String)fieldNameIndexed, (String)SEPARATOR);
                String fieldName = fieldNameAndIndex[0];
                int fieldValueIndex = Integer.parseInt(fieldNameAndIndex[1]);
                String fieldValue = rows.get(fieldNameIndexed);
                update.setString(1, fieldValue);
                update.setInt(2, recordId);
                update.setString(3, fieldName);
                update.setInt(4, fieldValueIndex);
                int nbRowsCount = update.executeUpdate();
                if (nbRowsCount != 0) continue;
                insert = con.prepareStatement(INSERT_FIELD);
                insert.setInt(1, recordId);
                insert.setString(2, fieldName);
                insert.setString(3, fieldValue);
                insert.setInt(4, fieldValueIndex);
                insert.execute();
            }
        }
        finally {
            DBUtil.close(update);
            DBUtil.close(insert);
        }
    }

    private Map<String, String> getRowsToStore(GenericDataRecord record, boolean crypt) throws FormException, CryptoException {
        Map<String, String> rows = new HashMap<String, String>();
        for (Field field : record.getFields()) {
            String fieldNameIndexed = field.getName() + SEPARATOR + field.getOccurrence();
            rows.put(fieldNameIndexed, field.getStringValue());
            SilverTrace.debug("form", "GenericRecordSetManager.updateFieldRows", "root.MSG_GEN_PARAM_VALUE", "fieldNameIndexed = " + fieldNameIndexed + ", fieldValue = " + field.getStringValue() + ", recordId = " + record.getInternalId());
        }
        if (crypt) {
            rows = this.getEncryptionService().encryptContent(rows);
        }
        return rows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteFieldRows(Connection con, IdentifiedRecordTemplate template, GenericDataRecord record) throws SQLException {
        PreparedStatement delete = null;
        try {
            int internalId = record.getInternalId();
            delete = con.prepareStatement(DELETE_RECORD_FIELDS);
            delete.setInt(1, internalId);
            delete.execute();
        }
        catch (Throwable throwable) {
            DBUtil.close(delete);
            throw throwable;
        }
        DBUtil.close(delete);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteRecordRows(Connection con, IdentifiedRecordTemplate template, GenericDataRecord record) throws SQLException {
        PreparedStatement delete = null;
        try {
            int internalId = record.getInternalId();
            delete = con.prepareStatement(DELETE_RECORD);
            delete.setInt(1, internalId);
            delete.execute();
        }
        catch (Throwable throwable) {
            DBUtil.close(delete);
            throw throwable;
        }
        DBUtil.close(delete);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTemplateId(Connection con, int newTemplateId, int recordId) throws SQLException {
        PreparedStatement update = null;
        try {
            update = con.prepareStatement(MOVE_RECORD);
            update.setInt(1, newTemplateId);
            update.setInt(2, recordId);
            update.execute();
        }
        finally {
            DBUtil.close(update);
        }
    }

    private void closeConnection(Connection con) {
        DBUtil.close(con);
    }
}

