/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.notification.jms;

import com.silverpeas.notification.SubscriptionException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.jms.JMSException;
import javax.jms.TopicSubscriber;

final class ManagedTopicsSubscriber {
    private static Map<String, ManagedTopicsSubscriber> subscribers = Collections.synchronizedMap(new HashMap());
    private final String id;
    private final List<TopicSubscriber> subscriptions = new ArrayList<TopicSubscriber>();

    public static ManagedTopicsSubscriber getManagedTopicsSubscriberById(String id) {
        ManagedTopicsSubscriber subscriber = null;
        if (subscribers.containsKey(id)) {
            subscriber = subscribers.get(id);
        }
        return subscriber;
    }

    public static ManagedTopicsSubscriber getNewManagedTopicsSubscriber() {
        return new ManagedTopicsSubscriber(UUID.randomUUID().toString());
    }

    public static Collection<ManagedTopicsSubscriber> getAllManagedTopicSubscribers() {
        return Collections.unmodifiableCollection(subscribers.values());
    }

    public boolean isSubscribedTo(String topicName) throws JMSException {
        return this.getSubscription(topicName) != null;
    }

    public String getId() {
        return this.id;
    }

    public TopicSubscriber getSubscription(String topicName) throws JMSException {
        TopicSubscriber subscription = null;
        for (TopicSubscriber topicSubscriber : this.subscriptions) {
            if (!topicSubscriber.getTopic().getTopicName().equals(topicName)) continue;
            subscription = topicSubscriber;
            break;
        }
        return subscription;
    }

    public Collection<TopicSubscriber> getAllSubscriptions() {
        return Collections.unmodifiableCollection(new ArrayList<TopicSubscriber>(this.subscriptions));
    }

    public void addSubscription(TopicSubscriber topicSubscriber) {
        this.subscriptions.add(topicSubscriber);
    }

    public void removeSubscription(TopicSubscriber topicSubscriber) {
        this.subscriptions.remove(topicSubscriber);
    }

    public boolean hasNoSusbscriptions() {
        return this.subscriptions.isEmpty();
    }

    public void save() {
        subscribers.put(this.getId(), this);
    }

    public void delete() {
        if (!this.subscriptions.isEmpty()) {
            throw new SubscriptionException("The subscriber cannot be deleted: it has " + this.subscriptions.size() + " subscriptions!");
        }
        subscribers.remove(this.getId());
    }

    private ManagedTopicsSubscriber(String id) {
        this.id = id;
    }
}

