/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.util;

import com.silverpeas.util.StringUtil;
import com.stratelia.webactiv.util.DateUtil;
import java.io.File;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.OfficeOpenXMLCore;
import org.apache.tika.metadata.Property;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.metadata.XMPDM;
import org.silverpeas.media.Definition;
import org.silverpeas.util.UnitUtil;
import org.silverpeas.util.memory.MemoryData;
import org.silverpeas.util.time.TimeData;
import org.silverpeas.util.time.TimeUnit;

public class MetaData {
    private final File source;
    private final Metadata metadata;

    MetaData(File source, Metadata metadata) {
        this.source = source;
        this.metadata = metadata;
    }

    public String getValue(String name) {
        return this.metadata.get(name);
    }

    public List<String> getAvailablePropertyNames() {
        return Arrays.asList(this.metadata.names());
    }

    public String getTitle() {
        return this.cleanString(this.metadata.get(TikaCoreProperties.TITLE));
    }

    public String getSubject() {
        String subject = this.metadata.get(this.metadata.get("subject"));
        if (!StringUtil.isDefined(subject)) {
            subject = this.metadata.get(OfficeOpenXMLCore.SUBJECT);
        }
        if (!StringUtil.isDefined(subject)) {
            subject = this.metadata.get(TikaCoreProperties.KEYWORDS);
        }
        return this.cleanString(subject);
    }

    public String getAuthor() {
        return this.cleanString(this.metadata.get(TikaCoreProperties.CREATOR));
    }

    public String getComments() {
        String comments = this.metadata.get(TikaCoreProperties.COMMENTS);
        if (!StringUtil.isDefined(comments)) {
            comments = this.metadata.get(TikaCoreProperties.DESCRIPTION);
        }
        return this.cleanString(comments);
    }

    public int getSecurity() {
        return this.metadata.getInt(Property.internalInteger((String)"Security"));
    }

    public String[] getKeywords() {
        return this.cleanString(this.metadata.getValues(TikaCoreProperties.KEYWORDS));
    }

    public String getSilverId() {
        return this.cleanString(this.metadata.get("SILVERID"));
    }

    public String getSilverName() {
        return this.metadata.get("SILVERNAME");
    }

    public Date getLastSaveDateTime() {
        Date date = this.parseDate(TikaCoreProperties.MODIFIED);
        if (date == null) {
            return this.parseDate(Metadata.LAST_MODIFIED);
        }
        return date;
    }

    public Date getCreationDate() {
        Date result = this.getDate(TikaCoreProperties.CREATED);
        if (result == null) {
            result = this.metadata.getDate(TikaCoreProperties.CREATED);
        }
        if (result == null) {
            result = this.metadata.getDate(Metadata.DATE);
        }
        return result;
    }

    public Definition getDefinition() {
        Definition definition = Definition.fromZero();
        Integer result = this.getInteger(Metadata.IMAGE_WIDTH);
        if (result == null) {
            result = this.getInteger(FLV.WIDTH);
        }
        if (result != null) {
            definition.widthOf(result);
        }
        if ((result = this.getInteger(Metadata.IMAGE_LENGTH)) == null) {
            result = this.getInteger(FLV.HEIGHT);
        }
        if (result != null) {
            definition.heightOf(result);
        }
        return definition;
    }

    public BigDecimal getFramerate() {
        BigDecimal result = this.getBigDecimal(XMPDM.VIDEO_FRAME_RATE);
        if (result == null) {
            result = this.getBigDecimal(FLV.FRAMERATE);
        }
        return result;
    }

    public TimeData getDuration() {
        TimeData result = null;
        BigDecimal duration = this.getBigDecimal(XMPDM.DURATION);
        if (duration != null) {
            result = UnitUtil.getTimeData(duration);
        }
        if (result == null && (duration = this.getBigDecimal(FLV.DURATION)) != null) {
            result = UnitUtil.getTimeData(duration, TimeUnit.SEC);
        }
        return result;
    }

    public MemoryData getMemoryData() {
        Long result = this.getLong("Content-Length");
        return result != null ? UnitUtil.getMemData(result) : null;
    }

    protected Date getDate(Property property) {
        Date result = this.metadata.getDate(property);
        if (result == null) {
            return this.parseDate(property);
        }
        return result;
    }

    protected Integer getInteger(Property property) {
        BigDecimal value;
        Integer result = this.metadata.getInt(property);
        if (result == null && (value = this.getBigDecimal(property)) != null) {
            result = value.intValue();
        }
        return result;
    }

    protected Long getLong(Property property) {
        String result = this.cleanString(this.metadata.get(property));
        try {
            return Long.valueOf(result);
        }
        catch (Exception e) {
            return null;
        }
    }

    protected Long getLong(String propertyName) {
        String result = this.cleanString(this.metadata.get(propertyName));
        try {
            return Long.valueOf(result);
        }
        catch (Exception e) {
            return null;
        }
    }

    protected BigDecimal getBigDecimal(Property property) {
        String result = this.cleanString(this.metadata.get(property));
        try {
            return new BigDecimal(result);
        }
        catch (Exception e) {
            return null;
        }
    }

    protected Date parseDate(Property property) {
        String date = this.metadata.get(property);
        if (date != null) {
            try {
                return DateUtil.parse(date, "yyyy-MM-dd'T'HH:mm:ss'Z'");
            }
            catch (ParseException ex) {
                return null;
            }
        }
        return null;
    }

    private String[] cleanString(String[] values) {
        String[] result = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            result[i] = this.cleanString(values[i]);
        }
        return result;
    }

    private String cleanString(String value) {
        if (StringUtil.isDefined(value)) {
            return value.replace("\u0000", "").replace("\u00ef\u00bf\u00bd\u00ef\u00bf\u00bd", "").trim();
        }
        return value;
    }

    private static interface FLV {
        public static final Property WIDTH = Property.internalText((String)"width");
        public static final Property HEIGHT = Property.internalText((String)"height");
        public static final Property DURATION = Property.internalText((String)"duration");
        public static final Property FRAMERATE = Property.internalText((String)"framerate");
    }
}

