/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.util.template;

import com.silverpeas.util.template.SilverpeasStringTemplate;
import com.silverpeas.util.template.SilverpeasStringTemplateUtil;
import com.silverpeas.util.template.SilverpeasTemplate;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;

public class SilverpeasTemplateFactory {
    private static final String separator = "/";

    public static SilverpeasTemplate createSilverpeasTemplate(Properties configuration) {
        return new SilverpeasStringTemplate(configuration);
    }

    public static SilverpeasTemplate createSilverpeasTemplateOnComponents() {
        return SilverpeasTemplateFactory.createSilverpeasTemplateOnComponents(null);
    }

    public static SilverpeasTemplate createSilverpeasTemplateOnComponents(String pathSuffix) {
        Properties config = new Properties();
        config.setProperty("template.root.dir", SilverpeasTemplateFactory.computePath(SilverpeasStringTemplateUtil.defaultComponentsDir, pathSuffix));
        config.setProperty("template.customer.dir", SilverpeasTemplateFactory.computePath(SilverpeasStringTemplateUtil.customComponentsDir, pathSuffix));
        return SilverpeasTemplateFactory.createSilverpeasTemplate(config);
    }

    public static SilverpeasTemplate createSilverpeasTemplateOnCore(String pathSuffix) {
        Properties config = new Properties();
        config.setProperty("template.root.dir", SilverpeasTemplateFactory.computePath(SilverpeasStringTemplateUtil.defaultCoreDir, pathSuffix));
        config.setProperty("template.customer.dir", SilverpeasTemplateFactory.computePath(SilverpeasStringTemplateUtil.customCoreDir, pathSuffix));
        return SilverpeasTemplateFactory.createSilverpeasTemplate(config);
    }

    private static String computePath(String pathBase, String pathSuffix) {
        StringBuffer sb = new StringBuffer(pathBase);
        if (StringUtils.isNotBlank((CharSequence)pathSuffix)) {
            sb.append(separator);
            sb.append(pathSuffix);
            sb.append(separator);
        }
        return sb.toString().replaceAll("[/]{1,}", separator);
    }
}

