/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.webactiv.util;

import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.util.ResourceLocator;
import com.stratelia.webactiv.util.exception.MultilangMessage;
import com.stratelia.webactiv.util.exception.UtilException;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;

public class EJBUtilitaire {
    private ResourceLocator resources = new ResourceLocator("org.silverpeas.util.jndi", "");
    private static EJBUtilitaire instance;
    private static EJBUtilitaire realInstance;

    private EJBUtilitaire() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static EJBUtilitaire getInstance() {
        Class<EJBUtilitaire> clazz = EJBUtilitaire.class;
        synchronized (EJBUtilitaire.class) {
            if (instance == null) {
                instance = new EJBUtilitaire();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void mock(EJBUtilitaire mock) {
        Class<EJBUtilitaire> clazz = EJBUtilitaire.class;
        synchronized (EJBUtilitaire.class) {
            realInstance = instance;
            instance = mock;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unmock() {
        Class<EJBUtilitaire> clazz = EJBUtilitaire.class;
        synchronized (EJBUtilitaire.class) {
            instance = realInstance;
            realInstance = null;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private Context initialiseContext() {
        InitialContext ic = null;
        try {
            Hashtable<String, String> env = new Hashtable<String, String>();
            String jnfi = this.resources.getString("java.naming.factory.initial", null);
            String jnpu = this.resources.getString("java.naming.provider.url", null);
            if (jnfi != null && jnfi.length() > 0) {
                env.put("java.naming.factory.initial", jnfi);
            }
            if (jnpu != null && jnpu.length() > 0) {
                env.put("java.naming.provider.url", jnpu);
            }
            ic = new InitialContext(env);
        }
        catch (NamingException e) {
            UtilException ue = new UtilException("EJBUtilitaire.getEJBObjectRef", "util.MSG_CANT_GET_INITIAL_CONTEXT", e);
            throw ue;
        }
        return ic;
    }

    public <T> T getObjectReference(String name, Class<T> classObj) throws UtilException {
        SilverTrace.debug("util", "EJBUtilitaire.getEJBObjectRef", name);
        Context ic = this.initialiseContext();
        try {
            Object ref = ic.lookup(name);
            return (T)PortableRemoteObject.narrow((Object)ref, classObj);
        }
        catch (Exception e) {
            UtilException ue = new UtilException("EJBUtilitaire.getEJBObjectRef", new MultilangMessage("util.MSG_EJB_REF_NOT_FOUND", name).toString(), e);
            throw ue;
        }
    }

    public static <T> T getEJBObjectRef(String name, Class<T> classObj) throws UtilException {
        return EJBUtilitaire.getInstance().getObjectReference(name, classObj);
    }

    static {
        realInstance = null;
    }
}

