/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.admin.space.quota.process.check;

import com.silverpeas.util.StringUtil;
import com.stratelia.webactiv.beans.admin.ComponentInst;
import com.stratelia.webactiv.beans.admin.ComponentInstLight;
import com.stratelia.webactiv.beans.admin.SpaceInst;
import com.stratelia.webactiv.util.ResourceLocator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import javax.inject.Inject;
import javax.inject.Named;
import org.silverpeas.admin.space.SpaceServiceFactory;
import org.silverpeas.admin.space.quota.DataStorageSpaceQuotaKey;
import org.silverpeas.admin.space.quota.process.check.SpaceDataStorageQuotaCountingOffset;
import org.silverpeas.admin.space.quota.process.check.exception.DataStorageQuotaException;
import org.silverpeas.core.admin.OrganisationController;
import org.silverpeas.notification.message.MessageManager;
import org.silverpeas.process.io.IOAccess;
import org.silverpeas.process.io.file.FileHandler;
import org.silverpeas.process.management.AbstractFileProcessCheck;
import org.silverpeas.process.management.ProcessExecutionContext;
import org.silverpeas.quota.constant.QuotaLoad;
import org.silverpeas.quota.exception.QuotaException;
import org.silverpeas.util.NotifierUtil;
import org.silverpeas.util.error.SilverpeasTransverseErrorUtil;

@Named
public class DataStorageQuotaProcessCheck
extends AbstractFileProcessCheck {
    protected static boolean dataStorageInSpaceQuotaActivated;
    @Inject
    private OrganisationController organizationController;

    @Override
    public void checkFiles(ProcessExecutionContext processExecutionProcess, FileHandler fileHandler) throws Exception {
        if (!dataStorageInSpaceQuotaActivated) {
            return;
        }
        if (IOAccess.READ_WRITE.equals((Object)fileHandler.getIoAccess())) {
            for (SpaceInst space : this.indentifyHandledSpaces(processExecutionProcess, fileHandler)) {
                try {
                    SpaceServiceFactory.getDataStorageSpaceQuotaService().verify(DataStorageSpaceQuotaKey.from(space), SpaceDataStorageQuotaCountingOffset.from(space, fileHandler));
                }
                catch (QuotaException quotaException) {
                    ComponentInstLight fromComponent = null;
                    String fromComponentInstanceId = processExecutionProcess.getComponentInstanceId();
                    if (StringUtil.isDefined(fromComponentInstanceId)) {
                        fromComponent = this.organizationController.getComponentInstLight(fromComponentInstanceId);
                    }
                    DataStorageQuotaException exception = new DataStorageQuotaException(quotaException.getQuota(), space, fromComponent);
                    NotifierUtil.addSevere(SilverpeasTransverseErrorUtil.performExceptionMessage(exception, MessageManager.getLanguage()), new Object[0]);
                    throw exception;
                }
            }
        }
    }

    private Collection<SpaceInst> indentifyHandledSpaces(ProcessExecutionContext processExecutionProcess, FileHandler fileHandler) {
        HashSet<String> spaceIds = new HashSet<String>();
        HashSet<String> componentInstanceIds = new HashSet<String>();
        if (StringUtil.isDefined(processExecutionProcess.getComponentInstanceId())) {
            componentInstanceIds.add(processExecutionProcess.getComponentInstanceId());
        }
        componentInstanceIds.addAll(fileHandler.getSessionHandledRootPathNames(true));
        for (String componentInstanceId : componentInstanceIds) {
            ComponentInst component = this.organizationController.getComponentInst(componentInstanceId);
            if (component == null) continue;
            spaceIds.add(component.getDomainFatherId());
        }
        ArrayList<SpaceInst> handledSpaces = new ArrayList<SpaceInst>();
        for (String spaceId : spaceIds) {
            SpaceInst handledSpace = this.organizationController.getSpaceInstById(spaceId);
            if (QuotaLoad.UNLIMITED.equals((Object)handledSpace.getDataStorageQuota().getLoad())) continue;
            handledSpaces.add(handledSpace);
        }
        return handledSpaces;
    }

    static {
        ResourceLocator settings = new ResourceLocator("com.silverpeas.jobStartPagePeas.settings.jobStartPagePeasSettings", "");
        dataStorageInSpaceQuotaActivated = settings.getBoolean("quota.space.datastorage.activated", false);
    }
}

