/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.authentication.verifier;

import com.stratelia.webactiv.beans.admin.UserDetail;
import org.silverpeas.authentication.AuthenticationCredential;
import org.silverpeas.authentication.verifier.AbstractAuthenticationVerifier;
import org.silverpeas.authentication.verifier.UserCanLoginVerifier;
import org.silverpeas.authentication.verifier.UserCanTryAgainToLoginVerifier;
import org.silverpeas.authentication.verifier.UserMustAcceptTermsOfServiceVerifier;
import org.silverpeas.authentication.verifier.UserMustChangePasswordVerifier;

public class AuthenticationUserVerifierFactory {
    public static UserCanLoginVerifier getUserCanLoginVerifier(UserDetail user) {
        return new UserCanLoginVerifier(user);
    }

    public static UserCanLoginVerifier getUserCanLoginVerifier(String userId) {
        return AuthenticationUserVerifierFactory.getUserCanLoginVerifier(AbstractAuthenticationVerifier.getUserById(userId));
    }

    public static UserCanLoginVerifier getUserCanLoginVerifier(AuthenticationCredential credential) {
        return AuthenticationUserVerifierFactory.getUserCanLoginVerifier(AbstractAuthenticationVerifier.getUserByCredential(credential));
    }

    public static UserCanTryAgainToLoginVerifier getUserCanTryAgainToLoginVerifier(AuthenticationCredential credential) {
        UserDetail user = AbstractAuthenticationVerifier.getUserByCredential(credential);
        if (user == null) {
            user = new UserDetail();
            user.setLogin(credential.getLogin());
            user.setDomainId(credential.getDomainId());
        }
        return AuthenticationUserVerifierFactory.getUserCanTryAgainToLoginVerifier(user);
    }

    public static synchronized UserCanTryAgainToLoginVerifier getUserCanTryAgainToLoginVerifier(UserDetail user) {
        return UserCanTryAgainToLoginVerifier.get(user);
    }

    public static UserMustChangePasswordVerifier getUserMustChangePasswordVerifier(UserDetail user) {
        return new UserMustChangePasswordVerifier(user);
    }

    public static UserMustChangePasswordVerifier getUserMustChangePasswordVerifier(AuthenticationCredential credential) {
        return AuthenticationUserVerifierFactory.getUserMustChangePasswordVerifier(AbstractAuthenticationVerifier.getUserByCredential(credential));
    }

    public static UserMustAcceptTermsOfServiceVerifier getUserMustAcceptTermsOfServiceVerifier(AuthenticationCredential credential) {
        return new UserMustAcceptTermsOfServiceVerifier(AbstractAuthenticationVerifier.getUserByCredential(credential));
    }

    public static synchronized UserMustAcceptTermsOfServiceVerifier getUserMustAcceptTermsOfServiceVerifier(String tosToken) {
        return UserMustAcceptTermsOfServiceVerifier.get(tosToken);
    }
}

